/*
 * Decompiled with CFR 0.152.
 */
package org.minju.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.X_GL_BudgetControlLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ProcessRequisition2
extends SvrProcess {
    private int p_Requisition_ID = 0;
    private String p_Action = "PR";
    private String p_Message = "";

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("Action")) {
                this.p_Action = para[i].getParameterAsString();
            } else if (name.equals("Message")) {
                this.p_Message = para[i].getParameterAsString();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.p_Requisition_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        if (this.p_Requisition_ID > 0) {
            MRequisition req = new MRequisition(this.getCtx(), this.p_Requisition_ID, this.get_TrxName());
            String newStatus = "DR";
            String newAction = "DR";
            this.log.config("paction " + this.p_Action);
            if (req.getDocStatus().compareTo("DR") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "AP";
                newAction = "AP";
            } else if (req.getDocStatus().compareTo("AP") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "CO";
                newAction = "CO";
            }
            int cant = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM AD_Document_Action_Access daa INNER JOIN AD_Ref_List rl ON (daa.AD_Ref_List_ID = rl.AD_Ref_List_ID)  WHERE value = '" + newAction + "' AND AD_Role_ID = " + Env.getAD_Role_ID(this.getCtx()) + " AND C_DocType_ID = " + req.getC_DocType_ID());
            this.log.config("cantidad" + cant);
            if (cant > 0) {
                if (newAction.compareTo("CO") != 0) {
                    req.setDocStatus(newStatus);
                    req.save();
                } else if (newAction.compareTo("CO") == 0) {
                    MCurrency curreTo = new MCurrency(this.getCtx(), 228, this.get_TrxName());
                    BigDecimal MultiplyRate = null;
                    if (req.get_ValueAsInt("C_Currency_ID") != curreTo.get_ID()) {
                        if (MultiplyRate == null || MultiplyRate.signum() == 0) {
                            MultiplyRate = MConversionRate.getRate(req.get_ValueAsInt("C_Currency_ID"), curreTo.get_ID(), req.getDateDoc(), req.get_ValueAsInt("C_ConversionType_ID"), req.getAD_Client_ID(), req.getAD_Org_ID());
                        }
                        this.log.config("currency = " + req.get_ValueAsInt("C_Currency_ID") + " - To_Currency=" + curreTo.get_ID() + "- Date=" + req.getDateDoc() + "-Conversion=" + req.get_ValueAsInt("C_ConversionType_ID"));
                        if (MultiplyRate == null || MultiplyRate.compareTo(Env.ZERO) <= 0) {
                            throw new AdempiereUserError("Por favor definir el tipo de cambio", "Conversion Monetaria");
                        }
                    } else {
                        MultiplyRate = Env.ONE;
                    }
                    MRequisitionLine[] lines = req.getLines();
                    int i = 0;
                    while (i < lines.length) {
                        MRequisitionLine rLine = lines[i];
                        if (rLine.get_ValueAsInt("GL_BudgetControlLine_ID") > 0) {
                            X_GL_BudgetControlLine bcLine = new X_GL_BudgetControlLine(this.getCtx(), rLine.get_ValueAsInt("GL_BudgetControlLine_ID"), this.get_TrxName());
                            BigDecimal usedAmt = (BigDecimal)bcLine.get_Value("Amount2");
                            if (usedAmt == null) {
                                usedAmt = Env.ZERO;
                            }
                            BigDecimal amtConvert = rLine.getLineNetAmt().multiply(MultiplyRate).setScale(curreTo.getStdPrecision(), 6);
                            if (rLine.get_ValueAsBoolean("IsTaxed")) {
                                amtConvert = amtConvert.multiply(new BigDecimal("1.19"));
                            }
                            if ((usedAmt = usedAmt.add(amtConvert)).compareTo((BigDecimal)bcLine.get_Value("Amount")) > 0) {
                                throw new AdempiereException("El monto solicitado excede al disponible");
                            }
                            bcLine.set_CustomColumn("Amount2", usedAmt);
                            bcLine.save();
                        }
                        ++i;
                    }
                    req.setDocStatus("IP");
                    req.processIt("CO");
                    req.save();
                }
            } else {
                throw new AdempiereException("Error: Permisos de rol insuficientes");
            }
        }
        return "Procesado";
    }
}

