/*
 * Decompiled with CFR 0.152.
 */
package org.minju.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MConversionRate;
import org.compiere.model.MConversionType;
import org.compiere.model.MPeriod;
import org.compiere.model.X_HR_ProcessBP;
import org.compiere.model.X_HR_ProcessBPDetail;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.X_HR_Concept;
import org.eevolution.model.X_HR_Process;

public class ProcessNomina
extends SvrProcess {
    private int p_HR_Process = 0;
    private int p_C_BPartner_ID = 0;
    private int p_AD_Org_ID = 0;
    private int p_Parent_Org_ID = 0;
    private String p_suplencia = "";
    private static CLogger s_log = CLogger.getCLogger(MConversionRate.class);

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = para[i].getParameterAsInt();
            } else if (name.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = para[i].getParameterAsInt();
            } else if (name.equals("Parent_Org_ID")) {
                this.p_Parent_Org_ID = para[i].getParameterAsInt();
            } else if (name.equals("Suplencia")) {
                this.p_suplencia = para[i].getParameterAsString();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.p_HR_Process = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        String logM = "";
        if (this.p_HR_Process > 0) {
            if (this.p_AD_Org_ID <= 0 && this.p_Parent_Org_ID <= 0 && this.p_C_BPartner_ID <= 0) {
                throw new AdempiereException("Debe seleccionar una organizaci\u00f3n o funcionario");
            }
            X_HR_Process pro = new X_HR_Process(this.getCtx(), this.p_HR_Process, this.get_TrxName());
            DB.executeUpdate("DELETE FROM HR_ProcessBPDetail WHERE HR_ProcessBPDetail_ID IN (SELECT HR_ProcessBPDetail_ID FROM HR_ProcessBPDetail d INNER JOIN HR_ProcessBP p ON (d.HR_ProcessBP_ID = p.HR_ProcessBP_ID) WHERE HR_Process_ID=" + pro.get_ID() + ")", this.get_TrxName());
            DB.executeUpdate("DELETE FROM HR_ProcessBP WHERE HR_Process_ID=" + pro.get_ID(), this.get_TrxName());
            String sqlBP = "SELECT bp.C_Bpartner_ID, bp.AD_Org_ID FROM C_Bpartner bp  INNER JOIN HR_Employee e ON (bp.C_Bpartner_ID = e.C_Bpartner_ID) WHERE bp.IsActive = 'Y' ";
            if (this.p_AD_Org_ID > 0) {
                sqlBP = String.valueOf(sqlBP) + " AND bp.AD_Org_ID = " + this.p_AD_Org_ID;
            }
            if (this.p_C_BPartner_ID > 0) {
                sqlBP = String.valueOf(sqlBP) + " AND bp.C_Bpartner_ID = " + this.p_C_BPartner_ID;
            }
            if (this.p_suplencia != null && this.p_suplencia.trim().length() > 0) {
                sqlBP = String.valueOf(sqlBP) + " AND e.suplencia LIKE '" + this.p_suplencia + "'";
            }
            if (this.p_Parent_Org_ID > 0) {
                sqlBP = String.valueOf(sqlBP) + " AND bp.AD_Org_ID IN (SELECT AD_Org_ID FROM AD_OrgInfo WHERE Parent_Org_ID = " + this.p_Parent_Org_ID + ") ";
            }
            String mes = "-" + Integer.toString(pro.getDateAcct().getMonth() + 1) + "-";
            CPreparedStatement pstmt = DB.prepareStatement(sqlBP, this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                BigDecimal tLiq;
                BigDecimal pTope;
                BigDecimal topeSaludImp;
                BigDecimal amtSaludImp;
                X_HR_ProcessBPDetail bpDet;
                X_HR_ProcessBPDetail bpDet2;
                X_HR_ProcessBP pBP = new X_HR_ProcessBP(this.getCtx(), 0, this.get_TrxName());
                pBP.setAD_Org_ID(rs.getInt("AD_Org_ID"));
                pBP.setHR_Process_ID(pro.get_ID());
                pBP.setC_BPartner_ID(rs.getInt("C_Bpartner_ID"));
                BigDecimal cantDays = DB.getSQLValueBD(this.get_TrxName(), "SELECT COUNT(DISTINCT(EXTRACT(day FROM DateTrx))) FROM HR_AttendanceLine WHERE C_BPartner_ID=" + rs.getInt("C_Bpartner_ID") + " AND EXTRACT(month FROM DateTrx) = " + (pro.getDateAcct().getMonth() + 1), new Object[0]);
                if (cantDays != null) {
                    pBP.set_CustomColumn("WorkedDays", cantDays);
                }
                pBP.saveEx();
                if (rs.getInt("C_Bpartner_ID") == 2007540) {
                    this.log.config("log bp en analisis");
                }
                Timestamp dateTope = pro.getDateAcct();
                String isINP = DB.getSQLValueString(this.get_TrxName(), "SELECT MAX(IsINP) FROM HR_Employee  WHERE C_Bpartner_ID=" + rs.getInt("C_Bpartner_ID"), new Object[0]);
                if (rs.getInt("C_Bpartner_ID") == 2007593) {
                    this.log.config("log bp en analisis");
                }
                if (isINP != null && isINP.compareTo("Y") == 0) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTimeInMillis(pro.getDateAcct().getTime());
                    cal.add(2, -1);
                    dateTope = new Timestamp(cal.getTimeInMillis());
                }
                String sqlBienestar = "SELECT * FROM HR_Welfare WHERE C_Bpartner_ID = ? AND Amount > 0 AND IsTaxable = 'N'";
                CPreparedStatement pstmtBienestar = DB.prepareStatement(sqlBienestar, this.get_TrxName());
                pstmtBienestar.setInt(1, rs.getInt("C_Bpartner_ID"));
                ResultSet rsBienestar = pstmtBienestar.executeQuery();
                while (rsBienestar.next()) {
                    X_HR_ProcessBPDetail bpDet3;
                    String mesWel = "";
                    mesWel = rsBienestar.getString("months") != null && rsBienestar.getString("months").trim().length() > 0 ? "-" + rsBienestar.getString("months") + "-" : mes;
                    if (!mesWel.contains(mes)) continue;
                    if (rsBienestar.getString("Type") != null && rsBienestar.getString("Type").compareTo("P") == 0 && rs.getInt("HR_ConceptRef_ID") > 0) {
                        BigDecimal amtCon = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(Amount) FROM HR_ProcessBPDetail WHERE HR_ProcessBP_ID = " + pBP.get_ID() + " AND  HR_Concept_ID = " + rsBienestar.getInt("HR_ConceptRef_ID"), new Object[0]);
                        if (amtCon == null) {
                            amtCon = Env.ZERO;
                        }
                        BigDecimal amount = rs.getBigDecimal("Amount");
                        amount = amount.multiply(amtCon).divide(Env.ZERO, 0, RoundingMode.HALF_EVEN);
                        X_HR_ProcessBPDetail bpDet4 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                        bpDet4.setHR_ProcessBP_ID(pBP.get_ID());
                        bpDet4.setAD_Org_ID(pBP.getAD_Org_ID());
                        if (rsBienestar.getInt("HR_Concept_ID") > 0) {
                            bpDet4.setHR_Concept_ID(rsBienestar.getInt("HR_Concept_ID"));
                        }
                        if (amount != null) {
                            bpDet4.setAmount(amount);
                        }
                        bpDet4.saveEx();
                    }
                    if (rsBienestar.getString("Type") != null && rsBienestar.getString("Type").compareTo("M") == 0) {
                        bpDet3 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                        bpDet3.setHR_ProcessBP_ID(pBP.get_ID());
                        bpDet3.setAD_Org_ID(pBP.getAD_Org_ID());
                        if (rsBienestar.getInt("HR_Concept_ID") > 0) {
                            bpDet3.setHR_Concept_ID(rsBienestar.getInt("HR_Concept_ID"));
                        }
                        if (rsBienestar.getBigDecimal("Amount") != null) {
                            bpDet3.setAmount(rsBienestar.getBigDecimal("Amount"));
                        }
                        bpDet3.saveEx();
                    }
                    if (rsBienestar.getString("Type") == null || rsBienestar.getString("Type").compareTo("U") != 0) continue;
                    bpDet3 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                    bpDet3.setHR_ProcessBP_ID(pBP.get_ID());
                    bpDet3.setAD_Org_ID(pBP.getAD_Org_ID());
                    if (rsBienestar.getInt("HR_Concept_ID") > 0) {
                        bpDet3.setHR_Concept_ID(rsBienestar.getInt("HR_Concept_ID"));
                    }
                    if (rsBienestar.getBigDecimal("Amount") != null) {
                        BigDecimal tasa = ProcessNomina.getRate(2000000, 228, dateTope, 114, pro.getAD_Client_ID(), pro.getAD_Org_ID());
                        tasa = rsBienestar.getBigDecimal("Amount").multiply(tasa);
                        bpDet3.setAmount(tasa.setScale(0, RoundingMode.HALF_EVEN));
                    }
                    bpDet3.saveEx();
                }
                String sqlConcept = "SELECT * FROM HR_PayrollConcept WHERE IsActive = 'Y' AND HR_Payroll_ID = ? ORDER BY SeqNo ";
                CPreparedStatement pstmtConcept = DB.prepareStatement(sqlConcept, this.get_TrxName());
                pstmtConcept.setInt(1, pro.getHR_Payroll_ID());
                ResultSet rsConcept = pstmtConcept.executeQuery();
                while (rsConcept.next()) {
                    X_HR_Concept conc = new X_HR_Concept(this.getCtx(), rsConcept.getInt("HR_Concept_ID"), this.get_TrxName());
                    BigDecimal amtCon = Env.ZERO;
                    if (conc.get_ValueAsString("TypeConcept").compareTo("T") == 0) {
                        String sqlValT = "SELECT COALESCE(MAX(MinValue),0) FROM HR_Attribute WHERE HR_Concept_ID = " + conc.get_ID();
                        if (conc.get_ValueAsString("HR_Reference1") != null && conc.get_ValueAsString("HR_Reference1").trim().length() > 0) {
                            sqlValT = String.valueOf(sqlValT) + " AND " + conc.get_ValueAsString("HR_Reference1") + " = (SELECT " + conc.get_ValueAsString("HR_Reference1") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                        }
                        if (conc.get_ValueAsString("HR_Reference2") != null && conc.get_ValueAsString("HR_Reference2").trim().length() > 0) {
                            sqlValT = String.valueOf(sqlValT) + " AND " + conc.get_ValueAsString("HR_Reference2") + " = (SELECT " + conc.get_ValueAsString("HR_Reference2") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                        }
                        if (conc.get_ValueAsString("HR_Reference3") != null && conc.get_ValueAsString("HR_Reference3").trim().length() > 0) {
                            sqlValT = String.valueOf(sqlValT) + " AND " + conc.get_ValueAsString("HR_Reference3") + " = (SELECT " + conc.get_ValueAsString("HR_Reference3") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                        }
                        if (conc.get_ValueAsBoolean("UseJob")) {
                            sqlValT = String.valueOf(sqlValT) + " AND HR_Job_ID = (SELECT HR_Job_ID FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                        }
                        if (conc.get_ValueAsBoolean("UseRegion")) {
                            sqlValT = String.valueOf(sqlValT) + " AND C_Region_ID = (SELECT C_Region_ID FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                        }
                        if ((amtCon = DB.getSQLValueBD(this.get_TrxName(), sqlValT, new Object[0])) == null) {
                            amtCon = Env.ZERO;
                        }
                        X_HR_ProcessBPDetail bpDet5 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                        bpDet5.setHR_ProcessBP_ID(pBP.get_ID());
                        bpDet5.setAD_Org_ID(pBP.getAD_Org_ID());
                        bpDet5.setHR_Concept_ID(conc.get_ID());
                        bpDet5.setAmount(amtCon);
                        bpDet5.saveEx();
                        continue;
                    }
                    if (conc.get_ValueAsString("TypeConcept").compareTo("F") == 0) {
                        if ((BigDecimal)conc.get_Value("Amount") != null) {
                            amtCon = (BigDecimal)conc.get_Value("Amount");
                        }
                        X_HR_ProcessBPDetail bpDet6 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                        bpDet6.setHR_ProcessBP_ID(pBP.get_ID());
                        bpDet6.setAD_Org_ID(pBP.getAD_Org_ID());
                        bpDet6.setHR_Concept_ID(conc.get_ID());
                        bpDet6.setAmount(amtCon);
                        bpDet6.saveEx();
                        continue;
                    }
                    if (conc.get_ValueAsString("TypeConcept").compareTo("P") == 0) {
                        String sqlAttributet = "SELECT HR_ConceptRef_ID, MinValue FROM HR_Attribute WHERE HR_Concept_ID = " + conc.get_ID();
                        if (conc.get_ValueAsString("HR_Reference1") != null && conc.get_ValueAsString("HR_Reference1").trim().length() > 0) {
                            sqlAttributet = String.valueOf(sqlAttributet) + " AND " + conc.get_ValueAsString("HR_Reference1") + " = (SELECT " + conc.get_ValueAsString("HR_Reference1") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                        }
                        if (conc.get_ValueAsString("HR_Reference2") != null && conc.get_ValueAsString("HR_Reference2").trim().length() > 0) {
                            sqlAttributet = String.valueOf(sqlAttributet) + " AND " + conc.get_ValueAsString("HR_Reference2") + " = (SELECT " + conc.get_ValueAsString("HR_Reference2") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                        }
                        if (conc.get_ValueAsString("HR_Reference3") != null && conc.get_ValueAsString("HR_Reference3").trim().length() > 0) {
                            sqlAttributet = String.valueOf(sqlAttributet) + " AND " + conc.get_ValueAsString("HR_Reference3") + " = (SELECT " + conc.get_ValueAsString("HR_Reference3") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                        }
                        if (conc.get_ValueAsBoolean("UseJob")) {
                            sqlAttributet = String.valueOf(sqlAttributet) + " AND HR_Job_ID = (SELECT HR_Job_ID FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                        }
                        if (conc.get_ValueAsBoolean("UseRegion")) {
                            sqlAttributet = String.valueOf(sqlAttributet) + " AND C_Region_ID = (SELECT C_Region_ID FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                        }
                        CPreparedStatement pstmtAtt = DB.prepareStatement(sqlAttributet, this.get_TrxName());
                        ResultSet rsAtt = pstmtAtt.executeQuery();
                        while (rsAtt.next()) {
                            BigDecimal amtAtt = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(Amount) FROM HR_ProcessBPDetail WHERE HR_ProcessBP_ID = " + pBP.get_ID() + " AND  HR_Concept_ID = " + rsAtt.getInt("HR_ConceptRef_ID"), new Object[0]);
                            if (amtAtt == null) {
                                amtAtt = Env.ZERO;
                            }
                            amtCon = amtAtt.multiply(rsAtt.getBigDecimal("MinValue")).divide(Env.ONEHUNDRED, RoundingMode.HALF_EVEN);
                            amtCon = amtCon.setScale(0, RoundingMode.HALF_EVEN);
                            bpDet2 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                            bpDet2.setHR_ProcessBP_ID(pBP.get_ID());
                            bpDet2.setAD_Org_ID(pBP.getAD_Org_ID());
                            bpDet2.setHR_Concept_ID(conc.get_ID());
                            bpDet2.setAmount(amtCon);
                            bpDet2.saveEx();
                        }
                        continue;
                    }
                    if (conc.get_ValueAsString("TypeConcept").compareTo("D1") == 0) {
                        BigDecimal tasa;
                        BigDecimal pTope2 = DB.getSQLValueBD(this.get_TrxName(), "SELECT MaxAmount FROM HR_Employee c WHERE c.C_Bpartner_ID=" + rs.getInt("C_Bpartner_ID"), new Object[0]);
                        if (pTope2 == null) {
                            pTope2 = Env.ONE;
                        }
                        if ((tasa = ProcessNomina.getRate(2000000, 228, dateTope, 114, pro.getAD_Client_ID(), pro.getAD_Org_ID())) == null) {
                            tasa = Env.ONE;
                        }
                        BigDecimal tope = pTope2.multiply(tasa);
                        BigDecimal sumH = DB.getSQLValueBD(this.get_TrxName(), "SELECT COALESCE(SUM(d.Amount),0) FROM HR_ProcessBPDetail d INNER JOIN HR_Concept c ON (d.HR_Concept_ID = c.HR_Concept_ID) WHERE d.Amount > 0 AND c.IsTaxable = 'Y' AND d.HR_ProcessBP_ID = " + pBP.get_ID(), new Object[0]);
                        if (sumH == null) {
                            sumH = Env.ZERO;
                        }
                        if (sumH.compareTo(tope) > 0 && tope.compareTo(Env.ZERO) > 0) {
                            sumH = tope;
                        }
                        BigDecimal amtTotal = Env.ZERO;
                        BigDecimal porc = Env.ZERO;
                        if (conc.get_ValueAsString("HR_Discount1") != null && conc.get_ValueAsString("HR_Discount1").trim().length() > 0 && (porc = DB.getSQLValueBD(this.get_TrxName(), "SELECT " + conc.get_ValueAsString("HR_Discount1") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID"), new Object[0])) == null) {
                            porc = Env.ZERO;
                        }
                        amtTotal = porc.multiply(sumH);
                        amtTotal = amtTotal.divide(Env.ONEHUNDRED, 0, RoundingMode.HALF_EVEN);
                        amtTotal = amtTotal.negate();
                        bpDet = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                        bpDet.setHR_ProcessBP_ID(pBP.get_ID());
                        bpDet.setAD_Org_ID(pBP.getAD_Org_ID());
                        bpDet.setHR_Concept_ID(conc.get_ID());
                        bpDet.setAmount(amtTotal);
                        bpDet.saveEx();
                        continue;
                    }
                    if (conc.get_ValueAsString("TypeConcept").compareTo("B1") != 0) continue;
                    String mesBono = conc.get_ValueAsString("months");
                    if (!(mesBono = "-" + mesBono + "-").contains(mes)) continue;
                    BigDecimal porc = Env.ZERO;
                    if (conc.get_ValueAsString("HR_Bono1") != null && conc.get_ValueAsString("HR_Bono1").trim().length() > 0) {
                        porc = DB.getSQLValueBD(this.get_TrxName(), "SELECT " + conc.get_ValueAsString("HR_Bono1") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID"), new Object[0]);
                    }
                    if (porc == null) {
                        porc = Env.ZERO;
                    }
                    if (porc.compareTo(Env.ZERO) == 0) continue;
                    BigDecimal amtBono = Env.ZERO;
                    int a2 = 0;
                    while (a2 < 3) {
                        BigDecimal amtLast = DB.getSQLValueBD(this.get_TrxName(), "SELECT TotalAmt FROM HR_ProcessBP bp INNER JOIN HR_Process pr ON (bp.HR_Process_ID = pr.HR_Process_ID)  WHERE bp.C_BPartner_ID=" + rs.getInt("C_BPartner_ID") + " AND EXTRACT(month FROM pr.dateAcct)=" + (pro.getDateAcct().getMonth() - a2) + " AND pr.DocStatus IN ('CO') AND bp.IsActive = 'Y' AND bp.Processed = 'Y'", new Object[0]);
                        if (amtLast == null) {
                            amtLast = Env.ZERO;
                        }
                        if (amtLast.compareTo(Env.ZERO) > 0) {
                            amtLast = amtLast.multiply(porc).divide(Env.ONEHUNDRED, RoundingMode.HALF_EVEN);
                        }
                        amtBono = amtBono.add(amtLast);
                        ++a2;
                    }
                    amtBono = amtBono.setScale(0, RoundingMode.HALF_EVEN);
                    X_HR_ProcessBPDetail bpDet7 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                    bpDet7.setHR_ProcessBP_ID(pBP.get_ID());
                    bpDet7.setAD_Org_ID(pBP.getAD_Org_ID());
                    bpDet7.setHR_Concept_ID(conc.get_ID());
                    bpDet7.setAmount(amtBono);
                    bpDet7.saveEx();
                }
                String sqlBienestarD = "SELECT * FROM HR_Welfare WHERE C_Bpartner_ID = ? AND Amount <= 0 AND IsTaxable = 'N'";
                CPreparedStatement pstmtBienestarD = DB.prepareStatement(sqlBienestarD, this.get_TrxName());
                pstmtBienestarD.setInt(1, rs.getInt("C_Bpartner_ID"));
                ResultSet rsBienestarD = pstmtBienestarD.executeQuery();
                while (rsBienestarD.next()) {
                    X_HR_ProcessBPDetail bpDet8;
                    String mesWel = "";
                    mesWel = rsBienestarD.getString("months") != null && rsBienestarD.getString("months").trim().length() > 0 ? "-" + rsBienestarD.getString("months") + "-" : mes;
                    if (!mesWel.contains(mes)) continue;
                    if (rsBienestarD.getString("Type") != null && rsBienestarD.getString("Type").compareTo("P") == 0) {
                        if (rsBienestarD.getInt("HR_ConceptRef_ID") > 0) {
                            BigDecimal amtCon = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(Amount) FROM HR_ProcessBPDetail WHERE HR_ProcessBP_ID = " + pBP.get_ID() + " AND  HR_Concept_ID = " + rsBienestarD.getInt("HR_ConceptRef_ID"), new Object[0]);
                            if (amtCon == null) {
                                amtCon = Env.ZERO;
                            }
                            BigDecimal amount = rsBienestarD.getBigDecimal("Amount");
                            amount = amount.multiply(amtCon).divide(Env.ONEHUNDRED, 0, RoundingMode.HALF_EVEN);
                            bpDet2 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                            bpDet2.setHR_ProcessBP_ID(pBP.get_ID());
                            bpDet2.setAD_Org_ID(pBP.getAD_Org_ID());
                            if (rsBienestarD.getInt("HR_Concept_ID") > 0) {
                                bpDet2.setHR_Concept_ID(rsBienestarD.getInt("HR_Concept_ID"));
                            }
                            if (amount != null) {
                                bpDet2.setAmount(amount);
                            }
                            bpDet2.saveEx();
                        }
                    } else if (rsBienestarD.getString("Type") != null && rsBienestarD.getString("Type").compareTo("M") == 0) {
                        bpDet8 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                        bpDet8.setHR_ProcessBP_ID(pBP.get_ID());
                        bpDet8.setAD_Org_ID(pBP.getAD_Org_ID());
                        if (rsBienestarD.getInt("HR_Concept_ID") > 0) {
                            bpDet8.setHR_Concept_ID(rsBienestarD.getInt("HR_Concept_ID"));
                        }
                        if (rsBienestarD.getBigDecimal("Amount") != null) {
                            bpDet8.setAmount(rsBienestarD.getBigDecimal("Amount"));
                        }
                        bpDet8.saveEx();
                    }
                    if (rsBienestarD.getString("Type") == null || rsBienestarD.getString("Type").compareTo("U") != 0) continue;
                    bpDet8 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                    bpDet8.setHR_ProcessBP_ID(pBP.get_ID());
                    bpDet8.setAD_Org_ID(pBP.getAD_Org_ID());
                    if (rsBienestarD.getInt("HR_Concept_ID") > 0) {
                        bpDet8.setHR_Concept_ID(rsBienestarD.getInt("HR_Concept_ID"));
                    }
                    if (rsBienestarD.getBigDecimal("Amount") != null) {
                        BigDecimal tasa = ProcessNomina.getRate(2000000, 228, dateTope, 114, pro.getAD_Client_ID(), pro.getAD_Org_ID());
                        tasa = rsBienestarD.getBigDecimal("Amount").multiply(tasa);
                        bpDet8.setAmount(tasa.setScale(0, RoundingMode.HALF_EVEN));
                    }
                    bpDet8.saveEx();
                }
                String sqlInc = "SELECT * FROM HR_Movement WHERE IsActive = 'Y' AND C_Bpartner_ID = ? AND EXTRACT(month FROM validfrom) = ? ";
                CPreparedStatement pstmtInc = DB.prepareStatement(sqlInc, this.get_TrxName());
                pstmtInc.setInt(1, rs.getInt("C_Bpartner_ID"));
                pstmtInc.setInt(2, pro.getDateAcct().getMonth() + 1);
                ResultSet rsInc = pstmtInc.executeQuery();
                while (rsInc.next()) {
                    if (rsInc.getString("Type") != null && rsInc.getString("Type").compareTo("P") == 0) {
                        if (rsInc.getInt("HR_ConceptRef_ID") <= 0) continue;
                        BigDecimal amtCon = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(Amount) FROM HR_ProcessBPDetail  WHERE HR_ProcessBP_ID = " + pBP.get_ID() + " AND  HR_Concept_ID = " + rsInc.getInt("HR_ConceptRef_ID"), new Object[0]);
                        if (amtCon == null) {
                            amtCon = Env.ZERO;
                        }
                        BigDecimal amount = rsInc.getBigDecimal("Amount");
                        amount = amount.multiply(amtCon).divide(Env.ZERO, 0, RoundingMode.HALF_EVEN);
                        bpDet = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                        bpDet.setHR_ProcessBP_ID(pBP.get_ID());
                        bpDet.setAD_Org_ID(pBP.getAD_Org_ID());
                        if (rsInc.getInt("HR_Concept_ID") > 0) {
                            bpDet.setHR_Concept_ID(rsInc.getInt("HR_Concept_ID"));
                        }
                        if (amount != null) {
                            bpDet.setAmount(amount);
                        }
                        bpDet.saveEx();
                        continue;
                    }
                    if (rsInc.getString("Type") == null || rsInc.getString("Type").compareTo("M") != 0) continue;
                    bpDet2 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                    bpDet2.setHR_ProcessBP_ID(pBP.get_ID());
                    bpDet2.setAD_Org_ID(pBP.getAD_Org_ID());
                    if (rsInc.getInt("HR_Concept_ID") > 0) {
                        bpDet2.setHR_Concept_ID(rsInc.getInt("HR_Concept_ID"));
                    }
                    if (rsInc.getBigDecimal("Amount") != null) {
                        bpDet2.setAmount(rsInc.getBigDecimal("Amount"));
                    }
                    bpDet2.saveEx();
                }
                BigDecimal pUF = DB.getSQLValueBD(this.get_TrxName(), "SELECT MAX(ISAPRE_UF) FROM HR_Employee  WHERE C_Bpartner_ID=" + rs.getInt("C_Bpartner_ID"), new Object[0]);
                BigDecimal tasa = ProcessNomina.getRate(2000000, 228, dateTope, 114, pro.getAD_Client_ID(), pro.getAD_Org_ID());
                if (pUF != null && pUF.compareTo(Env.ZERO) != 0) {
                    BigDecimal totalSalud;
                    if (tasa == null) {
                        tasa = Env.ONE;
                    }
                    if ((totalSalud = pUF.multiply(tasa)).compareTo(Env.ZERO) != 0) {
                        BigDecimal amtSalud = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(d.Amount)*-1  FROM HR_ProcessBPDetail d  INNER JOIN HR_Concept c ON (d.HR_Concept_ID = c.HR_Concept_ID) WHERE HR_ProcessBP_ID = " + pBP.get_ID() + " AND  upper(c.description) = 'SALUD'", new Object[0]);
                        if (amtSalud == null) {
                            amtSalud = Env.ZERO;
                        }
                        if (totalSalud.compareTo(amtSalud) > 0) {
                            X_HR_ProcessBPDetail bpDet9 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                            bpDet9.setHR_ProcessBP_ID(pBP.get_ID());
                            bpDet9.setAD_Org_ID(pBP.getAD_Org_ID());
                            int ID_Concept = DB.getSQLValue(this.get_TrxName(), "SELECT HR_Concept_ID FROM HR_Concept c  WHERE upper(c.description) = 'ASALUD'");
                            if (ID_Concept > 0) {
                                bpDet9.setHR_Concept_ID(ID_Concept);
                            }
                            bpDet9.setAmount(totalSalud.subtract(amtSalud).negate().setScale(0, RoundingMode.HALF_EVEN));
                            bpDet9.saveEx();
                        }
                    }
                }
                if ((amtSaludImp = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(d.Amount)*-1 FROM HR_ProcessBPDetail d  INNER JOIN HR_Concept c ON (d.HR_Concept_ID = c.HR_Concept_ID) WHERE HR_ProcessBP_ID = " + pBP.get_ID() + " AND (upper(c.description) = 'SALUD' OR upper(c.description) = 'ASALUD')", new Object[0])) == null) {
                    amtSaludImp = Env.ZERO;
                }
                if (pUF == null) {
                    pUF = Env.ZERO;
                }
                if (tasa == null) {
                    tasa = Env.ZERO;
                }
                BigDecimal totalPlanSalud = pUF.multiply(tasa);
                BigDecimal topeUF = DB.getSQLValueBD(this.get_TrxName(), "SELECT MAX(TOPEISAPRE_UF) FROM HR_Employee  WHERE C_Bpartner_ID=" + rs.getInt("C_Bpartner_ID"), new Object[0]);
                if (topeUF == null) {
                    topeUF = Env.ZERO;
                }
                if ((topeSaludImp = topeUF.multiply(tasa)) != null && topeSaludImp.compareTo(Env.ZERO) != 0 && amtSaludImp != null && amtSaludImp.compareTo(Env.ZERO) != 0) {
                    if (totalPlanSalud != null && totalPlanSalud.compareTo(Env.ZERO) > 0 && totalPlanSalud.compareTo(amtSaludImp) < 0) {
                        amtSaludImp = totalPlanSalud;
                    }
                    if (amtSaludImp.compareTo(topeSaludImp) > 0) {
                        X_HR_ProcessBPDetail bpDet10 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                        bpDet10.setHR_ProcessBP_ID(pBP.get_ID());
                        bpDet10.setAD_Org_ID(pBP.getAD_Org_ID());
                        int ID_Concept = DB.getSQLValue(this.get_TrxName(), "SELECT HR_Concept_ID FROM HR_Concept c  WHERE upper(c.description) = 'DSALUD'");
                        if (ID_Concept > 0) {
                            bpDet10.setHR_Concept_ID(ID_Concept);
                        }
                        bpDet10.setAmount(amtSaludImp.subtract(topeSaludImp).setScale(0, RoundingMode.HALF_EVEN));
                        bpDet10.saveEx();
                        X_HR_ProcessBPDetail bpDet22 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                        bpDet22.setHR_ProcessBP_ID(pBP.get_ID());
                        bpDet22.setAD_Org_ID(pBP.getAD_Org_ID());
                        int ID_Concept2 = DB.getSQLValue(this.get_TrxName(), "SELECT HR_Concept_ID FROM HR_Concept c  WHERE upper(c.description) = 'NISALUD'");
                        if (ID_Concept2 > 0) {
                            bpDet22.setHR_Concept_ID(ID_Concept2);
                        }
                        bpDet22.setAmount(amtSaludImp.subtract(topeSaludImp).negate().setScale(0, RoundingMode.HALF_EVEN));
                        bpDet22.saveEx();
                    }
                }
                if ((pTope = DB.getSQLValueBD(this.get_TrxName(), "SELECT MaxAmount FROM HR_Employee c WHERE c.C_Bpartner_ID=" + rs.getInt("C_Bpartner_ID"), new Object[0])) == null) {
                    pTope = Env.ONE;
                }
                if (tasa == null) {
                    tasa = Env.ZERO;
                }
                BigDecimal tope = pTope.multiply(tasa);
                tope = tope.setScale(0, RoundingMode.HALF_EVEN);
                BigDecimal tImp = DB.getSQLValueBD(this.get_TrxName(), "SELECT COALESCE(SUM(d.Amount),0) FROM HR_ProcessBPDetail d INNER JOIN HR_Concept c ON (d.HR_Concept_ID = c.HR_Concept_ID) WHERE d.Amount > 0 AND c.IsTaxable = 'Y' AND d.HR_ProcessBP_ID = " + pBP.get_ID(), new Object[0]);
                if (tImp == null) {
                    tImp = Env.ZERO;
                }
                if (tImp.compareTo(tope) > 0 && tope.compareTo(Env.ZERO) > 0) {
                    pBP.set_CustomColumn("TotalAmt", tope);
                } else {
                    tImp = tImp.setScale(0, RoundingMode.HALF_EVEN);
                    pBP.set_CustomColumn("TotalAmt", tImp);
                }
                BigDecimal dTributable = DB.getSQLValueBD(this.get_TrxName(), "SELECT COALESCE(SUM(d.Amount),0) FROM HR_ProcessBPDetail d INNER JOIN HR_Concept c ON (d.HR_Concept_ID = c.HR_Concept_ID) WHERE c.IsTaxableDiscount = 'Y' AND d.HR_ProcessBP_ID = " + pBP.get_ID(), new Object[0]);
                if (dTributable == null) {
                    dTributable = Env.ZERO;
                }
                BigDecimal tTributable = tImp.add(dTributable);
                pBP.set_CustomColumn("Total1", tTributable);
                pBP.saveEx();
                String useUTax = DB.getSQLValueString(this.get_TrxName(), "SELECT MAX(UseUniqueTax) FROM HR_Employee  WHERE C_Bpartner_ID=" + rs.getInt("C_Bpartner_ID"), new Object[0]);
                if (useUTax != null && useUTax.compareTo("Y") == 0) {
                    String Type2 = DB.getSQLValueString(this.get_TrxName(), "SELECT MAX(TypeUniqueTax) FROM HR_Employee  WHERE C_Bpartner_ID=" + rs.getInt("C_Bpartner_ID"), new Object[0]);
                    int ID_UniqueTax = DB.getSQLValue(this.get_TrxName(), "SELECT HR_SingleTax_id FROM HR_SingleTax  WHERE " + pBP.get_Value("Total1") + " BETWEEN minAmt AND MaxAmt AND C_Period_ID = ? AND Type='" + Type2 + "'", MPeriod.getC_Period_ID(this.getCtx(), pro.getDateAcct(), pro.getAD_Org_ID()));
                    if (ID_UniqueTax > 0) {
                        BigDecimal discount;
                        BigDecimal percent = DB.getSQLValueBD(this.get_TrxName(), "SELECT Percentage FROM HR_SIngleTax WHERE HR_SIngleTax_ID=" + ID_UniqueTax, new Object[0]);
                        if (percent == null) {
                            percent = Env.ZERO;
                        }
                        if ((discount = DB.getSQLValueBD(this.get_TrxName(), "SELECT DiscountAmt FROM HR_SIngleTax WHERE HR_SIngleTax_ID=" + ID_UniqueTax, new Object[0])) == null) {
                            discount = Env.ZERO;
                        }
                        BigDecimal taxUniqueAmt = (BigDecimal)pBP.get_Value("Total1");
                        taxUniqueAmt = taxUniqueAmt.multiply(percent).subtract(discount);
                        X_HR_ProcessBPDetail bpDet11 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                        bpDet11.setHR_ProcessBP_ID(pBP.get_ID());
                        bpDet11.setAD_Org_ID(pBP.getAD_Org_ID());
                        int ID_Concept = DB.getSQLValue(this.get_TrxName(), "SELECT HR_Concept_ID FROM HR_Concept c  WHERE upper(c.description) = 'UNICO'");
                        if (ID_Concept > 0) {
                            bpDet11.setHR_Concept_ID(ID_Concept);
                        }
                        bpDet11.setAmount(taxUniqueAmt.negate().setScale(0, RoundingMode.HALF_EVEN));
                        bpDet11.saveEx();
                    }
                }
                if ((tLiq = DB.getSQLValueBD(this.get_TrxName(), "SELECT COALESCE(SUM(Amount),0) FROM HR_ProcessBPDetail  WHERE HR_ProcessBP_ID=" + pBP.get_ID(), new Object[0])) != null) {
                    tLiq = tLiq.setScale(0, RoundingMode.HALF_EVEN);
                    pBP.set_CustomColumn("Total2", tLiq);
                }
                pBP.saveEx();
                String sqlBienestarTr = "SELECT * FROM HR_Welfare WHERE C_Bpartner_ID = ? AND IsTaxable = 'Y'";
                CPreparedStatement pstmtBienestarTr = DB.prepareStatement(sqlBienestarTr, this.get_TrxName());
                pstmtBienestarTr.setInt(1, rs.getInt("C_Bpartner_ID"));
                ResultSet rsBienestarTr = pstmtBienestarTr.executeQuery();
                while (rsBienestarTr.next()) {
                    String mesWel = "";
                    mesWel = rsBienestarTr.getString("months") != null && rsBienestarTr.getString("months").trim().length() > 0 ? "-" + rsBienestarTr.getString("months") + "-" : mes;
                    if (!mesWel.contains(mes) || rsBienestarTr.getString("Type") == null || rsBienestarTr.getString("Type").compareTo("P") != 0 || rs.getInt("HR_Concept_ID") <= 0) continue;
                    BigDecimal amtCon = (BigDecimal)pBP.get_Value("TotalAmt");
                    if (amtCon == null) {
                        amtCon = Env.ZERO;
                    }
                    BigDecimal amount = rs.getBigDecimal("Amount");
                    amount = amount.multiply(amtCon).divide(Env.ZERO, 0, RoundingMode.HALF_EVEN);
                    X_HR_ProcessBPDetail bpDet12 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                    bpDet12.setHR_ProcessBP_ID(pBP.get_ID());
                    bpDet12.setAD_Org_ID(pBP.getAD_Org_ID());
                    bpDet12.setHR_Concept_ID(rsBienestar.getInt("HR_Concept_ID"));
                    if (amount != null) {
                        bpDet12.setAmount(amount);
                    }
                    bpDet12.saveEx();
                }
                DB.executeUpdate("UPDATE HR_ProcessBP SET HR_RETIREMENT = TotalAMT * 0.014  WHERE HR_ProcessBP_ID = " + pBP.get_ID(), this.get_TrxName());
                DB.executeUpdate("UPDATE HR_ProcessBP SET HR_SIS = TotalAMT * 0.0141  WHERE HR_ProcessBP_ID = " + pBP.get_ID(), this.get_TrxName());
                DB.executeUpdate("UPDATE HR_ProcessBP SET HR_Health = TotalAMT * 0.0093  WHERE HR_ProcessBP_ID = " + pBP.get_ID(), this.get_TrxName());
            }
        }
        return "Procesado " + logM;
    }

    public static BigDecimal getRate(int CurFrom_ID, int CurTo_ID, Timestamp ConvDate, int ConversionType_ID, int AD_Client_ID, int AD_Org_ID) {
        if (CurFrom_ID == CurTo_ID) {
            return Env.ONE;
        }
        int C_ConversionType_ID = ConversionType_ID;
        if (C_ConversionType_ID == 0) {
            C_ConversionType_ID = MConversionType.getDefault(AD_Client_ID);
        }
        if (ConvDate == null) {
            ConvDate = new Timestamp(System.currentTimeMillis());
        }
        String sql = "SELECT MultiplyRate FROM C_Conversion_Rate WHERE IsTaxable = 'Y'  AND C_Currency_ID=? AND C_Currency_ID_To=? AND\tC_ConversionType_ID=? AND ? BETWEEN EXTRACT (month from ValidFrom) AND EXTRACT (month from ValidTo) AND AD_Client_ID IN (0,?) AND AD_Org_ID IN (0,?) ORDER BY AD_Client_ID DESC, AD_Org_ID DESC, ValidFrom DESC";
        BigDecimal retValue = null;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, CurFrom_ID);
            pstmt.setInt(2, CurTo_ID);
            pstmt.setInt(3, C_ConversionType_ID);
            pstmt.setInt(4, ConvDate.getMonth() + 1);
            pstmt.setInt(5, AD_Client_ID);
            pstmt.setInt(6, AD_Org_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getBigDecimal(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "getRate", e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (retValue == null) {
            s_log.info("getRate - not found - CurFrom=" + CurFrom_ID + ", CurTo=" + CurTo_ID + ", " + ConvDate + ", Type=" + ConversionType_ID + (ConversionType_ID == C_ConversionType_ID ? "" : "->" + C_ConversionType_ID) + ", Client=" + AD_Client_ID + ", Org=" + AD_Org_ID);
        }
        return retValue;
    }
}

