/*
 * Decompiled with CFR 0.152.
 */
package org.minju.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCash;
import org.compiere.model.MCashLine;
import org.compiere.model.MElementValue;
import org.compiere.model.X_GL_BudgetControlLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ProcessCash
extends SvrProcess {
    private int p_Cash_ID = 0;
    private String p_Action = "PR";
    private int flag = 0;
    private static CLogger s_log = CLogger.getCLogger(MElementValue.class);

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("Action")) {
                this.p_Action = para[i].getParameterAsString();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.p_Cash_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        if (this.p_Cash_ID > 0) {
            MCash cash = new MCash(this.getCtx(), this.p_Cash_ID, this.get_TrxName());
            String newStatus = "DR";
            String newAction = "DR";
            this.log.config("paction " + this.p_Action);
            if (cash.getDocStatus().compareTo("DR") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "SS";
                newAction = "SS";
            } else if (cash.getDocStatus().compareTo("SS") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "AJ";
                newAction = "AJ";
            } else if (cash.getDocStatus().compareTo("AJ") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "AV";
                newAction = "AV";
            } else if (cash.getDocStatus().compareTo("AV") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "AN";
                newAction = "AN";
            } else if (cash.getDocStatus().compareTo("AN") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "GA";
                newAction = "GA";
            } else if (cash.getDocStatus().compareTo("GA") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "AB";
                newAction = "AB";
            } else if (cash.getDocStatus().compareTo("AB") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "AY";
                newAction = "AY";
            } else if (cash.getDocStatus().compareTo("AY") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "AO";
                newAction = "AO";
            } else if (cash.getDocStatus().compareTo("AO") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "AR";
                newAction = "AR";
            } else if (cash.getDocStatus().compareTo("AR") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "AA";
                newAction = "AA";
            } else if (cash.getDocStatus().compareTo("AA") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "EF";
                newAction = "EF";
            } else if (cash.getDocStatus().compareTo("EF") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "RR";
                newAction = "RR";
            } else if (cash.getDocStatus().compareTo("RR") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "AZ";
                newAction = "AZ";
            } else if (cash.getDocStatus().compareTo("AZ") == 0 && this.p_Action.compareTo("CO") == 0) {
                newStatus = "CO";
                newAction = "CO";
            } else if (cash.getDocStatus().compareTo("AY") == 0 && (this.p_Action.compareTo("AN") == 0 || this.p_Action.compareTo("AB") == 0)) {
                newStatus = this.p_Action;
                newAction = this.p_Action;
                this.flag = 1;
            } else if (cash.getDocStatus().compareTo("AO") == 0 && (this.p_Action.compareTo("AN") == 0 || this.p_Action.compareTo("AB") == 0)) {
                newStatus = this.p_Action;
                newAction = this.p_Action;
                this.flag = 1;
            } else if (cash.getDocStatus().compareTo("AR") == 0 && (this.p_Action.compareTo("AN") == 0 || this.p_Action.compareTo("AB") == 0)) {
                newStatus = this.p_Action;
                newAction = this.p_Action;
                this.flag = 1;
            } else if (cash.getDocStatus().compareTo("AA") == 0 && (this.p_Action.compareTo("AN") == 0 || this.p_Action.compareTo("AB") == 0)) {
                newStatus = this.p_Action;
                newAction = this.p_Action;
                this.flag = 1;
            } else if (cash.getDocStatus().compareTo("EF") == 0 && (this.p_Action.compareTo("AN") == 0 || this.p_Action.compareTo("AB") == 0)) {
                newStatus = this.p_Action;
                newAction = this.p_Action;
                this.flag = 1;
            } else if (cash.getDocStatus().compareTo("RR") == 0 && (this.p_Action.compareTo("AN") == 0 || this.p_Action.compareTo("AB") == 0)) {
                newStatus = this.p_Action;
                newAction = this.p_Action;
                this.flag = 1;
            } else if (cash.getDocStatus().compareTo("AZ") == 0 && (this.p_Action.compareTo("AN") == 0 || this.p_Action.compareTo("AB") == 0)) {
                newStatus = this.p_Action;
                newAction = this.p_Action;
                this.flag = 1;
            }
            int cant = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM AD_Document_Action_Access daa INNER JOIN AD_Ref_List rl ON (daa.AD_Ref_List_ID = rl.AD_Ref_List_ID)  WHERE value = '" + newAction + "' AND AD_Role_ID = " + Env.getAD_Role_ID(this.getCtx()) + " AND C_DocType_ID = " + cash.get_ValueAsInt("C_DocType_ID"));
            this.log.config("cantidad" + cant);
            if (cant > 0) {
                if (newAction.compareTo("CO") != 0) {
                    MCashLine cLine;
                    int i;
                    MCashLine[] lines;
                    if (newAction.compareTo("SS") == 0) {
                        String records = "SELECT count(1) from ad_attachment where ad_table_id = 407 and record_id = " + cash.get_ID();
                        int recordsqty = DB.getSQLValue(this.get_TrxName(), records);
                        if (recordsqty < 1) {
                            throw new AdempiereException("Debe revisar que exista al menos un adjunto en cabecera");
                        }
                        String sqlobtainutm = "SELECT coalesce(MultiplyRate,0) FROM C_Conversion_Rate WHERE C_Currency_ID = ?  AND ValidFrom <= '" + cash.getStatementDate() + "' AND ValidTo >= '" + cash.getStatementDate() + "'";
                        int utmid = 2000001;
                        this.log.config("sqlobtainutm " + sqlobtainutm);
                        BigDecimal utmvalue = DB.getSQLValueBD(this.get_TrxName(), sqlobtainutm, utmid);
                        if (utmvalue == null || utmvalue.compareTo(Env.ZERO) <= 0) {
                            throw new AdempiereException("La UTM no esta definida");
                        }
                        MCashLine[] lines2 = cash.getLines(true);
                        int i2 = 0;
                        while (i2 < lines2.length) {
                            MCashLine cLine2 = lines2[i2];
                            int validcombination = cLine2.get_ValueAsInt("C_ValidCombination_ID");
                            String sqlaccountname = "SELECT Combination from C_ValidCombination where  c_validcombination_id = ?";
                            String accountname = DB.getSQLValueString(this.get_TrxName(), sqlaccountname, validcombination);
                            String sqlgetaccount = "SELECT IsAccountBasic FROM C_ElementValue WHERE  C_ElementValue_ID in (SELECT Account_ID from C_ValidCombination  WHERE C_ValidCombination_ID = ?)";
                            CPreparedStatement pstmt = null;
                            pstmt = DB.prepareStatement(sqlgetaccount, this.get_TrxName());
                            pstmt.setInt(1, validcombination);
                            this.log.config("config: " + sqlgetaccount);
                            ResultSet rs = pstmt.executeQuery();
                            rs.next();
                            String accountst = rs.getString("IsAccountBasic");
                            if (accountst.compareTo("N") == 0 && cLine2.getCashType().compareTo("E") == 0) {
                                String sumofvalues = "SELECT sum(abs(Amount)) from C_CashLine  WHERE  C_ValidCombination_ID = ? AND C_Cash_ID = " + cLine2.getC_Cash_ID() + " and CashType like 'E'";
                                BigDecimal sum = DB.getSQLValueBD(this.get_TrxName(), sumofvalues, validcombination);
                                if (sum.compareTo(utmvalue) < 0) {
                                    throw new AdempiereException("El monto total de la cuenta " + accountname + " no debe ser menor a 1 UTM.");
                                }
                            }
                            if (cLine2.getCashType().compareTo("T") != 0) {
                                int id_budget = cLine2.get_ValueAsInt("GL_BudgetControlLine_ID");
                                BigDecimal amount = cLine2.getAmount().abs();
                                X_GL_BudgetControlLine gl = new X_GL_BudgetControlLine(this.getCtx(), id_budget, this.get_TrxName());
                                BigDecimal amount2 = gl.getAmount2();
                                if (amount2 == null) {
                                    amount2 = Env.ZERO;
                                }
                                gl.setAmount2(amount2.subtract(amount));
                                gl.save();
                            }
                            ++i2;
                        }
                    }
                    if (newAction.compareTo("AB") == 0 && this.flag == 0 && (cash.getDocStatus().compareTo("DR") == 0 || cash.getDocStatus().compareTo("SS") == 0 || cash.getDocStatus().compareTo("AJ") == 0 || cash.getDocStatus().compareTo("AV") == 0 || cash.getDocStatus().compareTo("AN") == 0 || cash.getDocStatus().compareTo("GA") == 0)) {
                        lines = cash.getLines(true);
                        i = 0;
                        while (i < lines.length) {
                            cLine = lines[i];
                            if (cLine.getCashType().compareTo("T") != 0) {
                                int validcomb = cLine.get_ValueAsInt("C_ValidCombination_ID");
                                String cuenta = DB.getSQLValueString(cash.get_TrxName(), "SELECT alias FROM C_validcombination where c_validcombination_id = ?", validcomb);
                                int adorg = cash.getAD_Org_ID();
                                Date date = new Date();
                                date = cash.getDateAcct();
                                this.log.config("date " + date);
                                int year = Integer.parseInt(new SimpleDateFormat("yyyy").format(date));
                                String sql = "SELECT coalesce(max(gl_budgetcontrolline_id),0) from gl_budgetcontrolline where ad_org_id = " + adorg + " " + " and c_validcombination_id = " + validcomb + " AND GL_BudgetDetail_ID in ( SELECT " + " gl_budgetdetail_id from gl_budgetdetail where gl_budgetcontrol_id in " + "(SELECT gl_budgetcontrol_id from gl_budgetcontrol where gl_budgetcontrolheader_id in " + "(select gl_budgetcontrolheader_id from gl_budgetcontrolheader where c_year_id in " + "(SELECT c_year_id from c_year where fiscalyear like '" + year + "'))))";
                                int count = DB.getSQLValue(cash.get_TrxName(), sql);
                                if (count <= 0) {
                                    throw new AdempiereException("No hay asignacion para la cuenta " + cuenta);
                                }
                                BigDecimal amount = cLine.getAmount().abs();
                                X_GL_BudgetControlLine gl = new X_GL_BudgetControlLine(this.getCtx(), count, this.get_TrxName());
                                BigDecimal available = gl.getAmount().subtract(gl.getAmount3());
                                if (available.compareTo(amount) >= 0) {
                                    BigDecimal amount2 = gl.getAmount2();
                                    if (amount2 == null) {
                                        amount2 = Env.ZERO;
                                    }
                                    gl.setAmount2(amount2.add(amount));
                                    gl.save();
                                    cLine.set_CustomColumn("GL_BudgetControlLine_ID", count);
                                    cLine.save();
                                } else {
                                    throw new AdempiereException("No hay monto suficiente. Disponible: " + available.setScale(0, 4));
                                }
                            }
                            ++i;
                        }
                    }
                    if (newAction.compareTo("AB") == 0 && this.flag == 1) {
                        cash.set_CustomColumn("ForBudget", false);
                    }
                    if (newAction.compareTo("AN") == 0 && this.flag == 1) {
                        cash.set_CustomColumn("ForBudget", false);
                        lines = cash.getLines(true);
                        i = 0;
                        while (i < lines.length) {
                            cLine = lines[i];
                            if (cLine.getCashType().compareTo("T") != 0) {
                                int id_budget = cLine.get_ValueAsInt("GL_BudgetControlLine_ID");
                                BigDecimal amount = cLine.getAmount().abs();
                                X_GL_BudgetControlLine gl = new X_GL_BudgetControlLine(this.getCtx(), id_budget, this.get_TrxName());
                                BigDecimal amount2 = gl.getAmount2();
                                if (amount2 == null) {
                                    amount2 = Env.ZERO;
                                }
                                gl.setAmount2(amount2.subtract(amount));
                                gl.save();
                            }
                            ++i;
                        }
                    }
                    cash.setDocStatus(newStatus);
                    cash.save();
                } else if (newAction.compareTo("CO") == 0) {
                    MCashLine[] lines = cash.getLines(true);
                    int i = 0;
                    while (i < lines.length) {
                        MCashLine cLine = lines[i];
                        if (cLine.getCashType().compareTo("T") != 0) {
                            int id_budget = cLine.get_ValueAsInt("GL_BudgetControlLine_ID");
                            BigDecimal amount = cLine.getAmount().abs();
                            X_GL_BudgetControlLine gl = new X_GL_BudgetControlLine(this.getCtx(), id_budget, this.get_TrxName());
                            BigDecimal available = gl.getAmount().subtract(gl.getAmount3());
                            if (available.compareTo(amount) >= 0) {
                                BigDecimal amount3 = gl.getAmount3();
                                if (amount3 == null) {
                                    amount3 = Env.ZERO;
                                }
                                gl.setAmount3(amount3.add(amount));
                                BigDecimal amount8 = (BigDecimal)gl.get_Value("Amount8");
                                if (amount8 == null) {
                                    amount8 = Env.ZERO;
                                }
                                gl.set_CustomColumn("Amount8", amount8.add(amount));
                                gl.save();
                            } else {
                                throw new AdempiereException("No hay monto suficiente: Disponible " + available);
                            }
                        }
                        ++i;
                    }
                    cash.setDocStatus("IP");
                    cash.processIt("CO");
                    cash.save();
                }
            } else {
                throw new AdempiereException("Error: Permisos de rol insuficientes");
            }
        }
        return "Procesado";
    }
}

