/*
 * Decompiled with CFR 0.152.
 */
package org.minju.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import org.compiere.model.MPeriod;
import org.compiere.model.X_HR_AttendanceHours;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class GenerateAttendanceHoursV2
extends SvrProcess {
    private int p_Period = 0;
    private int p_BPartner = 0;
    private Timestamp p_From;
    private Timestamp p_To;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DateTo")) {
                this.p_To = (Timestamp)para[i].getParameter();
            } else if (name.equals("C_BPartner_ID")) {
                this.p_BPartner = ((BigDecimal)para[i].getParameter()).intValue();
            } else if (name.equals("DateFrom")) {
                this.p_From = (Timestamp)para[i].getParameter();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.p_From != null && this.p_To != null) {
            MPeriod period = new MPeriod(this.getCtx(), this.p_Period, this.get_TrxName());
            String sql = "DELETE from HR_AttendanceHours WHERE datetrx  between '" + this.p_From + "' AND '" + this.p_To + "'";
            if (this.p_BPartner > 0) {
                sql = String.valueOf(sql) + " AND c_bpartner_id = " + this.p_BPartner;
            }
            this.log.config("SQL DELETE " + sql);
            DB.executeUpdate(sql, this.get_TrxName());
            String sqlgethours = "SELECT fecha, ad_org_id, c_bpartner_id, dia, entrada -interval '1 hour' as entrada, salida -interval '1 hour' as salida, horas_trabajadas, incidencias, compensadas,  atrasobase,  horasmediamannana FROM RVOFB_Reloj_Control WHERE fecha  between '" + this.p_From + "' AND '" + this.p_To + "'";
            if (this.p_BPartner > 0) {
                sqlgethours = String.valueOf(sqlgethours) + " AND c_bpartner_id = " + this.p_BPartner;
            }
            this.log.config("SQL obtener desde vista " + sqlgethours);
            CPreparedStatement pstmt = DB.prepareStatement(sqlgethours, this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Date nighthourscalc;
                Date differencehours;
                Date precalcovertime2;
                Date precalcovertime1;
                Date precalcexit2;
                Date precalcexit1;
                Date earlyexit;
                Date precalcexit;
                Timestamp atrasocalculado;
                Date delaybegin;
                Date endmidmorning;
                Date maxearlyexit;
                Date earlyexitbase;
                Date midmorninghours;
                Date workinghours;
                X_HR_AttendanceHours att = new X_HR_AttendanceHours(this.getCtx(), 0, this.get_TrxName());
                int hoursqty = rs.getInt("compensadas");
                Timestamp actualdate = rs.getTimestamp("fecha");
                Timestamp time = new Timestamp(hoursqty);
                Date entryhour = new Date(rs.getTimestamp("entrada").getTime());
                Timestamp exithour = rs.getTimestamp("salida");
                Date compensadas = GenerateAttendanceHoursV2.calculateHours(actualdate, hoursqty, 0);
                Timestamp cff = new Timestamp(compensadas.getTime());
                String incidencias = rs.getString("incidencias");
                this.log.config("entry " + rs.getTimestamp("entrada"));
                att.setEntryHour(new Timestamp(entryhour.getTime()));
                att.setExitHour(exithour);
                att.setDateTrx(rs.getTimestamp("fecha"));
                att.setAD_Org_ID(rs.getInt("ad_org_id"));
                att.setC_BPartner_ID(rs.getInt("c_bpartner_id"));
                att.setDayOfWeek(rs.getString("dia"));
                att.setDescription(incidencias);
                att.setCompensatedTime(cff);
                att.setDelayBase(rs.getTimestamp("atrasobase"));
                att.saveEx(this.get_TrxName());
                String fecha = rs.getString("dia");
                if (fecha.compareToIgnoreCase("Domingo") == 0 || fecha.endsWith("bado")) {
                    workinghours = GenerateAttendanceHoursV2.calculateHours(actualdate, 0, 0);
                    midmorninghours = GenerateAttendanceHoursV2.calculateHours(actualdate, 0, 0);
                    earlyexitbase = GenerateAttendanceHoursV2.calculateHours(actualdate, 0, 0);
                    maxearlyexit = GenerateAttendanceHoursV2.calculateHours(actualdate, 0, 0);
                    endmidmorning = GenerateAttendanceHoursV2.calculateHours(actualdate, 0, 0);
                } else if (fecha.compareToIgnoreCase("Viernes") == 0) {
                    workinghours = GenerateAttendanceHoursV2.calculateHours(actualdate, 9, 0);
                    midmorninghours = GenerateAttendanceHoursV2.calculateHours(actualdate, 5, 0);
                    earlyexitbase = GenerateAttendanceHoursV2.calculateHours(actualdate, 18, 30);
                    maxearlyexit = GenerateAttendanceHoursV2.calculateHours(actualdate, 17, 0);
                    endmidmorning = GenerateAttendanceHoursV2.calculateHours(actualdate, 14, 30);
                } else {
                    workinghours = GenerateAttendanceHoursV2.calculateHours(actualdate, 10, 0);
                    midmorninghours = GenerateAttendanceHoursV2.calculateHours(actualdate, 5, 30);
                    earlyexitbase = GenerateAttendanceHoursV2.calculateHours(actualdate, 19, 30);
                    maxearlyexit = GenerateAttendanceHoursV2.calculateHours(actualdate, 18, 0);
                    endmidmorning = new Timestamp(GenerateAttendanceHoursV2.calculateHours(actualdate, 15, 0).getTime());
                }
                this.log.config("working hours " + workinghours);
                this.log.config("midmorninghours " + midmorninghours);
                this.log.config("earlyexitbase " + earlyexitbase);
                this.log.config("working hours " + new Timestamp(GenerateAttendanceHoursV2.calculateHours(actualdate, 14, 0).getTime()));
                this.log.config("maearlyexit " + maxearlyexit);
                att.setWorkingHours(new Timestamp(workinghours.getTime()));
                att.setMidMorningHours(new Timestamp(midmorninghours.getTime()));
                att.setEndMidMorning(new Timestamp(endmidmorning.getTime()));
                att.setEarlyExitBase(new Timestamp(earlyexitbase.getTime()));
                att.setMaxEarlyExit(new Timestamp(maxearlyexit.getTime()));
                int hoursamqty = 0;
                int hourspmqty = 0;
                if (incidencias.contains("COM(MA)")) {
                    String sqlam = "SELECT coalesce(sum(hours),0) from hr_administrativerequestsl where date01 = '" + actualdate + "' and " + " hr_administrativerequests_id in (select hr_Administrativerequests_id from hr_Administrativerequests " + " where requesttype like 'COM' and c_bpartner_id = ? " + " AND comments like '%AM%') and isactive='Y'";
                    BigDecimal hoursam = DB.getSQLValueBD(this.get_TrxName(), sqlam, rs.getInt("C_BPartner_ID"));
                    hoursamqty += hoursam.intValue();
                }
                if (incidencias.contains("COM(TA)")) {
                    String sqlpm = "SELECT coalesce(sum(hours),0) from hr_administrativerequestsl where date01 = '" + actualdate + "' and " + " hr_administrativerequests_id in (select hr_Administrativerequests_id from hr_Administrativerequests " + " where requesttype like 'COM' and c_bpartner_id = ? " + " AND comments like '%PM%') and isactive='Y'";
                    BigDecimal hourspm = DB.getSQLValueBD(this.get_TrxName(), sqlpm, rs.getInt("C_BPartner_ID"));
                    this.log.config("hours pm config " + hourspm);
                    hourspmqty += hourspm.intValue();
                }
                if (incidencias.contains("DA(AM)")) {
                    String sqlamda = "SELECT coalesce(sum(hours),0) from hr_administrativerequestsl where datestartrequest = '" + actualdate + "' and " + " hr_administrativerequests_id in (select hr_Administrativerequests_id from hr_Administrativerequests " + " where requesttype like 'DAA' and c_bpartner_id = ? " + " AND comments like '%AM%') and isactive='Y'";
                    BigDecimal hoursamda = DB.getSQLValueBD(this.get_TrxName(), sqlamda, rs.getInt("C_BPartner_ID"));
                    hoursamqty += hoursamda.intValue();
                }
                if (incidencias.contains("DA(PM)")) {
                    String sqlpmda = "SELECT coalesce(sum(hours),0) from hr_administrativerequestsl where datestartrequest = '" + actualdate + "' and " + " hr_administrativerequests_id in (select hr_Administrativerequests_id from hr_Administrativerequests " + " where requesttype like 'DAA' and c_bpartner_id = ? " + " AND comments like '%PM%') and isactive='Y'";
                    BigDecimal hourspmda = DB.getSQLValueBD(this.get_TrxName(), sqlpmda, rs.getInt("C_BPartner_ID"));
                    hourspmqty += hourspmda.intValue();
                }
                if (incidencias.contains("CAP(AM)")) {
                    String sqlamcap = "SELECT coalesce(sum(hours),0) from hr_administrativerequestsl where datestartrequest = '" + actualdate + "' and " + " hr_administrativerequests_id in (select hr_Administrativerequests_id from hr_Administrativerequests " + " where requesttype like 'CTN' and c_bpartner_id = ? " + " AND comments like '%AM%') and isactive='Y'";
                    BigDecimal hoursamcap = DB.getSQLValueBD(this.get_TrxName(), sqlamcap, rs.getInt("C_BPartner_ID"));
                    hoursamqty += hoursamcap.intValue();
                }
                if (incidencias.contains("CAP(PM)")) {
                    String sqlpmcap = "SELECT coalesce(sum(hours),0) from hr_administrativerequestsl where datestartrequest = '" + actualdate + "' and " + " hr_administrativerequests_id in (select hr_Administrativerequests_id from hr_Administrativerequests " + " where requesttype like 'CTN' and c_bpartner_id = ? " + " AND comments like '%PM%') and isactive='Y'";
                    BigDecimal hourspmcap = DB.getSQLValueBD(this.get_TrxName(), sqlpmcap, rs.getInt("C_BPartner_ID"));
                    hourspmqty += hourspmcap.intValue();
                }
                Date specialdayentry = GenerateAttendanceHoursV2.calculateHours(actualdate, hoursamqty + 1, 0);
                Date specialdayexit = GenerateAttendanceHoursV2.calculateHours(actualdate, hourspmqty + 1, 0);
                att.setSpecialDayEntry(new Timestamp(specialdayentry.getTime()));
                att.setSpecialDayExit(new Timestamp(specialdayexit.getTime()));
                Date workedhoursforcalc = incidencias.contains("PA(MA)") || incidencias.contains("PA(TA)") ? new Date(midmorninghours.getTime()) : (workinghours.getTime() - specialdayentry.getTime() + ((Date)actualdate).getTime() - specialdayexit.getTime() + ((Date)actualdate).getTime() < ((Date)actualdate).getTime() ? GenerateAttendanceHoursV2.calculateHours(workinghours, hoursqty, 0) : new Date(workinghours.getTime() - specialdayentry.getTime() + ((Date)actualdate).getTime() - specialdayexit.getTime() + ((Date)actualdate).getTime()));
                att.setWorkedHoursForCalc(new Timestamp(workedhoursforcalc.getTime()));
                this.log.config("bla " + hoursqty);
                Date workedhourscalc = new Date(exithour.getTime() - entryhour.getTime());
                this.log.config("entry hour" + entryhour);
                this.log.config("entryhourtime" + entryhour.getTime());
                this.log.config("worked hours calc " + workedhourscalc);
                workedhourscalc = new Date(workedhourscalc.getTime() + ((Date)actualdate).getTime());
                this.log.config("workedhourscalc updated " + workedhourscalc);
                att.setWorkedHoursCalc(new Timestamp(workedhourscalc.getTime()));
                if (fecha.compareToIgnoreCase("Domingo") == 0 || fecha.endsWith("bado")) {
                    delaybegin = GenerateAttendanceHoursV2.calculateHours(actualdate, 23, 59);
                    atrasocalculado = new Timestamp(GenerateAttendanceHoursV2.calculateHours(actualdate, 23, 59).getTime());
                } else if (incidencias.contains("PA(MA)")) {
                    delaybegin = endmidmorning;
                    atrasocalculado = new Timestamp(GenerateAttendanceHoursV2.calculateHours(actualdate, 14, 0).getTime());
                } else {
                    delaybegin = new Date(rs.getTimestamp("atrasobase").getTime() + specialdayentry.getTime() - ((Date)actualdate).getTime());
                    atrasocalculado = rs.getTimestamp("atrasobase");
                }
                att.setDelayBegin(new Timestamp(delaybegin.getTime()));
                Date entryhourdate = new Date(entryhour.getTime());
                Date atrasocalculadodate = new Date(atrasocalculado.getTime());
                Date delaycalc = entryhour.compareTo(delaybegin) > 0 ? (hoursqty > 0 ? (entryhourdate.getTime() - delaybegin.getTime() - cff.getTime() + ((Date)actualdate).getTime() + ((Date)actualdate).getTime() < ((Date)actualdate).getTime() ? GenerateAttendanceHoursV2.calculateHours(actualdate, 0, 0) : new Date(entryhourdate.getTime() - delaybegin.getTime() - cff.getTime() + ((Date)actualdate).getTime() + ((Date)actualdate).getTime())) : new Date(entryhourdate.getTime() - delaybegin.getTime() + ((Date)actualdate).getTime())) : GenerateAttendanceHoursV2.calculateHours(actualdate, 0, 0);
                att.setDelayCalc(new Timestamp(delaycalc.getTime()));
                if (entryhour.compareTo(delaybegin) < 0) {
                    precalcexit = new Date(entryhour.getTime() + workedhoursforcalc.getTime());
                    precalcexit = new Date(precalcexit.getTime() - ((Date)actualdate).getTime());
                } else {
                    precalcexit = earlyexitbase;
                }
                att.setPreCalcExit(new Timestamp(precalcexit.getTime()));
                Date calcexit = new Date();
                Date calcexitaux = new Date(entryhour.getTime() + workedhoursforcalc.getTime());
                this.log.config("calcexitaux " + calcexitaux);
                calcexitaux = new Date(calcexitaux.getTime() - ((Date)actualdate).getTime());
                if (entryhour.compareTo(delaybegin) < 0) {
                    this.log.config("calcexitaux " + calcexitaux);
                    if (calcexitaux.compareTo(maxearlyexit) < 0) {
                        this.log.config("calcexitaux " + calcexitaux);
                        calcexit = maxearlyexit;
                    } else {
                        calcexit = calcexitaux;
                    }
                } else {
                    this.log.config("calcexitaux " + calcexitaux);
                    calcexit = earlyexitbase;
                }
                att.setCalcExit(new Timestamp(calcexit.getTime()));
                if (incidencias.contains("PA(TA)")) {
                    earlyexit = endmidmorning;
                } else {
                    earlyexit = new Date(calcexit.getTime() - specialdayexit.getTime());
                    earlyexit = new Date(earlyexit.getTime() + ((Date)actualdate).getTime());
                }
                att.setEarlyExit(new Timestamp(earlyexit.getTime()));
                if (exithour.getTime() > ((Date)actualdate).getTime()) {
                    if (exithour.compareTo(earlyexit) < 0) {
                        if (compensadas.getTime() > ((Date)actualdate).getTime()) {
                            Date precalcaux = new Date(earlyexit.getTime() - exithour.getTime() - compensadas.getTime());
                            precalcexit1 = (precalcaux = new Date(precalcaux.getTime() + ((Date)actualdate).getTime() + ((Date)actualdate).getTime())).getTime() < ((Date)actualdate).getTime() ? GenerateAttendanceHoursV2.calculateHours(actualdate, 0, 0) : precalcaux;
                        } else {
                            precalcexit1 = new Date(earlyexit.getTime() - exithour.getTime());
                            precalcexit1 = new Date(precalcexit1.getTime() + ((Date)actualdate).getTime());
                        }
                    } else {
                        precalcexit1 = GenerateAttendanceHoursV2.calculateHours(actualdate, 0, 0);
                    }
                } else {
                    precalcexit1 = GenerateAttendanceHoursV2.calculateHours(actualdate, 0, 0);
                }
                att.setPreCalcExit1(new Timestamp(precalcexit1.getTime()));
                if (entryhour.getTime() > ((Date)actualdate).getTime()) {
                    if (delaybegin.compareTo(entryhour) > 0) {
                        precalcexit2 = new Date(delaybegin.getTime() - entryhour.getTime());
                        precalcexit2 = new Date(precalcexit2.getTime() + ((Date)actualdate).getTime());
                    } else {
                        precalcexit2 = GenerateAttendanceHoursV2.calculateHours(actualdate, 0, 0);
                    }
                } else {
                    precalcexit2 = GenerateAttendanceHoursV2.calculateHours(actualdate, 0, 0);
                }
                att.setPreCalcExit2(new Timestamp(precalcexit2.getTime()));
                Date exitcalc = fecha.compareToIgnoreCase("Domingo") == 0 || fecha.endsWith("bado") ? GenerateAttendanceHoursV2.calculateHours(actualdate, 0, 0) : precalcexit1;
                att.setExitCalc(new Timestamp(exitcalc.getTime()));
                Date sumdelayearlyworked = new Date(precalcexit1.getTime() + delaycalc.getTime() + workedhourscalc.getTime());
                this.log.config("sumdelayearlyworked " + sumdelayearlyworked);
                sumdelayearlyworked = new Date(sumdelayearlyworked.getTime() - ((Date)actualdate).getTime() - ((Date)actualdate).getTime());
                this.log.config("sumdelayearlyworked " + sumdelayearlyworked);
                att.setSumDelayEarlyWorked(new Timestamp(sumdelayearlyworked.getTime()));
                Date overtime = GenerateAttendanceHoursV2.calculateHours(actualdate, 9, 0);
                att.setOverTime(new Timestamp(overtime.getTime()));
                if (workedhourscalc.compareTo(workedhoursforcalc) > 0) {
                    precalcovertime1 = new Date(workedhourscalc.getTime() - workedhoursforcalc.getTime());
                    precalcovertime1 = new Date(precalcovertime1.getTime() + ((Date)actualdate).getTime());
                } else {
                    precalcovertime1 = GenerateAttendanceHoursV2.calculateHours(actualdate, 0, 0);
                }
                att.setPreCalcOvertime1(new Timestamp(precalcovertime1.getTime()));
                if (exithour.compareTo(earlyexit) > 0) {
                    precalcovertime2 = new Date(exithour.getTime() - earlyexit.getTime());
                    precalcovertime2 = new Date(precalcovertime2.getTime() + ((Date)actualdate).getTime());
                } else {
                    precalcovertime2 = GenerateAttendanceHoursV2.calculateHours(actualdate, 0, 0);
                }
                att.setPreCalcOvertime2(new Timestamp(precalcovertime2.getTime()));
                Date maxdaytime = fecha.compareToIgnoreCase("Domingo") == 0 || fecha.endsWith("bado") ? GenerateAttendanceHoursV2.calculateHours(actualdate, 0, 0) : (fecha.compareToIgnoreCase("Viernes") == 0 ? GenerateAttendanceHoursV2.calculateHours(actualdate, 6, 0) : GenerateAttendanceHoursV2.calculateHours(actualdate, 5, 0));
                att.setMaxDayTime(new Timestamp(maxdaytime.getTime()));
                if (entryhour.getTime() > ((Date)actualdate).getTime()) {
                    if (entryhour.compareTo(overtime) < 0) {
                        differencehours = new Date(overtime.getTime() - entryhour.getTime());
                        differencehours = new Date(differencehours.getTime() + ((Date)actualdate).getTime());
                    } else {
                        differencehours = GenerateAttendanceHoursV2.calculateHours(actualdate, 0, 0);
                    }
                } else {
                    differencehours = GenerateAttendanceHoursV2.calculateHours(actualdate, 0, 0);
                }
                att.setDifferenceHours(new Timestamp(differencehours.getTime()));
                Date nighthoursstart = GenerateAttendanceHoursV2.calculateHours(actualdate, 22, 0);
                att.setNightHoursStart(new Timestamp(nighthoursstart.getTime()));
                if (fecha.compareToIgnoreCase("Domingo") == 0 || fecha.endsWith("bado")) {
                    nighthourscalc = workedhourscalc;
                } else if (exithour.compareTo(nighthoursstart) > 0) {
                    nighthourscalc = new Date(exithour.getTime() - nighthoursstart.getTime());
                    nighthourscalc = new Date(nighthourscalc.getTime() + ((Date)actualdate).getTime());
                } else {
                    nighthourscalc = GenerateAttendanceHoursV2.calculateHours(actualdate, 0, 0);
                }
                this.log.config("nighthourscalc " + nighthourscalc);
                att.setNightHoursCalc(new Timestamp(nighthourscalc.getTime()));
                Date dayhourscalc = new Date();
                if (fecha.compareToIgnoreCase("Domingo") == 0 || fecha.endsWith("bado")) {
                    dayhourscalc = GenerateAttendanceHoursV2.calculateHours(actualdate, 0, 0);
                } else if (entryhour.getTime() > ((Date)actualdate).getTime()) {
                    Date dayhourscalcaux = new Date(sumdelayearlyworked.getTime() - workedhoursforcalc.getTime() - differencehours.getTime() - nighthourscalc.getTime());
                    dayhourscalc = (dayhourscalcaux = new Date(dayhourscalcaux.getTime() + ((Date)actualdate).getTime() + ((Date)actualdate).getTime() + ((Date)actualdate).getTime())).getTime() <= ((Date)actualdate).getTime() ? GenerateAttendanceHoursV2.calculateHours(actualdate, 0, 0) : dayhourscalcaux;
                } else {
                    dayhourscalc = GenerateAttendanceHoursV2.calculateHours(actualdate, 0, 0);
                }
                att.setDayHoursCalc(new Timestamp(dayhourscalc.getTime()));
                Date nighthoursend = GenerateAttendanceHoursV2.calculateHours(actualdate, 8, 0);
                att.setNightHoursEnd(new Timestamp(nighthoursend.getTime()));
                att.saveEx(this.get_TrxName());
            }
        }
        return "Procesado";
    }

    public static Date calculateHours(Date startDate, int duration, int minutes) {
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDate);
        int i = 1;
        while (i < duration) {
            startCal.add(11, 1);
            ++i;
        }
        if (minutes != 0) {
            startCal.add(12, minutes);
        }
        return startCal.getTime();
    }
}

