/*
 * Decompiled with CFR 0.152.
 */
package org.minju.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import org.compiere.model.MPeriod;
import org.compiere.model.X_HR_AttendanceHours;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class GenerateAttendanceHoursSIMPLE
extends SvrProcess {
    private int p_Period = 0;
    private int p_BPartner = 0;
    private Timestamp p_From;
    private Timestamp p_To;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DateTo")) {
                this.p_To = (Timestamp)para[i].getParameter();
            } else if (name.equals("C_BPartner_ID")) {
                this.p_BPartner = ((BigDecimal)para[i].getParameter()).intValue();
            } else if (name.equals("DateFrom")) {
                this.p_From = (Timestamp)para[i].getParameter();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.p_From != null && this.p_To != null) {
            MPeriod period = new MPeriod(this.getCtx(), this.p_Period, this.get_TrxName());
            String sql = "DELETE from HR_AttendanceHours WHERE datetrx  between '" + this.p_From + "' AND '" + this.p_To + "'";
            if (this.p_BPartner > 0) {
                sql = String.valueOf(sql) + " AND c_bpartner_id = " + this.p_BPartner;
            }
            this.log.config("SQL DELETE " + sql);
            DB.executeUpdate(sql, this.get_TrxName());
            String sqlgethours = "SELECT fecha, ad_org_id, c_bpartner_id, dia, entrada, salida, horas_trabajadas,  incidencias, compensadas, atrasobase, horasmediamannana FROM RVOFB_Reloj_Control WHERE fecha  between '" + this.p_From + "' AND '" + this.p_To + "'";
            if (this.p_BPartner > 0) {
                sqlgethours = String.valueOf(sqlgethours) + " AND c_bpartner_id = " + this.p_BPartner;
            }
            this.log.config("SQL obtener desde vista " + sqlgethours);
            CPreparedStatement pstmt = DB.prepareStatement(sqlgethours, this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_HR_AttendanceHours att = new X_HR_AttendanceHours(this.getCtx(), 0, this.get_TrxName());
                int hoursqty = rs.getInt("compensadas");
                Timestamp actualdate = rs.getTimestamp("fecha");
                Timestamp time = new Timestamp(hoursqty);
                Date entryhour = new Date(rs.getTimestamp("entrada").getTime());
                Timestamp exithour = rs.getTimestamp("salida");
                Date compensadas = GenerateAttendanceHoursSIMPLE.calculateHours(actualdate, hoursqty, 0);
                Timestamp cff = new Timestamp(compensadas.getTime());
                String incidencias = rs.getString("incidencias");
                this.log.config("entry " + rs.getTimestamp("entrada"));
                att.setEntryHour(new Timestamp(entryhour.getTime()));
                att.setExitHour(exithour);
                att.setDateTrx(rs.getTimestamp("fecha"));
                att.setAD_Org_ID(rs.getInt("ad_org_id"));
                att.setC_BPartner_ID(rs.getInt("c_bpartner_id"));
                att.setDayOfWeek(rs.getString("dia"));
                att.setDescription(incidencias);
                att.setCompensatedTime(cff);
                att.setDelayBase(rs.getTimestamp("atrasobase"));
                att.saveEx(this.get_TrxName());
                att.saveEx(this.get_TrxName());
            }
        }
        return "Procesado";
    }

    public static Date calculateHours(Date startDate, int duration, int minutes) {
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDate);
        int i = 1;
        while (i < duration) {
            startCal.add(11, 1);
            ++i;
        }
        if (minutes != 0) {
            startCal.add(12, minutes);
        }
        return startCal.getTime();
    }
}

