/*
 * Decompiled with CFR 0.152.
 */
package org.minju.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPayment;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModMINJUValidCompletePayBugdet
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModMINJUValidCompletePayBugdet.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("C_Payment", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MPayment pay;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 7 && po.get_Table_ID() == MPayment.Table_ID && (pay = (MPayment)po).getC_Invoice_ID() > 0) {
            MInvoice inv = new MInvoice(po.getCtx(), pay.getC_Invoice_ID(), po.get_TrxName());
            MInvoiceLine[] lines = inv.getLines();
            int i = 0;
            while (i < lines.length) {
                MInvoiceLine line = lines[i];
                int ID_ReqLine = DB.getSQLValue(po.get_TrxName(), "SELECT MAX(M_RequisitionLine_ID)  FROM M_RequisitionLine rl  INNER JOIN M_Requisition mr on (rl.M_Requisition_ID = mr.M_Requisition_ID)  WHERE rl.C_OrderLine_ID = " + line.getC_OrderLine_ID() + " AND rl.IsActive = 'Y' " + " AND mr.IsActive = 'Y' AND mr.DocStatus NOT IN ('VO')");
                if (ID_ReqLine > 0) {
                    MRequisitionLine rLine = new MRequisitionLine(po.getCtx(), ID_ReqLine, po.get_TrxName());
                    BigDecimal totalAmt = null;
                    totalAmt = line.getLineTotalAmt();
                    if (totalAmt.compareTo(rLine.getLineNetAmt()) > 0) {
                        return "Error de presupuesto en linea de factura " + line.getLine();
                    }
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

