/*
 * Decompiled with CFR 0.152.
 */
package org.minju.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MProjectLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_DM_Document;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModMINJUUpdateAmtProjectContract
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModMINJUUpdateAmtProjectContract.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("DM_Document", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        X_DM_Document doc;
        int projectline;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 4 || type == 5) && po.get_Table_ID() == X_DM_Document.Table_ID && (projectline = (doc = (X_DM_Document)po).getC_ProjectLine_ID()) > 0) {
            BigDecimal sum = DB.getSQLValueBD(po.get_TrxName(), "SELECT coalesce(sum(amt),0) FROM DM_Document where C_ProjectLine_ID = ?  AND Isactive='Y' AND C_DocType_ID in (SELECT C_DocType_ID from C_Doctype where lower(name) like '%contrato%')", projectline);
            MProjectLine pl = new MProjectLine(po.getCtx(), projectline, po.get_TrxName());
            pl.set_CustomColumn("BudgetAmt", sum);
            pl.save();
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

