/*
 * Decompiled with CFR 0.152.
 */
package org.minju.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_GL_BudgetControl;
import org.compiere.model.X_GL_BudgetControlLine;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModMINJUUpdateAmtBudget
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModMINJUUpdateAmtBudget.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("GL_BudgetControl", this);
        engine.addModelChange("GL_BudgetControlLine", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        X_GL_BudgetControlLine bcLine;
        BigDecimal sumAmt;
        X_GL_BudgetControl budget;
        BigDecimal amt;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (!(type != 1 && type != 2 || po.get_Table_ID() != X_GL_BudgetControl.Table_ID || (amt = (BigDecimal)(budget = (X_GL_BudgetControl)po).get_Value("Amount")) != null && amt.compareTo(Env.ZERO) != 0 || budget.get_ValueAsString("DocStatus").compareTo("CO") != 0 || (sumAmt = DB.getSQLValueBD(po.get_TrxName(), "SELECT SUM(amount)  FROM GL_BudgetControlLine WHERE IsActive = 'Y'  AND GL_BudgetControl_ID = " + budget.get_ID(), new Object[0])) == null)) {
            budget.set_CustomColumn("Amount", sumAmt);
        }
        if ((type == 4 || type == 2) && po.get_Table_ID() == X_GL_BudgetControlLine.Table_ID) {
            X_GL_BudgetControlLine bl = (X_GL_BudgetControlLine)po;
            bl.set_CustomColumn("Gl_BudgetControlLineRef2_ID", bl.get_ID());
        }
        if ((type == 4 || type == 5) && po.get_Table_ID() == X_GL_BudgetControlLine.Table_ID && (bcLine = (X_GL_BudgetControlLine)po).get_ValueAsInt("GL_BudgetControlLineRef_ID") > 0 && bcLine.get_ValueAsInt("GL_BudgetControlLineRef_ID") != bcLine.get_ID()) {
            X_GL_BudgetControlLine bcLineRef = new X_GL_BudgetControlLine(po.getCtx(), bcLine.get_ValueAsInt("GL_BudgetControlLineRef_ID"), po.get_TrxName());
            sumAmt = DB.getSQLValueBD(po.get_TrxName(), "SELECT SUM(amount)  FROM GL_BudgetControlLine WHERE IsActive = 'Y'  AND GL_BudgetControlLineRef_ID = " + bcLine.get_ValueAsInt("GL_BudgetControlLineRef_ID"), new Object[0]);
            if (sumAmt != null) {
                bcLineRef.set_CustomColumn("Amount4", sumAmt);
                bcLineRef.save(po.get_TrxName());
            }
        }
        if ((type == 1 || type == 2) && po.get_Table_ID() == X_GL_BudgetControlLine.Table_ID && (bcLine = (X_GL_BudgetControlLine)po).get_ValueAsBoolean("IsAdFlag") && bcLine.get_ValueAsInt("GL_BudgetControlLineRef2_ID") == bcLine.get_ID()) {
            BigDecimal amtR = (BigDecimal)bcLine.get_Value("Amount4");
            if (bcLine.getAmount() != null && amtR != null) {
                bcLine.set_CustomColumn("Amount5", bcLine.getAmount().subtract(amtR.negate()));
            }
        }
        if ((type == 1 || type == 2) && po.get_Table_ID() == X_GL_BudgetControlLine.Table_ID) {
            bcLine = (X_GL_BudgetControlLine)po;
            BigDecimal amtNew = (BigDecimal)bcLine.get_Value("AmountNew");
            if (amtNew == null) {
                amtNew = Env.ZERO;
            }
            if (amtNew.compareTo(Env.ZERO) > 0) {
                amtNew = amtNew.negate();
                bcLine.setAmount(amtNew);
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

