/*
 * Decompiled with CFR 0.152.
 */
package org.minju.model;

import java.sql.CallableStatement;
import org.compiere.model.MClient;
import org.compiere.model.MInventory;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModMINJUReqSendMail
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModMINJUReqSendMail.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("M_Inventory", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        CallableStatement cst;
        MInventory inv;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MInventory.Table_ID) {
            inv = (MInventory)po;
            try {
                cst = DB.prepareCall("{call pa_envia_mail_auto2(?,?,?,?)}");
                cst.setInt(1, Env.getAD_Client_ID(po.getCtx()));
                cst.setInt(2, 5);
                cst.setString(3, "-");
                cst.setInt(4, inv.get_ID());
                cst.execute();
            }
            catch (Exception e) {
                log.config(e.toString());
            }
        }
        if (timing == 10 && po.get_Table_ID() == MInventory.Table_ID) {
            inv = (MInventory)po;
            try {
                cst = DB.prepareCall("{call pa_envia_mail_auto2(?,?,?,?)}");
                cst.setInt(1, Env.getAD_Client_ID(po.getCtx()));
                cst.setInt(2, 6);
                cst.setString(3, "-");
                cst.setInt(4, inv.get_ID());
                cst.execute();
            }
            catch (Exception e) {
                log.config(e.toString());
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

