/*
 * Decompiled with CFR 0.152.
 */
package org.minju.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModMINJUFreeRequisitionLine
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModMINJUFreeRequisitionLine.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_OrderLine", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 3 && po.get_Table_ID() == MOrderLine.Table_ID) {
            MOrderLine ordl = (MOrderLine)po;
            int requisition = ordl.get_ValueAsInt("M_RequisitionLine_ID");
            BigDecimal qtyused = DB.getSQLValueBD(po.get_TrxName(), "SELECT qtyused from M_Requisitionline where m_requisitionline_id = ?", requisition);
            log.config("sql = " + qtyused);
            if (qtyused.compareTo(Env.ZERO) > 0) {
                DB.executeUpdate("UPDATE M_RequisitionLine set qtyused=0, c_orderline_id = null where M_RequisitionLine_ID = " + requisition, po.get_TrxName());
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

