/*
 * Decompiled with CFR 0.152.
 */
package org.minju.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_GL_BudgetControlLine;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModMINJUCopyInfoBudget
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModMINJUCopyInfoBudget.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("M_RequisitionLine", this);
        engine.addModelChange("C_OrderLine", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        X_GL_BudgetControlLine bcLine;
        MRequisitionLine reqLine;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == MRequisitionLine.Table_ID && (reqLine = (MRequisitionLine)po).get_ValueAsInt("GL_BudgetControlLine_ID") > 0) {
            bcLine = new X_GL_BudgetControlLine(po.getCtx(), reqLine.get_ValueAsInt("GL_BudgetControlLine_ID"), po.get_TrxName());
            if (bcLine.getM_Product_ID() > 0) {
                reqLine.setM_Product_ID(bcLine.getM_Product_ID());
            }
            if (bcLine.get_ValueAsInt("M_Product_Category_ID") > 0) {
                reqLine.set_CustomColumn("M_Product_Category_ID", bcLine.get_ValueAsInt("M_Product_Category_ID"));
            }
        }
        if ((type == 5 || type == 4) && po.get_Table_ID() == MOrderLine.Table_ID) {
            MOrderLine oLine = (MOrderLine)po;
            MOrder order = new MOrder(po.getCtx(), oLine.getC_Order_ID(), po.get_TrxName());
            if (order.getDocStatus().compareTo("CO") != 0 && order.getDocStatus().compareTo("VO") != 0 && oLine.get_ValueAsInt("M_RequisitionLine_ID") > 0) {
                MRequisitionLine req = new MRequisitionLine(po.getCtx(), oLine.get_ValueAsInt("M_RequisitionLine_ID"), po.get_TrxName());
                if (req.get_ValueAsInt("M_Product_Category_ID") > 0) {
                    DB.executeUpdate("UPDATE C_OrderLine SET M_Product_Category_ID = " + req.get_Value("M_Product_Category_ID") + " WHERE C_OrderLine_ID = " + oLine.get_ID(), po.get_TrxName());
                }
                if (req.getDescription() != null && req.getDescription().trim().length() > 0) {
                    DB.executeUpdate("UPDATE C_OrderLine SET Description = '" + req.getDescription() + "'" + " WHERE C_OrderLine_ID = " + oLine.get_ID(), po.get_TrxName());
                }
            }
        }
        if ((type == 4 || type == 5) && po.get_Table_ID() == MRequisitionLine.Table_ID && (reqLine = (MRequisitionLine)po).get_ValueAsInt("GL_BudgetControlLine_ID") > 0) {
            bcLine = new X_GL_BudgetControlLine(po.getCtx(), reqLine.get_ValueAsInt("GL_BudgetControlLine_ID"), po.get_TrxName());
            BigDecimal amtUsed = DB.getSQLValueBD(po.get_TrxName(), "SELECT coalesce(SUM(LineNetAmt),0) FROM M_RequisitionLine rLine  INNER JOIN M_Requisition r ON (rLine.M_Requisition_ID = r.M_Requisition_ID)  WHERE rLine.IsActive = 'Y' AND DocStatus IN ('CO','SR','IP')  AND rline.GL_BudgetControlLine_ID = ? ", bcLine.get_ID());
            BigDecimal amtOpen = bcLine.getAmount().subtract(amtUsed);
            log.config("lala " + reqLine.get_ValueAsInt("GL_BudgetControlLine_ID"));
            if (amtOpen.compareTo(Env.ZERO) < 0) {
                return "Error: Monto sobrepasa monto presupuestado";
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

