/*
 * Decompiled with CFR 0.152.
 */
package org.minju.model;

import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.eevolution.model.X_HR_Employee;

public class ModMINJUCopyInfoBPartner
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModMINJUCopyInfoBPartner.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_BPartner", this);
        engine.addModelChange("HR_Employee", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == X_HR_Employee.Table_ID) {
            X_HR_Employee emp = (X_HR_Employee)po;
            MBPartner bp = new MBPartner(po.getCtx(), emp.getC_BPartner_ID(), po.get_TrxName());
            if (emp.get_Value("Occupation") != null) {
                bp.set_CustomColumn("Occupation", emp.get_Value("Occupation"));
                bp.set_CustomColumn("Profession", emp.get_Value("Occupation"));
            }
            if (emp.get_ValueAsInt("Children") >= 0) {
                bp.set_CustomColumn("Children", emp.get_ValueAsInt("Children"));
            }
            if (emp.get_Value("JoinDateAP") != null) {
                bp.set_CustomColumn("JoinDateAP", emp.get_Value("JoinDateAP"));
            }
            if (emp.get_Value("JoinDateS") != null) {
                bp.set_CustomColumn("JoinDateS", emp.get_Value("JoinDateS"));
            }
            if (emp.get_Value("Estate") != null) {
                bp.set_CustomColumn("Estate", emp.get_Value("Estate"));
            }
            if (emp.get_Value("EstadoVinculacion") != null) {
                bp.set_CustomColumn("EstadoVinculacion", emp.get_Value("EstadoVinculacion"));
            }
            if (emp.get_ValueAsBoolean("Profesional_Externo")) {
                bp.set_CustomColumn("Profesional_Externo", emp.get_ValueAsBoolean("Profesional_Externo"));
            }
            if (emp.get_ValueAsBoolean("NoEnviaCorreo")) {
                bp.set_CustomColumn("NoEnviaCorreo", emp.get_ValueAsBoolean("NoEnviaCorreo"));
            }
            if (emp.get_Value("ID_Usuario_Reloj") != null) {
                bp.set_CustomColumn("ID_Usuario_Reloj", emp.get_Value("ID_Usuario_Reloj"));
            }
            if (emp.get_Value("ISAPRE") != null) {
                bp.set_CustomColumn("ISAPRE", emp.get_Value("ISAPRE"));
            }
            if (emp.get_Value("AFP") != null) {
                bp.set_CustomColumn("AFP", emp.get_Value("AFP"));
            }
            if (emp.get_Value("Nationality") != null) {
                bp.set_CustomColumn("Nationality", emp.get_Value("Nationality"));
            }
            if (emp.get_Value("MaritalStatus") != null) {
                bp.set_CustomColumn("MaritalStatus", emp.get_Value("MaritalStatus"));
            }
            if (emp.get_Value("Position") != null) {
                bp.set_CustomColumn("Position", emp.get_Value("Position"));
            }
            if (emp.get_Value("Gender") != null) {
                bp.set_CustomColumn("Gender", emp.get_Value("Gender"));
            }
            if (emp.get_Value("Suplencia") != null) {
                bp.set_CustomColumn("Suplencia", emp.get_Value("Suplencia"));
            }
            if (emp.get_ValueAsInt("HR_Job_ID") > 0) {
                int Job_ID = emp.get_ValueAsInt("HR_Job_ID");
                String sqljob = "SELECT lower(name) from hr_job where hr_job_id = ?";
                String name = DB.getSQLValueString(po.get_TrxName(), sqljob, Job_ID);
                if (name != null) {
                    String sqlstatevalue = "SELECT value from ad_Ref_list where ad_reference_id = ? and  lower(name) like '" + name + "'";
                    String value = DB.getSQLValueString(po.get_TrxName(), sqlstatevalue, 2000030);
                    if (value != null && value.compareTo("") != 0) {
                        bp.set_CustomColumn("Estate", value);
                    }
                }
            }
            bp.save();
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

