/*
 * Decompiled with CFR 0.152.
 */
package org.minju.model;

import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_DM_BG_History;
import org.compiere.model.X_DM_PerformanceBond;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.ofb.utils.DateUtils;

public class ModMINJUBGHistory
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModMINJUBGHistory.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("DM_PerformanceBond", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 2 && po.get_Table_ID() == X_DM_PerformanceBond.Table_ID && po.is_ValueChanged("DocStatus")) {
            X_DM_PerformanceBond doc = (X_DM_PerformanceBond)po;
            X_DM_BG_History his = new X_DM_BG_History(po.getCtx(), 0, po.get_TrxName());
            his.set_CustomColumn("DM_PerformanceBond_ID", doc.get_ID());
            his.setDocStatus(doc.getDocStatus());
            his.setdocstatusold(doc.get_ValueOld("DocStatus").toString());
            his.setDescription(doc.getDescription());
            his.setBG_Updated(DateUtils.now());
            his.setbg_updatedby(Env.getAD_User_ID(po.getCtx()));
            his.save(po.get_TrxName());
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

