/*
 * Decompiled with CFR 0.152.
 */
package org.minju.model;

import java.sql.Timestamp;
import org.compiere.model.MClient;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_A_Asset_Use;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModMINJUAssetUseReq
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModMINJUAssetUseReq.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("M_Requisition", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        block8: {
            MRequisition req;
            block9: {
                log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
                if (timing != 9 || po.get_Table_ID() != MRequisition.Table_ID) break block8;
                req = (MRequisition)po;
                if (req.getC_DocType().getName().compareTo("Asignacion de Activos") != 0) break block9;
                MRequisitionLine[] lines = req.getLines();
                int i = 0;
                while (i < lines.length) {
                    MRequisitionLine line = lines[i];
                    int ID_Asset = line.get_ValueAsInt("A_Asset_ID");
                    if (ID_Asset <= 0) {
                        ID_Asset = line.get_ValueAsInt("A_AssetRef_ID");
                    }
                    if (ID_Asset > 0) {
                        X_A_Asset_Use assetuse = new X_A_Asset_Use(po.getCtx(), 0, po.get_TrxName());
                        assetuse.setA_Asset_ID(ID_Asset);
                        assetuse.setUseDate(req.getDateDoc());
                        assetuse.setUseUnits(1);
                        assetuse.set_CustomColumn("IsClosed", false);
                        if (req.get_ValueAsInt("AD_UserRef_ID") > 0) {
                            assetuse.set_CustomColumn("AD_User_ID", req.get_ValueAsInt("AD_UserRef_ID"));
                        }
                        if (req.get_ValueAsInt("S_Resource_ID") > 0) {
                            assetuse.set_CustomColumn("S_Resource_ID", req.get_ValueAsInt("S_Resource_ID"));
                        }
                        assetuse.save();
                    }
                    ++i;
                }
                break block8;
            }
            if (req.getC_DocType().getName().compareTo("Devolucion de Activos") != 0) break block8;
            MRequisitionLine[] lines = req.getLines();
            int i = 0;
            while (i < lines.length) {
                int ID_AUse;
                MRequisitionLine line = lines[i];
                int ID_Asset = line.get_ValueAsInt("A_Asset_ID");
                if (ID_Asset <= 0) {
                    ID_Asset = line.get_ValueAsInt("A_AssetRef_ID");
                }
                if (ID_Asset > 0 && (ID_AUse = DB.getSQLValue(po.get_TrxName(), "SELECT A_Asset_Use_ID  FROM A_Asset_Use WHERE A_Asset_ID = " + ID_Asset + " AND IsActive = 'Y'" + " ORDER BY UseDate Desc")) > 0) {
                    X_A_Asset_Use aUse = new X_A_Asset_Use(po.getCtx(), ID_AUse, po.get_TrxName());
                    aUse.set_CustomColumn("IsClosed", true);
                    aUse.set_CustomColumn("EndDate", (Timestamp)req.get_Value("DateReturn"));
                    aUse.set_CustomColumn("Comments", line.getDescription());
                    aUse.save();
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

