/*
 * Decompiled with CFR 0.152.
 */
package org.minju.model;

import java.math.BigDecimal;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_HR_AdministrativeRequests;
import org.compiere.model.X_HR_AdministrativeRequestsL;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class ModMINJUAdministrativeReqL
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModMINJUAdministrativeReqL.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("HR_AdministrativeRequestsL", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == X_HR_AdministrativeRequestsL.Table_ID) {
            X_HR_AdministrativeRequestsL reqL = (X_HR_AdministrativeRequestsL)po;
            X_HR_AdministrativeRequests req = new X_HR_AdministrativeRequests(po.getCtx(), reqL.getHR_AdministrativeRequests_ID(), po.get_TrxName());
            if (req.getRequestType().compareTo("PPM") == 0 && reqL.getDays().compareTo(new BigDecimal("5.0")) > 0) {
                throw new AdempiereException("Solo se pueden solicitar m\u00e1ximo 5 dias.");
            }
            if (req.getRequestType().compareTo("PAT") == 0 && reqL.getDays().compareTo(Env.ZERO) <= 0) {
                throw new AdempiereException("Debe ingresar minimo 1 dia");
            }
            if (req.getRequestType().compareTo("FAL") == 0) {
                if (req.get_ValueAsString("RequestType2").compareTo("01") == 0 && reqL.getDays().compareTo(new BigDecimal("7.0")) > 0) {
                    throw new AdempiereException("Solo se pueden solicitar m\u00e1ximo 7 dias.");
                }
                if (req.get_ValueAsString("RequestType2").compareTo("02") == 0 && reqL.getDays().compareTo(new BigDecimal("3.0")) > 0) {
                    throw new AdempiereException("Solo se pueden solicitar m\u00e1ximo 3 dias.");
                }
            }
            if (req.getRequestType().compareTo("SVC") == 0 && reqL.getDays().compareTo(Env.ZERO) <= 0) {
                throw new AdempiereException("En solicitud de vacaciones, los d\u00edas deben ser mayor a 0");
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

