/*
 * Decompiled with CFR 0.152.
 */
package org.junaeb.model;

import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_M_Movement;
import org.compiere.util.CLogger;

public class ModelJUNAEBWarehouseMovement
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelJUNAEBWarehouseMovement.class);
    private int m_AD_Client_ID = -1;
    public static final String DOCSTATUS_Drafted = "DR";
    public static final String DOCSTATUS_Completed = "CO";
    public static final String DOCSTATUS_InProgress = "IP";
    public static final String DOCSTATUS_Voided = "VO";

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("M_Requisition", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MRequisition req;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MRequisition.Table_ID && (req = (MRequisition)po).getC_DocType().getDocBaseType().equals("RMV")) {
            MRequisitionLine[] lines = req.getLines();
            X_M_Movement mov = null;
            Object inv = null;
            MWarehouse whfrom = MWarehouse.get(req.getCtx(), req.getM_Warehouse_ID(), req.get_TrxName());
            MWarehouse whto = MWarehouse.get(req.getCtx(), req.get_ValueAsInt("M_WarehouseSource_ID"));
            int i = 0;
            while (i < lines.length) {
                MRequisitionLine line = lines[i];
                if (line.getM_Product_ID() > 0) {
                    if (mov == null) {
                        mov = new MMovement(req.getCtx(), 0, req.get_TrxName());
                        mov.setAD_Org_ID(req.getAD_Org_ID());
                        mov.setMovementDate(req.getDateDoc());
                        mov.setDescription("Generado automaticamente desde solicitud " + req.getDocumentNo());
                        mov.save();
                        try {
                            mov.set_CustomColumn("M_Requisition_ID", req.get_ID());
                            mov.save();
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, "No se pudo asignar la vvariable M_Requisition_ID en M_Movement ", e);
                        }
                        mov.save();
                    }
                    MMovementLine mline = new MMovementLine(req.getCtx(), 0, req.get_TrxName());
                    mline.setM_Movement_ID(mov.getM_Movement_ID());
                    mline.setAD_Org_ID(mov.getAD_Org_ID());
                    mline.setM_Product_ID(line.getM_Product_ID());
                    mline.setMovementQty(line.getQty());
                    mline.setM_Locator_ID(whfrom.getDefaultLocator().getM_Locator_ID());
                    mline.setM_LocatorTo_ID(whto.getDefaultLocator().getM_Locator_ID());
                    mline.save();
                }
                ++i;
            }
            if (mov != null) {
                try {
                    req.set_CustomColumn("M_Movement_ID", mov.getM_Movement_ID());
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "No se pudo asignar la variable M_Inventory_ID en M_Requisition", e);
                }
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

