/*
 * Decompiled with CFR 0.152.
 */
package org.junaeb.model;

import java.math.BigDecimal;
import org.compiere.model.MAssetAcct;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_A_Asset;
import org.compiere.model.X_A_Depreciation_Workfile;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.ofb.process.CreateAssetForecastOFB;

public class ModJUNAEBDepWorkfile
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModJUNAEBDepWorkfile.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("A_Asset", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 4 && po.get_Table_ID() == X_A_Asset.Table_ID) {
            X_A_Asset asset = (X_A_Asset)po;
            int aw_id = DB.getSQLValue(asset.get_TrxName(), "SELECT max(a_depreciation_workfile_id) from a_depreciation_workfile where a_Asset_id = " + asset.get_ID());
            X_A_Depreciation_Workfile aw = new X_A_Depreciation_Workfile(asset.getCtx(), aw_id, asset.get_TrxName());
            asset.set_CustomColumn("AD_OrgRef_ID", asset.getAD_Org_ID());
            asset.save();
            aw.setA_Asset_Cost((BigDecimal)asset.get_Value("GrandTotal"));
            aw.setA_Accumulated_Depr(Env.ZERO);
            aw.set_CustomColumn("A_Salvage_Value", Env.ONE);
            aw.setPostingType("A");
            aw.setIsDepreciated(true);
            aw.setA_QTY_Current(Env.ONE);
            aw.save();
            String sql = "SELECT coalesce(a_asset_Acct_id,0) from A_Asset_acct where a_Asset_id = " + asset.get_ID();
            int count = DB.getSQLValue(asset.get_TrxName(), sql);
            if (count != 0) {
                int life = DB.getSQLValue(asset.get_TrxName(), "SELECT max(a_Asset_life_years) from a_asset_group  where a_Asset_group_id in (select a_Asset_group_ref2_id from a_asset where a_Asset_id = " + asset.get_ID() + ") ");
                MAssetAcct acct = new MAssetAcct(asset.getCtx(), count, asset.get_TrxName());
                acct.setA_Period_End(life);
                acct.save();
                CreateAssetForecastOFB cast = new CreateAssetForecastOFB();
                log.config("marit");
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

