/*
 * Decompiled with CFR 0.152.
 */
package org.indap.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MPeriod;
import org.compiere.model.X_OFB_GenerateSeries;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class ProcessFillGenerateSeries
extends SvrProcess {
    private int p_Period = 0;
    private int p_BPartner = 0;
    private Timestamp p_From;
    private Timestamp p_To;
    private int p_Org = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DateTo")) {
                this.p_To = (Timestamp)para[i].getParameter();
            } else if (name.equals("C_BPartner_ID")) {
                if (para[i].getParameter() != null) {
                    this.p_BPartner = ((BigDecimal)para[i].getParameter()).intValue();
                }
            } else if (name.equals("DateFrom")) {
                this.p_From = (Timestamp)para[i].getParameter();
            } else if (name.equals("AD_OrgRef2_ID")) {
                this.p_Org = ((BigDecimal)para[i].getParameter()).intValue();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.p_From != null && this.p_To != null) {
            MPeriod period = new MPeriod(this.getCtx(), this.p_Period, this.get_TrxName());
            String sql = "DELETE from ofb_generateseries WHERE fecha  between '" + this.p_From + "' AND '" + this.p_To + "'";
            if (this.p_BPartner > 0) {
                sql = String.valueOf(sql) + " AND c_bpartner_id = " + this.p_BPartner;
            }
            this.log.config("SQL DELETE " + sql);
            DB.executeUpdate(sql, this.get_TrxName());
            String sqlgethours = "SELECT a.a::date as fecha, to_char(a.a::date::timestamp with time zone, 'TMDay'::text) as  dia, cbp.c_bpartner_id, cbp.ad_org_id  FROM generate_series('" + this.p_From + "'::timestamp with time zone, " + " '" + this.p_To + "'::timestamp with time zone + '1 day'::interval, '1 day'::interval) a(a), " + " c_bpartner cbp WHERE cbp.isemployee='Y' ";
            if (this.p_BPartner > 0) {
                sqlgethours = String.valueOf(sqlgethours) + " AND cbp.c_bpartner_id = " + this.p_BPartner;
            }
            this.log.config("query " + sqlgethours);
            CPreparedStatement pstmt = DB.prepareStatement(sqlgethours, this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            int counter = 0;
            while (rs.next()) {
                X_OFB_GenerateSeries serie = new X_OFB_GenerateSeries(this.getCtx(), 0, this.get_TrxName());
                serie.setfecha(rs.getTimestamp("fecha"));
                serie.setAD_Org_ID(rs.getInt("AD_Org_ID"));
                serie.setC_BPartner_ID(rs.getInt("C_BPartner_ID"));
                serie.setdia(rs.getString("dia"));
                serie.save();
                if (++counter != 50 && counter % 50 != 0) continue;
                this.log.config("contador = " + counter);
            }
            rs.close();
        }
        return "Procesado";
    }
}

