/*
 * Decompiled with CFR 0.152.
 */
package org.indap.process;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.X_HR_Movement;
import org.eevolution.model.X_I_HR_Movement;
import org.ofb.utils.DateUtils;

public class ImportHMovement
extends SvrProcess {
    private String p_PathFile;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("FilePathOrName")) {
                    this.p_PathFile = para[i].getParameterAsString();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        String rutaArchivo;
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setGroupingSeparator('.');
        symbols.setDecimalSeparator(',');
        String pattern = "#,##0.0#";
        DecimalFormat decimalFormat = new DecimalFormat(pattern, symbols);
        decimalFormat.setParseBigDecimal(true);
        String pFile = rutaArchivo = this.p_PathFile;
        ArrayList<String[]> datos = new ArrayList<String[]>();
        int cantLines = 0;
        int cant = 0;
        DB.executeUpdate("UPDATE I_HR_Movement SET Processed = 'Y' ", this.get_TrxName());
        try {
            FileInputStream fis = new FileInputStream(pFile);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "ISO-8859-1");
            BufferedReader br = new BufferedReader(isr);
            String linea = br.readLine();
            while (linea != null) {
                datos.add(linea.split(";"));
                linea = br.readLine();
                ++cantLines;
            }
            br.close();
            isr.close();
            fis.close();
            this.log.config(datos.toString());
            int x = 1;
            while (x < cantLines) {
                BigDecimal Amt = (BigDecimal)decimalFormat.parse(((String[])datos.get(x))[1].trim());
                BigDecimal Qty = Env.ZERO;
                if (decimalFormat.parse(((String[])datos.get(x))[5].trim()) != null) {
                    Qty = (BigDecimal)decimalFormat.parse(((String[])datos.get(x))[5].trim());
                }
                X_I_HR_Movement iMov = new X_I_HR_Movement(this.getCtx(), 0, this.get_TrxName());
                iMov.setAD_Org_ID(Env.getAD_Org_ID(this.getCtx()));
                iMov.setConceptValue(((String[])datos.get(x))[0]);
                if (Amt != null) {
                    iMov.setAmount(Amt);
                } else {
                    iMov.setAmount(Env.ZERO);
                }
                iMov.setBPartner_Value(((String[])datos.get(x))[2]);
                if (((String[])datos.get(x))[3] != null) {
                    iMov.setValidFrom(DateUtils.convertDateddMMyyyy(((String[])datos.get(x))[3]));
                }
                iMov.set_CustomColumn("Type", ((String[])datos.get(x))[4]);
                iMov.set_CustomColumn("Days", Qty);
                iMov.saveEx(this.get_TrxName());
                ++x;
            }
            this.commitEx();
            datos = null;
            StringBuffer sql = null;
            String clientCheck = " AND AD_Client_ID=" + Env.getAD_Client_ID(this.getCtx());
            int no = 0;
            sql = new StringBuffer("UPDATE I_HR_Movement o SET C_BPartner_ID =  (SELECT MAX(C_BPartner_ID) FROM C_BPartner p WHERE value LIKE o.BPartner_Value AND o.AD_Client_ID=p.AD_Client_ID) WHERE C_BPartner_ID IS NULL AND Processed<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            this.log.info("C_BPartner =" + no);
            sql = new StringBuffer("UPDATE I_HR_Movement  SET I_IsImported='N', I_ErrorMsg=I_ErrorMsg||'ERR=NO BPartner, '  WHERE C_BPartner_ID IS NULL AND BPartner_Value IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            sql = new StringBuffer("UPDATE I_HR_Movement o SET HR_Concept_ID =  (SELECT MAX(HR_Concept_ID) FROM HR_Concept p WHERE value LIKE o.ConceptValue AND o.AD_Client_ID=p.AD_Client_ID) WHERE HR_Concept_ID IS NULL AND Processed<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            this.log.info("HR_Concept =" + no);
            sql = new StringBuffer("UPDATE I_HR_Movement  SET I_IsImported='N', I_ErrorMsg=I_ErrorMsg||'ERR=NO HR_Concept, '  WHERE C_BPartner_ID IS NULL AND BPartner_Value IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            sql = new StringBuffer("SELECT * FROM I_HR_Movement  WHERE Processed = 'N' AND I_IsImported<>'Y'  AND C_BPartner_ID > 0 AND HR_Concept_ID > 0 ").append(clientCheck);
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_HR_Movement mov = new X_HR_Movement(this.getCtx(), 0, this.get_TrxName());
                mov.setAD_Org_ID(rs.getInt("AD_Org_ID"));
                mov.setHR_Concept_ID(rs.getInt("HR_Concept_ID"));
                mov.setAmount(rs.getBigDecimal("Amount"));
                mov.setC_BPartner_ID(rs.getInt("C_BPartner_ID"));
                if (rs.getTimestamp("ValidFrom") != null) {
                    mov.setValidFrom(rs.getTimestamp("ValidFrom"));
                }
                mov.set_CustomColumn("Type", rs.getString("Type"));
                mov.set_CustomColumn("Days", rs.getBigDecimal("Days"));
                mov.saveEx(this.get_TrxName());
                ++cant;
            }
        }
        catch (Exception e) {
            this.log.config("ERROR: " + e);
        }
        return "SE HAN GENERADO " + cant + " REGISTROS";
    }
}

