/*
 * Decompiled with CFR 0.152.
 */
package org.indap.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MConversionRate;
import org.compiere.model.MConversionType;
import org.compiere.model.MDocType;
import org.compiere.model.MPeriod;
import org.compiere.model.X_HR_EmployeeChange;
import org.compiere.model.X_HR_ProcessBP;
import org.compiere.model.X_HR_ProcessBPDetail;
import org.compiere.model.X_HR_ProcessHeader;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.MHREmployee;
import org.eevolution.model.X_HR_Concept;
import org.eevolution.model.X_HR_Process;
import org.ofb.model.OFBForward;
import org.ofb.utils.DateUtils;

public class GenerateNominaReassessment
extends SvrProcess {
    private int p_C_BPartner_ID = 0;
    private int p_AD_Org_ID = 0;
    private int p_Parent_Org_ID = 0;
    private String p_suplencia = "";
    private int p_PeriodFrom_ID = 0;
    private int p_PeriodTo_ID = 0;
    private int p_ProcessBP_ID = 0;
    private static CLogger s_log = CLogger.getCLogger(MConversionRate.class);

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = para[i].getParameterAsInt();
            } else if (name.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = para[i].getParameterAsInt();
            } else if (name.equals("Parent_Org_ID")) {
                this.p_Parent_Org_ID = para[i].getParameterAsInt();
            } else if (name.equals("Suplencia")) {
                this.p_suplencia = para[i].getParameterAsString();
            } else if (name.equals("C_Period_ID")) {
                this.p_PeriodFrom_ID = para[i].getParameterAsInt();
                this.p_PeriodTo_ID = para[i].getParameter_ToAsInt();
            } else if (name.equals("HR_ProcessBPRef_ID")) {
                this.p_ProcessBP_ID = para[i].getParameterAsInt();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        String logM = "";
        if (this.p_AD_Org_ID <= 0 && this.p_Parent_Org_ID <= 0 && this.p_C_BPartner_ID <= 0) {
            throw new AdempiereException("Debe seleccionar una organizaci\u00f3n o funcionario");
        }
        if (this.p_PeriodFrom_ID <= 0 || this.p_PeriodTo_ID <= 0) {
            throw new AdempiereException("Debe seleccionar un rango de periodos");
        }
        int ID_Periodo = this.p_PeriodFrom_ID;
        X_HR_ProcessHeader head = new X_HR_ProcessHeader(this.getCtx(), 0, this.get_TrxName());
        head.setC_Period_ID(this.p_PeriodFrom_ID);
        head.setC_PeriodTo_ID(this.p_PeriodTo_ID);
        head.setDescription("Reliquidaci\u00f3n " + head.getC_Period().getName() + " a " + head.getC_PeriodTo().getName());
        head.saveEx(this.get_TrxName());
        Timestamp startYear = new Timestamp(head.getC_Period().getStartDate().getTime());
        startYear = DateUtils.SumarMeses(head.getC_Period().getStartDate(), -2);
        Timestamp endYear = new Timestamp(head.getC_PeriodTo().getEndDate().getTime());
        String ID_BpartnerUsed = "0";
        while (ID_Periodo <= this.p_PeriodTo_ID) {
            MPeriod periodo = new MPeriod(this.getCtx(), ID_Periodo, this.get_TrxName());
            X_HR_Process pro = new X_HR_Process(this.getCtx(), 0, this.get_TrxName());
            pro.setAD_Org_ID(Env.getAD_Org_ID(this.getCtx()));
            pro.setC_DocTypeTarget_ID(MDocType.getDocType("HRP"));
            pro.setName("Reliquidaci\u00f3n " + periodo.getName());
            pro.setDateAcct(periodo.getEndDate());
            pro.setHR_Payroll_ID(2000002);
            pro.set_CustomColumn("C_Period_ID", periodo.get_ID());
            pro.setC_DocType_ID(MDocType.getDocType("HRP"));
            pro.set_CustomColumn("DateDoc", periodo.getEndDate());
            pro.set_CustomColumn("HR_ProcessHeader_ID", head.get_ID());
            pro.saveEx(this.get_TrxName());
            BigDecimal[] factoresVolt = new BigDecimal[]{Env.ZERO, Env.ZERO, Env.ZERO, Env.ZERO, Env.ZERO, Env.ZERO, Env.ZERO, Env.ZERO, Env.ZERO, Env.ZERO};
            BigDecimal[] factores = new BigDecimal[]{Env.ZERO, Env.ZERO, Env.ZERO, Env.ZERO, Env.ZERO, Env.ZERO, Env.ZERO, Env.ZERO, Env.ZERO, Env.ZERO};
            Calendar fecha = Calendar.getInstance();
            fecha.setTime(pro.getDateAcct());
            int qtyDaysM = fecha.getActualMaximum(5);
            BigDecimal amtAuxEx = Env.ZERO;
            String sqlBP = "SELECT bp.C_Bpartner_ID, bp.AD_Org_ID FROM C_Bpartner bp  INNER JOIN HR_Employee e ON (bp.C_Bpartner_ID = e.C_Bpartner_ID) WHERE bp.IsActive = 'Y' ";
            if (this.p_AD_Org_ID > 0) {
                sqlBP = String.valueOf(sqlBP) + " AND bp.AD_Org_ID = " + this.p_AD_Org_ID;
            }
            if (this.p_C_BPartner_ID > 0) {
                sqlBP = String.valueOf(sqlBP) + " AND bp.C_Bpartner_ID = " + this.p_C_BPartner_ID;
            }
            if (this.p_suplencia != null && this.p_suplencia.trim().length() > 0) {
                sqlBP = String.valueOf(sqlBP) + " AND e.suplencia LIKE '" + this.p_suplencia + "'";
            }
            if (this.p_Parent_Org_ID > 0) {
                sqlBP = String.valueOf(sqlBP) + " AND bp.AD_Org_ID IN (SELECT AD_Org_ID FROM AD_OrgInfo WHERE Parent_Org_ID = " + this.p_Parent_Org_ID + ") ";
            }
            sqlBP = String.valueOf(sqlBP) + " AND (e.C_Bpartner_ID IN (SELECT ech.C_Bpartner_ID FROM HR_EmployeeChange ech WHERE Processed = 'Y' AND IsUsed = 'N' AND DateTrx Between ? AND ?) OR  e.C_Bpartner_ID IN(SELECT mo.C_Bpartner_ID FROM HR_Movement mo WHERE mo.IsActive='Y'  AND IsUsed = 'N' AND HR_Concept_ID <> 2000054 AND ValidFrom Between ? AND ? ))";
            String mes = "-" + Integer.toString(pro.getDateAcct().getMonth() + 1) + "-";
            CPreparedStatement pstmt = DB.prepareStatement(sqlBP, this.get_TrxName());
            pstmt.setTimestamp(1, startYear);
            pstmt.setTimestamp(2, endYear);
            pstmt.setTimestamp(3, periodo.getStartDate());
            pstmt.setTimestamp(4, periodo.getEndDate());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                BigDecimal dTributable;
                BigDecimal tImpOld;
                BigDecimal tasa;
                BigDecimal tLiq;
                BigDecimal nightHoursCalc;
                X_HR_ProcessBPDetail bpDet;
                X_HR_ProcessBPDetail bpDet2;
                BigDecimal amtCon;
                ID_BpartnerUsed = String.valueOf(ID_BpartnerUsed) + "," + rs.getInt("C_Bpartner_ID");
                X_HR_ProcessBP pBP = new X_HR_ProcessBP(this.getCtx(), 0, this.get_TrxName());
                pBP.setAD_Org_ID(rs.getInt("AD_Org_ID"));
                pBP.set_CustomColumn("IsReassessment", true);
                pBP.setHR_Process_ID(pro.get_ID());
                pBP.setC_BPartner_ID(rs.getInt("C_Bpartner_ID"));
                MHREmployee employee = MHREmployee.getActiveEmployee(this.getCtx(), OFBForward.getBP(rs.getInt("C_Bpartner_ID")), this.get_TrxName());
                BigDecimal cantDays = DB.getSQLValueBD(this.get_TrxName(), "SELECT COUNT(DISTINCT(EXTRACT(day FROM DateTrx))) FROM HR_AttendanceLine WHERE C_BPartner_ID=" + rs.getInt("C_Bpartner_ID") + " AND EXTRACT(month FROM DateTrx) = " + (pro.getDateAcct().getMonth() + 1), new Object[0]);
                if (cantDays != null) {
                    pBP.set_CustomColumn("WorkedDays", cantDays);
                }
                pBP.saveEx();
                if (rs.getInt("C_Bpartner_ID") == 2007540) {
                    this.log.config("log bp en analisis");
                }
                Timestamp dateTope = pro.getDateAcct();
                String isINP = DB.getSQLValueString(this.get_TrxName(), "SELECT MAX(IsINP) FROM HR_Employee  WHERE C_Bpartner_ID=" + rs.getInt("C_Bpartner_ID"), new Object[0]);
                if (rs.getInt("C_Bpartner_ID") == 2007593) {
                    this.log.config("log bp en analisis");
                }
                if (isINP != null && isINP.compareTo("Y") == 0) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTimeInMillis(pro.getDateAcct().getTime());
                    cal.add(2, -1);
                    dateTope = new Timestamp(cal.getTimeInMillis());
                }
                String sqlBienestar = "SELECT * FROM HR_Welfare WHERE C_Bpartner_ID = ? AND Amount > 0 AND IsTaxable = 'N'  AND EndDate >= ? AND StartDate <= ?";
                CPreparedStatement pstmtBienestar = DB.prepareStatement(sqlBienestar, this.get_TrxName());
                pstmtBienestar.setInt(1, OFBForward.getBP(rs.getInt("C_Bpartner_ID")));
                pstmtBienestar.setTimestamp(2, periodo.getEndDate());
                pstmtBienestar.setTimestamp(3, periodo.getEndDate());
                ResultSet rsBienestar = pstmtBienestar.executeQuery();
                while (rsBienestar.next()) {
                    X_HR_ProcessBPDetail bpDet3;
                    String mesWel = "";
                    mesWel = rsBienestar.getString("months") != null && rsBienestar.getString("months").trim().length() > 0 ? "-" + rsBienestar.getString("months") + "-" : mes;
                    if (!mesWel.contains(mes)) continue;
                    if (rsBienestar.getString("Type") != null && rsBienestar.getString("Type").compareTo("P") == 0 && rsBienestar.getInt("HR_ConceptRef_ID") > 0) {
                        BigDecimal amtCon2 = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(Amount) FROM HR_ProcessBPDetail WHERE HR_ProcessBP_ID = " + pBP.get_ID() + " AND  HR_Concept_ID = " + rsBienestar.getInt("HR_ConceptRef_ID"), new Object[0]);
                        if (amtCon2 == null) {
                            amtCon2 = Env.ZERO;
                        }
                        BigDecimal amount = rsBienestar.getBigDecimal("Amount");
                        amount = amount.multiply(amtCon2).divide(Env.ONEHUNDRED, 0, RoundingMode.HALF_EVEN);
                        X_HR_ProcessBPDetail bpDet4 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                        bpDet4.setHR_ProcessBP_ID(pBP.get_ID());
                        bpDet4.setAD_Org_ID(pBP.getAD_Org_ID());
                        if (rsBienestar.getInt("HR_Concept_ID") > 0) {
                            bpDet4.setHR_Concept_ID(rsBienestar.getInt("HR_Concept_ID"));
                        }
                        if (amount != null) {
                            bpDet4.setAmount(amount);
                        }
                        bpDet4.saveEx();
                    }
                    if (rsBienestar.getString("Type") != null && rsBienestar.getString("Type").compareTo("M") == 0) {
                        bpDet3 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                        bpDet3.setHR_ProcessBP_ID(pBP.get_ID());
                        bpDet3.setAD_Org_ID(pBP.getAD_Org_ID());
                        if (rsBienestar.getInt("HR_Concept_ID") > 0) {
                            bpDet3.setHR_Concept_ID(rsBienestar.getInt("HR_Concept_ID"));
                        }
                        if (rsBienestar.getBigDecimal("Amount") != null) {
                            bpDet3.setAmount(rsBienestar.getBigDecimal("Amount"));
                        }
                        bpDet3.saveEx();
                    }
                    if (rsBienestar.getString("Type") == null || rsBienestar.getString("Type").compareTo("U") != 0) continue;
                    bpDet3 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                    bpDet3.setHR_ProcessBP_ID(pBP.get_ID());
                    bpDet3.setAD_Org_ID(pBP.getAD_Org_ID());
                    if (rsBienestar.getInt("HR_Concept_ID") > 0) {
                        bpDet3.setHR_Concept_ID(rsBienestar.getInt("HR_Concept_ID"));
                    }
                    if (rsBienestar.getBigDecimal("Amount") != null) {
                        BigDecimal tasa2 = GenerateNominaReassessment.getRate(2000000, 228, dateTope, 114, pro.getAD_Client_ID(), pro.getAD_Org_ID());
                        tasa2 = rsBienestar.getBigDecimal("Amount").multiply(tasa2);
                        bpDet3.setAmount(tasa2.setScale(0, RoundingMode.HALF_EVEN));
                    }
                    bpDet3.saveEx();
                }
                String sqlFact = "SELECT HR_EmployeeChange_ID, DateTrx FROM HR_EmployeeChange  WHERE IsACtive = 'Y' AND Processed = 'Y' AND C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + " AND DateTrx BETWEEN ? AND ? Order By DateTrx desc";
                CPreparedStatement pstmtFact = DB.prepareStatement(sqlFact, this.get_TrxName());
                pstmtFact.setTimestamp(1, periodo.getStartDate());
                pstmtFact.setTimestamp(2, periodo.getEndDate());
                ResultSet rsFact = pstmtFact.executeQuery();
                int indFact = 0;
                int difDays = 0;
                int lastFac = 0;
                int cantF = 0;
                int finMes = 30;
                while (rsFact.next()) {
                    Timestamp dateTrxF = rsFact.getTimestamp("DateTrx");
                    difDays = qtyDaysM - (dateTrxF.getDate() - 1);
                    if ((difDays -= lastFac) == qtyDaysM) {
                        finMes = difDays;
                    }
                    factoresVolt[indFact] = new BigDecimal(difDays).divide(new BigDecimal(finMes), 6, RoundingMode.HALF_EVEN);
                    lastFac += difDays;
                    ++cantF;
                }
                factoresVolt[cantF] = new BigDecimal(finMes - lastFac).divide(new BigDecimal(finMes), 6, RoundingMode.HALF_EVEN);
                int a2 = 0;
                while (a2 <= cantF) {
                    factores[a2] = factoresVolt[cantF - a2];
                    ++a2;
                }
                String sqlConcept = " SELECT pc.HR_Concept_ID FROM HR_PayrollConcept pc INNER JOIN HR_Concept c ON (pc.HR_Concept_ID = c.HR_Concept_ID) WHERE pc.IsActive = 'Y' AND c.IsActive = 'Y' AND pc.HR_Payroll_ID = ? AND (c.C_Year_ID IS NUll OR c.C_Year_ID=" + periodo.getC_Year_ID() + ") ORDER BY pc.SeqNo";
                CPreparedStatement pstmtConcept = DB.prepareStatement(sqlConcept, this.get_TrxName());
                pstmtConcept.setInt(1, pro.getHR_Payroll_ID());
                ResultSet rsConcept = pstmtConcept.executeQuery();
                while (rsConcept.next()) {
                    X_HR_Concept conc = new X_HR_Concept(this.getCtx(), rsConcept.getInt("HR_Concept_ID"), this.get_TrxName());
                    if (conc.get_ID() == 2000102 && rs.getInt("C_Bpartner_ID") == 2010197) {
                        this.log.config("stop para debug: " + conc.get_ID());
                    }
                    BigDecimal factorP2 = Env.ONE;
                    BigDecimal factorP1 = Env.ZERO;
                    BigDecimal amtP1 = Env.ZERO;
                    if (!conc.get_ValueAsBoolean("IsDivisibleAmount")) {
                        factorP2 = Env.ONE;
                    } else {
                        String sqlCh = "SELECT HR_EmployeeChange_ID FROM HR_EmployeeChange  WHERE IsACtive = 'Y' AND Processed = 'Y' AND C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + " AND DateTrx BETWEEN ? AND ? ORDER BY DateTrx asc";
                        CPreparedStatement pstmtCh = DB.prepareStatement(sqlCh, this.get_TrxName());
                        pstmtCh.setTimestamp(1, periodo.getStartDate());
                        pstmtCh.setTimestamp(2, periodo.getEndDate());
                        ResultSet rsCh = pstmtCh.executeQuery();
                        indFact = 0;
                        while (rsCh.next()) {
                            X_HR_EmployeeChange chan = new X_HR_EmployeeChange(this.getCtx(), rsCh.getInt("HR_EmployeeChange_ID"), this.get_TrxName());
                            factorP1 = factores[indFact];
                            amtP1 = Env.ZERO;
                            if (conc.get_ValueAsString("TypeConcept").compareTo("T") == 0) {
                                String sqlValT = "SELECT COALESCE(MAX(MinValue),0) FROM HR_Attribute WHERE HR_Concept_ID = " + conc.get_ID() + " AND ? BETWEEN dateStart AND dateEnd ";
                                if (conc.get_ValueAsString("HR_Reference1") != null && conc.get_ValueAsString("HR_Reference1").trim().length() > 0) {
                                    sqlValT = conc.get_ValueAsString("HR_Reference1").compareTo("grade") == 0 ? (chan.getgradeOld() != null && chan.getgrade() != null && chan.getgrade().trim().length() > 0 ? String.valueOf(sqlValT) + " AND " + conc.get_ValueAsString("HR_Reference1") + " = '" + chan.getgradeOld().trim() + "'" : String.valueOf(sqlValT) + " AND " + conc.get_ValueAsString("HR_Reference1") + " = (SELECT " + conc.get_ValueAsString("HR_Reference1") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")") : (conc.get_ValueAsString("HR_Reference1").compareTo("benio") == 0 ? (chan.get_ValueAsString("benioOld") != null && chan.get_ValueAsString("benio") != null && chan.get_ValueAsString("benio").trim().length() > 0 ? String.valueOf(sqlValT) + " AND " + conc.get_ValueAsString("HR_Reference1") + " = '" + chan.get_ValueAsString("benioOld").trim() + "'" : String.valueOf(sqlValT) + " AND " + conc.get_ValueAsString("HR_Reference1") + " = (SELECT " + conc.get_ValueAsString("HR_Reference1") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")") : String.valueOf(sqlValT) + " AND " + conc.get_ValueAsString("HR_Reference1") + " = (SELECT " + conc.get_ValueAsString("HR_Reference1") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")");
                                }
                                if (conc.get_ValueAsString("HR_Reference2") != null && conc.get_ValueAsString("HR_Reference2").trim().length() > 0) {
                                    sqlValT = conc.get_ValueAsString("HR_Reference2").compareTo("grade") == 0 ? (chan.getgradeOld() != null && chan.getgrade().trim().length() > 0 ? String.valueOf(sqlValT) + " AND " + conc.get_ValueAsString("HR_Reference2") + " = '" + chan.getgradeOld().trim() + "' " : String.valueOf(sqlValT) + " AND " + conc.get_ValueAsString("HR_Reference2") + " = (SELECT " + conc.get_ValueAsString("HR_Reference2") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")") : (conc.get_ValueAsString("HR_Reference2").compareTo("benio") == 0 ? (chan.get_ValueAsString("benioOld") != null && chan.get_ValueAsString("benio") != null && chan.get_ValueAsString("benio").trim().length() > 0 ? String.valueOf(sqlValT) + " AND " + conc.get_ValueAsString("HR_Reference2") + " = '" + chan.get_ValueAsString("benioOld").trim() + "'" : String.valueOf(sqlValT) + " AND " + conc.get_ValueAsString("HR_Reference2") + " = (SELECT " + conc.get_ValueAsString("HR_Reference2") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")") : String.valueOf(sqlValT) + " AND " + conc.get_ValueAsString("HR_Reference2") + " = (SELECT " + conc.get_ValueAsString("HR_Reference2") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")");
                                }
                                if (conc.get_ValueAsString("HR_Reference3") != null && conc.get_ValueAsString("HR_Reference3").trim().length() > 0) {
                                    sqlValT = String.valueOf(sqlValT) + " AND " + conc.get_ValueAsString("HR_Reference3") + " = (SELECT " + conc.get_ValueAsString("HR_Reference3") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                                }
                                if (conc.get_ValueAsString("HR_Reference4") != null && conc.get_ValueAsString("HR_Reference4").trim().length() > 0) {
                                    sqlValT = String.valueOf(sqlValT) + " AND " + conc.get_ValueAsString("HR_Reference4") + " = (SELECT " + conc.get_ValueAsString("HR_Reference4") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                                }
                                if (conc.get_ValueAsString("HR_Reference5") != null && conc.get_ValueAsString("HR_Reference5").trim().length() > 0) {
                                    sqlValT = String.valueOf(sqlValT) + " AND " + conc.get_ValueAsString("HR_Reference5") + " = (SELECT " + conc.get_ValueAsString("HR_Reference5") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                                }
                                if (conc.get_ValueAsString("HR_Reference6") != null && conc.get_ValueAsString("HR_Reference6").trim().length() > 0) {
                                    sqlValT = String.valueOf(sqlValT) + " AND " + conc.get_ValueAsString("HR_Reference6") + " = (SELECT " + conc.get_ValueAsString("HR_Reference6") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                                }
                                if (conc.get_ValueAsBoolean("UseJob")) {
                                    sqlValT = chan.getHR_JobOld_ID() > 0 ? ((conc.get_ID() == 2000013 || conc.get_ID() == 2000014) && (employee.get_ValueAsBoolean("IsProfessional") || employee.get_ValueAsBoolean("IsProfessional2") || employee.get_ValueAsBoolean("IsProfessional3")) && chan.getHR_JobOld_ID() == 2000002 ? String.valueOf(sqlValT) + " AND HR_Job_ID = 2000000" : String.valueOf(sqlValT) + " AND HR_Job_ID = " + chan.getHR_JobOld_ID()) : (!(conc.get_ID() != 2000013 && conc.get_ID() != 2000014 || !employee.get_ValueAsBoolean("IsProfessional") && !employee.get_ValueAsBoolean("IsProfessional2") && !employee.get_ValueAsBoolean("IsProfessional3") || employee.getHR_Job_ID() != 2000002) ? String.valueOf(sqlValT) + " AND HR_Job_ID = 2000000" : String.valueOf(sqlValT) + " AND HR_Job_ID = (SELECT HR_Job_ID FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")");
                                }
                                if (conc.get_ValueAsBoolean("UseRegion")) {
                                    sqlValT = chan.getC_RegionOld_ID() > 0 ? String.valueOf(sqlValT) + " AND C_Region_ID = " + chan.getC_RegionOld_ID() : String.valueOf(sqlValT) + " AND C_Region_ID = (SELECT C_Region_ID FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                                }
                                if (conc.get_ValueAsBoolean("UseOrg")) {
                                    sqlValT = chan.get_ValueAsInt("AD_OrgOld_ID") > 0 ? String.valueOf(sqlValT) + " AND AD_Org_ID = " + chan.get_ValueAsInt("AD_OrgOld_ID") : String.valueOf(sqlValT) + " AND AD_Org_ID = (SELECT AD_Org_ID FROM HR_Employee " + " where AD_Org_ID = " + rs.getInt("AD_Org_ID") + ")";
                                }
                                if ((amtP1 = DB.getSQLValueBD(this.get_TrxName(), sqlValT, pro.getDateAcct())) == null) {
                                    amtP1 = Env.ZERO;
                                } else {
                                    amtP1 = amtP1.multiply(factorP1);
                                    amtP1 = amtP1.setScale(3, RoundingMode.HALF_EVEN);
                                }
                                X_HR_ProcessBPDetail bpDetF = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                                bpDetF.setHR_ProcessBP_ID(pBP.get_ID());
                                bpDetF.setAD_Org_ID(pBP.getAD_Org_ID());
                                bpDetF.setHR_Concept_ID(conc.get_ID());
                                bpDetF.setAmount(amtP1);
                                bpDetF.saveEx();
                            }
                            ++indFact;
                            factorP2 = factorP2.subtract(factorP1);
                        }
                    }
                    amtCon = Env.ZERO;
                    if (conc.get_ValueAsString("TypeConcept").compareTo("T") == 0) {
                        String sqlValT = "SELECT COALESCE(MAX(MinValue),0) FROM HR_Attribute WHERE HR_Concept_ID = " + conc.get_ID() + " AND ? BETWEEN dateStart AND dateEnd ";
                        if (conc.get_ValueAsString("HR_Reference1") != null && conc.get_ValueAsString("HR_Reference1").trim().length() > 0) {
                            sqlValT = String.valueOf(sqlValT) + " AND " + conc.get_ValueAsString("HR_Reference1") + " = (SELECT " + conc.get_ValueAsString("HR_Reference1") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                        }
                        if (conc.get_ValueAsString("HR_Reference2") != null && conc.get_ValueAsString("HR_Reference2").trim().length() > 0) {
                            sqlValT = String.valueOf(sqlValT) + " AND " + conc.get_ValueAsString("HR_Reference2") + " = (SELECT " + conc.get_ValueAsString("HR_Reference2") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                        }
                        if (conc.get_ValueAsString("HR_Reference3") != null && conc.get_ValueAsString("HR_Reference3").trim().length() > 0) {
                            sqlValT = String.valueOf(sqlValT) + " AND " + conc.get_ValueAsString("HR_Reference3") + " = (SELECT " + conc.get_ValueAsString("HR_Reference3") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                        }
                        if (conc.get_ValueAsString("HR_Reference4") != null && conc.get_ValueAsString("HR_Reference4").trim().length() > 0) {
                            sqlValT = String.valueOf(sqlValT) + " AND " + conc.get_ValueAsString("HR_Reference4") + " = (SELECT " + conc.get_ValueAsString("HR_Reference4") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                        }
                        if (conc.get_ValueAsString("HR_Reference5") != null && conc.get_ValueAsString("HR_Reference5").trim().length() > 0) {
                            sqlValT = String.valueOf(sqlValT) + " AND " + conc.get_ValueAsString("HR_Reference5") + " = (SELECT " + conc.get_ValueAsString("HR_Reference5") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                        }
                        if (conc.get_ValueAsString("HR_Reference6") != null && conc.get_ValueAsString("HR_Reference6").trim().length() > 0) {
                            sqlValT = String.valueOf(sqlValT) + " AND " + conc.get_ValueAsString("HR_Reference6") + " = (SELECT " + conc.get_ValueAsString("HR_Reference6") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                        }
                        if (conc.get_ValueAsBoolean("UseJob")) {
                            sqlValT = !(conc.get_ID() != 2000013 && conc.get_ID() != 2000014 || !employee.get_ValueAsBoolean("IsProfessional") && !employee.get_ValueAsBoolean("IsProfessional2") && !employee.get_ValueAsBoolean("IsProfessional3") || employee.getHR_Job_ID() != 2000002) ? String.valueOf(sqlValT) + " AND HR_Job_ID = 2000000" : String.valueOf(sqlValT) + " AND HR_Job_ID = (SELECT HR_Job_ID FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                        }
                        if (conc.get_ValueAsBoolean("UseRegion")) {
                            sqlValT = String.valueOf(sqlValT) + " AND C_Region_ID = (SELECT C_Region_ID FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                        }
                        if (conc.get_ValueAsBoolean("UseOrg")) {
                            sqlValT = String.valueOf(sqlValT) + " AND AD_Org_ID = (SELECT AD_Org_ID FROM HR_Employee " + " where AD_Org_ID = " + rs.getInt("AD_Org_ID") + ")";
                        }
                        if ((conc.get_ID() == 2000103 || conc.get_ID() == 2000012) && employee.get_ValueAsString("Suplencia").compareTo("06") == 0) {
                            sqlValT = sqlValT.replace("grade", "gradeRef");
                        }
                        if ((amtCon = DB.getSQLValueBD(this.get_TrxName(), sqlValT, pro.getDateAcct())) == null) {
                            amtCon = Env.ZERO;
                        } else {
                            amtCon = amtCon.multiply(factorP2);
                            amtCon = amtCon.setScale(3, RoundingMode.HALF_EVEN);
                        }
                        bpDet2 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                        bpDet2.setHR_ProcessBP_ID(pBP.get_ID());
                        bpDet2.setAD_Org_ID(pBP.getAD_Org_ID());
                        bpDet2.setHR_Concept_ID(conc.get_ID());
                        bpDet2.setAmount(amtCon);
                        bpDet2.saveEx();
                        continue;
                    }
                    if (conc.get_ValueAsString("TypeConcept").compareTo("F") == 0) {
                        if ((BigDecimal)conc.get_Value("Amount") != null) {
                            amtCon = (BigDecimal)conc.get_Value("Amount");
                        }
                        X_HR_ProcessBPDetail bpDet5 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                        bpDet5.setHR_ProcessBP_ID(pBP.get_ID());
                        bpDet5.setAD_Org_ID(pBP.getAD_Org_ID());
                        bpDet5.setHR_Concept_ID(conc.get_ID());
                        bpDet5.setAmount(amtCon);
                        bpDet5.saveEx();
                        continue;
                    }
                    if (conc.get_ValueAsString("TypeConcept").compareTo("P") == 0) {
                        String sqlAttributet = "SELECT HR_ConceptRef_ID, MinValue FROM HR_Attribute WHERE HR_Concept_ID = " + conc.get_ID() + " AND ? BETWEEN dateStart AND dateEnd ";
                        if (conc.get_ValueAsString("HR_Reference1") != null && conc.get_ValueAsString("HR_Reference1").trim().length() > 0) {
                            sqlAttributet = String.valueOf(sqlAttributet) + " AND " + conc.get_ValueAsString("HR_Reference1") + " = (SELECT " + conc.get_ValueAsString("HR_Reference1") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                        }
                        if (conc.get_ValueAsString("HR_Reference2") != null && conc.get_ValueAsString("HR_Reference2").trim().length() > 0) {
                            sqlAttributet = String.valueOf(sqlAttributet) + " AND " + conc.get_ValueAsString("HR_Reference2") + " = (SELECT " + conc.get_ValueAsString("HR_Reference2") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                        }
                        if (conc.get_ValueAsString("HR_Reference3") != null && conc.get_ValueAsString("HR_Reference3").trim().length() > 0) {
                            sqlAttributet = String.valueOf(sqlAttributet) + " AND " + conc.get_ValueAsString("HR_Reference3") + " = (SELECT " + conc.get_ValueAsString("HR_Reference3") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                        }
                        if (conc.get_ValueAsString("HR_Reference4") != null && conc.get_ValueAsString("HR_Reference4").trim().length() > 0) {
                            sqlAttributet = String.valueOf(sqlAttributet) + " AND " + conc.get_ValueAsString("HR_Reference4") + " = (SELECT " + conc.get_ValueAsString("HR_Reference4") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                        }
                        if (conc.get_ValueAsString("HR_Reference5") != null && conc.get_ValueAsString("HR_Reference5").trim().length() > 0) {
                            sqlAttributet = String.valueOf(sqlAttributet) + " AND " + conc.get_ValueAsString("HR_Reference5") + " = (SELECT " + conc.get_ValueAsString("HR_Reference5") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                        }
                        if (conc.get_ValueAsString("HR_Reference6") != null && conc.get_ValueAsString("HR_Reference6").trim().length() > 0) {
                            sqlAttributet = String.valueOf(sqlAttributet) + " AND " + conc.get_ValueAsString("HR_Reference6") + " = (SELECT " + conc.get_ValueAsString("HR_Reference6") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                        }
                        if (conc.get_ValueAsBoolean("UseJob")) {
                            sqlAttributet = !(conc.get_ID() != 2000013 && conc.get_ID() != 2000013 || !employee.get_ValueAsBoolean("IsProfessional") && !employee.get_ValueAsBoolean("IsProfessional2") && !employee.get_ValueAsBoolean("IsProfessional3") || employee.getHR_Job_ID() != 2000002) ? String.valueOf(sqlAttributet) + " AND HR_Job_ID = 2000000" : String.valueOf(sqlAttributet) + " AND HR_Job_ID = (SELECT HR_Job_ID FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                        }
                        if (conc.get_ValueAsBoolean("UseRegion")) {
                            sqlAttributet = String.valueOf(sqlAttributet) + " AND C_Region_ID = (SELECT C_Region_ID FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                        }
                        if (conc.get_ValueAsBoolean("UseOrg")) {
                            sqlAttributet = String.valueOf(sqlAttributet) + " AND AD_Org_ID = (SELECT AD_Org_ID FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID") + ")";
                        }
                        CPreparedStatement pstmtAtt = DB.prepareStatement(sqlAttributet, this.get_TrxName());
                        pstmtAtt.setTimestamp(1, pro.getDateAcct());
                        ResultSet rsAtt = pstmtAtt.executeQuery();
                        int indDetEx = 1;
                        while (rsAtt.next()) {
                            BigDecimal amtAtt = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(Amount) FROM HR_ProcessBPDetail WHERE HR_ProcessBP_ID = " + pBP.get_ID() + " AND  HR_Concept_ID = " + rsAtt.getInt("HR_ConceptRef_ID"), new Object[0]);
                            if (amtAtt == null) {
                                amtAtt = Env.ZERO;
                            }
                            if ((conc.get_ID() == 2000103 || conc.get_ID() == 2000012) && employee.get_ValueAsString("Suplencia").compareTo("06") == 0) {
                                if (indDetEx == 1) {
                                    amtAuxEx = amtAtt = DB.getSQLValueBD(this.get_TrxName(), "SELECT MinValue FROM HR_Attribute WHERE HR_Concept_ID = " + rsAtt.getInt("HR_ConceptRef_ID") + conc.get_ID() + " AND ? BETWEEN dateStart AND dateEnd " + " AND IsActive = 'Y' AND grade = '" + employee.get_ValueAsString("gradeRef") + "'", pro.getDateAcct());
                                }
                                if (indDetEx == 2) {
                                    amtAtt = DB.getSQLValueBD(this.get_TrxName(), "SELECT MinValue FROM HR_Attribute WHERE HR_Concept_ID = " + rsAtt.getInt("HR_ConceptRef_ID") + conc.get_ID() + " AND ? BETWEEN dateStart AND dateEnd " + " AND IsActive = 'Y' AND benio = '" + employee.get_ValueAsString("benio") + "'", pro.getDateAcct());
                                    if (amtAtt == null) {
                                        amtAtt = Env.ZERO;
                                    }
                                    if (amtAuxEx == null) {
                                        amtAuxEx = Env.ZERO;
                                    }
                                    amtAtt = amtAtt.multiply(amtAuxEx);
                                    amtAtt = amtAtt.divide(Env.ONEHUNDRED, 0, RoundingMode.HALF_EVEN);
                                }
                                ++indDetEx;
                            }
                            if (amtAtt == null) {
                                amtAtt = Env.ZERO;
                            }
                            amtCon = amtAtt.multiply(rsAtt.getBigDecimal("MinValue")).divide(Env.ONEHUNDRED, RoundingMode.HALF_EVEN);
                            amtCon = amtCon.setScale(0, RoundingMode.HALF_EVEN);
                            bpDet = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                            bpDet.setHR_ProcessBP_ID(pBP.get_ID());
                            bpDet.setAD_Org_ID(pBP.getAD_Org_ID());
                            bpDet.setHR_Concept_ID(conc.get_ID());
                            if (conc.get_ID() == 2000012 || conc.get_ID() == 2000103) {
                                if (employee.get_ValueAsString("Suplencia").compareTo("07") == 0) {
                                    bpDet.setAmount(Env.ZERO);
                                } else {
                                    bpDet.setAmount(amtCon);
                                }
                            } else {
                                bpDet.setAmount(amtCon);
                            }
                            bpDet.saveEx();
                        }
                        continue;
                    }
                    if (conc.get_ValueAsString("TypeConcept").compareTo("B1") != 0) continue;
                    String mesBono = conc.get_ValueAsString("months");
                    if (!(mesBono = "-" + mesBono + "-").contains(mes)) continue;
                    BigDecimal porc = Env.ZERO;
                    if (conc.get_ValueAsString("HR_Bono1") != null && conc.get_ValueAsString("HR_Bono1").trim().length() > 0) {
                        porc = DB.getSQLValueBD(this.get_TrxName(), "SELECT " + conc.get_ValueAsString("HR_Bono1") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID"), new Object[0]);
                    }
                    if (porc == null) {
                        porc = Env.ZERO;
                    }
                    if (porc.compareTo(Env.ZERO) == 0) continue;
                    BigDecimal amtBono = Env.ZERO;
                    int a3 = 0;
                    while (a3 < 3) {
                        BigDecimal amtLast = DB.getSQLValueBD(this.get_TrxName(), "SELECT TotalAmt FROM HR_ProcessBP bp INNER JOIN HR_Process pr ON (bp.HR_Process_ID = pr.HR_Process_ID)  WHERE bp.C_BPartner_ID=" + rs.getInt("C_BPartner_ID") + " AND EXTRACT(month FROM pr.dateAcct)=" + (pro.getDateAcct().getMonth() - a3) + " AND pr.DocStatus IN ('CO') AND bp.IsActive = 'Y' AND bp.Processed = 'Y'", new Object[0]);
                        if (amtLast == null) {
                            amtLast = Env.ZERO;
                        }
                        if (amtLast.compareTo(Env.ZERO) > 0) {
                            amtLast = amtLast.multiply(porc).divide(Env.ONEHUNDRED, RoundingMode.HALF_EVEN);
                        }
                        amtBono = amtBono.add(amtLast);
                        ++a3;
                    }
                    amtBono = amtBono.setScale(0, RoundingMode.HALF_EVEN);
                    X_HR_ProcessBPDetail bpDet6 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                    bpDet6.setHR_ProcessBP_ID(pBP.get_ID());
                    bpDet6.setAD_Org_ID(pBP.getAD_Org_ID());
                    bpDet6.setHR_Concept_ID(conc.get_ID());
                    bpDet6.setAmount(amtBono);
                    bpDet6.saveEx();
                }
                String sqlBienestarD = "SELECT * FROM HR_Welfare WHERE C_Bpartner_ID = ? AND Amount <= 0 AND IsTaxable = 'N'AND EndDate >= ? AND StartDate <= ?";
                CPreparedStatement pstmtBienestarD = DB.prepareStatement(sqlBienestarD, this.get_TrxName());
                pstmtBienestarD.setInt(1, rs.getInt("C_Bpartner_ID"));
                pstmtBienestarD.setTimestamp(2, periodo.getEndDate());
                pstmtBienestarD.setTimestamp(3, periodo.getEndDate());
                ResultSet rsBienestarD = pstmtBienestarD.executeQuery();
                while (rsBienestarD.next()) {
                    X_HR_ProcessBPDetail bpDet7;
                    String mesWel = "";
                    mesWel = rsBienestarD.getString("months") != null && rsBienestarD.getString("months").trim().length() > 0 ? "-" + rsBienestarD.getString("months") + "-" : mes;
                    if (!mesWel.contains(mes)) continue;
                    if (rsBienestarD.getString("Type") != null && rsBienestarD.getString("Type").compareTo("P") == 0) {
                        if (rsBienestarD.getInt("HR_ConceptRef_ID") > 0) {
                            amtCon = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(Amount) FROM HR_ProcessBPDetail WHERE HR_ProcessBP_ID = " + pBP.get_ID() + " AND  HR_Concept_ID = " + rsBienestarD.getInt("HR_ConceptRef_ID"), new Object[0]);
                            if (amtCon == null) {
                                amtCon = Env.ZERO;
                            }
                            BigDecimal amount = rsBienestarD.getBigDecimal("Amount");
                            amount = amount.multiply(amtCon).divide(Env.ONEHUNDRED, 0, RoundingMode.HALF_EVEN);
                            bpDet2 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                            bpDet2.setHR_ProcessBP_ID(pBP.get_ID());
                            bpDet2.setAD_Org_ID(pBP.getAD_Org_ID());
                            if (rsBienestarD.getInt("HR_Concept_ID") > 0) {
                                bpDet2.setHR_Concept_ID(rsBienestarD.getInt("HR_Concept_ID"));
                            }
                            if (amount != null) {
                                bpDet2.setAmount(amount);
                            }
                            bpDet2.saveEx();
                        }
                    } else if (rsBienestarD.getString("Type") != null && rsBienestarD.getString("Type").compareTo("M") == 0) {
                        bpDet7 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                        bpDet7.setHR_ProcessBP_ID(pBP.get_ID());
                        bpDet7.setAD_Org_ID(pBP.getAD_Org_ID());
                        if (rsBienestarD.getInt("HR_Concept_ID") > 0) {
                            bpDet7.setHR_Concept_ID(rsBienestarD.getInt("HR_Concept_ID"));
                        }
                        if (rsBienestarD.getBigDecimal("Amount") != null) {
                            bpDet7.setAmount(rsBienestarD.getBigDecimal("Amount"));
                        }
                        bpDet7.saveEx();
                    }
                    if (rsBienestarD.getString("Type") == null || rsBienestarD.getString("Type").compareTo("U") != 0) continue;
                    bpDet7 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                    bpDet7.setHR_ProcessBP_ID(pBP.get_ID());
                    bpDet7.setAD_Org_ID(pBP.getAD_Org_ID());
                    if (rsBienestarD.getInt("HR_Concept_ID") > 0) {
                        bpDet7.setHR_Concept_ID(rsBienestarD.getInt("HR_Concept_ID"));
                    }
                    if (rsBienestarD.getBigDecimal("Amount") != null) {
                        BigDecimal tasa3 = GenerateNominaReassessment.getRate(2000000, 228, dateTope, 114, pro.getAD_Client_ID(), pro.getAD_Org_ID());
                        tasa3 = rsBienestarD.getBigDecimal("Amount").multiply(tasa3);
                        bpDet7.setAmount(tasa3.setScale(0, RoundingMode.HALF_EVEN));
                    }
                    bpDet7.saveEx();
                }
                String sqlInc = "SELECT * FROM HR_Movement WHERE IsActive = 'Y' AND C_Bpartner_ID = ? AND EXTRACT(month FROM validfrom) = ?  AND  HR_Concept_ID <> 2000054 ";
                CPreparedStatement pstmtInc = DB.prepareStatement(sqlInc, this.get_TrxName());
                pstmtInc.setInt(1, rs.getInt("C_Bpartner_ID"));
                pstmtInc.setInt(2, pro.getDateAcct().getMonth() + 1);
                ResultSet rsInc = pstmtInc.executeQuery();
                while (rsInc.next()) {
                    if (rsInc.getString("Type") != null && rsInc.getString("Type").compareTo("P") == 0) {
                        if (rsInc.getInt("HR_ConceptRef_ID") <= 0) continue;
                        BigDecimal amtCon3 = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(Amount) FROM HR_ProcessBPDetail  WHERE HR_ProcessBP_ID = " + pBP.get_ID() + " AND  HR_Concept_ID = " + rsInc.getInt("HR_ConceptRef_ID"), new Object[0]);
                        if (amtCon3 == null) {
                            amtCon3 = Env.ZERO;
                        }
                        BigDecimal amount = rsInc.getBigDecimal("Amount");
                        amount = amount.multiply(amtCon3).divide(Env.ZERO, 0, RoundingMode.HALF_EVEN);
                        X_HR_ProcessBPDetail bpDet8 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                        bpDet8.setHR_ProcessBP_ID(pBP.get_ID());
                        bpDet8.setAD_Org_ID(pBP.getAD_Org_ID());
                        if (rsInc.getInt("HR_Concept_ID") > 0) {
                            bpDet8.setHR_Concept_ID(rsInc.getInt("HR_Concept_ID"));
                        }
                        if (amount != null) {
                            bpDet8.setAmount(amount);
                        }
                        bpDet8.saveEx();
                        continue;
                    }
                    if (rsInc.getString("Type") == null || rsInc.getString("Type").compareTo("M") != 0) continue;
                    bpDet2 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                    bpDet2.setHR_ProcessBP_ID(pBP.get_ID());
                    bpDet2.setAD_Org_ID(pBP.getAD_Org_ID());
                    if (rsInc.getInt("HR_Concept_ID") > 0) {
                        bpDet2.setHR_Concept_ID(rsInc.getInt("HR_Concept_ID"));
                    }
                    if (rsInc.getBigDecimal("Amount") != null) {
                        bpDet2.setAmount(rsInc.getBigDecimal("Amount"));
                    }
                    bpDet2.saveEx();
                }
                int ID_ConceptHE = DB.getSQLValue(this.get_TrxName(), "SELECT HR_Concept_ID FROM HR_Concept c  WHERE upper(c.description) = 'HEXTRA'");
                int ID_ConceptHENO = DB.getSQLValue(this.get_TrxName(), "SELECT HR_Concept_ID FROM HR_Concept c  WHERE upper(c.description) = 'HEXTRANOCHE'");
                BigDecimal vHExtra = DB.getSQLValueBD(this.get_TrxName(), "SELECT COALESCE(SUM(d.Amount),0) FROM HR_ProcessBPDetail d INNER JOIN HR_Concept c ON (d.HR_Concept_ID = c.HR_Concept_ID) WHERE c.IsHEAmt = 'Y' AND d.HR_ProcessBP_ID IN (SELECT HR_ProcessBP_ID FROM HR_ProcessBP pbp INNER JOIN HR_Process p ON (p.HR_Process_ID = pbp.HR_Process_ID) WHERE pbp.IsActive='Y' AND C_Period_ID = " + periodo.get_ID() + " AND pbp.C_Bpartner_ID=" + pBP.getC_BPartner_ID() + " AND p.IsActive='Y')", new Object[0]);
                if (vHExtra == null) {
                    vHExtra = Env.ZERO;
                }
                vHExtra = vHExtra.divide(new BigDecimal("190.0"), 0, RoundingMode.HALF_EVEN);
                BigDecimal dayhourscalc = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(DayTimeReal) as DayTimeReal  FROM HR_HourPlanningControl pc INNER JOIN HR_HourPlanningLine pl ON (pc.HR_HourPlanningControl_ID = pl.HR_HourPlanningControl_ID) WHERE C_BPartner_ID = " + pBP.getC_BPartner_ID() + " AND C_Period_ID = " + (periodo.get_ID() - 1), new Object[0]);
                if (dayhourscalc != null && dayhourscalc.compareTo(Env.ZERO) != 0) {
                    dayhourscalc = dayhourscalc.divide(new BigDecimal("60.0"), 0, RoundingMode.HALF_EVEN);
                    dayhourscalc = dayhourscalc.multiply(new BigDecimal("1.25"));
                    dayhourscalc = dayhourscalc.multiply(vHExtra);
                }
                if (dayhourscalc != null && dayhourscalc.compareTo(Env.ZERO) > 0) {
                    bpDet = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                    bpDet.setHR_ProcessBP_ID(pBP.get_ID());
                    bpDet.setAD_Org_ID(pBP.getAD_Org_ID());
                    if (ID_ConceptHE > 0) {
                        bpDet.setHR_Concept_ID(ID_ConceptHE);
                    }
                    bpDet.setAmount(dayhourscalc);
                    bpDet.saveEx();
                }
                if ((nightHoursCalc = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(NightTimeReal) as NightTimeReal  FROM HR_HourPlanningControl pc INNER JOIN HR_HourPlanningLine pl ON (pc.HR_HourPlanningControl_ID = pl.HR_HourPlanningControl_ID) WHERE C_BPartner_ID = " + pBP.getC_BPartner_ID() + " AND C_Period_ID = " + (periodo.get_ID() - 1), new Object[0])) != null && nightHoursCalc.compareTo(Env.ZERO) != 0) {
                    nightHoursCalc = nightHoursCalc.divide(new BigDecimal("60.0"), 0, RoundingMode.HALF_EVEN);
                    nightHoursCalc = nightHoursCalc.multiply(new BigDecimal("1.5"));
                    nightHoursCalc = nightHoursCalc.multiply(vHExtra);
                }
                if (nightHoursCalc != null && nightHoursCalc.compareTo(Env.ZERO) > 0) {
                    X_HR_ProcessBPDetail bpDet9 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                    bpDet9.setHR_ProcessBP_ID(pBP.get_ID());
                    bpDet9.setAD_Org_ID(pBP.getAD_Org_ID());
                    if (ID_ConceptHENO > 0) {
                        bpDet9.setHR_Concept_ID(ID_ConceptHENO);
                    }
                    bpDet9.setAmount(nightHoursCalc);
                    bpDet9.saveEx();
                }
                if ((tLiq = DB.getSQLValueBD(this.get_TrxName(), "SELECT COALESCE(SUM(Amount),0) FROM HR_ProcessBPDetail  WHERE HR_ProcessBP_ID=" + pBP.get_ID(), new Object[0])) != null) {
                    tLiq = tLiq.setScale(0, RoundingMode.HALF_EVEN);
                    pBP.set_CustomColumn("Total2", tLiq);
                }
                pBP.saveEx();
                String sqlBienestarTr = "SELECT * FROM HR_Welfare WHERE C_Bpartner_ID = ? AND IsTaxable = 'Y' AND EndDate >= ? AND StartDate <= ? ";
                CPreparedStatement pstmtBienestarTr = DB.prepareStatement(sqlBienestarTr, this.get_TrxName());
                pstmtBienestarTr.setInt(1, rs.getInt("C_Bpartner_ID"));
                pstmtBienestarTr.setTimestamp(2, periodo.getEndDate());
                pstmtBienestarTr.setTimestamp(3, periodo.getEndDate());
                ResultSet rsBienestarTr = pstmtBienestarTr.executeQuery();
                while (rsBienestarTr.next()) {
                    String mesWel = "";
                    mesWel = rsBienestarTr.getString("months") != null && rsBienestarTr.getString("months").trim().length() > 0 ? "-" + rsBienestarTr.getString("months") + "-" : mes;
                    if (!mesWel.contains(mes) || rsBienestarTr.getString("Type") == null || rsBienestarTr.getString("Type").compareTo("P") != 0 || rs.getInt("HR_Concept_ID") <= 0) continue;
                    BigDecimal amtCon4 = (BigDecimal)pBP.get_Value("TotalAmt");
                    if (amtCon4 == null) {
                        amtCon4 = Env.ZERO;
                    }
                    BigDecimal amount = rs.getBigDecimal("Amount");
                    amount = amount.multiply(amtCon4).divide(Env.ZERO, 0, RoundingMode.HALF_EVEN);
                    X_HR_ProcessBPDetail bpDet10 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                    bpDet10.setHR_ProcessBP_ID(pBP.get_ID());
                    bpDet10.setAD_Org_ID(pBP.getAD_Org_ID());
                    bpDet10.setHR_Concept_ID(rsBienestar.getInt("HR_Concept_ID"));
                    if (amount != null) {
                        bpDet10.setAmount(amount);
                    }
                    bpDet10.saveEx();
                }
                BigDecimal tBonus = DB.getSQLValueBD(this.get_TrxName(), "SELECT COALESCE(SUM(d.Amount),0) FROM HR_ProcessBPDetail d INNER JOIN HR_Concept c ON (d.HR_Concept_ID = c.HR_Concept_ID) WHERE c.IsBonusAmt = 'Y' AND d.HR_ProcessBP_ID = " + pBP.get_ID(), new Object[0]);
                pBP.set_CustomColumn("TotalBonus", tBonus);
                pBP.saveEx();
                int existChange = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM HR_EmployeeChange  WHERE Processed = 'Y' AND DateTrx Between ? AND ? AND C_Bpartner_ID =" + pBP.getC_BPartner_ID(), startYear, periodo.getEndDate());
                int existHE = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM HR_ProcessBPDetail  WHERE IsActive='Y' AND HR_Concept_ID IN (2000051,2000128) AND HR_ProcessBP_ID = " + pBP.get_ID());
                if (existChange <= 0 && existHE > 0) {
                    DB.executeUpdate("UPDATE HR_ProcessBPDetail SET Amount=0 WHERE HR_Concept_ID NOT IN (2000051,2000128,2000102,2000060,2000057,2000159,2000169,2000170,2000177,2000200)  AND HR_ProcessBP_ID = " + pBP.get_ID(), this.get_TrxName());
                }
                DB.executeUpdate("UPDATE HR_ProcessBP SET HR_RETIREMENT = TotalAMT * 0.014  WHERE HR_ProcessBP_ID = " + pBP.get_ID(), this.get_TrxName());
                DB.executeUpdate("UPDATE HR_ProcessBP SET HR_SIS = TotalAMT * 0.0141  WHERE HR_ProcessBP_ID = " + pBP.get_ID(), this.get_TrxName());
                DB.executeUpdate("UPDATE HR_ProcessBP SET HR_Health = TotalAMT * 0.0093  WHERE HR_ProcessBP_ID = " + pBP.get_ID(), this.get_TrxName());
                this.commitEx();
                DB.executeUpdate("UPDATE HR_ProcessBPDetail SET AmountOld = Amount WHERE HR_ProcessBP_ID = " + pBP.get_ID(), this.get_TrxName());
                DB.executeUpdate("UPDATE HR_Movement SET IsUsed = 'Y' WHERE C_Bpartner_ID =" + pBP.getC_BPartner_ID(), this.get_TrxName());
                int ID_ProcessBPRel = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(HR_ProcessBP_ID) FROM HR_ProcessBP pbp INNER JOIN HR_Process p ON (p.HR_Process_ID = pbp.HR_Process_ID) WHERE pbp.IsActive='Y' AND C_Period_ID = " + periodo.get_ID() + " AND pbp.C_Bpartner_ID=" + pBP.getC_BPartner_ID() + " AND p.IsActive='Y' AND IsReassessment = 'Y' AND HR_ProcessBP_ID <> " + pBP.get_ID());
                if (ID_ProcessBPRel > 0) {
                    pBP.set_CustomColumn("HR_ProcessBPRef_ID", ID_ProcessBPRel);
                    String sqlCompa = "SELECT HR_Concept_ID,HR_ProcessBPDetail_ID FROM HR_ProcessBPDetail  WHERE Amount <> 0 AND HR_ProcessBP_ID=" + pBP.get_ID();
                    CPreparedStatement pstmtCompa = null;
                    pstmtCompa = DB.prepareStatement(sqlCompa, this.get_TrxName());
                    ResultSet rsCompa = pstmtCompa.executeQuery();
                    String ID_ConcepUsed = "1,";
                    while (rsCompa.next()) {
                        BigDecimal amtRes;
                        if (!ID_ConcepUsed.contains(Integer.toString(rsCompa.getInt("HR_Concept_ID"))) && (amtRes = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(AmountOld) FROM HR_ProcessBPDetail  WHERE HR_ProcessBP_ID=" + ID_ProcessBPRel + " AND HR_Concept_ID=" + rsCompa.getInt("HR_Concept_ID"), new Object[0])) != null) {
                            DB.executeUpdate("UPDATE HR_ProcessBPDetail SET Amount = Amount-(" + amtRes.intValue() + ")" + " WHERE HR_ProcessBPDetail_ID=" + rsCompa.getInt("HR_ProcessBPDetail_ID"), this.get_TrxName());
                        }
                        ID_ConcepUsed = String.valueOf(ID_ConcepUsed) + rsCompa.getInt("HR_Concept_ID");
                    }
                } else {
                    int ID_ProcessBPOld = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(HR_ProcessBP_ID) FROM HR_ProcessBP pbp INNER JOIN HR_Process p ON (p.HR_Process_ID = pbp.HR_Process_ID) WHERE pbp.IsActive='Y' AND C_Period_ID = " + periodo.get_ID() + " AND pbp.C_Bpartner_ID=" + pBP.getC_BPartner_ID() + " AND p.IsActive='Y' AND IsReassessment <> 'Y'");
                    if (ID_ProcessBPOld > 0) {
                        pBP.set_CustomColumn("HR_ProcessBPRef_ID", ID_ProcessBPOld);
                        String sqlCompa = "SELECT HR_Concept_ID,Amount,HR_ProcessBPDetail_ID FROM HR_ProcessBPDetail  WHERE (Amount <> 0 OR HR_Concept_ID=2000102) AND HR_ProcessBP_ID=" + pBP.get_ID();
                        CPreparedStatement pstmtCompa = null;
                        pstmtCompa = DB.prepareStatement(sqlCompa, this.get_TrxName());
                        ResultSet rsCompa = pstmtCompa.executeQuery();
                        String ID_ConcepUsed = "1,";
                        while (rsCompa.next()) {
                            BigDecimal amtRes;
                            if (!ID_ConcepUsed.contains(Integer.toString(rsCompa.getInt("HR_Concept_ID"))) && (amtRes = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(Amount) FROM HR_ProcessBPDetail  WHERE HR_ProcessBP_ID=" + ID_ProcessBPOld + " AND HR_Concept_ID=" + rsCompa.getInt("HR_Concept_ID"), new Object[0])) != null) {
                                DB.executeUpdate("UPDATE HR_ProcessBPDetail SET Amount = Amount-(" + amtRes.intValue() + ")" + " WHERE HR_ProcessBPDetail_ID=" + rsCompa.getInt("HR_ProcessBPDetail_ID"), this.get_TrxName());
                            }
                            ID_ConcepUsed = String.valueOf(ID_ConcepUsed) + rsCompa.getInt("HR_Concept_ID");
                        }
                    }
                }
                int ID_ProcessBPOLD = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(HR_ProcessBP_ID) FROM HR_ProcessBP pbp  INNER JOIN HR_Process p ON (p.HR_Process_ID = pbp.HR_Process_ID) WHERE pbp.IsActive='Y' AND C_Period_ID = " + periodo.get_ID() + " AND pbp.C_Bpartner_ID=" + pBP.getC_BPartner_ID() + " AND p.IsActive='Y' AND IsReassessment <> 'Y'");
                X_HR_ProcessBP pbpOld = new X_HR_ProcessBP(this.getCtx(), ID_ProcessBPOLD, this.get_TrxName());
                BigDecimal pTope = DB.getSQLValueBD(this.get_TrxName(), "SELECT MaxAmount FROM HR_Employee c WHERE c.C_Bpartner_ID=" + rs.getInt("C_Bpartner_ID"), new Object[0]);
                if (pTope == null) {
                    pTope = Env.ONE;
                }
                if ((tasa = GenerateNominaReassessment.getRate(2000000, 228, dateTope, 114, pro.getAD_Client_ID(), pro.getAD_Org_ID())) == null) {
                    tasa = Env.ZERO;
                }
                BigDecimal tope = pTope.multiply(tasa);
                tope = tope.setScale(0, RoundingMode.HALF_EVEN);
                BigDecimal tImp = DB.getSQLValueBD(this.get_TrxName(), "SELECT COALESCE(SUM(d.Amount),0) FROM HR_ProcessBPDetail d INNER JOIN HR_Concept c ON (d.HR_Concept_ID = c.HR_Concept_ID) WHERE c.IsTaxable = 'Y' AND d.HR_ProcessBP_ID = " + pBP.get_ID(), new Object[0]);
                if (tImp == null) {
                    tImp = Env.ZERO;
                }
                if ((tImpOld = DB.getSQLValueBD(this.get_TrxName(), "SELECT TotalAmt FROM HR_ProcessBP pbp  WHERE HR_ProcessBP_ID = " + pbpOld.get_ID(), new Object[0])) == null) {
                    tImpOld = Env.ZERO;
                }
                if ((tImp = tImp.add(tImpOld)).compareTo(tope) > 0 && tope.compareTo(Env.ZERO) > 0) {
                    pBP.set_CustomColumn("TotalAmt", tope);
                } else {
                    tImp = tImp.setScale(0, RoundingMode.HALF_EVEN);
                    pBP.set_CustomColumn("TotalAmt", tImp.subtract(tImpOld));
                }
                pBP.saveEx(this.get_TrxName());
                if (((BigDecimal)pBP.get_Value("TotalAmt")).compareTo(Env.ZERO) > 0) {
                    X_HR_ProcessBPDetail bpDet11;
                    BigDecimal amtSaludOld;
                    BigDecimal pUF;
                    String sqlConceptDe = " SELECT pc.HR_Concept_ID FROM HR_PayrollConcept pc INNER JOIN HR_Concept c ON (pc.HR_Concept_ID = c.HR_Concept_ID) WHERE pc.IsActive = 'Y' AND c.IsActive = 'Y' AND TypeConcept = 'D1' AND pc.HR_Payroll_ID = ? AND (c.C_Year_ID IS NUll OR c.C_Year_ID=" + periodo.getC_Year_ID() + ") ORDER BY pc.SeqNo";
                    CPreparedStatement pstmtConceptDe = DB.prepareStatement(sqlConceptDe, this.get_TrxName());
                    pstmtConceptDe.setInt(1, pro.getHR_Payroll_ID());
                    ResultSet rsConceptDe = pstmtConceptDe.executeQuery();
                    while (rsConceptDe.next()) {
                        X_HR_Concept conc = new X_HR_Concept(this.getCtx(), rsConceptDe.getInt("HR_Concept_ID"), this.get_TrxName());
                        BigDecimal amtTotal = Env.ZERO;
                        BigDecimal porc = Env.ZERO;
                        if (conc.get_ValueAsString("HR_Discount1") != null && conc.get_ValueAsString("HR_Discount1").trim().length() > 0 && (porc = DB.getSQLValueBD(this.get_TrxName(), "SELECT " + conc.get_ValueAsString("HR_Discount1") + " FROM HR_Employee " + " where C_Bpartner_ID = " + rs.getInt("C_Bpartner_ID"), new Object[0])) == null) {
                            porc = Env.ZERO;
                        }
                        amtTotal = porc.multiply((BigDecimal)pBP.get_Value("TotalAmt"));
                        amtTotal = amtTotal.divide(Env.ONEHUNDRED, 0, RoundingMode.HALF_EVEN);
                        amtTotal = amtTotal.negate();
                        X_HR_ProcessBPDetail bpDet12 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                        bpDet12.setHR_ProcessBP_ID(pBP.get_ID());
                        bpDet12.setAD_Org_ID(pBP.getAD_Org_ID());
                        bpDet12.setHR_Concept_ID(conc.get_ID());
                        bpDet12.setAmount(amtTotal);
                        bpDet12.saveEx();
                        bpDet12.set_CustomColumn("AmountOld", bpDet12.getAmount());
                        bpDet12.saveEx();
                    }
                    tasa = GenerateNominaReassessment.getRate(2000000, 228, dateTope, 114, pro.getAD_Client_ID(), pro.getAD_Org_ID());
                    if (tasa == null) {
                        tasa = Env.ONE;
                    }
                    if ((pUF = DB.getSQLValueBD(this.get_TrxName(), "SELECT MAX(ISAPRE_UF) FROM HR_Employee  WHERE C_Bpartner_ID=" + rs.getInt("C_Bpartner_ID"), new Object[0])) == null) {
                        pUF = Env.ZERO;
                    }
                    BigDecimal pSaludUF = pUF.multiply(tasa);
                    BigDecimal topeUF = DB.getSQLValueBD(this.get_TrxName(), "SELECT MAX(TOPEISAPRE_UF) FROM HR_Employee  WHERE C_Bpartner_ID=" + rs.getInt("C_Bpartner_ID"), new Object[0]);
                    if (topeUF == null) {
                        topeUF = Env.ZERO;
                    }
                    BigDecimal topeSalud = topeUF.multiply(tasa);
                    topeSalud = topeSalud.setScale(0, RoundingMode.HALF_EVEN);
                    BigDecimal amtSalud = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(d.Amount)*-1  FROM HR_ProcessBPDetail d  INNER JOIN HR_Concept c ON (d.HR_Concept_ID = c.HR_Concept_ID) WHERE HR_ProcessBP_ID = " + pBP.get_ID() + " AND  upper(c.description) = 'SALUD'", new Object[0]);
                    if (amtSalud == null) {
                        amtSalud = Env.ZERO;
                    }
                    if ((amtSaludOld = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(d.Amount)*-1  FROM HR_ProcessBPDetail d  INNER JOIN HR_Concept c ON (d.HR_Concept_ID = c.HR_Concept_ID) WHERE upper(c.description) = 'SALUD' AND HR_ProcessBP_ID = " + pbpOld.get_ID(), new Object[0])) == null) {
                        amtSaludOld = Env.ZERO;
                    }
                    if ((amtSalud = amtSalud.add(amtSaludOld)).compareTo(pSaludUF) < 0 && amtSalud.compareTo(topeSalud) < 0) {
                        if (pSaludUF.compareTo(topeSalud) > 0) {
                            BigDecimal amtASaludOld;
                            BigDecimal amtATSaludOld;
                            bpDet11 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                            bpDet11.setHR_ProcessBP_ID(pBP.get_ID());
                            bpDet11.setAD_Org_ID(pBP.getAD_Org_ID());
                            int ID_Concept = DB.getSQLValue(this.get_TrxName(), "SELECT HR_Concept_ID FROM HR_Concept c  WHERE upper(c.description) = 'ATSALUD'");
                            if (ID_Concept > 0) {
                                bpDet11.setHR_Concept_ID(ID_Concept);
                            }
                            if ((amtATSaludOld = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(d.Amount)*-1  FROM HR_ProcessBPDetail d  INNER JOIN HR_Concept c ON (d.HR_Concept_ID = c.HR_Concept_ID) WHERE upper(c.description) = 'ATSALUD' AND HR_ProcessBP_ID = " + pbpOld.get_ID(), new Object[0])) == null) {
                                amtATSaludOld = Env.ZERO;
                            }
                            bpDet11.setAmount(pSaludUF.subtract(topeSalud).negate().setScale(0, RoundingMode.HALF_EVEN));
                            bpDet11.setAmount(bpDet11.getAmount().add(amtATSaludOld));
                            bpDet11.saveEx();
                            bpDet11.set_CustomColumn("AmountOld", bpDet11.getAmount());
                            bpDet11.saveEx();
                            X_HR_ProcessBPDetail bpDet22 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                            bpDet22.setHR_ProcessBP_ID(pBP.get_ID());
                            bpDet22.setAD_Org_ID(pBP.getAD_Org_ID());
                            int ID_Concept2 = DB.getSQLValue(this.get_TrxName(), "SELECT HR_Concept_ID FROM HR_Concept c  WHERE upper(c.description) = 'ASALUD'");
                            if (ID_Concept2 > 0) {
                                bpDet22.setHR_Concept_ID(ID_Concept2);
                            }
                            if ((amtASaludOld = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(d.Amount)*-1  FROM HR_ProcessBPDetail d  INNER JOIN HR_Concept c ON (d.HR_Concept_ID = c.HR_Concept_ID) WHERE upper(c.description) = 'ASALUD' AND HR_ProcessBP_ID = " + pbpOld.get_ID(), new Object[0])) == null) {
                                amtASaludOld = Env.ZERO;
                            }
                            bpDet22.setAmount(topeSalud.subtract(amtSalud).negate().setScale(0, RoundingMode.HALF_EVEN));
                            bpDet22.setAmount(bpDet22.getAmount().add(amtASaludOld));
                            bpDet22.saveEx();
                            bpDet22.set_CustomColumn("AmountOld", bpDet11.getAmount());
                            bpDet22.saveEx();
                        } else if (pSaludUF.compareTo(topeSalud) <= 0) {
                            BigDecimal amtASaludOld;
                            bpDet11 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                            bpDet11.setHR_ProcessBP_ID(pBP.get_ID());
                            bpDet11.setAD_Org_ID(pBP.getAD_Org_ID());
                            int ID_Concept = DB.getSQLValue(this.get_TrxName(), "SELECT HR_Concept_ID FROM HR_Concept c  WHERE upper(c.description) = 'ASALUD'");
                            if (ID_Concept > 0) {
                                bpDet11.setHR_Concept_ID(ID_Concept);
                            }
                            if ((amtASaludOld = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(d.Amount)*-1  FROM HR_ProcessBPDetail d  INNER JOIN HR_Concept c ON (d.HR_Concept_ID = c.HR_Concept_ID) WHERE upper(c.description) = 'ASALUD' AND HR_ProcessBP_ID = " + pbpOld.get_ID(), new Object[0])) == null) {
                                amtASaludOld = Env.ZERO;
                            }
                            bpDet11.setAmount(pSaludUF.subtract(amtSalud).negate().setScale(0, RoundingMode.HALF_EVEN));
                            bpDet11.setAmount(bpDet11.getAmount().add(amtASaludOld));
                            bpDet11.saveEx();
                            bpDet11.set_CustomColumn("AmountOld", bpDet11.getAmount());
                            bpDet11.saveEx();
                        }
                    } else if (amtSalud.compareTo(pSaludUF) < 0 && amtSalud.compareTo(topeSalud) >= 0) {
                        BigDecimal amtATSaludOld;
                        bpDet11 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                        bpDet11.setHR_ProcessBP_ID(pBP.get_ID());
                        bpDet11.setAD_Org_ID(pBP.getAD_Org_ID());
                        int ID_Concept = DB.getSQLValue(this.get_TrxName(), "SELECT HR_Concept_ID FROM HR_Concept c  WHERE upper(c.description) = 'ATSALUD'");
                        if (ID_Concept > 0) {
                            bpDet11.setHR_Concept_ID(ID_Concept);
                        }
                        if ((amtATSaludOld = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(d.Amount)*-1  FROM HR_ProcessBPDetail d  INNER JOIN HR_Concept c ON (d.HR_Concept_ID = c.HR_Concept_ID) WHERE upper(c.description) = 'ATSALUD' AND HR_ProcessBP_ID = " + pbpOld.get_ID(), new Object[0])) == null) {
                            amtATSaludOld = Env.ZERO;
                        }
                        bpDet11.setAmount(pSaludUF.subtract(amtSalud).negate().setScale(0, RoundingMode.HALF_EVEN));
                        bpDet11.setAmount(bpDet11.getAmount().add(amtATSaludOld));
                        bpDet11.saveEx();
                        bpDet11.set_CustomColumn("AmountOld", bpDet11.getAmount());
                        bpDet11.saveEx();
                    } else if (amtSalud.compareTo(topeSalud) > 0) {
                        BigDecimal amtATSaludOld;
                        bpDet11 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                        bpDet11.setHR_ProcessBP_ID(pBP.get_ID());
                        bpDet11.setAD_Org_ID(pBP.getAD_Org_ID());
                        int ID_Concept = DB.getSQLValue(this.get_TrxName(), "SELECT HR_Concept_ID FROM HR_Concept c  WHERE upper(c.description) = 'ATSALUD'");
                        if (ID_Concept > 0) {
                            bpDet11.setHR_Concept_ID(ID_Concept);
                        }
                        if ((amtATSaludOld = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(d.Amount)*-1  FROM HR_ProcessBPDetail d  INNER JOIN HR_Concept c ON (d.HR_Concept_ID = c.HR_Concept_ID) WHERE upper(c.description) = 'ATSALUD' AND HR_ProcessBP_ID = " + pbpOld.get_ID(), new Object[0])) == null) {
                            amtATSaludOld = Env.ZERO;
                        }
                        bpDet11.setAmount(amtSalud.subtract(topeSalud).negate().setScale(0, RoundingMode.HALF_EVEN));
                        bpDet11.setAmount(bpDet11.getAmount().add(amtATSaludOld));
                        bpDet11.saveEx();
                        bpDet11.set_CustomColumn("AmountOld", bpDet11.getAmount());
                        bpDet11.saveEx();
                    }
                }
                if ((dTributable = DB.getSQLValueBD(this.get_TrxName(), "SELECT COALESCE(SUM(d.Amount),0) FROM HR_ProcessBPDetail d INNER JOIN HR_Concept c ON (d.HR_Concept_ID = c.HR_Concept_ID) WHERE c.IsTaxableDiscount = 'Y' AND d.HR_ProcessBP_ID = " + pBP.get_ID(), new Object[0])) == null) {
                    dTributable = Env.ZERO;
                }
                BigDecimal tTributable = DB.getSQLValueBD(this.get_TrxName(), "SELECT COALESCE(SUM(d.Amount),0) FROM HR_ProcessBPDetail d INNER JOIN HR_Concept c ON (d.HR_Concept_ID = c.HR_Concept_ID) WHERE d.HR_ProcessBP_ID = " + pBP.get_ID() + " AND HR_Concept_Category_ID = 2000001" + " AND c.IsTaxable = 'Y'", new Object[0]);
                tTributable = tTributable.add(dTributable);
                pBP.set_CustomColumn("Total1", tTributable);
                BigDecimal tHaberes = DB.getSQLValueBD(this.get_TrxName(), "SELECT COALESCE(SUM(d.Amount),0) FROM HR_ProcessBPDetail d INNER JOIN HR_Concept c ON (d.HR_Concept_ID = c.HR_Concept_ID) WHERE d.HR_ProcessBP_ID = " + pBP.get_ID() + " AND HR_Concept_Category_ID = 2000001", new Object[0]);
                pBP.set_CustomColumn("Total3", tHaberes);
                pBP.saveEx(this.get_TrxName());
                String useUTax = DB.getSQLValueString(this.get_TrxName(), "SELECT MAX(UseUniqueTax) FROM HR_Employee  WHERE C_Bpartner_ID=" + rs.getInt("C_Bpartner_ID"), new Object[0]);
                if (useUTax != null && useUTax.compareTo("Y") == 0) {
                    BigDecimal taxUniqueAmt = (BigDecimal)pBP.get_Value("Total1");
                    BigDecimal tTributableOld = DB.getSQLValueBD(this.get_TrxName(), "SELECT Total1 FROM HR_ProcessBP pbp  WHERE HR_ProcessBP_ID =" + pbpOld.get_ID(), new Object[0]);
                    if (tTributableOld == null) {
                        tTributableOld = Env.ZERO;
                    }
                    taxUniqueAmt = taxUniqueAmt.add(tTributableOld);
                    String Type2 = DB.getSQLValueString(this.get_TrxName(), "SELECT MAX(TypeUniqueTax) FROM HR_Employee  WHERE C_Bpartner_ID=" + rs.getInt("C_Bpartner_ID"), new Object[0]);
                    int ID_UniqueTax = DB.getSQLValue(this.get_TrxName(), "SELECT HR_SingleTax_id FROM HR_SingleTax  WHERE " + taxUniqueAmt + " BETWEEN minAmt AND MaxAmt AND C_Period_ID = ? AND Type='" + Type2 + "'", periodo.get_ID());
                    if (ID_UniqueTax > 0) {
                        BigDecimal amtIUnicoOld;
                        BigDecimal discount;
                        BigDecimal percent = DB.getSQLValueBD(this.get_TrxName(), "SELECT Percentage FROM HR_SIngleTax WHERE HR_SIngleTax_ID=" + ID_UniqueTax, new Object[0]);
                        if (percent == null) {
                            percent = Env.ZERO;
                        }
                        if ((discount = DB.getSQLValueBD(this.get_TrxName(), "SELECT DiscountAmt FROM HR_SIngleTax WHERE HR_SIngleTax_ID=" + ID_UniqueTax, new Object[0])) == null) {
                            discount = Env.ZERO;
                        }
                        taxUniqueAmt = taxUniqueAmt.multiply(percent).subtract(discount);
                        X_HR_ProcessBPDetail bpDet13 = new X_HR_ProcessBPDetail(this.getCtx(), 0, this.get_TrxName());
                        bpDet13.setHR_ProcessBP_ID(pBP.get_ID());
                        bpDet13.setAD_Org_ID(pBP.getAD_Org_ID());
                        int ID_Concept = DB.getSQLValue(this.get_TrxName(), "SELECT HR_Concept_ID FROM HR_Concept c  WHERE upper(c.description) = 'UNICO'");
                        if (ID_Concept > 0) {
                            bpDet13.setHR_Concept_ID(ID_Concept);
                        }
                        if ((amtIUnicoOld = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(d.Amount)*-1  FROM HR_ProcessBPDetail d  INNER JOIN HR_Concept c ON (d.HR_Concept_ID = c.HR_Concept_ID) WHERE upper(c.description) = 'UNICO' AND HR_ProcessBP_ID = " + pbpOld.get_ID(), new Object[0])) == null) {
                            amtIUnicoOld = Env.ZERO;
                        }
                        bpDet13.setAmount(taxUniqueAmt.negate().setScale(0, RoundingMode.HALF_EVEN));
                        bpDet13.setAmount(bpDet13.getAmount().add(amtIUnicoOld));
                        bpDet13.saveEx();
                        bpDet13.set_CustomColumn("AmountOld", bpDet13.getAmount());
                        bpDet13.saveEx();
                    }
                }
                DB.executeUpdate("UPDATE HR_ProcessBPDetail SET HR_ProcessBPRef_ID = " + this.p_ProcessBP_ID + " WHERE HR_ProcessBP_ID = " + pBP.get_ID(), this.get_TrxName());
                DB.executeUpdate("UPDATE HR_ProcessBPDetail SET C_PeriodProcess_ID = " + periodo.get_ID() + " WHERE HR_ProcessBP_ID = " + pBP.get_ID(), this.get_TrxName());
                DB.executeUpdate("UPDATE HR_ProcessBPDetail SET C_PeriodReassessment_ID  = " + this.p_PeriodTo_ID + " WHERE HR_ProcessBP_ID = " + pBP.get_ID(), this.get_TrxName());
                pBP.set_CustomColumn("Total2", DB.getSQLValueBD(this.get_TrxName(), "SELECT COALESCE(SUM(Amount),0) FROM HR_ProcessBPDetail  WHERE HR_ProcessBP_ID=" + pBP.get_ID(), new Object[0]));
                pBP.saveEx(this.get_TrxName());
            }
            if (periodo.getPeriodNo() < 12) {
                ID_Periodo = DB.getSQLValue(this.get_TrxName(), "SELECT C_Period_ID FROM C_Period WHERE C_Year_ID=" + periodo.getC_Year_ID() + " AND PeriodNo=" + (periodo.getPeriodNo() + 1));
                continue;
            }
            if (periodo.getPeriodNo() != 12) continue;
            ID_Periodo = DB.getSQLValue(this.get_TrxName(), "SELECT C_Period_ID FROM C_Period WHERE C_Year_ID=" + (periodo.getC_Year_ID() + 1) + " AND PeriodNo= 1");
        }
        DB.executeUpdate("UPDATE HR_EmployeeChange SET IsUsed = 'Y' WHERE C_Bpartner_ID IN (" + ID_BpartnerUsed + ")", this.get_TrxName());
        return "Procesado " + logM;
    }

    public static BigDecimal getRate(int CurFrom_ID, int CurTo_ID, Timestamp ConvDate, int ConversionType_ID, int AD_Client_ID, int AD_Org_ID) {
        if (CurFrom_ID == CurTo_ID) {
            return Env.ONE;
        }
        int C_ConversionType_ID = ConversionType_ID;
        if (C_ConversionType_ID == 0) {
            C_ConversionType_ID = MConversionType.getDefault(AD_Client_ID);
        }
        if (ConvDate == null) {
            ConvDate = new Timestamp(System.currentTimeMillis());
        }
        String sql = "SELECT MultiplyRate FROM C_Conversion_Rate WHERE IsTaxable = 'Y'  AND C_Currency_ID=? AND C_Currency_ID_To=? AND\tC_ConversionType_ID=? AND ? BETWEEN EXTRACT (month from ValidFrom) AND EXTRACT (month from ValidTo) AND AD_Client_ID IN (0,?) AND AD_Org_ID IN (0,?) ORDER BY AD_Client_ID DESC, AD_Org_ID DESC, ValidFrom DESC";
        BigDecimal retValue = null;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, CurFrom_ID);
            pstmt.setInt(2, CurTo_ID);
            pstmt.setInt(3, C_ConversionType_ID);
            pstmt.setInt(4, ConvDate.getMonth() + 1);
            pstmt.setInt(5, AD_Client_ID);
            pstmt.setInt(6, AD_Org_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getBigDecimal(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "getRate", e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (retValue == null) {
            s_log.info("getRate - not found - CurFrom=" + CurFrom_ID + ", CurTo=" + CurTo_ID + ", " + ConvDate + ", Type=" + ConversionType_ID + (ConversionType_ID == C_ConversionType_ID ? "" : "->" + C_ConversionType_ID) + ", Client=" + AD_Client_ID + ", Org=" + AD_Org_ID);
        }
        return retValue;
    }
}

