/*
 * Decompiled with CFR 0.152.
 */
package org.indap.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.X_DM_Document;
import org.compiere.model.X_DM_DocumentLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class GenerateLineResolution
extends SvrProcess {
    private int p_ID_Resolution = 0;
    private int p_C_BPartner_ID = 0;
    private int p_AD_Org_ID = 0;
    private int p_Parent_Org_ID = 0;
    private String p_RequestType = "";
    private Timestamp p_DateFrom = null;
    private Timestamp p_DateTo = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = para[i].getParameterAsInt();
            } else if (name.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = para[i].getParameterAsInt();
            } else if (name.equals("Parent_Org_ID")) {
                this.p_Parent_Org_ID = para[i].getParameterAsInt();
            } else if (name.equals("RequestType")) {
                this.p_RequestType = para[i].getParameterAsString();
            } else if (name.equals("DateTrx")) {
                this.p_DateFrom = para[i].getParameterAsTimestamp();
                this.p_DateTo = para[i].getParameterToAsTimestamp();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.p_ID_Resolution = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        int cant = 0;
        if (this.p_ID_Resolution > 0) {
            X_DM_Document res = new X_DM_Document(this.getCtx(), this.p_ID_Resolution, this.get_TrxName());
            Timestamp dateNew = new Timestamp(res.getDateTrx().getTime());
            dateNew.setYear(res.getDateTrx().getYear() - 2);
            String sql = "";
            if (res.getC_DocType_ID() == 2000138) {
                sql = "SELECT RH_MedicalLicenses_ID FROM RH_MedicalLicenses b  WHERE b.DocStatus IN ('CO') AND b.RH_MedicalLicenses_ID NOT IN (SELECT RH_MedicalLicenses_ID FROM DM_DocumentLine WHERE IsActive = 'Y' AND RH_MedicalLicenses_ID IS NOT NULL)";
                if (this.p_DateFrom != null && this.p_DateTo != null) {
                    sql = String.valueOf(sql) + " AND Date1 >= ? AND Date1 <=? ";
                }
            } else if (res.getC_DocType_ID() == 2000180) {
                sql = "SELECT HR_AdministrativeRequests_ID,b.C_BPartner_ID  FROM HR_AdministrativeRequests b  WHERE b.DocStatus IN ('CO') AND HR_AdministrativeRequests_ID NOT IN (SELECT HR_AdministrativeRequests_ID FROM DM_DocumentLine  WHERE IsActive = 'Y' AND HR_AdministrativeRequests_ID IS NOT NULL)";
                if (this.p_DateFrom != null && this.p_DateTo != null) {
                    sql = String.valueOf(sql) + " AND DateDoc >= ? AND DateDoc <=? ";
                }
                if (this.p_RequestType != null && this.p_RequestType.trim().length() > 0) {
                    sql = String.valueOf(sql) + " AND RequestType = '" + this.p_RequestType + "'";
                }
            } else if (res.getC_DocType_ID() == 2000164) {
                sql = "SELECT b.C_BPartner_ID FROM HR_Employee b  WHERE b.joinDateAP IS NOT NULL  AND TRUNC(extract(days from((?)::timestamp - (joinDateAP+qtyDays)))/365)::integer%2 = 0 AND TRUNC(extract(days from((?)::timestamp - (joinDateAP+qtyDays)))/365) > 0 AND C_BPartner_ID NOT IN (SELECT dl.C_BPartner_ID FROM DM_DocumentLine dl INNER JOIN DM_Document d ON (dl.DM_Document_ID = d.DM_Document_ID) WHERE dl.C_BPartner_ID IS NOT NULL AND DateTrx > ?)";
            }
            if (this.p_AD_Org_ID > 0) {
                sql = String.valueOf(sql) + " AND b.AD_Org_ID = " + this.p_AD_Org_ID;
            }
            if (this.p_C_BPartner_ID > 0) {
                sql = String.valueOf(sql) + " AND b.C_Bpartner_ID = " + this.p_C_BPartner_ID;
            }
            if (this.p_Parent_Org_ID > 0) {
                sql = String.valueOf(sql) + " AND b.AD_Org_ID IN (SELECT AD_Org_ID FROM AD_OrgInfo WHERE Parent_Org_ID = " + this.p_Parent_Org_ID + ") ";
            }
            CPreparedStatement pstmt = DB.prepareStatement(sql, this.get_TrxName());
            if (res.getC_DocType_ID() == 2000164) {
                pstmt.setTimestamp(1, res.getDateTrx());
                pstmt.setTimestamp(2, res.getDateTrx());
                pstmt.setTimestamp(3, dateNew);
            } else if (this.p_DateFrom != null && this.p_DateTo != null) {
                pstmt.setTimestamp(1, this.p_DateFrom);
                pstmt.setTimestamp(2, this.p_DateTo);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_DM_DocumentLine rLine = new X_DM_DocumentLine(this.getCtx(), 0, this.get_TrxName());
                rLine.setAD_Org_ID(res.getAD_Org_ID());
                rLine.setDM_Document_ID(res.get_ID());
                if (res.getC_DocType_ID() == 2000138) {
                    rLine.set_CustomColumn("RH_MedicalLicenses_ID", rs.getInt("RH_MedicalLicenses_ID"));
                }
                if (res.getC_DocType_ID() == 2000180) {
                    rLine.set_CustomColumn("HR_AdministrativeRequests_ID", rs.getInt("HR_AdministrativeRequests_ID"));
                    rLine.set_CustomColumn("C_BPartner_ID", rs.getInt("C_BPartner_ID"));
                }
                if (res.getC_DocType_ID() == 2000164) {
                    rLine.set_CustomColumn("C_BPartner_ID", rs.getInt("C_BPartner_ID"));
                }
                rLine.saveEx(this.get_TrxName());
                ++cant;
            }
        }
        return "Se han agregado " + cant + " lineas";
    }
}

