/*
 * Decompiled with CFR 0.152.
 */
package org.indap.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_HR_AdministrativeRequests;
import org.compiere.model.X_HR_AdministrativeRequestsL;
import org.compiere.util.CLogger;

public class ModINDAPValidateHoursQty
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModINDAPValidateHoursQty.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("HR_AdministrativeRequestsL", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == X_HR_AdministrativeRequestsL.Table_ID) {
            X_HR_AdministrativeRequestsL reql = (X_HR_AdministrativeRequestsL)po;
            X_HR_AdministrativeRequests req = new X_HR_AdministrativeRequests(po.getCtx(), reql.getHR_AdministrativeRequests_ID(), po.get_TrxName());
            String reqtype = req.getRequestType();
            if (reqtype.compareToIgnoreCase("COM") == 0) {
                Timestamp diadelasemana = (Timestamp)reql.get_Value("Date01");
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(diadelasemana.getTime());
                int dia = calendar.get(7);
                BigDecimal hours = reql.gethours();
                if (dia == 6) {
                    if (hours.compareTo(new BigDecimal(4)) != 0 && hours.compareTo(new BigDecimal(8)) != 0) {
                        return "Las horas no pueden ser distintas a 4 / 8 para un dia Viernes";
                    }
                } else if ((dia == 5 || dia == 2 || dia == 3 || dia == 4) && hours.compareTo(new BigDecimal(4.5)) != 0 && hours.compareTo(new BigDecimal(9)) != 0) {
                    return "Las horas no pueden ser distintas a 4.5 / 9 para un dia Lu/ma/mi/ju";
                }
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

