/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostType;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;

public class ValuationEffectiveDate
extends SvrProcess {
    private int p_M_Warehouse_ID;
    private int p_M_Product_ID;
    private int p_M_Product_Category_ID;
    private int p_M_CostType_ID;
    private int p_M_CostElement_ID;
    private Timestamp p_DateValue;
    private List<MCostType> costTypes = new ArrayList<MCostType>();
    private List<MCostElement> costElements = new ArrayList<MCostElement>();
    private List<MWarehouse> warehouses = new ArrayList<MWarehouse>();
    private int[] products = new int[0];
    private StringBuffer whereClause1 = null;
    private StringBuffer whereClause2 = null;
    PreparedStatement pstmt = null;
    private int batchSize = 1000;
    private int count = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] parameters;
        for (ProcessInfoParameter parameter : parameters = this.getParameter()) {
            String name = parameter.getParameterName();
            if (parameter.getParameter() == null) continue;
            if (name.equals("DateValue")) {
                this.p_DateValue = (Timestamp)parameter.getParameter();
                if (this.p_DateValue != null) continue;
                throw new FillMandatoryException(new String[]{"@DateValue@"});
            }
            if (name.equals("M_Warehouse_ID")) {
                this.p_M_Warehouse_ID = parameter.getParameterAsInt();
                continue;
            }
            if (name.equals("M_Product_ID")) {
                this.p_M_Product_ID = parameter.getParameterAsInt();
                continue;
            }
            if (name.equals("M_Product_Category_ID")) {
                this.p_M_Product_Category_ID = parameter.getParameterAsInt();
                continue;
            }
            if (name.equals("M_CostType_ID")) {
                this.p_M_CostType_ID = parameter.getParameterAsInt();
                continue;
            }
            if (!name.equals("M_CostElement_ID")) continue;
            this.p_M_CostElement_ID = parameter.getParameterAsInt();
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.setup();
        for (MWarehouse warehouse : this.warehouses) {
            for (MCostType costType : this.costTypes) {
                for (MCostElement costElement : this.costElements) {
                    for (int productId : this.products) {
                        this.generateInventoryValue(productId, costType.getM_CostType_ID(), costElement.getM_CostElement_ID(), warehouse.getM_Warehouse_ID());
                    }
                }
            }
        }
        this.pstmt.executeBatch();
        this.commitEx();
        DB.close(this.pstmt);
        DB.executeUpdate("UPDATE T_InventoryValue SET Cost = CASE WHEN QtyOnHand <> 0 THEN (CostAmt + CostAmtLL) / QtyOnHand ELSE  0 END  ,  CumulatedAmt = CASE WHEN QtyOnHand <> 0  THEN  CostAmt + CostAmtLL ELSE 0 END ,  DateValue = " + DB.TO_DATE(this.p_DateValue) + " WHERE AD_PInstance_ID=?", this.getAD_PInstance_ID(), this.get_TrxName());
        return "@Ok@ " + this.count;
    }

    private void setup() {
        if (this.p_M_CostType_ID > 0) {
            this.costTypes.add(new MCostType(this.getCtx(), this.p_M_CostType_ID, this.get_TrxName()));
        } else {
            this.costTypes = MCostType.get(this.getCtx(), this.get_TrxName());
        }
        if (this.p_M_CostElement_ID > 0) {
            this.costElements.add(MCostElement.get(this.getCtx(), this.p_M_CostElement_ID));
        } else {
            this.costElements = MCostElement.getCostElement(this.getCtx(), this.get_TrxName());
        }
        if (this.p_M_Warehouse_ID > 0) {
            this.warehouses.add(MWarehouse.get(this.getCtx(), this.p_M_Warehouse_ID, this.get_TrxName()));
        } else {
            this.warehouses = new Query(this.getCtx(), "M_Warehouse", "", this.get_TrxName()).setClient_ID().list();
        }
        this.products = this.p_M_Product_ID == 0 ? new Query(this.getCtx(), "M_Product", "", this.get_TrxName()).setClient_ID().getIDs() : new int[]{this.p_M_Product_ID};
        this.setWhere();
        StringBuffer insert = new StringBuffer();
        insert.append("INSERT INTO T_InventoryValue ").append("(AD_PInstance_ID,DateValue,AD_Client_ID,AD_Org_ID,M_CostElement_ID,M_CostType_ID,M_Warehouse_ID,").append("M_Product_ID,M_Product_Category_ID,M_AttributeSetInstance_ID,Group1,Group2,QtyOnHand,CostAmt,CostAmtLL) ").append("SELECT ").append(this.getAD_PInstance_ID()).append(",").append("tc.DateAcct").append(",").append("p.AD_Client_ID,p.AD_Org_ID,tc.M_CostElement_ID,tc.M_CostType_ID, tc.M_Warehouse_ID,p.M_Product_ID,").append("p.M_Product_Category_ID,tc.M_AttributeSetInstance_ID,p.Group1,p.Group2,  tc.qty + tc.cumulatedqty AS QtyOnHand,").append(" CASE WHEN tc.Qty < 0 OR (tc.qty = 0 AND tc.cumulatedqty < 0) THEN ((tc.costAmt + tc.costadjustment) * -1) + tc.CumulatedAmt ELSE ((tc.costAmt + tc.costadjustment) * 1) + tc.CumulatedAmt END  AS CostAmt,").append(" CASE WHEN tc.Qty < 0 OR (tc.qty = 0 AND tc.cumulatedqty < 0) THEN ((tc.costAmtLL + tc.costadjustmentLL) * -1)  + tc.CumulatedAmtLL ELSE ((tc.costAmtLL + tc.costadjustmentLL) * 1) + tc.CumulatedAmtLL END AS CostAmtLL").append(" FROM M_Product p ").append(" INNER JOIN M_CostDetail tc ON (p.M_Product_ID=tc.M_Product_ID) ");
        insert.append(this.whereClause1).append(this.whereClause2);
        this.pstmt = DB.prepareStatement(insert.toString(), 1004, 1008, this.get_TrxName());
    }

    public void setWhere() {
        this.whereClause1 = new StringBuffer("WHERE tc.IsReversal='N' ");
        this.whereClause2 = new StringBuffer(" AND tc.SeqNo = (SELECT MAX(SeqNo) FROM M_CostDetail tc1").append(" WHERE tc1.IsReversal='N' AND tc1.M_Product_ID=tc.M_Product_ID AND tc1.M_Warehouse_ID = tc.M_Warehouse_ID ");
        this.whereClause1.append("AND tc.DateAcct<= ").append(DB.TO_DATE(this.p_DateValue));
        this.whereClause2.append("AND tc1.DateAcct<= ").append(DB.TO_DATE(this.p_DateValue));
        this.whereClause1.append(" AND p.M_Product_ID=? ");
        if (this.p_M_Product_Category_ID > 0) {
            this.whereClause1.append(" AND p.M_Product_Category_ID =? ");
        }
        this.whereClause1.append(" AND tc.M_CostType_ID =?  ");
        this.whereClause2.append(" AND tc1.M_CostType_ID=tc.M_CostType_ID ");
        this.whereClause1.append(" AND tc.M_CostElement_ID=? ");
        this.whereClause2.append(" AND tc1.M_CostElement_ID = tc.M_CostElement_ID");
        this.whereClause1.append(" AND tc.M_Warehouse_ID=? ");
        this.whereClause2.append(")");
    }

    private void generateInventoryValue(int M_Product_ID, int M_CostType_ID, int M_CostElement_ID, int M_Warehouse_ID) throws SQLException {
        this.pstmt.setInt(1, M_Product_ID);
        this.pstmt.setInt(2, M_CostType_ID);
        this.pstmt.setInt(3, M_CostElement_ID);
        this.pstmt.setInt(4, M_Warehouse_ID);
        if (this.p_M_Product_Category_ID > 0) {
            this.pstmt.setInt(5, this.p_M_Product_Category_ID);
        }
        this.pstmt.addBatch();
        if (++this.count % this.batchSize == 0) {
            this.pstmt.executeBatch();
            this.commitEx();
        }
    }
}

