/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.adempiere.engine.CostDimension;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MCostElement;
import org.compiere.model.MProduct;
import org.compiere.model.MUOMConversion;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.MPPMRP;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;
import org.eevolution.model.MPPProductPlanning;

public class RollupBillOfMaterial
extends SvrProcess {
    private int p_AD_Org_ID = 0;
    private int p_C_AcctSchema_ID = 0;
    private int p_M_CostType_ID = 0;
    private String p_ConstingMethod = "S";
    private int p_M_Product_ID = 0;
    private int p_M_Product_Category_ID = 0;
    private String p_ProductType = null;
    private Collection<MCostElement> m_costElements = null;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter para : this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if (name.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("C_AcctSchema_ID")) {
                this.p_C_AcctSchema_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("M_CostType_ID")) {
                this.p_M_CostType_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("CostingMethod")) {
                this.p_ConstingMethod = (String)para.getParameter();
                continue;
            }
            if (name.equals("M_Product_ID")) {
                this.p_M_Product_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("M_Product_Category_ID")) {
                this.p_M_Product_Category_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("ProductType")) {
                this.p_ProductType = para.getParameter() == null ? null : para.getParameter().toString();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        int maxLowLevel;
        this.resetCostsLLForLLC0();
        for (int lowLevel = maxLowLevel = MPPMRP.getMaxLowLevel(this.getCtx(), this.get_TrxName()); lowLevel >= 0; --lowLevel) {
            for (MProduct product : this.getProducts(lowLevel)) {
                MPPProductBOM bom;
                MPPProductPlanning pp = MPPProductPlanning.find(this.getCtx(), this.p_AD_Org_ID, 0, 0, product.getM_Product_ID(), this.get_TrxName());
                int PP_Product_BOM_ID = 0;
                if (pp != null) {
                    PP_Product_BOM_ID = pp.getPP_Product_BOM_ID();
                } else {
                    this.createNotice(product, "@NotFound@ @PP_Product_Planning_ID@");
                }
                if (PP_Product_BOM_ID <= 0) {
                    PP_Product_BOM_ID = MPPProductBOM.getBOMSearchKey(product);
                }
                if ((bom = MPPProductBOM.get(this.getCtx(), PP_Product_BOM_ID)) == null) {
                    this.createNotice(product, "@NotFound@ @PP_Product_BOM_ID@");
                }
                this.rollup(product, bom);
            }
        }
        return "@OK@";
    }

    protected void rollup(MProduct product, MPPProductBOM bom) {
        for (MCostElement element : this.getCostElements()) {
            for (MCost cost : this.getCosts(product, element.get_ID())) {
                this.log.info("Calculate Lower Cost for: " + bom);
                BigDecimal price = this.getCurrentCostPriceLL(bom, element);
                this.log.info(element.getName() + " Cost Low Level:" + price);
                cost.setCurrentCostPriceLL(price);
                this.updateCoProductCosts(bom, cost);
                cost.saveEx();
            }
        }
    }

    private void updateCoProductCosts(MPPProductBOM bom, MCost baseDimension) {
        if (bom == null) {
            return;
        }
        BigDecimal costPriceTotal = Env.ZERO;
        for (MPPProductBOMLine bomLine : bom.getLines()) {
            if (!bomLine.isCoProduct()) continue;
            BigDecimal costPrice = baseDimension.getCurrentCostPriceLL().multiply(bomLine.getCostAllocationPerc(true));
            MCost dimension = MCost.getDimension((MProduct)bomLine.getM_Product(), baseDimension.getC_AcctSchema_ID(), baseDimension.getAD_Org_ID(), baseDimension.getM_Warehouse_ID(), 0, baseDimension.getM_CostType_ID(), baseDimension.getM_CostElement_ID());
            if (dimension == null) {
                dimension = new MCost(baseDimension.getCtx(), 0, baseDimension.get_TrxName());
                dimension.setAD_Org_ID(baseDimension.getAD_Org_ID());
                dimension.setM_Product_ID(bomLine.getM_Product_ID());
                dimension.setM_CostType_ID(baseDimension.getM_CostType_ID());
                dimension.setC_AcctSchema_ID(baseDimension.getC_AcctSchema_ID());
                dimension.setM_CostElement_ID(baseDimension.getM_CostElement_ID());
                dimension.setM_AttributeSetInstance_ID(0);
            }
            dimension.setCurrentCostPriceLL(costPrice);
            dimension.saveEx();
            costPriceTotal = costPriceTotal.add(costPrice);
        }
        if (costPriceTotal.signum() != 0) {
            baseDimension.setCurrentCostPriceLL(costPriceTotal);
        }
    }

    private BigDecimal getCurrentCostPriceLL(MPPProductBOM bom, MCostElement element) {
        this.log.info("Element: " + element);
        BigDecimal costPriceLL = Env.ZERO;
        if (bom == null) {
            return costPriceLL;
        }
        for (MPPProductBOMLine bomline : bom.getLines()) {
            if (bomline.isCoProduct()) continue;
            MProduct component = MProduct.get(this.getCtx(), bomline.getM_Product_ID());
            for (MCost cost : this.getCosts(component, element.get_ID())) {
                BigDecimal qty = bomline.getQty(true);
                if (bomline.isByProduct()) {
                    cost.setCurrentCostPriceLL(Env.ZERO);
                }
                BigDecimal costPrice = cost.getCurrentCostPrice().add(cost.getCurrentCostPriceLL());
                if (bomline.getM_Product().getC_UOM_ID() != bomline.getC_UOM_ID()) {
                    BigDecimal rate = MUOMConversion.getProductRateFrom(this.getCtx(), component.getM_Product_ID(), bomline.getC_UOM_ID());
                    costPrice = rate == null ? costPrice.multiply(BigDecimal.ONE) : costPrice.multiply(rate);
                }
                BigDecimal componentCost = costPrice.multiply(qty);
                costPriceLL = costPriceLL.add(componentCost);
                this.log.info("CostElement: " + element.getName() + ", Component: " + component.getValue() + ", CostPrice: " + costPrice + ", Qty: " + qty + ", Cost: " + componentCost + " => Total Cost Element: " + costPriceLL);
            }
        }
        return costPriceLL;
    }

    private Collection<MCost> getCosts(MProduct product, int M_CostElement_ID) {
        MAcctSchema as = MAcctSchema.get(this.getCtx(), this.p_C_AcctSchema_ID);
        CostDimension d = new CostDimension(product, as, this.p_M_CostType_ID, this.p_AD_Org_ID, 0, 0, M_CostElement_ID);
        return d.toQuery(MCost.class, this.get_TrxName()).list();
    }

    private Collection<MProduct> getProducts(int lowLevel) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer("AD_Client_ID=?").append(" AND ").append("LowLevel").append("=?");
        params.add(this.getAD_Client_ID());
        params.add(lowLevel);
        whereClause.append(" AND ").append("IsBOM").append("=?");
        params.add(true);
        if (this.p_M_Product_ID > 0) {
            whereClause.append(" AND ").append("M_Product_ID").append("=?");
            params.add(this.p_M_Product_ID);
        } else if (this.p_M_Product_Category_ID > 0) {
            whereClause.append(" AND ").append("M_Product_Category_ID").append("=?");
            params.add(this.p_M_Product_Category_ID);
        }
        if (this.p_M_Product_ID <= 0 && this.p_ProductType != null) {
            whereClause.append(" AND ").append("ProductType").append("=?");
            params.add(this.p_ProductType);
        }
        return new Query(this.getCtx(), "M_Product", whereClause.toString(), this.get_TrxName()).setParameters(params).list();
    }

    private void resetCostsLLForLLC0() {
        ArrayList<Integer> params = new ArrayList<Integer>();
        StringBuffer productWhereClause = new StringBuffer();
        productWhereClause.append("AD_Client_ID=? AND LowLevel=?");
        params.add(this.getAD_Client_ID());
        params.add(0);
        if (this.p_M_Product_ID > 0) {
            productWhereClause.append(" AND ").append("M_Product_ID").append("=?");
            params.add(this.p_M_Product_ID);
        } else if (this.p_M_Product_Category_ID > 0) {
            productWhereClause.append(" AND ").append("M_Product_Category_ID").append("=?");
            params.add(this.p_M_Product_Category_ID);
        }
        String sql = "UPDATE M_Cost c SET CurrentCostPriceLL=0 WHERE EXISTS (SELECT 1 FROM M_Product p WHERE p.M_Product_ID=c.M_Product_ID AND " + productWhereClause + ")";
        int no = DB.executeUpdateEx(sql, params.toArray(), this.get_TrxName());
        this.log.info("Updated #" + no);
    }

    private Collection<MCostElement> getCostElements() {
        if (this.m_costElements == null) {
            this.m_costElements = MCostElement.getCostElement(this.getCtx(), this.get_TrxName());
        }
        return this.m_costElements;
    }

    private void createNotice(MProduct product, String msg) {
        String productValue = product != null ? product.getValue() : "-";
        this.addLog("WARNING: Product " + productValue + ": " + msg);
    }
}

