/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.NoVendorForProductException;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrg;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPO;
import org.compiere.model.MQuery;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MStorage;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.model.PrintInfo;
import org.compiere.model.Query;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportCtl;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.wf.MWorkflow;
import org.eevolution.engine.warehouse.WMRuleEngine;
import org.eevolution.exceptions.NoBPartnerLinkedforOrgException;
import org.eevolution.exceptions.NoPlantForWarehouseException;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MDDOrderLine;
import org.eevolution.model.MPPMRP;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductPlanning;
import org.eevolution.model.MWMInOutBound;
import org.eevolution.model.MWMInOutBoundLine;

public class ReleaseInOutBound
extends SvrProcess {
    protected int p_Record_ID = 0;
    protected int p_M_Locator_ID = 0;
    protected String p_DocAction = null;
    protected String p_DeliveryRule = null;
    protected int p_C_DocType_ID = 0;
    protected int p_WM_Area_Type_ID = 0;
    protected int p_WM_Section_Type_ID = 0;
    protected boolean p_IsPrintPickList = false;
    protected boolean p_IsCreateSupply = false;
    private MLocator m_locator = null;
    private int AD_User_ID = 0;
    private Timestamp Today = new Timestamp(System.currentTimeMillis());
    private MDDOrder order = null;

    @Override
    protected void prepare() {
        this.AD_User_ID = Env.getAD_User_ID(this.getCtx());
        this.p_Record_ID = this.getRecord_ID();
        for (ProcessInfoParameter processInfoParameter : this.getParameter()) {
            String string = processInfoParameter.getParameterName();
            if (processInfoParameter.getParameter() == null) continue;
            if (string.equals("WM_Area_Type_ID")) {
                this.p_WM_Area_Type_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            if (string.equals("WM_Section_Type_ID")) {
                this.p_WM_Section_Type_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            if (string.equals("DeliveryRule")) {
                this.p_DeliveryRule = (String)processInfoParameter.getParameter();
                continue;
            }
            if (string.equals("DocAction")) {
                this.p_DocAction = (String)processInfoParameter.getParameter();
                continue;
            }
            if (string.equals("C_DocType_ID")) {
                this.p_C_DocType_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            if (string.equals("M_Locator_ID")) {
                this.p_M_Locator_ID = processInfoParameter.getParameterAsInt();
                this.m_locator = new MLocator(this.getCtx(), this.p_M_Locator_ID, this.get_TrxName());
                continue;
            }
            if (string.equals("IsPrintPickList")) {
                this.p_IsPrintPickList = "Y".equals(processInfoParameter.getParameter());
                continue;
            }
            if (string.equals("IsCreateSupply")) {
                this.p_IsCreateSupply = "Y".equals(processInfoParameter.getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + string);
        }
    }

    @Override
    protected String doIt() throws Exception {
        String string = "EXISTS (SELECT T_Selection_ID FROM T_Selection WHERE  T_Selection.AD_PInstance_ID=? AND T_Selection.T_Selection_ID=WM_InOutBoundLine.WM_InOutboundLine_ID)";
        List list = new Query(this.getCtx(), "WM_InOutBoundLine", string, this.get_TrxName()).setClient_ID().setParameters(this.getAD_PInstance_ID()).list();
        int n = 10;
        for (MWMInOutBoundLine mWMInOutBoundLine : list) {
            MWMInOutBound mWMInOutBound = mWMInOutBoundLine.getParent();
            if ("CO".equals(mWMInOutBound.getDocStatus()) || "CL".equals(mWMInOutBound.getDocStatus()) || "VO".equals(mWMInOutBound.getDocStatus()) || mWMInOutBoundLine.isProcessed()) continue;
            BigDecimal bigDecimal = this.createDDOrder(mWMInOutBoundLine);
            if (this.p_IsCreateSupply && bigDecimal.signum() > 0) {
                Env.setContext(mWMInOutBoundLine.getCtx(), "IsCreateSupply", "Y");
                this.createSupply(mWMInOutBoundLine, bigDecimal);
            }
            ++n;
        }
        if (this.order != null && this.p_DocAction != null) {
            this.order.setDocAction(this.p_DocAction);
            this.order.setDocStatus("IP");
            this.order.completeIt();
            this.order.save();
        }
        if (this.p_IsPrintPickList && this.order != null) {
            ReportEngine reportEngine = this.getReportEngine("DistributionOrder_Header  ** TEMPLATE **", "DD_Order_Header_v", this.order.getDD_Order_ID());
            if (reportEngine == null) {
                return "";
            }
            ReportCtl.preview(reportEngine);
            reportEngine.print();
        }
        return "";
    }

    protected BigDecimal createDDOrder(MWMInOutBoundLine mWMInOutBoundLine) {
        WMRuleEngine wMRuleEngine = WMRuleEngine.get();
        Collection<MStorage> collection = wMRuleEngine.getMStorage(mWMInOutBoundLine, this.p_WM_Area_Type_ID, this.p_WM_Section_Type_ID);
        int n = 0;
        BigDecimal bigDecimal = Env.ZERO;
        if (collection != null && collection.size() > 0) {
            MWarehouse[] mWarehouseArray = MWarehouse.getInTransitForOrg(this.getCtx(), this.m_locator.getAD_Org_ID());
            if (mWarehouseArray == null || mWarehouseArray.length == 0) {
                throw new AdempiereException("Do not exist Transit Warehouse");
            }
            MOrg mOrg = MOrg.get(this.getCtx(), this.m_locator.getAD_Org_ID());
            int n2 = mOrg.getLinkedC_BPartner_ID(this.get_TrxName());
            if (n2 == 0) {
                throw new NoBPartnerLinkedforOrgException(mOrg);
            }
            MBPartner mBPartner = MBPartner.get(this.getCtx(), n2);
            if (this.order == null) {
                this.order = new MDDOrder(this.getCtx(), 0, this.get_TrxName());
                this.order.setAD_Org_ID(this.m_locator.getAD_Org_ID());
                this.order.setC_BPartner_ID(n2);
                if (this.p_C_DocType_ID > 0) {
                    this.order.setC_DocType_ID(this.p_C_DocType_ID);
                } else {
                    this.order.setC_DocType_ID(MDocType.getDocType("DOO"));
                }
                this.order.setM_Warehouse_ID(mWarehouseArray[0].get_ID());
                if (this.p_DocAction != null) {
                    this.order.setDocAction(this.p_DocAction);
                } else {
                    this.order.setDocAction("PR");
                }
                MUser[] mUserArray = MUser.getOfBPartner(this.getCtx(), mBPartner.getC_BPartner_ID(), this.get_TrxName());
                if (mUserArray == null || mUserArray.length == 0) {
                    throw new AdempiereException("Do not exist Users for this Business Partner" + mBPartner.getName());
                }
                this.order.setDateOrdered(this.getToday());
                this.order.setDatePromised(this.getToday());
                this.order.setAD_User_ID(mUserArray[0].getAD_User_ID());
                this.order.setM_Shipper_ID(n);
                this.order.setIsInDispute(false);
                this.order.setIsInTransit(false);
                this.order.setSalesRep_ID(mBPartner.getPrimaryAD_User_ID());
                this.order.saveEx();
            }
            for (MStorage mStorage : collection) {
                MDDOrderLine mDDOrderLine = new MDDOrderLine(this.order);
                mDDOrderLine.setM_Locator_ID(mStorage.getM_Locator_ID());
                mDDOrderLine.setM_LocatorTo_ID(this.p_M_Locator_ID);
                mDDOrderLine.setC_UOM_ID(mWMInOutBoundLine.getC_UOM_ID());
                mDDOrderLine.setM_Product_ID(mWMInOutBoundLine.getM_Product_ID());
                mDDOrderLine.setDateOrdered(this.getToday());
                mDDOrderLine.setDatePromised(mWMInOutBoundLine.getPickDate());
                mDDOrderLine.set_ValueOfColumn("WM_InOutBoundLine_ID", (Object)mWMInOutBoundLine.getWM_InOutBoundLine_ID());
                mDDOrderLine.setIsInvoiced(false);
                if (mWMInOutBoundLine.getQtyToPick().subtract(bigDecimal).compareTo(mStorage.getQtyOnHand()) < 0) {
                    mDDOrderLine.setConfirmedQty(mWMInOutBoundLine.getQtyToPick());
                    mDDOrderLine.setQtyEntered(mWMInOutBoundLine.getQtyToPick());
                    mDDOrderLine.setQtyOrdered(mWMInOutBoundLine.getQtyToPick());
                    mDDOrderLine.setTargetQty(mWMInOutBoundLine.getQtyToPick());
                    bigDecimal = bigDecimal.add(mWMInOutBoundLine.getQtyToPick());
                } else {
                    mDDOrderLine.setConfirmedQty(mStorage.getQtyOnHand());
                    mDDOrderLine.setQtyEntered(mStorage.getQtyOnHand());
                    mDDOrderLine.setQtyOrdered(mStorage.getQtyOnHand());
                    mDDOrderLine.setTargetQty(mStorage.getQtyOnHand());
                    bigDecimal = bigDecimal.add(mStorage.getQtyOnHand());
                }
                mDDOrderLine.saveEx();
            }
        } else {
            bigDecimal = mWMInOutBoundLine.getQtyToPick().subtract(bigDecimal);
        }
        return bigDecimal;
    }

    public void createSupply(MWMInOutBoundLine mWMInOutBoundLine, BigDecimal bigDecimal) {
        MProduct mProduct = MProduct.get(mWMInOutBoundLine.getCtx(), mWMInOutBoundLine.getM_Product_ID());
        if (mProduct.isBOM()) {
            this.createMO(mWMInOutBoundLine, mProduct, bigDecimal);
        } else if (mProduct.isPurchased()) {
            this.createRequisition(mWMInOutBoundLine, mProduct, bigDecimal);
        }
    }

    public void createRequisition(MWMInOutBoundLine mWMInOutBoundLine, MProduct mProduct, BigDecimal bigDecimal) {
        MProductPO[] mProductPOArray;
        int n = 0;
        int n2 = 0;
        MProductPO mProductPO = null;
        for (MProductPO pO2 : mProductPOArray = MProductPO.getOfProduct(this.getCtx(), mProduct.getM_Product_ID(), null)) {
            if (!pO2.isCurrentVendor() || pO2.getC_BPartner_ID() == 0) continue;
            n = pO2.getC_BPartner_ID();
            mProductPO = pO2;
            break;
        }
        if (n == 0 && mProductPOArray.length > 0) {
            n = mProductPOArray[0].getC_BPartner_ID();
        }
        if (n == 0) {
            throw new NoVendorForProductException(mProduct.getName());
        }
        n2 = DB.getSQLValueEx(this.get_TrxName(), "SELECT COALESCE(bp.PO_PriceList_ID,bpg.PO_PriceList_ID) FROM C_BPartner bp INNER JOIN C_BP_Group bpg ON (bpg.C_BP_Group_ID=bp.C_BP_Group_ID) WHERE bp.C_BPartner_ID=?", n);
        MRequisition mRequisition = new MRequisition(this.getCtx(), 0, this.get_TrxName());
        mRequisition.setAD_Org_ID(this.m_locator.getAD_Org_ID());
        mRequisition.setAD_User_ID(this.AD_User_ID);
        mRequisition.setDateRequired(mWMInOutBoundLine.getPickDate());
        mRequisition.setDescription("Generate from Outbound Order");
        mRequisition.setM_Warehouse_ID(this.m_locator.getM_Warehouse_ID());
        mRequisition.setC_DocType_ID(MDocType.getDocType("POR"));
        if (n2 > 0) {
            mRequisition.setM_PriceList_ID(n2);
        }
        mRequisition.saveEx();
        MRequisitionLine mRequisitionLine = new MRequisitionLine(mRequisition);
        mRequisitionLine.setLine(10);
        mRequisitionLine.setAD_Org_ID(this.m_locator.getAD_Org_ID());
        mRequisitionLine.setC_BPartner_ID(n);
        mRequisitionLine.setM_Product_ID(mProduct.getM_Product_ID());
        mRequisitionLine.setPrice();
        mRequisitionLine.setPriceActual(Env.ZERO);
        mRequisitionLine.setQty(bigDecimal);
        mRequisitionLine.saveEx();
        MOrderLine mOrderLine = new MOrderLine(this.getCtx(), mWMInOutBoundLine.getC_OrderLine_ID(), this.get_TrxName());
        mOrderLine.setDescription(mOrderLine.getDescription() + " " + Msg.translate(this.getCtx(), "M_Requisition_ID") + " : " + mRequisition.getDocumentNo());
        mOrderLine.saveEx();
        mWMInOutBoundLine.setDescription(mWMInOutBoundLine.getDescription() + " " + Msg.translate(mWMInOutBoundLine.getCtx(), "M_Requisition_ID") + " : " + mRequisition.getDocumentNo());
    }

    public void createMO(MWMInOutBoundLine mWMInOutBoundLine, MProduct mProduct, BigDecimal bigDecimal) {
        MPPProductBOM mPPProductBOM;
        MPPOrder mPPOrder = MPPOrder.forC_OrderLine_ID(mWMInOutBoundLine.getCtx(), mWMInOutBoundLine.getC_OrderLine_ID(), mProduct.get_ID(), mWMInOutBoundLine.get_TrxName());
        if (mPPOrder == null && (mPPProductBOM = MPPProductBOM.getDefault(mProduct, this.get_TrxName())) != null) {
            MPPProductPlanning mPPProductPlanning = null;
            if (mPPProductBOM == null && (mPPProductPlanning = MPPProductPlanning.find(this.getCtx(), mWMInOutBoundLine.getAD_Org_ID(), 0, 0, mProduct.getM_Product_ID(), null)) != null) {
                mPPProductBOM = mPPProductPlanning.getPP_Product_BOM();
            }
            if (mPPProductBOM != null) {
                int n = MPPProductPlanning.getPlantForWarehouse(mWMInOutBoundLine.getM_Warehouse_ID());
                if (n <= 0) {
                    throw new NoPlantForWarehouseException(mWMInOutBoundLine.getM_Warehouse_ID());
                }
                MWorkflow mWorkflow = MWorkflow.get(this.getCtx(), MWorkflow.getWorkflowSearchKey(mProduct));
                if (mWorkflow == null && mPPProductPlanning != null) {
                    mWorkflow = mPPProductPlanning.getAD_Workflow();
                }
                if (n > 0 && mWorkflow != null) {
                    String string = Msg.translate(this.getCtx(), "WM_InOutBound_ID") + " : " + mWMInOutBoundLine.getParent().getDocumentNo();
                    mPPProductPlanning = new MPPProductPlanning(this.getCtx(), 0, this.get_TrxName());
                    mPPProductPlanning.setAD_Org_ID(mWMInOutBoundLine.getAD_Org_ID());
                    mPPProductPlanning.setM_Product_ID(mProduct.getM_Product_ID());
                    mPPProductPlanning.setPlanner_ID(mWMInOutBoundLine.getParent().getSalesRep_ID());
                    mPPProductPlanning.setPP_Product_BOM_ID(mPPProductBOM.getPP_Product_BOM_ID());
                    mPPProductPlanning.setAD_Workflow_ID(mWorkflow.getAD_Workflow_ID());
                    mPPProductPlanning.setM_Warehouse_ID(mWMInOutBoundLine.getM_Warehouse_ID());
                    mPPProductPlanning.setS_Resource_ID(n);
                    mPPOrder = MPPMRP.createMO(mPPProductPlanning, mWMInOutBoundLine.getC_OrderLine_ID(), mWMInOutBoundLine.getM_AttributeSetInstance_ID(), bigDecimal, mWMInOutBoundLine.getPickDate(), mWMInOutBoundLine.getShipDate(), string);
                    MOrderLine mOrderLine = new MOrderLine(this.getCtx(), mWMInOutBoundLine.getC_OrderLine_ID(), this.get_TrxName());
                    string = "";
                    if (mOrderLine.getDescription() != null) {
                        string = mOrderLine.getDescription();
                    }
                    string = string + " " + Msg.translate(mOrderLine.getCtx(), "PP_Order_ID") + " : " + mPPOrder.getDocumentNo();
                    mOrderLine.setDescription(string);
                    mOrderLine.saveEx();
                    String string2 = "";
                    if (mWMInOutBoundLine.getDescription() != null) {
                        string2 = mWMInOutBoundLine.getDescription();
                    }
                    string2 = string2 + " " + Msg.translate(this.getCtx(), "PP_Order_ID") + " : " + mPPOrder.getDocumentNo();
                    mWMInOutBoundLine.setDescription(string2);
                }
            }
        }
        if (mPPOrder != null) {
            mWMInOutBoundLine.setProcessed(true);
            mWMInOutBoundLine.saveEx();
        }
    }

    private ReportEngine getReportEngine(String string, String string2, int n) {
        int n2 = MPrintFormat.getPrintFormat_ID(string, MTable.getTable_ID(string2), this.getAD_Client_ID());
        MPrintFormat mPrintFormat = MPrintFormat.get(this.getCtx(), n2, true);
        if (mPrintFormat == null) {
            this.addLog("@NotFound@ @AD_PrintFormat_ID@");
            return null;
        }
        MQuery mQuery = new MQuery(string2);
        mQuery.addRestriction("DD_Order_ID", "=", n);
        PrintInfo printInfo = new PrintInfo(string2, MTable.getTable_ID(string2), n);
        ReportEngine reportEngine = new ReportEngine(this.getCtx(), mPrintFormat, mQuery, printInfo);
        return reportEngine;
    }

    protected Timestamp getToday() {
        return this.Today;
    }
}

