/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MClient;
import org.compiere.model.MInterestArea;
import org.compiere.model.MMailText;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Trx;

public class PayrollViaEMail
extends SvrProcess {
    private int mailTextId = -1;
    private MMailText mailText = null;
    private int bPartnerId = -1;
    private MClient client = null;
    private MBPartner employee = null;
    private int m_counter = 0;
    private int m_errors = 0;
    private int payrollProcessId = -1;
    private MInterestArea m_ia = null;
    private int bPartnerGroupId = -1;
    private int reportProcessId = -1;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        for (int i = 0; i < processInfoParameterArray.length; ++i) {
            String string = processInfoParameterArray[i].getParameterName();
            if (processInfoParameterArray[i].getParameter() == null) {
                this.log.fine("Null parameter: " + string);
                continue;
            }
            if (string.equals("HR_Process_ID")) {
                this.payrollProcessId = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (string.equals("R_MailText_ID")) {
                this.mailTextId = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (string.equals("C_BP_Group_ID")) {
                this.bPartnerGroupId = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (string.equals("C_BPartner_ID")) {
                this.bPartnerId = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            if (string.equals("AD_Process_ID")) {
                this.reportProcessId = processInfoParameterArray[i].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + string);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("R_MailText_ID=" + this.mailTextId);
        this.mailText = new MMailText(this.getCtx(), this.mailTextId, this.get_TrxName());
        if (this.mailText.getR_MailText_ID() == 0) {
            throw new Exception("@R_MailText_ID@=" + this.mailTextId + " @NotFound@ ");
        }
        this.client = MClient.get(this.getCtx());
        if (this.client.getAD_Client_ID() == 0) {
            throw new Exception(" @AD_Client_ID@  @NotFound@ ");
        }
        if (this.client.getSMTPHost() == null || this.client.getSMTPHost().length() == 0) {
            throw new Exception("@SMTPHost@  @NotFound@ ");
        }
        long l = System.currentTimeMillis();
        if (this.bPartnerId > 0) {
            this.employee = new MBPartner(this.getCtx(), this.bPartnerId, this.get_TrxName());
            if (this.employee == null) {
                throw new Exception("@C_BPartner_ID@=" + this.bPartnerId + " @NotFound@");
            }
            this.sendIndividualMail(this.bPartnerId, null);
        } else {
            this.sendBPGroup();
        }
        this.log.fine("From " + this.employee);
        return "@Created@=" + this.m_counter + ", @Errors@=" + this.m_errors + " - " + (System.currentTimeMillis() - l) + "ms";
    }

    private void sendBPGroup() {
        int[] nArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IsActive").append("=? AND ").append("IsEmployee").append("=? AND ").append("EXISTS (SELECT 1 FROM HR_Movement m WHERE m.C_BPartner_ID=C_BPartner.C_BPartner_ID AND m.HR_Process_ID=?)");
        arrayList.add(true);
        arrayList.add(true);
        arrayList.add(this.payrollProcessId);
        if (this.bPartnerGroupId > 0) {
            stringBuffer.append(" AND ").append("C_BP_Group_ID").append("=? ");
            arrayList.add(this.bPartnerGroupId);
        }
        int[] nArray2 = nArray = new Query(this.getCtx(), "C_BPartner", stringBuffer.toString(), this.get_TrxName()).setClient_ID().setParameters(arrayList).getIDs();
        int n = nArray2.length;
        for (int i = 0; i < n; ++i) {
            Integer n2 = nArray2[i];
            Boolean bl = this.sendIndividualMail(n2, null);
            if (bl == null) continue;
            if (bl.booleanValue()) {
                ++this.m_counter;
                continue;
            }
            ++this.m_errors;
        }
    }

    private Boolean sendIndividualMail(int n, String string) {
        try {
            MBPartner mBPartner = new MBPartner(this.getCtx(), n, null);
            String string2 = this.mailText.getMailText(true);
            if (string != null) {
                string2 = string2 + string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("C_BPartner_ID").append(" = ? AND ").append("ContactType").append("=?");
            MBPartnerLocation mBPartnerLocation = (MBPartnerLocation)new Query(this.getCtx(), "C_BPartner_Location", stringBuffer.toString(), this.get_TrxName()).setOnlyActiveRecords(true).setParameters(n, "Primary").first();
            if (mBPartnerLocation == null) {
                this.addLog(0, null, null, mBPartner.getName() + " @Email@ @NotFound@");
                return false;
            }
            MClient mClient = MClient.get(this.getCtx());
            String string3 = mClient.getSMTPHost();
            String string4 = mClient.getRequestEMail();
            String string5 = mBPartnerLocation.get_ValueAsString("EMail");
            String string6 = mClient.getRequestUser();
            String string7 = mClient.getRequestUserPW();
            EMail eMail = new EMail(this.getCtx(), string3, string4, string5, this.mailText.getMailHeader(), string2);
            if (this.mailText.isHtml()) {
                eMail.setMessageHTML(this.mailText.getMailHeader(), string2);
            } else {
                eMail.setSubject(this.mailText.getMailHeader());
                eMail.setMessageText(string2);
            }
            eMail.addAttachment(this.CreatePDF(n));
            if (!eMail.isValid() && !eMail.isValid(true)) {
                this.log.warning("NOT VALID - " + eMail);
                mBPartner.setIsActive(false);
                mBPartner.save();
                return Boolean.FALSE;
            }
            eMail.createAuthenticator(string6, string7);
            boolean bl = "OK".equals(eMail.send());
            if (bl) {
                this.addLog(0, null, null, mBPartner.getName() + " @Email@ @OK@");
                this.log.fine(mBPartner.getURL());
            } else {
                this.log.warning("FAILURE - " + mBPartner.getURL());
            }
            this.addLog(0, null, null, (bl ? "@OK@" : "@ERROR@") + " - " + string5);
            return bl;
        }
        catch (Exception exception) {
            return Boolean.FALSE;
        }
    }

    private File CreatePDF(int n) {
        File file = null;
        int n2 = this.reportProcessId;
        MPInstance mPInstance = new MPInstance(Env.getCtx(), n2, n);
        mPInstance.saveEx();
        ProcessInfo processInfo = new ProcessInfo("PH_SendEmail", n2);
        processInfo.setAD_PInstance_ID(mPInstance.getAD_PInstance_ID());
        MPInstancePara mPInstancePara = new MPInstancePara(mPInstance, 10);
        mPInstancePara.setParameter("HR_Process_ID", this.payrollProcessId);
        mPInstancePara.saveEx();
        processInfo.setRecord_ID(n);
        processInfo.setIsBatch(true);
        MProcess mProcess = new MProcess(this.getCtx(), n2, this.get_TrxName());
        mProcess.processIt(processInfo, Trx.get(this.get_TrxName(), true));
        file = processInfo.getPDFReport();
        return file;
    }
}

