/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.compiere.model.MForecastLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRequisition;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.eevolution.form.Browser;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MDDOrderLine;
import org.eevolution.model.MPPMRP;
import org.eevolution.model.MPPOrder;

public class MRPSchedule
extends SvrProcess {
    protected Integer p_Planner_ID = null;
    protected String p_Priority = null;
    protected Integer p_Line = null;
    protected LinkedHashMap<Integer, LinkedHashMap<String, Object>> m_values = null;
    protected List<MPPMRP> m_records = null;
    protected String DEMAND = "DEMAND";
    protected String SUPPLY = "SUPPLY";
    protected int processRecords = 0;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter para : this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if (name.equals("Planner_ID")) {
                this.p_Planner_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("Priority")) {
                this.p_Priority = (String)para.getParameter();
                continue;
            }
            if (name.equals("Line")) {
                this.p_Line = para.getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.setColumnsValues();
    }

    @Override
    protected String doIt() throws Exception {
        for (MPPMRP mrp : this.getRecords()) {
            if ("D".equals(mrp.getTypeMRP())) {
                this.saveBrowseValues(mrp, this.DEMAND);
            } else if ("S".equals(mrp.getTypeMRP())) {
                this.saveBrowseValues(mrp, this.SUPPLY);
            }
            if (this.p_Priority != null) {
                mrp.setPriority(this.p_Priority);
            }
            if (this.p_Planner_ID != null) {
                mrp.setPlanner_ID(this.p_Planner_ID);
            }
            this.schedule(mrp);
        }
        return "@DocProcessed@ " + this.processRecords;
    }

    private void schedule(MPPMRP mrp) {
        MOrderLine orderLine;
        if (!mrp.is_Changed()) {
            return;
        }
        ++this.processRecords;
        if ("FCT".equals(mrp.getOrderType())) {
            MForecastLine forecastLine = (MForecastLine)mrp.getM_ForecastLine();
            if (forecastLine != null) {
                forecastLine.setDatePromised(mrp.getDatePromised());
                forecastLine.setSalesRep_ID(mrp.getPlanner_ID());
                forecastLine.saveEx();
            }
        } else if ("POR".equals(mrp.getOrderType())) {
            MRequisition requisition = (MRequisition)mrp.getM_Requisition();
            if (requisition != null) {
                requisition.setDateDoc(mrp.getDateStartSchedule());
                requisition.setDateRequired(mrp.getDatePromised());
                requisition.setAD_User_ID(mrp.getPlanner_ID());
                requisition.setPriorityRule(mrp.getPriority());
                requisition.saveEx();
            }
        } else if ("MOP".equals(mrp.getOrderType())) {
            MPPOrder order = (MPPOrder)mrp.getPP_Order();
            if (order != null) {
                order.setDateStartSchedule(mrp.getDateStartSchedule());
                order.setDateFinishSchedule(mrp.getDateFinishSchedule());
                order.setDatePromised(mrp.getDatePromised());
                order.setPlanner_ID(mrp.getPlanner_ID());
                if (mrp.getPriority() != null) {
                    order.setPriorityRule(mrp.getPriority());
                }
                order.setLine(this.p_Line);
                order.saveEx();
            }
        } else if ("DOO".equals(mrp.getOrderType())) {
            MDDOrderLine orderLine2 = (MDDOrderLine)mrp.getDD_OrderLine();
            if (orderLine2 != null) {
                orderLine2.setDateOrdered(mrp.getDateStartSchedule());
                orderLine2.setDatePromised(mrp.getDatePromised());
                orderLine2.saveEx();
                MDDOrder order = orderLine2.getParent();
                order.setSalesRep_ID(mrp.getPlanner_ID());
                order.setPriorityRule(mrp.getPriority());
                order.saveEx();
            }
        } else if ("SOO".equals(mrp.getOrderType())) {
            MOrderLine orderLine3 = (MOrderLine)mrp.getC_OrderLine();
            if (orderLine3 != null) {
                orderLine3.setDateOrdered(mrp.getDateStartSchedule());
                orderLine3.setDatePromised(mrp.getDatePromised());
                orderLine3.saveEx();
                MOrder order = orderLine3.getParent();
                order.setSalesRep_ID(mrp.getPlanner_ID());
                order.setPriorityRule(mrp.getPriority());
                order.saveEx();
            }
        } else if ("POO".equals(mrp.getOrderType()) && (orderLine = (MOrderLine)mrp.getC_OrderLine()) != null) {
            orderLine.setDateOrdered(mrp.getDateStartSchedule());
            orderLine.setDatePromised(mrp.getDatePromised());
            orderLine.saveEx();
            MOrder order = orderLine.getParent();
            order.setSalesRep_ID(mrp.getPlanner_ID());
            order.setPriorityRule(mrp.getPriority());
            order.saveEx();
        }
    }

    private void saveBrowseValues(PO po, String alias) {
        LinkedHashMap<String, Object> values = this.m_values.get(po.get_ID());
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String columnName = entry.getKey();
            if (!columnName.contains(alias.toUpperCase() + "_")) continue;
            columnName = columnName.substring(columnName.indexOf("_") + 1);
            po.set_ValueOfColumn(columnName, entry.getValue());
        }
    }

    private List<MPPMRP> getRecords() {
        if (this.m_records != null) {
            return this.m_records;
        }
        String whereClause = "EXISTS (SELECT T_Selection_ID FROM T_Selection WHERE  T_Selection.AD_PInstance_ID=? AND T_Selection.T_Selection_ID=PP_MRP.PP_MRP_ID)";
        this.m_records = new Query(this.getCtx(), "PP_MRP", whereClause, this.get_TrxName()).setClient_ID().setParameters(this.getAD_PInstance_ID()).list();
        return this.m_records;
    }

    private LinkedHashMap<Integer, LinkedHashMap<String, Object>> setColumnsValues() {
        if (this.m_values != null) {
            return this.m_values;
        }
        this.m_values = new LinkedHashMap();
        for (MPPMRP record : this.getRecords()) {
            this.m_values.put(record.get_ID(), Browser.getBrowseValues(this.getAD_PInstance_ID(), null, record.get_ID(), null));
        }
        return this.m_values;
    }
}

