/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MLocator;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.form.Browser;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MDDOrderLine;
import org.eevolution.model.MPPMRP;
import org.eevolution.model.MPPOrder;

public class MRPApproval
extends SvrProcess {
    protected int Record_ID;
    protected String p_OrderType = null;
    protected String p_Priority = null;
    protected int p_C_BPartner_ID = 0;
    protected String p_ReferenceNo = null;
    protected int p_S_Resource_ID = 0;
    protected int p_AD_Workflow_ID = 0;
    protected int p_PP_Product_BOM_ID = 0;
    protected int p_M_Shipper_ID = 0;
    protected int p_M_Warehouse_ID = 0;
    protected int p_M_Locator_ID = 0;
    protected int p_M_LocatorTo_ID = 0;
    protected String EXECUTION_MODE = "MOP";
    protected LinkedHashMap<Integer, LinkedHashMap<String, Object>> m_values = null;
    protected List<MPPMRP> m_records = null;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter para : this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if (name.equals("OrderType")) {
                this.p_OrderType = (String)para.getParameter();
                continue;
            }
            if (name.equals("PriorityRule")) {
                this.p_Priority = (String)para.getParameter();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("PP_Product_BOM_ID")) {
                this.p_PP_Product_BOM_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("AD_Workflow_ID")) {
                this.p_AD_Workflow_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("M_Shipper_ID")) {
                this.p_M_Shipper_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("ReferenceNo")) {
                this.p_ReferenceNo = (String)para.getParameter();
                continue;
            }
            if (name.equals("M_Warehouse_ID")) {
                this.p_M_Warehouse_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("M_Locator_ID")) {
                this.p_M_Locator_ID = para.getParameterAsInt();
                continue;
            }
            if (name.equals("M_LocatorTo_ID")) {
                this.p_M_LocatorTo_ID = para.getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.Record_ID = this.getRecord_ID();
        int AD_Process_ID = this.getProcessInfo().getAD_Process_ID();
        if (AD_Process_ID == 53322) {
            this.EXECUTION_MODE = "MOP";
        }
        if (AD_Process_ID == 53323) {
            this.EXECUTION_MODE = "DOO";
        }
        if (AD_Process_ID == 53321) {
            this.EXECUTION_MODE = "POR";
        }
        this.setColumnsValues();
    }

    @Override
    protected String doIt() throws Exception {
        for (MPPMRP mrp : this.getMRPRecords()) {
            this.saveBrowseValues(mrp, "MRP");
            if (this.p_Priority != null) {
                mrp.setPriority(this.p_Priority);
            }
            if (this.p_OrderType != null && !mrp.getOrderType().equals(this.p_OrderType)) {
                this.createSupply(mrp, this.p_OrderType);
                continue;
            }
            if (this.EXECUTION_MODE.equals("MOP")) {
                this.executeManufacturingOrderApproval(mrp);
            }
            if (this.EXECUTION_MODE.equals("DOO")) {
                this.executeDistributionOrderApproval(mrp);
            }
            if (!this.EXECUTION_MODE.equals("POR")) continue;
            if (this.p_C_BPartner_ID > 0) {
                mrp.setC_BPartner_ID(this.p_C_BPartner_ID);
            }
            this.executeRequisitionApproval(mrp);
        }
        return null;
    }

    private void createSupply(MPPMRP mrp, String orderType) {
        PO order;
        if ("POR".equals(orderType)) {
            if (this.p_C_BPartner_ID <= 0) {
                throw new AdempiereException("@BPartnerNotFound@");
            }
            this.createRequisition(mrp);
        }
        if ("MOP".equals(orderType) && this.p_S_Resource_ID > 0 && this.p_PP_Product_BOM_ID > 0 && this.p_AD_Workflow_ID > 0) {
            this.createManufacturingOrder(mrp);
        }
        if ("DOO".equals(orderType) && this.p_M_Warehouse_ID > 0 && this.p_M_Shipper_ID > 0 && this.p_M_Locator_ID > 0 && this.p_M_LocatorTo_ID > 0 && this.p_C_BPartner_ID > 0) {
            this.createDistributionOrder(mrp);
        }
        if ("POR".equals(mrp.getOrderType())) {
            MRequisition requisition = (MRequisition)mrp.getM_Requisition();
            requisition.deleteEx(true);
        }
        if ("MOP".equals(mrp.getOrderType())) {
            order = (MPPOrder)mrp.getPP_Order();
            order.deleteEx(true);
        }
        if ("DOO".equals(mrp.getOrderType())) {
            order = (MDDOrder)mrp.getDD_Order();
            order.deleteEx(true);
        }
    }

    private void createDistributionOrder(MPPMRP mrp) {
        MLocator locator = MLocator.get(mrp.getCtx(), this.p_M_Locator_ID);
        MLocator locator_to = MLocator.get(mrp.getCtx(), this.p_M_LocatorTo_ID);
        int docTypeDO_ID = MPPMRP.getDocType(this.getCtx(), "DOO", locator_to.getAD_Org_ID(), Env.getAD_User_ID(this.getCtx()), this.get_TrxName());
        MBPartner bp = MBPartner.get(mrp.getCtx(), this.p_C_BPartner_ID);
        MDDOrder order = new MDDOrder(this.getCtx(), 0, this.get_TrxName());
        order.setAD_Org_ID(mrp.getAD_Org_ID());
        order.addDescription("Generated by MRP");
        order.setC_BPartner_ID(this.p_C_BPartner_ID);
        order.setAD_User_ID(bp.getPrimaryAD_User_ID());
        order.setC_DocType_ID(docTypeDO_ID);
        order.setM_Warehouse_ID(this.p_M_Warehouse_ID);
        if (this.p_ReferenceNo != null) {
            order.setPOReference(this.p_ReferenceNo);
        }
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.setDateOrdered(mrp.getDateFinishSchedule());
        order.setDatePromised(mrp.getDatePromised());
        order.setM_Shipper_ID(this.p_M_Shipper_ID);
        if (this.p_Priority != null) {
            order.setPriorityRule(this.p_Priority);
        }
        order.setIsInDispute(false);
        order.setIsInTransit(false);
        order.setSalesRep_ID(mrp.getPlanner_ID());
        order.saveEx();
        MDDOrderLine oline = new MDDOrderLine(this.getCtx(), 0, this.get_TrxName());
        oline.setDD_Order_ID(order.getDD_Order_ID());
        oline.setAD_Org_ID(locator_to.getAD_Org_ID());
        oline.setM_Locator_ID(locator.getM_Locator_ID());
        oline.setM_LocatorTo_ID(locator_to.getM_Locator_ID());
        oline.setM_Product_ID(mrp.getM_Product_ID());
        oline.setDateOrdered(order.getDateOrdered());
        oline.setDatePromised(mrp.getDatePromised());
        oline.setQtyEntered((BigDecimal)this.getBrowseRowValue("MRP", "Qty", mrp.getPP_MRP_ID()));
        oline.setQtyOrdered((BigDecimal)this.getBrowseRowValue("MRP", "Qty", mrp.getPP_MRP_ID()));
        oline.setConfirmedQty((BigDecimal)this.getBrowseRowValue("DL", "ConfirmedQty", mrp.getPP_MRP_ID()));
        oline.setTargetQty(MPPMRP.getQtyReserved(this.getCtx(), locator_to.getM_Warehouse_ID(), mrp.getM_Product_ID(), mrp.getDateStartSchedule(), this.get_TrxName()));
        oline.setIsInvoiced(false);
        oline.saveEx();
        order.processIt("PR");
        order.saveEx();
    }

    private void createRequisition(MPPMRP mrp) {
        if ("MOP".equals(mrp.getOrderType())) {
            int docTypeReq_ID = MPPMRP.getDocType(this.getCtx(), "POR", mrp.getAD_Org_ID(), Env.getAD_User_ID(this.getCtx()), this.get_TrxName());
            int M_PriceList_ID = -1;
            String sql = "SELECT COALESCE(bp.PO_PriceList_ID,bpg.PO_PriceList_ID) FROM C_BPartner bp INNER JOIN C_BP_Group bpg ON (bpg.C_BP_Group_ID=bp.C_BP_Group_ID) WHERE bp.C_BPartner_ID=?";
            M_PriceList_ID = DB.getSQLValueEx(this.get_TrxName(), "SELECT COALESCE(bp.PO_PriceList_ID,bpg.PO_PriceList_ID) FROM C_BPartner bp INNER JOIN C_BP_Group bpg ON (bpg.C_BP_Group_ID=bp.C_BP_Group_ID) WHERE bp.C_BPartner_ID=?", this.p_C_BPartner_ID);
            MRequisition requisition = new MRequisition(this.getCtx(), 0, this.get_TrxName());
            requisition.setAD_Org_ID(mrp.getAD_Org_ID());
            requisition.setAD_User_ID(mrp.getPlanner_ID());
            requisition.setDateDoc(mrp.getDateStartSchedule());
            requisition.setDateRequired(mrp.getDatePromised());
            requisition.setM_Warehouse_ID(mrp.getM_Warehouse_ID());
            requisition.setC_DocType_ID(docTypeReq_ID);
            if (M_PriceList_ID > 0) {
                requisition.setM_PriceList_ID(M_PriceList_ID);
            }
            requisition.saveEx();
            MRequisitionLine requisitionLine = new MRequisitionLine(requisition);
            requisitionLine.setLine(10);
            requisitionLine.setAD_Org_ID(mrp.getAD_Org_ID());
            requisitionLine.setC_BPartner_ID(mrp.getC_BPartner_ID());
            requisitionLine.setM_Product_ID(mrp.getM_Product_ID());
            requisitionLine.setPrice();
            if (this.p_ReferenceNo != null) {
                requisitionLine.setDescription(this.p_ReferenceNo);
            }
            requisitionLine.setPriceActual(Env.ZERO);
            requisitionLine.setQty(mrp.getQty());
            requisitionLine.saveEx();
            requisition.processIt("PR");
            requisition.saveEx();
        }
    }

    private void createManufacturingOrder(MPPMRP mrp) {
        int docTypeMO_ID = MPPMRP.getDocType(this.getCtx(), "MOP", mrp.getAD_Org_ID(), mrp.getPlanner_ID(), this.get_TrxName());
        MPPOrder order = new MPPOrder(this.getCtx(), 0, this.get_TrxName());
        if (this.p_ReferenceNo != null) {
            order.addDescription(this.p_ReferenceNo);
        }
        order.setAD_Org_ID(mrp.getAD_Org_ID());
        order.setLine(10);
        order.setC_DocTypeTarget_ID(docTypeMO_ID);
        order.setC_DocType_ID(docTypeMO_ID);
        if (this.p_Priority != null) {
            order.setPriorityRule(this.p_Priority);
        }
        order.setS_Resource_ID(this.p_S_Resource_ID);
        order.setM_Warehouse_ID(mrp.getM_Warehouse_ID());
        order.setM_Product_ID(mrp.getM_Product_ID());
        order.setM_AttributeSetInstance_ID(0);
        order.setPP_Product_BOM_ID(this.p_PP_Product_BOM_ID);
        order.setAD_Workflow_ID(this.p_AD_Workflow_ID);
        order.setPlanner_ID(mrp.getPlanner_ID());
        order.setDateOrdered(mrp.getDateOrdered());
        order.setDatePromised(mrp.getDatePromised());
        order.setDateStartSchedule(mrp.getDateStartSchedule());
        order.setDateFinishSchedule(mrp.getDateFinishSchedule());
        order.setQty((BigDecimal)this.getBrowseRowValue("MRP", "Qty", mrp.getPP_MRP_ID()));
        order.setC_UOM_ID(mrp.getM_Product().getC_UOM_ID());
        order.setYield(Env.ZERO);
        order.setScheduleType("D");
        order.setPriorityRule("5");
        order.setDocAction("CO");
        order.saveEx();
        order.processIt("PR");
        order.saveEx();
    }

    private void executeRequisitionApproval(MPPMRP mrp) {
        MRequisition requisition = (MRequisition)mrp.getM_Requisition();
        Timestamp dateRequired = (Timestamp)this.getBrowseRowValue("R", "DateRequired", mrp.getPP_MRP_ID());
        if (dateRequired != null) {
            requisition.setDateRequired(dateRequired);
        }
        if (mrp.is_Changed()) {
            // empty if block
        }
        this.validateChanges(mrp, "Priority", requisition, "PriorityRule");
        requisition.saveEx();
        MRequisitionLine requisitionLine = (MRequisitionLine)mrp.getM_RequisitionLine();
        this.validateChanges(mrp, "C_BPartner_ID", requisitionLine, "C_BPartner_ID");
        this.validateChanges(mrp, "Qty", requisitionLine, "Qty");
        requisitionLine.saveEx();
        requisition.processIt("PR");
        requisition.saveEx();
    }

    private void executeDistributionOrderApproval(MPPMRP mrp) {
        MDDOrder order = (MDDOrder)mrp.getDD_Order();
        if (mrp.is_Changed()) {
            this.validateChanges(mrp, "Priority", order, "PriorityRule");
            order.saveEx();
            MDDOrderLine orderLine = (MDDOrderLine)mrp.getDD_OrderLine();
            orderLine.setQty((BigDecimal)this.getBrowseRowValue("MRP", "Qty", mrp.getPP_MRP_ID()));
            Timestamp datePromised = (Timestamp)this.getBrowseRowValue("MRP", "DatePromised", mrp.getPP_MRP_ID());
            if (datePromised != null) {
                orderLine.setDatePromised(datePromised);
            }
            orderLine.saveEx();
        }
        if (this.p_M_Shipper_ID > 0) {
            order.setM_Shipper_ID(this.p_M_Shipper_ID);
        }
        order.processIt("PR");
        order.saveEx();
    }

    private void executeManufacturingOrderApproval(MPPMRP mrp) {
        boolean createMO = false;
        if (this.p_PP_Product_BOM_ID > 0) {
            createMO = true;
        }
        if (this.p_AD_Workflow_ID > 0) {
            createMO = true;
        }
        MPPOrder currentOrder = (MPPOrder)mrp.getPP_Order();
        if (createMO) {
            MPPOrder newOrder = new MPPOrder(mrp.getCtx(), 0, this.get_TrxName());
            MPPOrder.copyValues(currentOrder, newOrder);
            if (this.p_PP_Product_BOM_ID > 0) {
                newOrder.setPP_Product_BOM_ID(this.p_PP_Product_BOM_ID);
            }
            if (this.p_AD_Workflow_ID > 0) {
                newOrder.setAD_Workflow_ID(this.p_AD_Workflow_ID);
            }
            newOrder.saveEx();
            currentOrder.deleteEx(true);
            currentOrder = newOrder;
        }
        if (mrp.is_Changed()) {
            this.validateChanges(mrp, "Priority", currentOrder, "PriorityRule");
            this.validateChanges(mrp, "DateStartSchedule", currentOrder, "DateStartSchedule");
            this.validateChanges(mrp, "DatePromised", currentOrder, "DatePromised");
            currentOrder.setQty((BigDecimal)this.getBrowseRowValue("MRP", "Qty", mrp.getPP_MRP_ID()));
            currentOrder.saveEx();
        }
        currentOrder.processIt("PR");
        currentOrder.saveEx();
    }

    private void saveBrowseValues(PO po, String alias) {
        LinkedHashMap<String, Object> values = this.m_values.get(po.get_ID());
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String columnName = entry.getKey();
            if (!columnName.contains(alias.toUpperCase() + "_")) continue;
            columnName = columnName.substring(columnName.indexOf("_") + 1);
            po.set_ValueOfColumn(columnName, entry.getValue());
        }
    }

    private Object getBrowseRowValue(String alias, String columnName, int recordId) {
        LinkedHashMap<String, Object> values = this.m_values.get(recordId);
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            if (!entry.getKey().contains(alias.toUpperCase() + "_" + columnName)) continue;
            return entry.getValue();
        }
        return null;
    }

    private void validateChanges(MPPMRP mrp, String columnSource, PO po, String columnTarget) {
        if (mrp.is_ValueChanged(columnSource)) {
            po.set_ValueOfColumn(columnTarget, mrp.get_Value(columnSource));
        }
    }

    private List<MPPMRP> getMRPRecords() {
        if (this.m_records != null) {
            return this.m_records;
        }
        String whereClause = "EXISTS (SELECT T_Selection_ID FROM T_Selection WHERE  T_Selection.AD_PInstance_ID=? AND T_Selection.T_Selection_ID=PP_MRP.PP_MRP_ID)";
        this.m_records = new Query(this.getCtx(), "PP_MRP", whereClause, this.get_TrxName()).setClient_ID().setParameters(this.getAD_PInstance_ID()).list();
        return this.m_records;
    }

    private LinkedHashMap<Integer, LinkedHashMap<String, Object>> setColumnsValues() {
        if (this.m_values != null) {
            return this.m_values;
        }
        this.m_values = new LinkedHashMap();
        for (MPPMRP record : this.getMRPRecords()) {
            this.m_values.put(record.get_ID(), Browser.getBrowseValues(this.getAD_PInstance_ID(), null, record.get_ID(), null));
        }
        return this.m_values;
    }
}

