/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.util.List;
import java.util.logging.Level;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Msg;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodeNext;
import org.compiere.wf.MWorkflow;
import org.eevolution.model.X_I_Workflow;

public class ImportWorkflow
extends SvrProcess {
    private boolean m_DeleteOldImported = false;
    private boolean m_IsImportOnlyNoErrors = true;
    private int imported = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] parameters;
        for (ProcessInfoParameter para : parameters = this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if (name.equals("IsImportOnlyNoErrors")) {
                this.m_IsImportOnlyNoErrors = "Y".equals(para.getParameter());
                continue;
            }
            if (name.equals("DeleteOldImported")) {
                this.m_DeleteOldImported = "Y".equals(para.getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.m_DeleteOldImported) {
            int no = 0;
            for (X_I_Workflow importWorkflow : this.getRecords(true, false)) {
                importWorkflow.deleteEx(true);
                ++no;
            }
            this.log.fine("Delete Old Impored =" + no);
        }
        this.fillIDValues();
        this.importRecords();
        return "Imported: " + this.imported;
    }

    public void fillIDValues() {
        for (X_I_Workflow importWorkflow : this.getRecords(false, false)) {
            int S_Resource_ID;
            int AD_Org_ID = this.getID("AD_Org", "Value = ?", new Object[]{importWorkflow.getOrgValue()});
            if (AD_Org_ID > 0) {
                importWorkflow.setAD_Org_ID(AD_Org_ID);
            }
            if ((S_Resource_ID = this.getID("S_Resource", "Value=?", new Object[]{importWorkflow.getResourceValue()})) > 0) {
                importWorkflow.setS_Resource_ID(S_Resource_ID);
            }
            String errorMsg = "";
            if ("M".equals(importWorkflow.getWorkflowType()) && importWorkflow.getS_Resource_ID() <= 0) {
                errorMsg = errorMsg + "@S_Resource_ID@ @NotFound@, ";
            }
            if (importWorkflow.getDocumentNo() == null) {
                errorMsg = errorMsg + "@DocumentNo@ @NotFound@, ";
            }
            if (importWorkflow.getName() == null) {
                errorMsg = errorMsg + "@Name@ @NotFound@, ";
            }
            if (importWorkflow.getAccessLevel() == null) {
                errorMsg = errorMsg + "@AccessLevel@ @NotFound@, ";
            }
            if (importWorkflow.getAuthor() == null) {
                errorMsg = errorMsg + "@Author@ @NotFound@, ";
            }
            if (importWorkflow.getAuthor() == null) {
                errorMsg = errorMsg + "@Author@ @NotFound@, ";
            }
            if (importWorkflow.getEntityType() == null) {
                errorMsg = errorMsg + "@EntityType@ @NotFound@, ";
            }
            if (importWorkflow.getPublishStatus() == null) {
                errorMsg = errorMsg + "@PublishStatus@ @NotFound@, ";
            }
            if (importWorkflow.getValue() == null) {
                errorMsg = errorMsg + "@Value@ @NotFound@, ";
            }
            if (importWorkflow.getVersion() <= 0) {
                errorMsg = errorMsg + "@Version@ @NotFound@, ";
            }
            if (importWorkflow.getWorkflowType() == null) {
                errorMsg = errorMsg + "@WorkflowType@ @NotFound@, ";
            }
            if (importWorkflow.getDurationUnit() == null) {
                errorMsg = errorMsg + "@DurationUnit@ @NotFound@, ";
            }
            if (errorMsg != null && errorMsg.length() > 0) {
                importWorkflow.setI_ErrorMsg(Msg.parseTranslation(this.getCtx(), errorMsg));
            }
            importWorkflow.saveEx();
        }
    }

    public void importRecords() {
        MWFNode node;
        List<X_I_Workflow> iworkflows = this.getRecords(false, this.m_IsImportOnlyNoErrors);
        for (X_I_Workflow importWorkflow : iworkflows) {
            node = null;
            MWorkflow workflow = this.getWorkflow(importWorkflow);
            if (workflow != null) {
                node = this.getWorkflowNode(importWorkflow, workflow);
            }
            if (node != null) {
                if (workflow.getAD_WF_Node_ID() <= 0) {
                    workflow.setAD_WF_Node_ID(node.get_ID());
                    workflow.saveEx();
                }
                importWorkflow.setAD_WF_Node_ID(node.get_ID());
                importWorkflow.setAD_Workflow_ID(workflow.get_ID());
                ++this.imported;
            }
            importWorkflow.setI_IsImported(true);
            importWorkflow.setProcessed(true);
            importWorkflow.saveEx();
        }
        for (X_I_Workflow importWorkflow : iworkflows) {
            int node_id;
            node = (MWFNode)importWorkflow.getAD_WF_Node();
            if (node == null || (node_id = this.getID("AD_WF_Node", "AD_Workflow_ID= ? AND Value=?", new Object[]{importWorkflow.getAD_Workflow_ID(), importWorkflow.getNodeNextValue()})) <= 0) continue;
            MWFNode next = new MWFNode(this.getCtx(), node_id, this.get_TrxName());
            this.createTransition(node, next);
        }
    }

    public MWorkflow getWorkflow(X_I_Workflow iWf) {
        MWorkflow workflow = (MWorkflow)new Query(this.getCtx(), "AD_Workflow", "Value=? AND Name=?", this.get_TrxName()).setClient_ID().setParameters(iWf.getValue(), iWf.getName()).firstOnly();
        if (workflow == null) {
            workflow = new MWorkflow(this.getCtx(), 0, this.get_TrxName());
            workflow.setValue(iWf.getValue());
            workflow.setName(iWf.getName());
        }
        workflow.setIsBetaFunctionality(iWf.isBetaFunctionality());
        workflow.setWorkflowType(iWf.getWorkflowType());
        workflow.setAccessLevel(iWf.getAccessLevel());
        workflow.setValidFrom(iWf.getValidFrom());
        workflow.setValidTo(iWf.getValidTo());
        workflow.setPublishStatus(iWf.getPublishStatus());
        workflow.setVersion(iWf.getVersion());
        workflow.setAuthor(iWf.getAuthor());
        workflow.setIsDefault(iWf.isDefault());
        workflow.setAD_WorkflowProcessor_ID(iWf.getAD_WorkflowProcessor_ID());
        workflow.setDurationUnit(iWf.getDurationUnit());
        workflow.setAD_Table_ID(iWf.getAD_Table_ID());
        workflow.setDocValueLogic(iWf.getDocValueLogic());
        workflow.setEntityType(iWf.getEntityType());
        workflow.setProcessType(iWf.getProcessType());
        workflow.setS_Resource_ID(iWf.getS_Resource_ID());
        workflow.setDocumentNo(iWf.getDocumentNo());
        workflow.setMovingTime(iWf.getMovingTime());
        workflow.setUnitsCycles(iWf.getUnitsCycles());
        workflow.setQtyBatchSize(iWf.getQtyBatchSize());
        workflow.setQueuingTime(iWf.getQueuingTime());
        workflow.setSetupTime(iWf.getSetupTime());
        workflow.setYield(iWf.getYield());
        workflow.saveEx();
        return workflow;
    }

    private MWFNode getWorkflowNode(X_I_Workflow importWorkflow, MWorkflow workflow) {
        String whereClause = "AD_Workflow_ID=? AND Value=? AND Name=?";
        MWFNode node = (MWFNode)new Query(this.getCtx(), "AD_WF_Node", "AD_Workflow_ID=? AND Value=? AND Name=?", this.get_TrxName()).setClient_ID().setParameters(workflow.get_ID(), importWorkflow.getNodeValue(), importWorkflow.getNodeName()).first();
        if (node == null) {
            node = new MWFNode(this.getCtx(), 0, this.get_TrxName());
            node.setValue(importWorkflow.getNodeValue());
            node.setName(importWorkflow.getNodeName());
        }
        node.setDescription(importWorkflow.getDescription());
        node.setIsCentrallyMaintained(importWorkflow.isCentrallyMaintained());
        node.setStartMode(importWorkflow.getStartMode());
        node.setFinishMode(importWorkflow.getFinishMode());
        node.setJoinElement(importWorkflow.getJoinElement());
        node.setSplitElement(importWorkflow.getSplitElement());
        node.setAction(importWorkflow.getAction());
        node.setAD_Image_ID(importWorkflow.getAD_Image_ID());
        node.setDocAction(importWorkflow.getDocAction());
        node.setDynPriorityUnit(importWorkflow.getDynPriorityUnit());
        node.setDynPriorityChange(importWorkflow.getDynPriorityChange());
        node.setAD_WF_Responsible_ID(importWorkflow.getAD_WF_Responsible_ID());
        node.setPriority(importWorkflow.getPriority());
        node.setLimit(importWorkflow.getLimit());
        node.setDuration(importWorkflow.getDuration());
        node.setCost(importWorkflow.getCost());
        node.setWorkingTime(importWorkflow.getWorkingTime());
        node.setWaitingTime(importWorkflow.getWaitingTime());
        node.setEntityType(importWorkflow.getEntityType());
        node.setAD_Column_ID(importWorkflow.getAD_Column_ID());
        node.setAttributeName(importWorkflow.getAttributeName());
        node.setAttributeValue(importWorkflow.getAttributeValue());
        node.setEMailRecipient(importWorkflow.getEMailRecipient());
        node.setEMail(importWorkflow.getEMail());
        node.setSubflowExecution(importWorkflow.getSubflowExecution());
        node.setAD_Process_ID(importWorkflow.getAD_Process_ID());
        node.setAD_Window_ID(importWorkflow.getAD_Window_ID());
        node.setAD_Form_ID(importWorkflow.getAD_Form_ID());
        node.setR_MailText_ID(importWorkflow.getR_MailText_ID());
        node.setAD_Task_ID(importWorkflow.getAD_Task_ID());
        node.setWaitTime(importWorkflow.getWaitTime());
        node.setAD_Workflow_ID(workflow.get_ID());
        node.setIsMilestone(importWorkflow.isMilestone());
        node.setIsSubcontracting(importWorkflow.isSubcontracting());
        node.setMovingTime(importWorkflow.getMovingTime());
        node.setOverlapUnits(importWorkflow.getOverlapUnits());
        node.setQueuingTime(importWorkflow.getQueuingTime());
        node.setS_Resource_ID(importWorkflow.getS_Resource_ID());
        node.setSetupTime(importWorkflow.getSetupTime());
        node.setUnitsCycles(importWorkflow.getUnitsCycles());
        node.setValidFrom(importWorkflow.getValidFrom());
        node.setValidTo(importWorkflow.getValidTo());
        node.setYield(importWorkflow.getYield());
        node.saveEx();
        return node;
    }

    private boolean createTransition(MWFNode source, MWFNode target) {
        if (source == null) {
            return true;
        }
        String whereClause = "AD_WF_Node_ID=?";
        MWFNodeNext transition = (MWFNodeNext)new Query(this.getCtx(), "AD_WF_NodeNext", "AD_WF_Node_ID=?", this.get_TrxName()).setClient_ID().setParameters(target.get_ID()).first();
        if (transition == null) {
            transition = new MWFNodeNext(this.getCtx(), 0, this.get_TrxName());
        }
        transition.setAD_WF_Node_ID(source.get_ID());
        transition.setAD_WF_Next_ID(target.get_ID());
        transition.setEntityType(source.getEntityType());
        transition.saveEx();
        return true;
    }

    private int getID(String tableName, String whereClause, Object[] values) {
        return new Query(this.getCtx(), tableName, whereClause, this.get_TrxName()).setClient_ID().setParameters(values).firstId();
    }

    private List<X_I_Workflow> getRecords(boolean imported, boolean isWithError) {
        StringBuffer whereClause = new StringBuffer("I_IsImported").append("=?");
        if (isWithError) {
            whereClause.append(" AND ").append("I_ErrorMsg").append(" IS NULL");
        }
        return new Query(this.getCtx(), "I_Workflow", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(imported).setOrderBy("Created").list();
    }
}

