/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.model.MSalesHistory;
import org.eevolution.model.X_I_SalesHistory;

public class ImportSalesHistory
extends SvrProcess {
    private boolean m_DeleteOldImported = false;
    private boolean m_IsImportOnlyNoErrors = true;
    private boolean isImported = false;
    private int imported = 0;
    private int notimported = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] parameters;
        for (ProcessInfoParameter para : parameters = this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if (name.equals("IsImportOnlyNoErrors")) {
                this.m_IsImportOnlyNoErrors = "Y".equals(para.getParameter());
                continue;
            }
            if (name.equals("DeleteOldImported")) {
                this.m_DeleteOldImported = "Y".equals(para.getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.m_DeleteOldImported) {
            int no = 0;
            for (X_I_SalesHistory saleshistory : this.getRecords(true, false)) {
                saleshistory.deleteEx(true);
                ++no;
            }
            this.log.fine("Delete Old Impored =" + no);
        }
        this.fillIDValues();
        this.importRecords();
        return "Imported: " + this.imported + ", Not imported: " + this.notimported;
    }

    private void importRecords() throws SQLException {
        for (X_I_SalesHistory salesHistoryImport : this.getRecords(false, this.m_IsImportOnlyNoErrors)) {
            this.isImported = false;
            MSalesHistory salesHistory = this.importMSalesHistory(salesHistoryImport);
            if (salesHistory == null) {
                this.isImported = false;
            }
            if (this.isImported) {
                salesHistoryImport.setC_SalesHistory_ID(salesHistory.getC_SalesHistory_ID());
                salesHistoryImport.setI_IsImported(true);
                salesHistoryImport.setProcessed(true);
                salesHistoryImport.setI_ErrorMsg("");
                salesHistoryImport.saveEx();
                ++this.imported;
                salesHistoryImport.saveEx();
            } else {
                salesHistoryImport.setI_IsImported(false);
                salesHistoryImport.setProcessed(true);
                salesHistoryImport.saveEx();
                ++this.notimported;
            }
            this.commitEx();
        }
    }

    private MSalesHistory importMSalesHistory(X_I_SalesHistory salesHistoryImporth) throws SQLException {
        String whereClause = "C_SalesHistory_ID= ? ";
        MSalesHistory salesHistory = (MSalesHistory)new Query(Env.getCtx(), "C_SalesHistory", "C_SalesHistory_ID= ? ", this.get_TrxName()).setClient_ID().setParameters(salesHistoryImporth.getC_SalesHistory_ID()).first();
        if (salesHistory == null) {
            salesHistory = new MSalesHistory(Env.getCtx(), 0, this.get_TrxName());
            salesHistory.setAD_Org_ID(salesHistoryImporth.getAD_Org_ID());
            salesHistory.setM_Product_ID(salesHistoryImporth.getM_Product_ID());
            salesHistory.setC_BPartner_ID(salesHistoryImporth.getC_BPartner_ID());
            salesHistory.setM_Warehouse_ID(salesHistoryImporth.getM_Warehouse_ID());
        }
        salesHistory.setC_BPartner_Location_ID(salesHistoryImporth.getC_BPartner_Location_ID());
        salesHistory.setC_BP_Group_ID(salesHistoryImporth.getC_BP_Group_ID());
        salesHistory.setSalesRep_ID(salesHistoryImporth.getSalesRep_ID());
        salesHistory.setM_Product_Category_ID(salesHistoryImporth.getM_Product_Category_ID());
        salesHistory.setM_Product_Class_ID(salesHistoryImporth.getM_Product_Class_ID());
        salesHistory.setM_Product_Classification_ID(salesHistoryImporth.getM_Product_Classification_ID());
        salesHistory.setM_Product_Group_ID(salesHistoryImporth.getM_Product_Group_ID());
        salesHistory.setDateInvoiced(salesHistoryImporth.getDateInvoiced());
        salesHistory.setQty(salesHistoryImporth.getQty());
        salesHistory.setTotalInvQty(salesHistoryImporth.getTotalInvQty());
        salesHistory.setCostAmt(salesHistoryImporth.getCostAmt());
        salesHistory.setTotalInvCost(salesHistoryImporth.getTotalInvCost());
        salesHistory.setPriceInvoiced(salesHistoryImporth.getPriceInvoiced());
        salesHistory.setDocumentNo(salesHistoryImporth.getDocumentNo());
        salesHistory.setTotalInvAmt(salesHistoryImporth.getTotalInvAmt());
        salesHistory.setC_Project_ID(salesHistoryImporth.getC_Project_ID());
        salesHistory.setC_ProjectPhase_ID(salesHistoryImporth.getC_ProjectPhase_ID());
        salesHistory.setC_ProjectTask_ID(salesHistoryImporth.getC_ProjectTask_ID());
        salesHistory.setC_Campaign_ID(salesHistoryImporth.getC_Campaign_ID());
        salesHistory.setC_Activity_ID(salesHistoryImporth.getC_Activity_ID());
        salesHistory.setUser1_ID(salesHistoryImporth.getUser1_ID());
        salesHistory.setUser2_ID(salesHistoryImporth.getUser2_ID());
        salesHistory.saveEx();
        this.isImported = true;
        return salesHistory;
    }

    private void fillIDValues() throws SQLException {
        for (X_I_SalesHistory ish : this.getRecords(false, this.m_IsImportOnlyNoErrors)) {
            int AD_Org_ID = 0;
            if (ish.getAD_Org_ID() > 0) {
                AD_Org_ID = this.getID("AD_Org", "AD_Org_ID = ?", ish.getAD_Org_ID());
            }
            if (AD_Org_ID <= 0 && ish.getOrgValue() != null) {
                AD_Org_ID = this.getID("AD_Org", "Value = ?", ish.getOrgValue());
                ish.setAD_Org_ID(AD_Org_ID);
            } else {
                ish.setAD_Org_ID(AD_Org_ID);
            }
            int C_BPartner_ID = 0;
            if (ish.getC_BPartner_ID() > 0) {
                C_BPartner_ID = this.getID("C_BPartner", "C_BPartner_ID = ?", ish.getC_BPartner_ID());
            }
            if (C_BPartner_ID <= 0 && ish.getBPartnerValue() != null) {
                C_BPartner_ID = this.getID("C_BPartner", "Value = ?", ish.getBPartnerValue());
                ish.setC_BPartner_ID(C_BPartner_ID);
            } else {
                ish.setC_BPartner_ID(C_BPartner_ID);
            }
            int C_BP_Group_ID = 0;
            if (ish.getC_BP_Group_ID() > 0) {
                C_BP_Group_ID = this.getID("C_BP_Group", "C_BP_Group_ID = ?", ish.getC_BP_Group_ID());
            }
            if (C_BP_Group_ID <= 0 && ish.getGroupValue() != null) {
                C_BP_Group_ID = this.getID("C_BP_Group", "Value = ?", ish.getGroupValue());
                ish.setC_BP_Group_ID(C_BP_Group_ID);
            } else {
                ish.setC_BP_Group_ID(C_BP_Group_ID);
            }
            int SalesRep_ID = 0;
            if (ish.getSalesRep_ID() > 0) {
                SalesRep_ID = this.getID("AD_User", "AD_User_ID = ?", ish.getSalesRep_ID());
            }
            if (SalesRep_ID <= 0 && ish.getSalesRep_Name() != null) {
                SalesRep_ID = this.getID("AD_User", "Name = ?", ish.getSalesRep_Name());
                ish.setSalesRep_ID(SalesRep_ID);
            } else {
                ish.setSalesRep_ID(SalesRep_ID);
            }
            int C_SalesRegion_ID = 0;
            if (ish.getC_SalesRegion_ID() > 0) {
                C_SalesRegion_ID = this.getID("C_SalesRegion", "C_SalesRegion_ID = ?", ish.getC_SalesRegion_ID());
            }
            if (C_SalesRegion_ID <= 0 && ish.getRegionName() != null) {
                C_SalesRegion_ID = this.getID("C_SalesRegion", "Name = ?", ish.getRegionName());
                ish.setC_SalesRegion_ID(C_SalesRegion_ID);
            } else {
                ish.setC_SalesRegion_ID(C_SalesRegion_ID);
            }
            int M_Product_ID = 0;
            if (ish.getM_Product_ID() > 0) {
                M_Product_ID = this.getID("M_Product", "M_Product_ID = ?", ish.getM_Product_ID());
            }
            if (M_Product_ID <= 0 && ish.getProductValue() != null) {
                M_Product_ID = this.getID("M_Product", "Value = ?", ish.getProductValue());
                ish.setM_Product_ID(M_Product_ID);
            } else {
                ish.setM_Product_ID(M_Product_ID);
            }
            int M_Product_Category_ID = 0;
            if (ish.getM_Product_Category_ID() > 0) {
                M_Product_Category_ID = this.getID("M_Product_Category", "M_Product_Category_ID = ?", ish.getM_Product_Category_ID());
            }
            if (M_Product_Category_ID <= 0 && ish.getCategoryName() != null) {
                M_Product_Category_ID = this.getID("M_Product_Category", "Name = ?", ish.getCategoryName());
                ish.setM_Product_Category_ID(M_Product_Category_ID);
            } else {
                ish.setM_Product_Category_ID(M_Product_Category_ID);
            }
            int M_Product_Classification_ID = 0;
            if (ish.getM_Product_Classification_ID() > 0) {
                M_Product_Classification_ID = this.getID("M_Product_Classification", "M_Product_Classification_ID = ?", ish.getM_Product_Classification_ID());
            }
            ish.setM_Product_Classification_ID(M_Product_Classification_ID);
            int M_Product_Class_ID = 0;
            if (ish.getM_Product_Class_ID() > 0) {
                M_Product_Class_ID = this.getID("M_Product_Class", "M_Product_Class_ID = ?", ish.getM_Product_Class_ID());
            }
            ish.setM_Product_Class_ID(M_Product_Class_ID);
            int M_Product_Group_ID = 0;
            if (ish.getM_Product_Group_ID() > 0) {
                M_Product_Group_ID = this.getID("M_Product_Group", "M_Product_Group_ID = ?", ish.getM_Product_Group_ID());
            }
            ish.setM_Product_Group_ID(M_Product_Group_ID);
            int M_Warehouse_ID = 0;
            if (ish.getM_Warehouse_ID() > 0) {
                M_Warehouse_ID = this.getID("M_Warehouse", "M_Warehouse_ID = ?", ish.getM_Warehouse_ID());
            }
            if (M_Warehouse_ID <= 0 && ish.getWarehouseValue() != null) {
                M_Warehouse_ID = this.getID("M_Warehouse", "Value = ?", ish.getWarehouseValue());
                ish.setM_Warehouse_ID(M_Warehouse_ID);
            } else {
                ish.setM_Warehouse_ID(M_Warehouse_ID);
            }
            int C_Project_ID = 0;
            if (ish.getC_Project_ID() > 0) {
                C_Project_ID = this.getID("C_Project", "C_Project_ID = ?", ish.getC_Project_ID());
            }
            if (C_Project_ID <= 0 && ish.getProjectName() != null) {
                C_Project_ID = this.getID("C_Project", "Name = ?", ish.getProjectName());
                ish.setC_Project_ID(C_Project_ID);
            } else {
                ish.setC_Project_ID(C_Project_ID);
            }
            int C_ProjectPhase_ID = 0;
            if (ish.getC_ProjectPhase_ID() > 0) {
                C_ProjectPhase_ID = this.getID("C_ProjectPhase", "C_ProjectPhase_ID = ?", ish.getC_ProjectPhase_ID());
            }
            ish.setC_ProjectPhase_ID(C_ProjectPhase_ID);
            int C_ProjectTask_ID = 0;
            if (ish.getC_ProjectTask_ID() > 0) {
                C_ProjectTask_ID = this.getID("C_ProjectTask", "C_ProjectTask_ID = ?", ish.getC_ProjectTask_ID());
            }
            ish.setC_ProjectTask_ID(C_ProjectTask_ID);
            int C_Campaign_ID = 0;
            if (ish.getC_Campaign_ID() > 0) {
                C_Campaign_ID = this.getID("C_Campaign", "C_Campaign_ID = ?", ish.getC_Campaign_ID());
            }
            if (C_Campaign_ID <= 0 && ish.getCampaignValue() != null) {
                C_Campaign_ID = this.getID("C_Campaign", "Value = ?", ish.getCampaignValue());
                ish.setC_Campaign_ID(C_Campaign_ID);
            } else {
                ish.setC_Campaign_ID(C_Campaign_ID);
            }
            int C_Activity_ID = 0;
            if (ish.getC_Activity_ID() > 0) {
                C_Activity_ID = this.getID("C_Activity", "C_Activity_ID = ?", ish.getC_Activity_ID());
            }
            if (C_Activity_ID <= 0 && ish.getActivityValue() != null) {
                C_Activity_ID = this.getID("C_Activity", "Value = ?", ish.getActivityValue());
                ish.setC_Activity_ID(C_Activity_ID);
            } else {
                ish.setC_Activity_ID(C_Activity_ID);
            }
            ish.saveEx();
            StringBuffer err = new StringBuffer("");
            if (ish.getAD_Org_ID() <= 0) {
                err.append(" @AD_Org_ID@ @NotFound@,");
            }
            if (ish.getM_Product_ID() <= 0) {
                err.append(" @M_Product_ID@ @NotFound@,");
            }
            if (ish.getM_Warehouse_ID() <= 0) {
                err.append(" @M_Warehouse_ID@ @NotFound@,");
            }
            if (ish.getC_BPartner_ID() <= 0) {
                err.append(" @C_BPartner_ID@ @NotFound@,");
            }
            if (err.toString() != null && err.toString().length() > 0) {
                ++this.notimported;
                ish.setI_ErrorMsg(Msg.parseTranslation(this.getCtx(), err.toString()));
                ish.saveEx();
            }
            this.commitEx();
        }
    }

    private int getID(String tableName, String whereClause, Object ... parameters) {
        return new Query(this.getCtx(), tableName, whereClause, this.get_TrxName()).setParameters(parameters).firstId();
    }

    private List<X_I_SalesHistory> getRecords(boolean imported, boolean isWithError) {
        StringBuffer whereClause = new StringBuffer("I_IsImported").append("=?");
        if (isWithError) {
            whereClause.append(" AND ").append("I_ErrorMsg").append(" IS NULL");
        }
        return new Query(this.getCtx(), "I_SalesHistory", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(imported).list();
    }
}

