/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import org.compiere.model.MForecast;
import org.compiere.model.MForecastLine;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.model.MPPPeriod;
import org.eevolution.model.X_I_Forecast;

public class ImportForecast
extends SvrProcess {
    private boolean m_DeleteOldImported = false;
    private boolean m_IsImportOnlyNoErrors = true;
    private boolean isImported = false;
    private int imported = 0;
    private int notimported = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] parameters;
        for (ProcessInfoParameter para : parameters = this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if (name.equals("IsImportOnlyNoErrors")) {
                this.m_IsImportOnlyNoErrors = "Y".equals(para.getParameter());
                continue;
            }
            if (name.equals("DeleteOldImported")) {
                this.m_DeleteOldImported = "Y".equals(para.getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.m_DeleteOldImported) {
            int no = 0;
            for (X_I_Forecast forecast : this.getRecords(true, false)) {
                forecast.deleteEx(true);
                ++no;
            }
            this.log.fine("Delete Old Impored =" + no);
        }
        this.fillIDValues();
        this.importRecords();
        return "Imported: " + this.imported + ", Not imported: " + this.notimported;
    }

    private void importRecords() {
        for (X_I_Forecast ifl : this.getRecords(false, this.m_IsImportOnlyNoErrors)) {
            this.isImported = false;
            MForecastLine fl = this.importForecast(ifl);
            if (fl != null) {
                this.isImported = true;
            }
            if (this.isImported) {
                ifl.setM_ForecastLine_ID(fl.getM_ForecastLine_ID());
                ifl.setI_IsImported(true);
                ifl.setProcessed(true);
                ifl.setI_ErrorMsg("");
                ifl.saveEx();
                ++this.imported;
                ifl.saveEx();
                continue;
            }
            ifl.setI_IsImported(false);
            ifl.setProcessed(true);
            ifl.saveEx();
            ++this.notimported;
        }
    }

    private MForecastLine importForecast(X_I_Forecast ifl) {
        MForecastLine fl = new MForecastLine(this.getCtx(), ifl.getM_ForecastLine_ID(), this.get_TrxName());
        MForecast f = (MForecast)ifl.getM_Forecast();
        if (fl == null || fl.get_ID() <= 0) {
            fl = new MForecastLine(Env.getCtx(), 0, this.get_TrxName());
            fl.setAD_Org_ID(ifl.getAD_Org_ID());
            fl.setM_Forecast_ID(ifl.getM_Forecast_ID());
            fl.setM_Product_ID(ifl.getM_Product_ID());
            fl.setM_Warehouse_ID(ifl.getM_Warehouse_ID());
        }
        fl.setQty(ifl.getQty());
        fl.setIsActive(true);
        fl.setSalesRep_ID(ifl.getSalesRep_ID());
        fl.setDatePromised(ifl.getDatePromised());
        fl.setPP_Period_ID(MPPPeriod.findByCalendar(this.getCtx(), ifl.getDatePromised(), f.getPP_Calendar_ID(), this.get_TrxName()).get_ID());
        fl.saveEx();
        this.isImported = true;
        return fl;
    }

    private void fillIDValues() throws SQLException {
        for (X_I_Forecast ifl : this.getRecords(false, this.m_IsImportOnlyNoErrors)) {
            int M_Forecast_ID = 0;
            if (ifl.getM_Forecast_ID() > 0) {
                M_Forecast_ID = this.getID("M_Forecast", "M_Forecast_ID = ?", ifl.getM_Forecast_ID());
            }
            int AD_Org_ID = 0;
            if (ifl.getAD_Org_ID() > 0) {
                AD_Org_ID = this.getID("AD_Org", "AD_Org_ID = ?", ifl.getAD_Org_ID());
            }
            if (AD_Org_ID <= 0 && ifl.getOrgValue() != null) {
                AD_Org_ID = this.getID("AD_Org", "Value = ?", ifl.getOrgValue());
                ifl.setAD_Org_ID(AD_Org_ID);
            } else {
                ifl.setAD_Org_ID(AD_Org_ID);
            }
            int SalesRep_ID = 0;
            if (ifl.getSalesRep_ID() > 0) {
                SalesRep_ID = this.getID("AD_User", "AD_User_ID = ?", ifl.getSalesRep_ID());
            }
            if (SalesRep_ID <= 0 && ifl.getSalesRep_Name() != null) {
                SalesRep_ID = this.getID("AD_User", "Name = ?", ifl.getSalesRep_Name());
                ifl.setSalesRep_ID(SalesRep_ID);
            } else {
                ifl.setSalesRep_ID(SalesRep_ID);
            }
            int M_Product_ID = 0;
            if (ifl.getM_Product_ID() > 0) {
                M_Product_ID = this.getID("M_Product", "M_Product_ID = ?", ifl.getM_Product_ID());
            }
            if (M_Product_ID <= 0 && ifl.getProductValue() != null) {
                M_Product_ID = this.getID("M_Product", "Value = ?", ifl.getProductValue());
                ifl.setM_Product_ID(M_Product_ID);
            } else {
                ifl.setM_Product_ID(M_Product_ID);
            }
            int M_Warehouse_ID = 0;
            if (ifl.getM_Warehouse_ID() > 0) {
                M_Warehouse_ID = this.getID("M_Warehouse", "M_Warehouse_ID = ?", ifl.getM_Warehouse_ID());
            }
            if (M_Warehouse_ID <= 0 && ifl.getWarehouseValue() != null) {
                M_Warehouse_ID = this.getID("M_Warehouse", "Value = ?", ifl.getWarehouseValue());
                ifl.setM_Warehouse_ID(M_Warehouse_ID);
            } else {
                ifl.setM_Warehouse_ID(M_Warehouse_ID);
            }
            ifl.saveEx();
            StringBuffer err = new StringBuffer("");
            if (ifl.getM_Forecast_ID() <= 0) {
                err.append(" @M_Forecast_ID@ @NotFound@,");
            }
            if (ifl.getAD_Org_ID() <= 0) {
                err.append(" @AD_Org_ID@ @NotFound@,");
            }
            if (ifl.getM_Product_ID() <= 0) {
                err.append(" @M_Product_ID@ @NotFound@,");
            }
            if (ifl.getM_Warehouse_ID() <= 0) {
                err.append(" @M_Warehouse_ID@ @NotFound@,");
            }
            if (ifl.getDatePromised() == null) {
                err.append(" @DatePromised@ @NotFound@,");
            }
            if (err.toString() != null && err.toString().length() > 0) {
                ++this.notimported;
                ifl.setI_ErrorMsg(Msg.parseTranslation(this.getCtx(), err.toString()));
                ifl.saveEx();
            }
            ifl.saveEx();
            this.commitEx();
        }
    }

    private int getID(String tableName, String whereClause, Object ... parameters) {
        return new Query(this.getCtx(), tableName, whereClause, this.get_TrxName()).setParameters(parameters).firstId();
    }

    private List<X_I_Forecast> getRecords(boolean imported, boolean isWithError) {
        StringBuffer whereClause = new StringBuffer("I_IsImported").append("=?");
        if (isWithError) {
            whereClause.append(" AND ").append("I_ErrorMsg").append(" IS NULL");
        }
        return new Query(this.getCtx(), "I_Forecast", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(imported).list();
    }
}

