/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.util.List;
import java.util.logging.Level;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.eevolution.model.MHRConcept;
import org.eevolution.model.X_HR_Attribute;
import org.eevolution.model.X_I_HR_Attribute;

public class ImportEmployeeAttributes
extends SvrProcess {
    protected boolean deleteOldImported = false;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter processInfoParameter : this.getParameter()) {
            String string = processInfoParameter.getParameterName();
            if (processInfoParameter.getParameter() == null) {
                // empty if block
            }
            if (processInfoParameter.getParameterName().equals("DeleteOldImported")) {
                this.deleteOldImported = processInfoParameter.getParameter_ToAsBoolean();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + string);
        }
    }

    @Override
    protected String doIt() throws Exception {
        String string = "";
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("I_IsImported").append("=? AND ").append("Processed").append("=?");
        List list = new Query(this.getCtx(), "I_HR_Attribute", stringBuilder.toString(), this.get_TrxName()).setOnlyActiveRecords(true).setParameters(false, false).list();
        for (X_I_HR_Attribute x_I_HR_Attribute : list) {
            int n2;
            int n3 = DB.getSQLValue(null, "SELECT C_BPartner_ID FROM C_BPartner WHERE TRIM(Value) = ?", x_I_HR_Attribute.getValue().trim());
            if (n3 < 0) {
                x_I_HR_Attribute.setI_ErrorMsg(Msg.parseTranslation(this.getCtx(), "@HR_Employee_ID@ @NotFound@"));
                x_I_HR_Attribute.saveEx();
                continue;
            }
            int n4 = DB.getSQLValue(null, "SELECT HR_Concept_ID FROM HR_Concept WHERE TRIM(Value) = ?", x_I_HR_Attribute.getConceptValue().trim());
            if (n4 < 0) {
                x_I_HR_Attribute.setI_ErrorMsg(Msg.parseTranslation(this.getCtx(), "@HR_Concept_ID@ @NotFound@"));
                x_I_HR_Attribute.saveEx();
                continue;
            }
            MHRConcept mHRConcept = new MHRConcept(this.getCtx(), n4, this.get_TrxName());
            if (x_I_HR_Attribute.getValidFrom() == null) {
                x_I_HR_Attribute.setI_ErrorMsg(Msg.parseTranslation(this.getCtx(), "@Invalid@ @ValidFrom@"));
                x_I_HR_Attribute.saveEx();
                continue;
            }
            if (x_I_HR_Attribute.getAmount().signum() <= 0 && x_I_HR_Attribute.getQty().signum() <= 0) continue;
            X_HR_Attribute x_HR_Attribute = new X_HR_Attribute(this.getCtx(), 0, this.get_TrxName());
            x_HR_Attribute.setC_BPartner_ID(n3);
            x_HR_Attribute.setHR_Concept_ID(mHRConcept.get_ID());
            x_HR_Attribute.setColumnType(mHRConcept.getColumnType());
            x_HR_Attribute.setValidFrom(x_I_HR_Attribute.getValidFrom());
            if (x_I_HR_Attribute.getAmount().signum() > 0) {
                x_HR_Attribute.setAmount(x_I_HR_Attribute.getAmount());
            }
            if (x_I_HR_Attribute.getQty().signum() > 0) {
                x_HR_Attribute.setQty(x_I_HR_Attribute.getQty());
            }
            if (x_I_HR_Attribute.getValidTo() != null) {
                x_HR_Attribute.setValidTo(x_I_HR_Attribute.getValidTo());
            }
            if (x_I_HR_Attribute.getPayrollValue() != null && (n2 = DB.getSQLValue(null, "SELECT HR_Payroll_ID FROM HR_Payroll WHERE TRIM(Value) = ?", x_I_HR_Attribute.getValue().trim())) < 0) {
                x_HR_Attribute.setHR_Payroll_ID(n2);
            }
            x_HR_Attribute.setIsActive(true);
            if (!x_HR_Attribute.save()) continue;
            x_I_HR_Attribute.setI_IsImported(true);
            x_I_HR_Attribute.setI_ErrorMsg("");
            x_I_HR_Attribute.setProcessed(true);
            x_I_HR_Attribute.setHR_Attribute_ID(x_HR_Attribute.get_ID());
            x_I_HR_Attribute.saveEx();
        }
        return n + " @Records@ @ProcessOK@";
    }
}

