/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_M_InOut;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.model.MWMInOutBoundLine;

public class GenerateShipmentOutBound
extends SvrProcess {
    protected int p_Record_ID = 0;
    protected String p_DocAction = null;
    protected boolean p_IsIncludeNotAvailable = false;
    protected Timestamp p_MovementDate = null;
    private Hashtable m_shipments = new Hashtable();

    @Override
    protected void prepare() {
        this.p_Record_ID = this.getRecord_ID();
        for (ProcessInfoParameter processInfoParameter : this.getParameter()) {
            String string = processInfoParameter.getParameterName();
            if (processInfoParameter.getParameter() == null) continue;
            if (string.equals("DocAction")) {
                this.p_DocAction = (String)processInfoParameter.getParameter();
                continue;
            }
            if (string.equals("IsIncludeNotAvailable")) {
                this.p_IsIncludeNotAvailable = "Y".equals(processInfoParameter.getParameter());
                continue;
            }
            if (string.equals("MovementDate")) {
                this.p_MovementDate = (Timestamp)processInfoParameter.getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + string);
        }
    }

    @Override
    protected String doIt() throws Exception {
        String string = "EXISTS (SELECT T_Selection_ID FROM T_Selection WHERE  T_Selection.AD_PInstance_ID=? AND T_Selection.T_Selection_ID=WM_InOutBoundLine.WM_InOutboundLine_ID)";
        List list = new Query(this.getCtx(), "WM_InOutBoundLine", string, this.get_TrxName()).setClient_ID().setParameters(this.getAD_PInstance_ID()).list();
        int n = 10;
        for (PO pO : list) {
            if (((MWMInOutBoundLine)pO).getQtyToDeliver().signum() > 0 || this.p_IsIncludeNotAvailable) {
                this.createMInOut((MWMInOutBoundLine)pO);
            }
            ++n;
        }
        Enumeration enumeration = this.m_shipments.elements();
        while (enumeration.hasMoreElements()) {
            PO pO;
            pO = (MInOut)enumeration.nextElement();
            ((X_M_InOut)pO).setDocAction(this.p_DocAction);
            ((MInOut)pO).processIt(this.p_DocAction);
            if (!((MInOut)pO).processIt(this.p_DocAction)) {
                this.log.warning("Failed: " + pO);
            }
            pO.saveEx();
        }
        return "";
    }

    public void createMInOut(MWMInOutBoundLine mWMInOutBoundLine) {
        MOrderLine mOrderLine = mWMInOutBoundLine.getMOrderLine();
        if (mWMInOutBoundLine.getPickedQty().subtract(mOrderLine.getQtyDelivered()).signum() <= 0 && !this.p_IsIncludeNotAvailable) {
            return;
        }
        MLocator mLocator = null;
        BigDecimal bigDecimal = Env.ZERO;
        if (this.p_IsIncludeNotAvailable) {
            mLocator = MLocator.getDefault((MWarehouse)mWMInOutBoundLine.getParent().getM_Warehouse());
            bigDecimal = mWMInOutBoundLine.getQtyToPick().subtract(mOrderLine.getQtyDelivered());
        } else {
            mLocator = mWMInOutBoundLine.getMLocator();
            bigDecimal = mWMInOutBoundLine.getPickedQty().subtract(mOrderLine.getQtyDelivered());
        }
        MInOut mInOut = this.getMInOut(mOrderLine);
        mInOut.setIsSOTrx(true);
        mInOut.saveEx();
        MInOutLine mInOutLine = new MInOutLine(mWMInOutBoundLine.getCtx(), 0, mWMInOutBoundLine.get_TrxName());
        mInOutLine.setM_InOut_ID(mInOut.getM_InOut_ID());
        mInOutLine.setM_Locator_ID(mLocator.getM_Locator_ID());
        mInOutLine.setM_Product_ID(mWMInOutBoundLine.getM_Product_ID());
        mInOutLine.setQtyEntered(bigDecimal);
        mInOutLine.setMovementQty(bigDecimal);
        mInOutLine.setC_OrderLine_ID(mOrderLine.getC_OrderLine_ID());
        mInOutLine.saveEx();
    }

    protected int getDocType(String string) {
        MDocType[] mDocTypeArray = MDocType.getOfDocBaseType(this.getCtx(), string);
        if (mDocTypeArray == null || mDocTypeArray.length == 0) {
            String string2 = Msg.getMsg(this.getCtx(), "SequenceDocNotFound");
            String string3 = "Not found default document type for docbasetype " + string;
            throw new AdempiereException(string3);
        }
        for (MDocType mDocType : mDocTypeArray) {
            if (!mDocType.isSOTrx()) continue;
            this.log.info("Doc Type for " + string + ": " + mDocType.getC_DocType_ID());
            return mDocType.getC_DocType_ID();
        }
        String string4 = "Not found default document type for docbasetype " + string;
        throw new AdempiereException(string4);
    }

    private MInOut getMInOut(MOrderLine mOrderLine) {
        MInOut mInOut = (MInOut)this.m_shipments.get(mOrderLine.getC_Order_ID());
        if (mInOut != null) {
            return mInOut;
        }
        MOrder mOrder = mOrderLine.getParent();
        mInOut = new MInOut(mOrder, this.getDocType("MMS"), this.p_MovementDate);
        this.m_shipments.put(mOrder.getC_Order_ID(), mInOut);
        return mInOut;
    }
}

