/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.eevolution.form.Browser;
import org.eevolution.form.IPrintDocument;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MDDOrderLine;

public class GenerateMovementMaterial
extends SvrProcess {
    protected LinkedHashMap<Integer, LinkedHashMap<String, Object>> values = null;
    protected Timestamp movementDate;
    protected int orderId;
    protected MDDOrder distributionOrder;
    protected List<MDDOrderLine> distributionOrderLines;
    protected String result;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter para : this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null || !"MovementDate".equals(name)) continue;
            this.movementDate = para.getParameterAsTimestamp();
        }
        int orderId = Env.getContextAsInt(this.getCtx(), this.getWindowNo(), "line.DD_Order_ID");
        if (orderId >= 0) {
            this.distributionOrder = new MDDOrder(this.getCtx(), orderId, this.get_TrxName());
        }
        if (this.distributionOrder == null) {
            throw new AdempiereException("@DD_Order_ID@ @NotFound@");
        }
        this.setColumnsValues();
    }

    @Override
    protected String doIt() throws Exception {
        this.generateMovements();
        return this.result;
    }

    private List<MDDOrderLine> getRecords() {
        if (this.distributionOrderLines != null) {
            return this.distributionOrderLines;
        }
        String whereClause = "EXISTS (SELECT T_Selection_ID FROM T_Selection WHERE  T_Selection.AD_PInstance_ID=? AND T_Selection.T_Selection_ID=DD_OrderLine.DD_OrderLine_ID)";
        this.distributionOrderLines = new Query(this.getCtx(), "DD_OrderLine", whereClause, this.get_TrxName()).setClient_ID().setParameters(this.getAD_PInstance_ID()).list();
        return this.distributionOrderLines;
    }

    private void generateMovements() {
        Trx.run(new TrxRunnable(){

            @Override
            public void run(String trxName) {
                if (GenerateMovementMaterial.this.getRecords().size() <= 0) {
                    return;
                }
                MMovement movement = new MMovement(GenerateMovementMaterial.this.getCtx(), 0, trxName);
                movement.setDD_Order_ID(GenerateMovementMaterial.this.distributionOrder.getDD_Order_ID());
                movement.setAD_User_ID(GenerateMovementMaterial.this.distributionOrder.getAD_User_ID());
                movement.setPOReference(GenerateMovementMaterial.this.distributionOrder.getPOReference());
                movement.setReversal_ID(0);
                movement.setM_Shipper_ID(GenerateMovementMaterial.this.distributionOrder.getM_Shipper_ID());
                movement.setDescription(GenerateMovementMaterial.this.distributionOrder.getDescription());
                movement.setC_BPartner_ID(GenerateMovementMaterial.this.distributionOrder.getC_BPartner_ID());
                movement.setC_BPartner_Location_ID(GenerateMovementMaterial.this.distributionOrder.getC_BPartner_Location_ID());
                movement.setAD_Org_ID(GenerateMovementMaterial.this.distributionOrder.getAD_Org_ID());
                movement.setAD_OrgTrx_ID(GenerateMovementMaterial.this.distributionOrder.getAD_OrgTrx_ID());
                movement.setAD_User_ID(GenerateMovementMaterial.this.distributionOrder.getAD_User_ID());
                movement.setC_Activity_ID(GenerateMovementMaterial.this.distributionOrder.getC_Activity_ID());
                movement.setC_Campaign_ID(GenerateMovementMaterial.this.distributionOrder.getC_Campaign_ID());
                movement.setC_Project_ID(GenerateMovementMaterial.this.distributionOrder.getC_Project_ID());
                movement.setMovementDate(GenerateMovementMaterial.this.movementDate);
                movement.setDeliveryRule(GenerateMovementMaterial.this.distributionOrder.getDeliveryRule());
                movement.setDeliveryViaRule(GenerateMovementMaterial.this.distributionOrder.getDeliveryViaRule());
                movement.setDocAction("PR");
                movement.setDocStatus("DR");
                int docTypeDO_ID = MDocType.getDocType("MMM", GenerateMovementMaterial.this.distributionOrder.getAD_Org_ID());
                if (docTypeDO_ID <= 0) {
                    throw new AdempiereException("@C_DocType_ID@ @NotFound@");
                }
                movement.setC_DocType_ID(docTypeDO_ID);
                movement.saveEx();
                for (MDDOrderLine orderLine : GenerateMovementMaterial.this.getRecords()) {
                    MMovementLine line = new MMovementLine(movement);
                    line.setM_Product_ID(orderLine.getM_Product_ID());
                    BigDecimal QtyDeliver = (BigDecimal)GenerateMovementMaterial.this.getBrowseRowValue("LINE", "QtyInTransit", orderLine.get_ID());
                    if (QtyDeliver == null | QtyDeliver.compareTo(orderLine.getQtyInTransit()) > 0) {
                        throw new AdempiereException("Error @QtyInTransit@");
                    }
                    line.setOrderLine(orderLine, QtyDeliver, true);
                    line.saveEx();
                }
                movement.setDocAction("CL");
                movement.setDocStatus(movement.completeIt());
                movement.saveEx();
                GenerateMovementMaterial.this.printDocument(movement, "Inventory Move Hdr (Example)");
            }
        });
    }

    private LinkedHashMap<Integer, LinkedHashMap<String, Object>> setColumnsValues() {
        if (this.values != null) {
            return this.values;
        }
        this.values = new LinkedHashMap();
        for (MDDOrderLine record : this.getRecords()) {
            this.values.put(record.get_ID(), Browser.getBrowseValues(this.getAD_PInstance_ID(), null, record.get_ID(), null));
        }
        return this.values;
    }

    private Object getBrowseRowValue(String alias, String columnName, int recordId) {
        LinkedHashMap<String, Object> columns = this.values.get(recordId);
        for (Map.Entry<String, Object> entry : columns.entrySet()) {
            if (!entry.getKey().contains(alias.toUpperCase() + "_" + columnName)) continue;
            return entry.getValue();
        }
        return null;
    }

    private int getWindowNo() {
        return this.getProcessInfo().getWindowNo();
    }

    private void printDocument(PO document, String printFormantName) {
        StringBuffer resultText = new StringBuffer(Msg.translate(Env.getCtx(), "DocumentNo") + " : " + document.get_ValueAsString("DocumentNo"));
        this.result = resultText.toString();
        IPrintDocument IPrintDocument2 = Ini.isClient() ? this.getPrintDocument("org.eevolution.form.VPrintDocument") : this.getPrintDocument("org.eevolution.form.WPrintDocument");
        IPrintDocument2.print(document, printFormantName, this.getWindowNo());
    }

    public IPrintDocument getPrintDocument(String className) throws RuntimeException {
        IPrintDocument result = null;
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = null;
            constructor = clazz.getDeclaredConstructor(new Class[0]);
            result = (IPrintDocument)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

