/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.lang.reflect.Constructor;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.apps.ProcessCtl;
import org.compiere.model.MLocator;
import org.compiere.model.MMovement;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.eevolution.form.IPrintDocument;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MPPOrder;

public class GenerateMovement
extends SvrProcess {
    protected List<MPPOrder> records = new ArrayList<MPPOrder>();
    private Timestamp movementDate = null;
    private MLocator locator = null;
    private String result = null;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter para : this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null || !name.equals("MovementDate")) continue;
            this.movementDate = para.getParameterAsTimestamp();
            if (this.movementDate != null) continue;
            throw new AdempiereException("@MovementDate@ @NotFound@");
        }
        int locatorId = Env.getContextAsInt(Env.getCtx(), this.getProcessInfo().getWindowNo(), "mc.M_Locator_ID");
        if (locatorId > 0) {
            this.locator = new MLocator(this.getCtx(), locatorId, this.get_TrxName());
        }
        if (this.locator == null) {
            throw new AdempiereException("@M_Locator_ID@ @NotFound@");
        }
    }

    @Override
    protected String doIt() throws Exception {
        for (MDDOrder order : this.getRecords()) {
            this.generate(order);
        }
        return this.result;
    }

    private List<MDDOrder> getRecords() {
        String whereClause = "EXISTS (SELECT T_Selection_ID FROM T_Selection WHERE  T_Selection.AD_PInstance_ID=? AND T_Selection.T_Selection_ID=DD_Order.DD_Order_ID)";
        return new Query(this.getCtx(), "DD_Order", whereClause, this.get_TrxName()).setClient_ID().setParameters(this.getAD_PInstance_ID()).list();
    }

    private void generate(MDDOrder order) {
        String trxName = Trx.createTrxName("IMG");
        Trx trx = Trx.get(trxName, true);
        String info = "";
        int AD_Process_ID = MProcess.getProcess_ID("M_Generate Movement", null);
        MPInstance instance = new MPInstance(Env.getCtx(), AD_Process_ID, 0);
        if (!instance.save()) {
            info = Msg.getMsg(Env.getCtx(), "ProcessNoInstance");
            this.addLog(info);
        }
        ArrayList<Integer> ordersId = new ArrayList<Integer>();
        ordersId.add(order.getDD_Order_ID());
        DB.createT_Selection(instance.getAD_PInstance_ID(), ordersId, null);
        ProcessInfo pi = new ProcessInfo("Generate Movement", AD_Process_ID);
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        MPInstancePara ip = new MPInstancePara(instance, 10);
        ip.setParameter("Selection", "Y");
        ip.saveEx();
        ip = new MPInstancePara(instance, 20);
        ip.setParameter("M_Warehouse_ID", this.locator.getM_Warehouse_ID());
        ip.saveEx();
        ip = new MPInstancePara(instance, 30);
        ip.setParameter("MovementDate", this.movementDate);
        ip.saveEx();
        ProcessCtl worker = new ProcessCtl(null, pi.getWindowNo(), pi, trx);
        worker.run();
        this.result = pi.getSummary();
        MMovement movement = new MMovement(this.getCtx(), pi.getRecord_ID(), trxName);
        if (movement == null || movement.get_ID() <= 0) {
            throw new AdempiereException("@M_Movement_ID@ @NotFound@");
        }
        this.printDocument(movement, "Inventory Move Hdr (Example)", pi.getWindowNo());
    }

    private void printDocument(PO document, String printFormantName, int documentNo) {
        StringBuffer resultText = new StringBuffer(Msg.translate(Env.getCtx(), "DocumentNo") + " : " + document.get_ValueAsString("DocumentNo"));
        this.result = this.result == null ? " " + resultText.toString() : this.result + " " + resultText.toString();
        IPrintDocument IPrintDocument2 = Ini.isClient() ? this.getPrintDocument("org.eevolution.form.VPrintDocument") : this.getPrintDocument("org.eevolution.form.WPrintDocument");
        IPrintDocument2.print(document, printFormantName, documentNo);
    }

    public IPrintDocument getPrintDocument(String className) throws RuntimeException {
        IPrintDocument result = null;
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = null;
            constructor = clazz.getDeclaredConstructor(new Class[0]);
            result = (IPrintDocument)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

