/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.sql.Timestamp;
import java.util.List;
import java.util.logging.Level;
import org.adempiere.exceptions.DocTypeNotFoundException;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MOrderLine;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.eevolution.model.MWMInOutBound;
import org.eevolution.model.MWMInOutBoundLine;

public class GenerateInOutBound
extends SvrProcess {
    protected int p_Record_ID = 0;
    protected int p_M_Locator_ID = 0;
    protected String p_DocAction = null;
    protected Timestamp p_ShipDate = null;
    protected Timestamp p_PickDate = null;
    protected int p_C_DocType_ID = 0;
    protected String p_DeliveryRule = null;
    protected String p_POReference = null;

    @Override
    protected void prepare() {
        this.p_Record_ID = this.getRecord_ID();
        for (ProcessInfoParameter processInfoParameter : this.getParameter()) {
            String string = processInfoParameter.getParameterName();
            if (processInfoParameter.getParameter() == null) continue;
            if (string.equals("ShipDate")) {
                this.p_ShipDate = (Timestamp)processInfoParameter.getParameter();
                continue;
            }
            if (string.equals("PickDate")) {
                this.p_PickDate = (Timestamp)processInfoParameter.getParameter();
                continue;
            }
            if (string.equals("POReference")) {
                this.p_POReference = (String)processInfoParameter.getParameter();
                continue;
            }
            if (string.equals("M_Locator_ID")) {
                this.p_M_Locator_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            if (string.equals("DeliveryRule")) {
                this.p_DeliveryRule = (String)processInfoParameter.getParameter();
                continue;
            }
            if (string.equals("C_DocType_ID")) {
                this.p_C_DocType_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            if (string.equals("DocAction")) {
                this.p_DocAction = (String)processInfoParameter.getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + string);
        }
    }

    @Override
    protected String doIt() throws Exception {
        int n;
        MLocator mLocator = MLocator.get(this.getCtx(), this.p_M_Locator_ID);
        MWMInOutBound mWMInOutBound = new MWMInOutBound(this.getCtx(), 0, this.get_TrxName());
        mWMInOutBound.setShipDate(this.p_ShipDate);
        mWMInOutBound.setPickDate(this.p_PickDate);
        if (this.p_POReference != null) {
            mWMInOutBound.setPOReference(this.p_POReference);
        }
        if (this.p_DeliveryRule != null) {
            mWMInOutBound.setDeliveryRule(this.p_DeliveryRule);
        }
        if (this.p_C_DocType_ID > 0) {
            mWMInOutBound.setC_DocType_ID(this.p_C_DocType_ID);
        } else {
            n = MDocType.getDocType("WMO");
            if (n <= 0) {
                throw new DocTypeNotFoundException("WMO", "");
            }
            mWMInOutBound.setC_DocType_ID(n);
        }
        if (this.p_DocAction != null) {
            mWMInOutBound.setDocAction(this.p_DocAction);
        } else {
            mWMInOutBound.setDocAction("PR");
        }
        mWMInOutBound.setDocStatus("DR");
        mWMInOutBound.setM_Warehouse_ID(mLocator.getM_Warehouse_ID());
        mWMInOutBound.setIsSOTrx(true);
        mWMInOutBound.saveEx();
        n = 10;
        String string = "EXISTS (SELECT T_Selection_ID FROM T_Selection WHERE  T_Selection.AD_PInstance_ID=? AND T_Selection.T_Selection_ID=C_OrderLine.C_OrderLine_ID)";
        List list = new Query(this.getCtx(), "C_OrderLine", string, this.get_TrxName()).setClient_ID().setParameters(this.getAD_PInstance_ID()).list();
        for (MOrderLine mOrderLine : list) {
            MWMInOutBoundLine mWMInOutBoundLine = new MWMInOutBoundLine(mWMInOutBound);
            mWMInOutBoundLine.setLine(n);
            mWMInOutBoundLine.setM_Product_ID(mOrderLine.getM_Product_ID());
            mWMInOutBoundLine.setM_AttributeSetInstance_ID(mOrderLine.getM_AttributeSetInstance_ID());
            mWMInOutBoundLine.setMovementQty(mOrderLine.getQtyOrdered().subtract(mOrderLine.getQtyDelivered()));
            mWMInOutBoundLine.setC_UOM_ID(mOrderLine.getC_UOM_ID());
            mWMInOutBoundLine.setDescription(mOrderLine.getDescription());
            mWMInOutBoundLine.setC_OrderLine_ID(mOrderLine.getC_OrderLine_ID());
            mWMInOutBoundLine.setPickDate(mWMInOutBound.getPickDate());
            mWMInOutBoundLine.setShipDate(mWMInOutBound.getShipDate());
            mWMInOutBoundLine.saveEx();
            ++n;
        }
        return "@DocumentNo@ " + mWMInOutBound.getDocumentNo();
    }
}

