/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.adempiere.engine.CostEngineFactory;
import org.adempiere.engine.CostingMethodFactory;
import org.adempiere.engine.StandardCostingMethod;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostElement;
import org.compiere.model.MCostType;
import org.compiere.model.MInOutLine;
import org.compiere.model.MLandedCostAllocation;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MProduct;
import org.compiere.model.MTransaction;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Trx;
import org.eevolution.model.MPPCostCollector;

public class GenerateCostDetail
extends SvrProcess {
    private int p_M_Product_ID;
    private int p_M_CostElement_ID;
    private int p_M_CostType_ID;
    private int p_C_AcctSchema_ID;
    private Timestamp p_DateAcct;
    private Timestamp p_DateAcctTo;
    private ArrayList<Object> deleteParameters;
    private ArrayList<Object> resetCostParameters;
    private List<MAcctSchema> acctSchemas = new ArrayList<MAcctSchema>();
    private List<MCostType> costTypes = new ArrayList<MCostType>();
    private List<MCostElement> costElements = new ArrayList<MCostElement>();
    private StringBuffer deleteCostDetailWhereClause;
    private StringBuffer resetCostWhereClause;
    private List<Integer> deferredTransactionIds = new ArrayList<Integer>();
    private List<Integer> deferredProductIds = new ArrayList<Integer>();

    @Override
    protected void prepare() {
        ProcessInfoParameter[] parameters;
        for (ProcessInfoParameter parameter : parameters = this.getParameter()) {
            String name = parameter.getParameterName();
            if (parameter.getParameter() == null) {
                // empty if block
            }
            if (name.equals("C_AcctSchema_ID")) {
                this.p_C_AcctSchema_ID = parameter.getParameterAsInt();
                continue;
            }
            if (name.equals("M_CostType_ID")) {
                this.p_M_CostType_ID = parameter.getParameterAsInt();
                continue;
            }
            if (name.equals("M_CostElement_ID")) {
                this.p_M_CostElement_ID = parameter.getParameterAsInt();
                continue;
            }
            if (name.equals("M_Product_ID")) {
                this.p_M_Product_ID = parameter.getParameterAsInt();
                continue;
            }
            if (!name.equals("DateAcct")) continue;
            this.p_DateAcct = (Timestamp)parameter.getParameter();
            if (this.p_DateAcct == null) {
                throw new FillMandatoryException(new String[]{"DateAcct"});
            }
            this.p_DateAcctTo = (Timestamp)parameter.getParameter_To();
            if (this.p_DateAcctTo != null) continue;
            this.p_DateAcctTo = new Timestamp(System.currentTimeMillis());
        }
        if (this.p_DateAcct != null) {
            this.setup();
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.generateCostDetail();
        return "@Ok@";
    }

    private void deleteCostDetail(String trxName) throws SQLException {
        int record = 0;
        StringBuffer sqlDelete = new StringBuffer("DELETE M_CostDetail WHERE ");
        sqlDelete.append(this.deleteCostDetailWhereClause);
        record = DB.executeUpdateEx(sqlDelete.toString(), this.deleteParameters.toArray(), trxName);
    }

    private void resetCostDimension(String costingMethod, String trxName) throws SQLException {
        int record = 0;
        StringBuffer sqlReset = new StringBuffer("UPDATE M_Cost SET ");
        if ("I".equals(costingMethod)) {
            sqlReset.append("CurrentCostPrice").append("=0.0,");
            sqlReset.append("CurrentCostPriceLL").append("= 0.0,");
        }
        sqlReset.append("CurrentQty").append("= 0.0,");
        sqlReset.append("CumulatedAmt").append("= 0.0,");
        sqlReset.append("CumulatedAmtLL").append("= 0.0,");
        sqlReset.append("CumulatedQty").append("= 0.0 ");
        sqlReset.append(" WHERE ").append(this.resetCostWhereClause);
        record = DB.executeUpdateEx(sqlReset.toString(), this.resetCostParameters.toArray(), trxName);
    }

    private void setup() {
        if (this.p_C_AcctSchema_ID > 0) {
            this.acctSchemas.add(MAcctSchema.get(this.getCtx(), this.p_C_AcctSchema_ID, this.get_TrxName()));
        } else {
            this.acctSchemas = new ArrayList<MAcctSchema>(Arrays.asList(MAcctSchema.getClientAcctSchema(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName())));
        }
        if (this.p_M_CostType_ID > 0) {
            this.costTypes.add(new MCostType(this.getCtx(), this.p_M_CostType_ID, this.get_TrxName()));
        } else {
            this.costTypes = MCostType.get(this.getCtx(), this.get_TrxName());
        }
        if (this.p_M_CostElement_ID > 0) {
            this.costElements.add(MCostElement.get(this.getCtx(), this.p_M_CostElement_ID));
        } else {
            this.costElements = MCostElement.getCostElement(this.getCtx(), this.get_TrxName());
        }
    }

    private void applyCriteria(int accountSchemaId, int costTypeId, int costElementId, int productId, Timestamp dateAccount, Timestamp dateAccountTo) {
        this.deleteParameters = new ArrayList();
        this.resetCostParameters = new ArrayList();
        this.deleteCostDetailWhereClause = new StringBuffer("1=1");
        this.resetCostWhereClause = new StringBuffer("1=1");
        if (accountSchemaId > 0) {
            this.deleteCostDetailWhereClause.append(" AND ").append("C_AcctSchema_ID").append("=? ");
            this.deleteParameters.add(accountSchemaId);
            this.resetCostWhereClause.append(" AND ").append("C_AcctSchema_ID").append("=? ");
            this.resetCostParameters.add(accountSchemaId);
        }
        if (costTypeId > 0) {
            this.deleteCostDetailWhereClause.append(" AND ").append("M_CostType_ID").append("=? ");
            this.deleteParameters.add(costTypeId);
            this.resetCostWhereClause.append(" AND ").append("M_CostType_ID").append("=? ");
            this.resetCostParameters.add(costTypeId);
        }
        if (costElementId > 0) {
            this.deleteCostDetailWhereClause.append(" AND ").append("M_CostElement_ID").append("=? ");
            this.deleteParameters.add(costElementId);
            this.resetCostWhereClause.append(" AND ").append("M_CostElement_ID").append("=? ");
            this.resetCostParameters.add(costElementId);
        }
        if (productId > 0) {
            this.deleteCostDetailWhereClause.append(" AND ").append("M_Product_ID").append("=? ");
            this.deleteParameters.add(productId);
            this.resetCostWhereClause.append(" AND ").append("M_Product_ID").append("=? ");
            this.resetCostParameters.add(productId);
        }
        if (dateAccount != null) {
            this.deleteCostDetailWhereClause.append(" AND ").append("DateAcct").append(">=? ");
            this.deleteParameters.add(dateAccount);
        }
        if (dateAccountTo != null) {
            this.deleteCostDetailWhereClause.append(" AND ").append("DateAcct").append("<=? ");
            this.deleteParameters.add(dateAccountTo);
        }
        this.resetCostWhereClause.append(" AND EXISTS ( SELECT 1 FROM RV_Transaction WHERE M_Product_ID=? AND TRUNC(DateAcct)>=? AND TRUNC(DateAcct)<=?)");
        this.resetCostParameters.add(productId);
        this.resetCostParameters.add(dateAccount);
        this.resetCostParameters.add(dateAccountTo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateCostDetail() {
        KeyNamePair[] transactions = this.getTransactionIdsByDateAcct();
        Integer process = 0;
        Integer productId = 0;
        boolean processNewProduct = true;
        Trx dbTransaction = null;
        try {
            for (KeyNamePair keyNamePair : transactions) {
                int transactionId = keyNamePair.getKey();
                int transactionProductId = new Integer(keyNamePair.getName());
                if (productId != transactionProductId) {
                    if (dbTransaction != null) {
                        dbTransaction.commit(true);
                        dbTransaction.close();
                    }
                    productId = transactionProductId;
                    processNewProduct = true;
                    dbTransaction = Trx.get(productId.toString(), true);
                    MProduct product = new MProduct(Env.getCtx(), productId, dbTransaction.getTrxName());
                }
                MTransaction transaction = new MTransaction(this.getCtx(), transactionId, dbTransaction.getTrxName());
                for (MAcctSchema mAcctSchema : this.acctSchemas) {
                    for (MCostType costType : this.costTypes) {
                        for (MCostElement costElement : this.costElements) {
                            if (processNewProduct) {
                                this.applyCriteria(mAcctSchema.getC_AcctSchema_ID(), costType.getM_CostType_ID(), costElement.getM_CostElement_ID(), productId, this.p_DateAcct, this.p_DateAcctTo);
                                this.deleteCostDetail(dbTransaction.getTrxName());
                                this.resetCostDimension(costType.getCostingMethod(), dbTransaction.getTrxName());
                                this.generateCostCollectorNotTransaction(productId, dbTransaction.getTrxName());
                                processNewProduct = false;
                                if (("I".equals(costType.getCostingMethod()) || "A".equals(costType.getCostingMethod())) && this.IsUsedInProduction(productId, dbTransaction.getTrxName())) {
                                    this.deferredProductIds.add(productId);
                                }
                            }
                            if (this.deferredProductIds.contains(transaction.getM_Product_ID())) {
                                this.deferredTransactionIds.add(transactionId);
                                continue;
                            }
                            this.generateCostDetail(mAcctSchema, costType, costElement, transaction);
                        }
                    }
                }
                Iterator<MCostElement> i$ = process;
                Integer n = process = Integer.valueOf(process + 1);
            }
            if (dbTransaction != null) {
                dbTransaction.commit(true);
                dbTransaction.close();
                dbTransaction = null;
            }
            Comparator<Integer> orderTransaction = new Comparator<Integer>(){

                @Override
                public int compare(Integer t1, Integer t2) {
                    return t2.compareTo(t1);
                }
            };
            Collections.sort(this.deferredTransactionIds, orderTransaction);
            for (Integer transactionId : this.deferredTransactionIds) {
                for (MAcctSchema accountSchema : this.acctSchemas) {
                    for (MCostType costType : this.costTypes) {
                        if (!"I".equals(costType.getCostingMethod()) && !"A".equals(costType.getCostingMethod())) continue;
                        for (MCostElement mCostElement : this.costElements) {
                            int transactionProductId = DB.getSQLValue(this.get_TrxName(), "SELECT M_Product_ID FROM M_Transaction WHERE M_Transaction_ID=?", transactionId);
                            if (productId != transactionProductId) {
                                if (dbTransaction != null) {
                                    dbTransaction.commit(true);
                                    dbTransaction.close();
                                }
                                productId = transactionProductId;
                                dbTransaction = Trx.get(productId.toString(), true);
                                MProduct product = MProduct.get(Env.getCtx(), productId);
                            }
                            MTransaction transaction = new MTransaction(this.getCtx(), transactionId, dbTransaction.getTrxName());
                            this.generateCostDetail(accountSchema, costType, mCostElement, transaction);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            if (dbTransaction != null) {
                dbTransaction.rollback();
                dbTransaction.close();
                dbTransaction = null;
                e.printStackTrace();
            }
        }
        finally {
            if (dbTransaction != null) {
                dbTransaction.commit();
                dbTransaction.close();
                dbTransaction = null;
            }
        }
    }

    private boolean IsUsedInProduction(int productId, String trxName) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("M_Product_ID").append("=? AND ");
        whereClause.append("MovementType").append("=?");
        return new Query(this.getCtx(), "M_Transaction", whereClause.toString(), trxName).setClient_ID().setParameters(productId, "P+").match();
    }

    public void generateCostDetail(MAcctSchema accountSchema, MCostType costType, MCostElement costElement, MTransaction transaction) {
        CostEngineFactory.getCostEngine(accountSchema.getAD_Client_ID()).createCostDetail(accountSchema, costType, costElement, transaction, transaction.getDocumentLine(), true);
        CostEngineFactory.getCostEngine(accountSchema.getAD_Client_ID()).clearAccounting(accountSchema, transaction);
        if ("V+".equals(transaction.getMovementType())) {
            MInOutLine line = (MInOutLine)transaction.getDocumentLine();
            if ("M".equals(costElement.getCostElementType())) {
                List<MMatchPO> orderMatches = MMatchPO.getInOutLine(line);
                for (MMatchPO match : orderMatches) {
                    if (match.getM_Product_ID() != transaction.getM_Product_ID()) continue;
                    CostEngineFactory.getCostEngine(accountSchema.getAD_Client_ID()).createCostDetail(accountSchema, costType, costElement, transaction, match, true);
                }
                List<MMatchInv> invoiceMatches = MMatchInv.getInOutLine(line);
                for (MMatchInv match : invoiceMatches) {
                    if (match.getM_Product_ID() != transaction.getM_Product_ID()) continue;
                    CostEngineFactory.getCostEngine(accountSchema.getAD_Client_ID()).createCostDetail(accountSchema, costType, costElement, transaction, match, true);
                }
            }
            for (MLandedCostAllocation allocation : MLandedCostAllocation.getOfInOuline(line, costElement.getM_CostElement_ID())) {
                CostEngineFactory.getCostEngine(accountSchema.getAD_Client_ID()).createCostDetail(accountSchema, costType, costElement, transaction, allocation, true);
            }
        }
    }

    private void generateCostCollectorNotTransaction(int productId, String trxName) throws SQLException {
        List<MPPCostCollector> costCollectors = MPPCostCollector.getCostCollectorNotTransaction(this.getCtx(), productId, this.getAD_Client_ID(), this.p_DateAcct, trxName);
        for (MPPCostCollector costCollector : costCollectors) {
            for (MCostDetail costDetail : MCostDetail.getByCollectorCost(costCollector)) {
                costDetail.deleteEx(true);
            }
            StandardCostingMethod standardCostingMethod = (StandardCostingMethod)CostingMethodFactory.get().getCostingMethod("S");
            if ("120".equals(costCollector.getCostCollectorType())) {
                standardCostingMethod.createUsageVariances(costCollector);
                continue;
            }
            if ("130".equals(costCollector.getCostCollectorType())) {
                standardCostingMethod.createMethodVariances(costCollector);
                continue;
            }
            if ("140".equals(costCollector.getCostCollectorType())) {
                standardCostingMethod.createRateVariances(costCollector);
                continue;
            }
            if (!"160".equals(costCollector.getCostCollectorType())) continue;
            standardCostingMethod.createActivityControl(costCollector);
        }
    }

    private KeyNamePair[] getTransactionIdsByDateAcct() {
        StringBuilder sql = new StringBuilder();
        ArrayList<Comparable<Integer>> parameters = new ArrayList<Comparable<Integer>>();
        StringBuilder whereClause = new StringBuilder("WHERE ");
        whereClause.append("AD_Client_ID").append("=").append(this.getAD_Client_ID()).append(" AND ");
        if (this.p_M_Product_ID > 0) {
            whereClause.append("M_Product_ID").append("=?").append(" AND ");
            parameters.add(Integer.valueOf(this.p_M_Product_ID));
        }
        whereClause.append("TRUNC(").append("DateAcct").append(")>=?");
        parameters.add(this.p_DateAcct);
        if (this.p_DateAcctTo != null) {
            whereClause.append(" AND TRUNC(").append("DateAcct").append(")<=?");
            parameters.add(this.p_DateAcctTo);
        }
        sql.append("SELECT M_Transaction_ID , M_Product_ID FROM RV_Transaction ").append((CharSequence)whereClause).append(" ORDER BY M_Product_ID ,  TRUNC( DateAcct ) , M_Transaction_ID , SUBSTR(MovementType,2,1) ");
        return DB.getKeyNamePairs(this.get_TrxName(), sql.toString(), false, parameters.toArray());
    }
}

