/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import org.compiere.model.MProduct;
import org.compiere.model.MSequence;
import org.compiere.model.MUOM;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.engine.forecast.DataElement;
import org.eevolution.engine.forecast.DataSet;
import org.eevolution.engine.forecast.ForecastEngine;
import org.eevolution.engine.forecast.ForecastFactory;
import org.eevolution.model.MPPForecastDefinition;
import org.eevolution.model.MPPForecastDefinitionLine;
import org.eevolution.model.MPPForecastRule;
import org.eevolution.model.MPPForecastRun;
import org.eevolution.model.MPPForecastRunDetail;
import org.eevolution.model.MPPForecastRunMaster;
import org.eevolution.model.MPPForecastRunResult;
import org.eevolution.model.MPPPeriod;
import org.eevolution.model.MPPPeriodDefinition;

public class ForecastRunCreate
extends SvrProcess {
    private int p_PP_ForecastRun_ID = 0;
    private MPPForecastRun m_run = null;
    private MPPPeriodDefinition m_period_definition_base = null;
    private MPPPeriodDefinition m_period_definition_target = null;
    private MPPForecastDefinition m_forecast_definition = null;
    private MPPForecastRule m_forecast_rule = null;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter para : this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_PP_ForecastRun_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        this.m_run = new MPPForecastRun(this.getCtx(), this.p_PP_ForecastRun_ID, this.get_TrxName());
        this.m_forecast_definition = (MPPForecastDefinition)this.m_run.getPP_ForecastDefinition();
        if (this.m_run.get_ID() == 0) {
            throw new IllegalArgumentException("@NotFound@ @PP_ForecastRun_ID@");
        }
        if (this.m_forecast_definition.get_ID() == 0) {
            throw new IllegalArgumentException("@NotFound@ @PP_ForecastDefinition_ID@");
        }
        if (!this.m_run.deleteEntries(true)) {
            throw new IllegalArgumentException("Cannot delete existing entries");
        }
        return "@PP_ForecastRunMaster_ID@ #" + this.generateForecastResult(this.m_run.getM_Warehouse_ID());
    }

    private int generateForecastResult(int M_Warehouse_ID) {
        this.deleteData();
        this.m_period_definition_base = new MPPPeriodDefinition(this.getCtx(), this.m_run.getRef_DefinitionPeriod_ID(), this.get_TrxName());
        this.m_period_definition_target = new MPPPeriodDefinition(this.getCtx(), this.m_run.getPP_PeriodDefinition_ID(), this.get_TrxName());
        this.m_forecast_rule = (MPPForecastRule)this.m_run.getPP_ForecastRule();
        List<MPPPeriod> m_period_history = this.m_period_definition_base.getPeriodsOfHistory(this.m_run.getPeriodHistory());
        int selection = this.generateForecastRunMaster(this.m_run, this.m_forecast_definition, m_period_history.get(m_period_history.size() - 1), m_period_history.get(0));
        if (selection <= 0) {
            throw new IllegalArgumentException("@FindZeroRecords@");
        }
        for (MPPForecastRunMaster master : MPPForecastRunMaster.getLines(this.getCtx(), this.p_PP_ForecastRun_ID, this.get_TrxName())) {
            for (MPPPeriod period : m_period_history) {
                this.createForecastRunDetail(master, period);
            }
        }
        return this.createForecastRunResult(M_Warehouse_ID);
    }

    private int createForecastRunResult(int M_Warehouse_ID) {
        int records = 0;
        ForecastEngine engine = ForecastFactory.getForecastEngine(this.getAD_Client_ID());
        for (MPPForecastRunMaster master : MPPForecastRunMaster.getLines(this.getCtx(), this.p_PP_ForecastRun_ID, this.get_TrxName())) {
            DataSet series = new DataSet();
            series.setPeriods(this.m_run.getPeriodHistory());
            MProduct product = MProduct.get(this.getCtx(), master.getM_Product_ID());
            List<MPPForecastRunDetail> details = MPPForecastRunMaster.getDetails(this.getCtx(), master.get_ID(), this.get_TrxName());
            for (MPPForecastRunDetail detail : details) {
                MPPPeriod period = (MPPPeriod)detail.getPP_Period();
                DataElement data = new DataElement(master.get_ID(), period.getPeriodNo(), detail.getQtyCalculated(), null);
                series.addDataElement(data);
            }
            DataSet results = engine.getForecast(this.m_forecast_rule.getCalculationClass(), master.get_ID(), series, master.getFactorAlpha().doubleValue(), master.getFactorGamma().doubleValue(), master.getFactorBeta().doubleValue(), master.getFactorMultiplier().doubleValue(), master.getFactorScale().doubleValue(), master.getFactorUser().doubleValue());
            Enumeration<DataElement> elements = results.getDataElements();
            while (elements.hasMoreElements()) {
                DataElement element = elements.nextElement();
                MUOM uom = (MUOM)product.getC_UOM();
                MPPForecastRunResult result = new MPPForecastRunResult(this.getCtx(), 0, this.get_TrxName());
                result.setPP_ForecastRun_ID(this.m_run.get_ID());
                result.setPP_ForecastRunMaster_ID(element.getKey());
                result.setDescription(element.getDescription());
                BigDecimal qty = (BigDecimal)element.getValue();
                result.setQtyCalculated(qty);
                result.setQtyPlan(uom.round(qty, true));
                result.setIsActive(true);
                result.setPP_Period_ID(MPPPeriod.getIDByPeriodNo(this.m_period_definition_target, element.getPeriodNo()));
                result.setPeriodNo(element.getPeriodNo());
                result.saveEx();
                ++records;
            }
        }
        return records;
    }

    private void createForecastRunDetail(MPPForecastRunMaster master, MPPPeriod period) {
        MPPForecastRunDetail forecastRunDetail = new MPPForecastRunDetail(this.getCtx(), 0, this.get_TrxName());
        forecastRunDetail.setPP_ForecastRun_ID(this.m_run.get_ID());
        forecastRunDetail.setPP_ForecastRunMaster_ID(master.getPP_ForecastRunMaster_ID());
        forecastRunDetail.setPP_Period_ID(period.get_ID());
        forecastRunDetail.setPeriodNo(period.getPeriodNo());
        forecastRunDetail.saveEx();
        this.generateForcastRunLines(forecastRunDetail);
        this.updateDetail(period.get_ID(), forecastRunDetail.get_ID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int generateForecastRunMaster(MPPForecastRun run, MPPForecastDefinition fd, MPPPeriod start, MPPPeriod end) {
        int count = 0;
        for (MPPForecastDefinitionLine fdl : fd.getLines(true)) {
            StringBuffer select = new StringBuffer("SELECT DISTINCT sh.M_Product_ID , sh.M_Warehouse_ID FROM C_SalesHistory sh LEFT JOIN  PP_ForecastRunMaster m ON (m.M_Product_ID=sh.M_Product_ID AND ");
            select.append("PP_ForecastRun_ID");
            select.append("=").append(run.get_ID()).append(" ) WHERE  ");
            select.append(fdl.getSQlWhere(run.getM_WarehouseSource_ID(), "sh"));
            select.append("DateInvoiced");
            select.append(" BETWEEN ");
            select.append(DB.TO_DATE(start.getStartDate()));
            select.append(" AND ");
            select.append(DB.TO_DATE(end.getEndDate()));
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement(select.toString(), this.get_TrxName());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ++count;
                    int M_Product_ID = rs.getInt("M_Product_ID");
                    MPPForecastRunMaster master = MPPForecastRunMaster.getByProduct(this.getCtx(), run.getPP_ForecastRun_ID(), M_Product_ID, this.get_TrxName());
                    if (master != null) continue;
                    master = new MPPForecastRunMaster(this.getCtx(), 0, this.get_TrxName());
                    master.setAD_Org_ID(run.getAD_Org_ID());
                    master.setPP_ForecastRun_ID(run.get_ID());
                    master.setPP_ForecastDefinitionLine_ID(fdl.getPP_ForecastDefinitionLine_ID());
                    master.setM_Product_ID(M_Product_ID);
                    master.setM_Warehouse_ID(run.getM_Warehouse_ID());
                    master.setFactorAlpha(fdl.getFactorAlpha());
                    master.setFactorGamma(fdl.getFactorGamma());
                    master.setFactorBeta(fdl.getFactorBeta());
                    master.setFactorMultiplier(fdl.getFactorMultiplier());
                    master.setFactorScale(fdl.getFactorScale());
                    master.setFactorUser(fdl.getFactorUser());
                    master.saveEx();
                }
            }
            catch (Exception e) {
                try {
                    this.log.log(Level.SEVERE, select.toString(), e);
                    this.getProcessInfo().addLog(this.getProcessInfo().getAD_PInstance_ID(), null, null, e.getLocalizedMessage());
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                continue;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return count;
    }

    public int generateForcastRunLines(MPPForecastRunDetail frd) {
        ArrayList<Comparable<Integer>> parameters = new ArrayList<Comparable<Integer>>();
        StringBuffer insertSQL = new StringBuffer();
        MPPPeriod period = (MPPPeriod)frd.getPP_Period();
        insertSQL.append("INSERT INTO ").append("PP_ForecastRunLine").append(" frl (");
        insertSQL.append("PP_ForecastRunLine_ID").append(",");
        insertSQL.append("PP_ForecastRun_ID").append(",");
        insertSQL.append("PP_ForecastRunDetail_ID").append(",");
        insertSQL.append("AD_Client_ID").append(",");
        insertSQL.append("AD_Org_ID").append(",");
        insertSQL.append("C_SalesHistory_ID").append(",");
        insertSQL.append("PP_Period_ID").append(",");
        insertSQL.append("Created").append(",");
        insertSQL.append("CreatedBy").append(",");
        insertSQL.append("Updated").append(",");
        insertSQL.append("UpdatedBy").append(")");
        insertSQL.append(" SELECT DISTINCT ");
        insertSQL.append("nextidfunc(").append(MSequence.get(this.getCtx(), "PP_ForecastRunLine").get_ID()).append(",'Y')").append(",");
        insertSQL.append(frd.getPP_ForecastRun_ID()).append(",");
        insertSQL.append(frd.getPP_ForecastRunDetail_ID()).append(",");
        insertSQL.append("AD_Client_ID").append(",");
        insertSQL.append("AD_Org_ID").append(",");
        insertSQL.append("C_SalesHistory_ID").append(",");
        insertSQL.append(period.getPP_Period_ID()).append(",");
        insertSQL.append("SYSDATE").append(",");
        insertSQL.append(Env.getAD_User_ID(this.getCtx())).append(",");
        insertSQL.append("SYSDATE").append(",");
        insertSQL.append(Env.getAD_User_ID(this.getCtx()));
        insertSQL.append(" FROM ").append("C_SalesHistory");
        insertSQL.append(" WHERE ");
        insertSQL.append("M_Product_ID").append("=? AND ");
        insertSQL.append("M_Warehouse_ID").append("=? AND ");
        insertSQL.append("DateInvoiced").append(" BETWEEN ? AND ? ");
        parameters.add(Integer.valueOf(frd.getPP_ForecastRunMaster().getM_Product_ID()));
        parameters.add(Integer.valueOf(this.m_run.getM_WarehouseSource_ID()));
        parameters.add(period.getStartDate());
        parameters.add(period.getEndDate());
        return DB.executeUpdateEx(insertSQL.toString(), parameters.toArray(), this.get_TrxName());
    }

    public void updateDetail(int PP_Period_ID, int PP_ForecastRunDetail_ID) {
        StringBuffer updateSQL = new StringBuffer();
        updateSQL.append("UPDATE PP_ForecastRunDetail frd SET");
        updateSQL.append(" QtyCalculated=(");
        updateSQL.append(" SELECT SUM(sh.Qty) AS Qty");
        updateSQL.append(" FROM PP_ForecastRunLine frl");
        updateSQL.append(" INNER JOIN C_SalesHistory sh ");
        updateSQL.append(" ON (sh.C_SalesHistory_ID=frl.C_SalesHistory_ID)");
        updateSQL.append(" WHERE frl.PP_ForecastRunDetail_ID=").append(PP_ForecastRunDetail_ID);
        updateSQL.append(" ),");
        updateSQL.append(" PP_Period_ID=").append(PP_Period_ID);
        updateSQL.append(" WHERE frd.PP_ForecastRunDetail_ID=").append(PP_ForecastRunDetail_ID);
        DB.executeUpdateEx(updateSQL.toString(), this.get_TrxName());
    }

    public void deleteData() {
        StringBuffer updateSQL = new StringBuffer();
        updateSQL.append("DELETE FROM PP_ForecastRunLine WHERE PP_ForecastRun_ID=").append(this.p_PP_ForecastRun_ID);
        DB.executeUpdateEx(updateSQL.toString(), this.get_TrxName());
        updateSQL = new StringBuffer();
        updateSQL.append("DELETE FROM PP_ForecastRunDetail WHERE PP_ForecastRun_ID=").append(this.p_PP_ForecastRun_ID);
        DB.executeUpdateEx(updateSQL.toString(), this.get_TrxName());
        updateSQL = new StringBuffer();
        updateSQL.append("DELETE FROM PP_ForecastRunResult WHERE PP_ForecastRun_ID=").append(this.p_PP_ForecastRun_ID);
        DB.executeUpdateEx(updateSQL.toString(), this.get_TrxName());
        updateSQL = new StringBuffer();
        updateSQL.append("DELETE FROM PP_ForecastRunMaster WHERE PP_ForecastRun_ID=").append(this.p_PP_ForecastRun_ID);
        DB.executeUpdateEx(updateSQL.toString(), this.get_TrxName());
    }
}

