/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MBankAccount;
import org.compiere.model.MPayment;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.Env;

public class BankTransfer
extends SvrProcess {
    private String p_DocumentNo = "";
    private String p_Description = "";
    private int p_C_BPartner_ID = 0;
    private int p_C_Currency_ID = 0;
    private int p_C_ConversionType_ID = 0;
    private int p_C_Charge_ID = 0;
    private BigDecimal p_Amount = new BigDecimal(0);
    private int p_From_C_BankAccount_ID = 0;
    private int p_To_C_BankAccount_ID = 0;
    private Timestamp p_StatementDate = null;
    private Timestamp p_DateAcct = null;
    private int m_created = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (name.equals("From_C_BankAccount_ID")) {
                this.p_From_C_BankAccount_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("To_C_BankAccount_ID")) {
                this.p_To_C_BankAccount_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("C_Currency_ID")) {
                this.p_C_Currency_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("C_ConversionType_ID")) {
                this.p_C_ConversionType_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("C_Charge_ID")) {
                this.p_C_Charge_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("DocumentNo")) {
                this.p_DocumentNo = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("Amount")) {
                this.p_Amount = (BigDecimal)para[i2].getParameter();
                continue;
            }
            if (name.equals("Description")) {
                this.p_Description = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("StatementDate")) {
                this.p_StatementDate = (Timestamp)para[i2].getParameter();
                continue;
            }
            if (name.equals("DateAcct")) {
                this.p_DateAcct = (Timestamp)para[i2].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("From Bank=" + this.p_From_C_BankAccount_ID + " - To Bank=" + this.p_To_C_BankAccount_ID + " - C_BPartner_ID=" + this.p_C_BPartner_ID + "- C_Charge_ID= " + this.p_C_Charge_ID + " - Amount=" + this.p_Amount + " - DocumentNo=" + this.p_DocumentNo + " - Description=" + this.p_Description + " - Statement Date=" + this.p_StatementDate + " - Date Account=" + this.p_DateAcct);
        if (this.p_To_C_BankAccount_ID == 0 || this.p_From_C_BankAccount_ID == 0) {
            throw new IllegalArgumentException("Banks required");
        }
        if (this.p_DocumentNo == null || this.p_DocumentNo.length() == 0) {
            throw new IllegalArgumentException("Document No required");
        }
        if (this.p_To_C_BankAccount_ID == this.p_From_C_BankAccount_ID) {
            throw new AdempiereUserError("Banks From and To must be different");
        }
        if (this.p_C_BPartner_ID == 0) {
            throw new AdempiereUserError("Business Partner required");
        }
        if (this.p_C_Currency_ID == 0) {
            throw new AdempiereUserError("Currency required");
        }
        if (this.p_C_Charge_ID == 0) {
            throw new AdempiereUserError("Business Partner required");
        }
        if (this.p_Amount.compareTo(new BigDecimal(0)) == 0) {
            throw new AdempiereUserError("Amount required");
        }
        if (this.p_StatementDate == null) {
            this.p_StatementDate = Env.getContextAsDate(this.getCtx(), "#Date");
        }
        if (this.p_StatementDate == null) {
            this.p_StatementDate = new Timestamp(System.currentTimeMillis());
        }
        if (this.p_DateAcct == null) {
            this.p_DateAcct = this.p_StatementDate;
        }
        this.generateBankTransfer();
        return "@Created@ = " + this.m_created;
    }

    private void generateBankTransfer() {
        MBankAccount mBankFrom = new MBankAccount(this.getCtx(), this.p_From_C_BankAccount_ID, this.get_TrxName());
        MBankAccount mBankTo = new MBankAccount(this.getCtx(), this.p_To_C_BankAccount_ID, this.get_TrxName());
        MPayment paymentBankFrom = new MPayment(this.getCtx(), 0, this.get_TrxName());
        paymentBankFrom.setC_BankAccount_ID(mBankFrom.getC_BankAccount_ID());
        paymentBankFrom.setDocumentNo(this.p_DocumentNo);
        paymentBankFrom.setDateAcct(this.p_DateAcct);
        paymentBankFrom.setDateTrx(this.p_StatementDate);
        paymentBankFrom.setTenderType("A");
        paymentBankFrom.setDescription(this.p_Description);
        paymentBankFrom.setC_BPartner_ID(this.p_C_BPartner_ID);
        paymentBankFrom.setC_Currency_ID(this.p_C_Currency_ID);
        if (this.p_C_ConversionType_ID > 0) {
            paymentBankFrom.setC_ConversionType_ID(this.p_C_ConversionType_ID);
        }
        paymentBankFrom.setPayAmt(this.p_Amount);
        paymentBankFrom.setOverUnderAmt(Env.ZERO);
        paymentBankFrom.setC_DocType_ID(false);
        paymentBankFrom.setC_Charge_ID(this.p_C_Charge_ID);
        paymentBankFrom.saveEx();
        paymentBankFrom.processIt("CO");
        paymentBankFrom.saveEx();
        MPayment paymentBankTo = new MPayment(this.getCtx(), 0, this.get_TrxName());
        paymentBankTo.setC_BankAccount_ID(mBankTo.getC_BankAccount_ID());
        paymentBankTo.setDocumentNo(this.p_DocumentNo);
        paymentBankTo.setDateAcct(this.p_DateAcct);
        paymentBankTo.setDateTrx(this.p_StatementDate);
        paymentBankTo.setTenderType("A");
        paymentBankTo.setDescription(this.p_Description);
        paymentBankTo.setC_BPartner_ID(this.p_C_BPartner_ID);
        paymentBankTo.setC_Currency_ID(this.p_C_Currency_ID);
        if (this.p_C_ConversionType_ID > 0) {
            paymentBankFrom.setC_ConversionType_ID(this.p_C_ConversionType_ID);
        }
        paymentBankTo.setPayAmt(this.p_Amount);
        paymentBankTo.setOverUnderAmt(Env.ZERO);
        paymentBankTo.setC_DocType_ID(true);
        paymentBankTo.setC_Charge_ID(this.p_C_Charge_ID);
        paymentBankTo.saveEx();
        paymentBankTo.processIt("CO");
        paymentBankTo.saveEx();
        ++this.m_created;
    }
}

