/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MDocType;
import org.compiere.model.MProduct;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.eevolution.model.MWMInOutBoundLine;
import org.eevolution.model.X_WM_InOutBound;

public class MWMInOutBound
extends X_WM_InOutBound
implements DocAction {
    private static final long serialVersionUID = -7216075035497599383L;
    private static CLogger s_log = CLogger.getCLogger(MWMInOutBound.class);
    private MWMInOutBoundLine[] m_lines = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MWMInOutBound(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setIsApproved(false);
            this.setIsInTransit(false);
            this.setIsPrinted(false);
            this.setSendEMail(false);
        }
    }

    public MWMInOutBound(Properties properties, int n) {
        this(properties, n, null);
    }

    public MWMInOutBound(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("MInOutBound[").append(this.get_ID()).append("-").append("").append("]");
        return stringBuffer.toString();
    }

    @Override
    public boolean approveIt() {
        this.setIsApproved(true);
        return true;
    }

    @Override
    public File createPDF() {
        try {
            File file = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(file);
        }
        catch (Exception exception) {
            this.log.severe("Could not create PDF - " + exception.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return Env.ZERO;
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    @Override
    public String getDocumentInfo() {
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return mDocType.getName() + " " + this.getDocumentNo();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public String getSummary() {
        return "" + this.getDocumentNo() + "/";
    }

    @Override
    public boolean processIt(String string) {
        this.m_processMsg = null;
        DocumentEngine documentEngine = new DocumentEngine(this, this.getDocStatus());
        return documentEngine.processIt(string, this.getDocAction());
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType mDocType = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        MWMInOutBoundLine[] mWMInOutBoundLineArray = this.getLines(true, "Line");
        if (mWMInOutBoundLineArray.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        if (this.getDeliveryRule() != null && this.getDeliveryRule().equals("D")) {
            for (MWMInOutBoundLine mWMInOutBoundLine : mWMInOutBoundLineArray) {
                MProduct mProduct = mWMInOutBoundLine.getMProduct();
                if (mProduct == null || !mProduct.isExcludeAutoDelivery()) continue;
                this.m_processMsg = "@M_Product_ID@ " + mProduct.getValue() + " @IsExcludeAutoDelivery@";
                return "IN";
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        return "IP";
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        if (this.isProcessed()) {
            return false;
        }
        for (MWMInOutBoundLine mWMInOutBoundLine : this.getLines(true, null)) {
            mWMInOutBoundLine.deleteEx(true);
        }
        return true;
    }

    @Override
    public boolean unlockIt() {
        this.log.info(this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info(this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        MWMInOutBoundLine[] mWMInOutBoundLineArray;
        if ("PR".equals(this.getDocAction())) {
            this.setProcessed(false);
            return "IP";
        }
        if (!this.m_justPrepared && !"IP".equals(mWMInOutBoundLineArray = this.prepareIt())) {
            return mWMInOutBoundLineArray;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.setProcessed(true);
        for (MWMInOutBoundLine mWMInOutBoundLine : mWMInOutBoundLineArray = this.getLines(true, "Line")) {
            mWMInOutBoundLine.setProcessed(true);
            mWMInOutBoundLine.saveEx();
        }
        this.setDocAction("CL");
        String string = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (string != null) {
            this.m_processMsg = string;
            return "IN";
        }
        return "CO";
    }

    @Override
    public boolean voidIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocStatus("CL");
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        return this.voidIt();
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    public MWMInOutBoundLine[] getLines(boolean bl, String string) {
        if (this.m_lines != null && !bl) {
            MWMInOutBound.set_TrxName(this.m_lines, this.get_TrxName());
            return this.m_lines;
        }
        String string2 = "";
        string2 = string != null && string.length() > 0 ? string2 + string : string2 + "Line";
        this.m_lines = this.getLines(null, string2);
        return this.m_lines;
    }

    public MWMInOutBoundLine[] getLines(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("WM_InOutBound_ID=?");
        if (!Util.isEmpty(string, true)) {
            stringBuffer.append(stringBuffer);
        }
        if (string2.length() == 0) {
            string2 = "Line";
        }
        List<MWMInOutBoundLine> list = new Query(this.getCtx(), "WM_InOutBoundLine", stringBuffer.toString(), this.get_TrxName()).setParameters(this.get_ID()).setOrderBy(string2).list();
        return list.toArray(new MWMInOutBoundLine[list.size()]);
    }
}

