/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MResource;
import org.compiere.model.Query;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.wf.MWorkflow;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.X_PP_Product_Planning;

public class MPPProductPlanning
extends X_PP_Product_Planning {
    private static final long serialVersionUID = -3061309620804116277L;
    private static CLogger log = CLogger.getCLogger(MPPProductPlanning.class);
    private int m_C_BPartner_ID = 0;

    public MPPProductPlanning(Properties ctx, int pp_product_planning_id, String trxname) {
        super(ctx, pp_product_planning_id, trxname);
        if (pp_product_planning_id == 0) {
            // empty if block
        }
    }

    public MPPProductPlanning(Properties ctx, ResultSet rs, String trxname) {
        super(ctx, rs, trxname);
    }

    public static MPPProductPlanning get(Properties ctx, int ad_client_id, int ad_org_id, int m_product_id, String trxName) {
        int M_Warehouse_ID = MOrgInfo.get(ctx, ad_org_id, trxName).getM_Warehouse_ID();
        if (M_Warehouse_ID <= 0) {
            return null;
        }
        int S_Resource_ID = MPPProductPlanning.getPlantForWarehouse(M_Warehouse_ID);
        if (S_Resource_ID <= 0) {
            return null;
        }
        return MPPProductPlanning.get(ctx, ad_client_id, ad_org_id, M_Warehouse_ID, S_Resource_ID, m_product_id, trxName);
    }

    public static MPPProductPlanning get(Properties ctx, int ad_client_id, int ad_org_id, int m_warehouse_id, int s_resource_id, int m_product_id, String trxname) {
        log.info("AD_Client_ID=" + ad_client_id + " AD_Org_ID=" + ad_org_id + " M_Product_ID=" + m_product_id + " M_Warehouse_ID=" + m_warehouse_id + " S_Resource_ID=" + s_resource_id);
        String sql_warehouse = "M_Warehouse_ID=?";
        if (m_warehouse_id == 0) {
            sql_warehouse = sql_warehouse + " OR M_Warehouse_ID IS NULL";
        }
        String whereClause = " AD_Client_ID=? AND AD_Org_ID=? AND M_Product_ID=? AND (" + sql_warehouse + ")" + " AND " + "S_Resource_ID" + "=?";
        return (MPPProductPlanning)new Query(ctx, "PP_Product_Planning", whereClause, trxname).setParameters(ad_client_id, ad_org_id, m_product_id, m_warehouse_id, s_resource_id).setOnlyActiveRecords(true).firstOnly();
    }

    public static MPPProductPlanning find(Properties ctx, int AD_Org_ID, int M_Warehouse_ID, int S_Resource_ID, int M_Product_ID, String trxName) {
        String whereClause = "AD_Client_ID=? AND M_Product_ID=? AND (AD_Org_ID IN (0,?) OR AD_Org_ID IS NULL) AND (M_Warehouse_ID IN (0,?) OR M_Warehouse_ID IS NULL) AND (S_Resource_ID IN (0,?) OR S_Resource_ID IS NULL)";
        return (MPPProductPlanning)new Query(ctx, "PP_Product_Planning", "AD_Client_ID=? AND M_Product_ID=? AND (AD_Org_ID IN (0,?) OR AD_Org_ID IS NULL) AND (M_Warehouse_ID IN (0,?) OR M_Warehouse_ID IS NULL) AND (S_Resource_ID IN (0,?) OR S_Resource_ID IS NULL)", trxName).setParameters(Env.getAD_Client_ID(ctx), M_Product_ID, AD_Org_ID, M_Warehouse_ID, S_Resource_ID).setOnlyActiveRecords(true).setOrderBy("COALESCE(AD_Org_ID, 0) DESC, COALESCE(M_Warehouse_ID, 0) DESC, COALESCE(S_Resource_ID, 0) DESC").first();
    }

    public static int getPlantForWarehouse(int M_Warehouse_ID) {
        String sql = "SELECT MIN(S_Resource_ID) FROM S_Resource WHERE IsManufacturingResource=? AND ManufacturingResourceType=? AND M_Warehouse_ID=?";
        int plant_id = DB.getSQLValueEx(null, "SELECT MIN(S_Resource_ID) FROM S_Resource WHERE IsManufacturingResource=? AND ManufacturingResourceType=? AND M_Warehouse_ID=?", true, "PT", M_Warehouse_ID);
        return plant_id;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getOrder_Policy() == null) {
            this.setOrder_Policy("LFL");
        }
        if (this.getOrder_Min().signum() > 0 && this.getOrder_Max().signum() > 0 && this.getOrder_Min().compareTo(this.getOrder_Max()) > 0) {
            throw new AdempiereException("@Order_Min@ > @Order_Max@");
        }
        if ("POQ".equals(this.getOrder_Policy()) && this.getOrder_Period().signum() <= 0) {
            throw new AdempiereException("@Order_Period@ <= 0");
        }
        if ("FOQ".equals(this.getOrder_Policy()) && this.getOrder_Qty().signum() <= 0) {
            throw new AdempiereException("@Order_Qty@ <= 0");
        }
        return true;
    }

    @Override
    public MPPProductBOM getPP_Product_BOM() {
        return MPPProductBOM.get(this.getCtx(), this.getPP_Product_BOM_ID());
    }

    @Override
    public MWorkflow getAD_Workflow() {
        return MWorkflow.get(this.getCtx(), this.getAD_Workflow_ID());
    }

    @Override
    public MResource getS_Resource() {
        return MResource.get(this.getCtx(), this.getS_Resource_ID());
    }

    public void setC_BPartner_ID(int C_BPartner_ID) {
        this.m_C_BPartner_ID = C_BPartner_ID;
    }

    public int getC_BPartner_ID() {
        return this.m_C_BPartner_ID;
    }

    @Override
    public void dump() {
        if (!CLogMgt.isLevelInfo()) {
            return;
        }
        log.info("------------ Planning Data --------------");
        log.info("           Create Plan: " + this.isCreatePlan());
        log.info("              Resource: " + this.getS_Resource_ID());
        log.info("          M_Product_ID: " + this.getM_Product_ID());
        log.info("                   BOM: " + this.getPP_Product_BOM_ID());
        log.info("              Workflow: " + this.getAD_Workflow_ID());
        log.info("  Network Distribution: " + this.getDD_NetworkDistribution_ID());
        log.info("Delivery Time Promised: " + this.getDeliveryTime_Promised());
        log.info("         TransfertTime: " + this.getTransferTime());
        log.info("         Order Min/Max: " + this.getOrder_Min() + " / " + this.getOrder_Max());
        log.info("            Order Pack: " + this.getOrder_Pack());
        log.info("          Safety Stock: " + this.getSafetyStock());
        log.info("          Order Period: " + this.getOrder_Period());
        log.info("          Order Policy: " + this.getOrder_Policy());
        log.info("             Warehouse: " + this.getM_Warehouse_ID());
        log.info("               Planner: " + this.getPlanner_ID());
        log.info("              Supplier: " + this.getC_BPartner_ID());
    }
}

