/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.eevolution.model.MPPPeriodDefinition;
import org.eevolution.model.X_PP_Period;

public class MPPPeriod
extends X_PP_Period {
    private static CCache<Integer, MPPPeriod> s_cache = new CCache("PP_Period", 10);
    private static CLogger s_log = CLogger.getCLogger(MPPPeriod.class);
    private int m_M_Calendar_ID = 0;
    private static final long serialVersionUID = 4217725345703715155L;

    public static int getIDByPeriodNo(MPPPeriodDefinition definition, int periodNo) {
        String whereClause = "PP_PeriodDefinition_ID=? AND PeriodNo= ?";
        return new Query(definition.getCtx(), "PP_Period", "PP_PeriodDefinition_ID=? AND PeriodNo= ?", definition.get_TrxName()).setClient_ID().setParameters(definition.get_ID(), periodNo).firstIdOnly();
    }

    public MPPPeriod(Properties ctx, int M_Period_ID, String trxName) {
        super(ctx, M_Period_ID, trxName);
    }

    public MPPPeriod(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPPPeriod(MPPPeriodDefinition pd, int PeriodNo, String name, Timestamp startDate, Timestamp endDate) {
        this(pd.getCtx(), 0, pd.get_TrxName());
        this.setClientOrg(pd);
        this.setPP_Period_ID(pd.getPP_PeriodDefinition_ID());
        this.setPeriodNo(PeriodNo);
        this.setName(name);
        this.setStartDate(startDate);
        this.setEndDate(endDate);
    }

    public static MPPPeriod findByCalendar(Properties ctx, Timestamp date, int M_Calendar_ID, String trxName) {
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        for (MPPPeriod period : s_cache.values()) {
            if (period.getM_Calendar_ID() != M_Calendar_ID || !period.isInPeriod(date) || period.getAD_Client_ID() != AD_Client_ID) continue;
            return period;
        }
        String whereClause = "PP_PeriodDefinition_ID IN (SELECT PP_PeriodDefinition_ID FROM PP_PeriodDefinition WHERE PP_Calendar_ID = ?)  AND ? BETWEEN TRUNC(StartDate, 'DD') AND TRUNC(EndDate, 'DD')";
        MPPPeriod period = (MPPPeriod)new Query(ctx, "PP_Period", whereClause, trxName).setClient_ID().setParameters(M_Calendar_ID, TimeUtil.getDay(date)).setOnlyActiveRecords(true).first();
        if (period == null) {
            return period;
        }
        Integer key = new Integer(period.getPP_Period_ID());
        s_cache.put(key, period);
        return period;
    }

    public boolean isInPeriod(Timestamp date) {
        Timestamp from;
        if (date == null) {
            return false;
        }
        Timestamp dateOnly = TimeUtil.getDay(date);
        if (dateOnly.before(from = TimeUtil.getDay(this.getStartDate()))) {
            return false;
        }
        Timestamp to = TimeUtil.getDay(this.getEndDate());
        return !dateOnly.after(to);
    }

    public int getM_Calendar_ID() {
        if (this.m_M_Calendar_ID == 0) {
            MPPPeriodDefinition pd = (MPPPeriodDefinition)this.getPP_PeriodDefinition();
            if (pd != null) {
                this.m_M_Calendar_ID = pd.getPP_Calendar_ID();
            } else {
                this.log.severe("@NotFound@ @PP_PeriodDefinition_ID@ =" + this.getPP_PeriodDefinition_ID());
            }
        }
        return this.m_M_Calendar_ID;
    }
}

