/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.adempiere.engine.CostDimension;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DocTypeNotFoundException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MCost;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MResource;
import org.compiere.model.MStorage;
import org.compiere.model.MTable;
import org.compiere.model.MUOM;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.POResultSet;
import org.compiere.model.Query;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodeNext;
import org.compiere.wf.MWorkflow;
import org.eevolution.exceptions.BOMExpiredException;
import org.eevolution.exceptions.RoutingExpiredException;
import org.eevolution.model.I_PP_Order;
import org.eevolution.model.I_PP_Order_BOMLine;
import org.eevolution.model.I_PP_Order_Node;
import org.eevolution.model.MPPCostCollector;
import org.eevolution.model.MPPOrderBOM;
import org.eevolution.model.MPPOrderBOMLine;
import org.eevolution.model.MPPOrderCost;
import org.eevolution.model.MPPOrderNode;
import org.eevolution.model.MPPOrderNodeAsset;
import org.eevolution.model.MPPOrderNodeNext;
import org.eevolution.model.MPPOrderNodeProduct;
import org.eevolution.model.MPPOrderWorkflow;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;
import org.eevolution.model.MPPWFNodeAsset;
import org.eevolution.model.MPPWFNodeProduct;
import org.eevolution.model.MQMSpecification;
import org.eevolution.model.X_PP_Order;
import org.eevolution.model.X_PP_Order_Node;

public class MPPOrder
extends X_PP_Order
implements DocAction {
    private static final long serialVersionUID = 7341647141173120822L;
    private MPPOrderBOMLine[] m_lines = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private MPPOrderWorkflow m_PP_Order_Workflow = null;

    public static MPPOrder forC_OrderLine_ID(Properties ctx, int C_OrderLine_ID, int M_Product_ID, String trxName) {
        return (MPPOrder)new Query(ctx, "PP_Order", "C_OrderLine_ID=? AND M_Product_ID=?", trxName).setParameters(C_OrderLine_ID, M_Product_ID).firstOnly();
    }

    public static void updateQtyBatchs(Properties ctx, I_PP_Order order, boolean override) {
        BigDecimal qtyBatchSize = order.getQtyBatchSize();
        if (qtyBatchSize.signum() == 0 || override) {
            int AD_Workflow_ID = order.getAD_Workflow_ID();
            if (AD_Workflow_ID <= 0) {
                return;
            }
            MWorkflow wf = MWorkflow.get(ctx, AD_Workflow_ID);
            qtyBatchSize = wf.getQtyBatchSize().setScale(0, RoundingMode.UP);
            order.setQtyBatchSize(qtyBatchSize);
        }
        BigDecimal QtyBatchs = qtyBatchSize.signum() == 0 ? Env.ONE : order.getQtyOrdered().divide(qtyBatchSize, 0, 0);
        order.setQtyBatchs(QtyBatchs);
    }

    public static boolean isQtyAvailable(MPPOrder order, ArrayList[][] issue, Timestamp minGuaranteeDate) {
        boolean isCompleteQtyDeliver = false;
        for (int i2 = 0; i2 < issue.length; ++i2) {
            int PP_Order_BOMLine_ID;
            KeyNamePair key = (KeyNamePair)issue[i2][0].get(0);
            boolean isSelected = key.getName().equals("Y");
            if (key == null || !isSelected) continue;
            String value = (String)issue[i2][0].get(2);
            KeyNamePair productkey = (KeyNamePair)issue[i2][0].get(3);
            int M_Product_ID = productkey.getKey();
            BigDecimal qtyToDeliver = (BigDecimal)issue[i2][0].get(4);
            BigDecimal qtyScrapComponent = (BigDecimal)issue[i2][0].get(5);
            MProduct product = MProduct.get(order.getCtx(), M_Product_ID);
            if (product == null || !product.isStocked()) continue;
            int M_AttributeSetInstance_ID = 0;
            if (value == null && isSelected) {
                M_AttributeSetInstance_ID = key.getKey();
            } else if (value != null && isSelected && (PP_Order_BOMLine_ID = Integer.valueOf(key.getKey()).intValue()) > 0) {
                MPPOrderBOMLine orderBOMLine = new MPPOrderBOMLine(order.getCtx(), PP_Order_BOMLine_ID, order.get_TrxName());
                M_AttributeSetInstance_ID = orderBOMLine.getM_AttributeSetInstance_ID();
            }
            MStorage[] storages = MPPOrder.getStorages(order.getCtx(), M_Product_ID, order.getM_Warehouse_ID(), M_AttributeSetInstance_ID, minGuaranteeDate, order.get_TrxName());
            if (M_AttributeSetInstance_ID == 0) {
                BigDecimal toIssue = qtyToDeliver.add(qtyScrapComponent);
                for (MStorage storage : storages) {
                    BigDecimal issueActual;
                    if (storage.getQtyOnHand().signum() != 0 && (toIssue = toIssue.subtract(issueActual = toIssue.min(storage.getQtyOnHand()))).signum() <= 0) break;
                }
            } else {
                BigDecimal qtydelivered = qtyToDeliver;
                qtydelivered.setScale(4, 4);
                qtydelivered = Env.ZERO;
            }
            BigDecimal onHand = Env.ZERO;
            for (MStorage storage : storages) {
                onHand = onHand.add(storage.getQtyOnHand());
            }
            boolean bl = isCompleteQtyDeliver = onHand.compareTo(qtyToDeliver.add(qtyScrapComponent)) >= 0;
            if (!isCompleteQtyDeliver) break;
        }
        return isCompleteQtyDeliver;
    }

    public static MStorage[] getStorages(Properties ctx, int M_Product_ID, int M_Warehouse_ID, int M_ASI_ID, Timestamp minGuaranteeDate, String trxName) {
        MProduct product = MProduct.get(ctx, M_Product_ID);
        if (product != null && product.isStocked()) {
            if (product.getM_AttributeSetInstance_ID() == 0) {
                String MMPolicy = product.getMMPolicy();
                return MStorage.getWarehouse(ctx, M_Warehouse_ID, M_Product_ID, M_ASI_ID, minGuaranteeDate, "F".equals(MMPolicy), true, 0, trxName);
            }
            String MMPolicy = product.getMMPolicy();
            return MStorage.getWarehouse(ctx, M_Warehouse_ID, M_Product_ID, 0, minGuaranteeDate, "F".equals(MMPolicy), true, 0, trxName);
        }
        return new MStorage[0];
    }

    public MPPOrder(Properties ctx, int PP_Order_ID, String trxName) {
        super(ctx, PP_Order_ID, trxName);
        if (PP_Order_ID == 0) {
            this.setDefault();
        }
    }

    public MPPOrder(MProject project, int PP_Product_BOM_ID, int AD_Workflow_ID) {
        this(project.getCtx(), 0, project.get_TrxName());
        this.setAD_Client_ID(project.getAD_Client_ID());
        this.setAD_Org_ID(project.getAD_Org_ID());
        this.setC_Campaign_ID(project.getC_Campaign_ID());
        this.setC_Project_ID(project.getC_Project_ID());
        this.setDescription(project.getName());
        this.setLine(10);
        this.setPriorityRule("5");
        if (project.getDateContract() == null) {
            throw new IllegalStateException("Date Contract is mandatory for Manufacturing Order.");
        }
        if (project.getDateFinish() == null) {
            throw new IllegalStateException("Date Finish is mandatory for Manufacturing Order.");
        }
        Timestamp ts = project.getDateContract();
        Timestamp df = project.getDateContract();
        if (ts != null) {
            this.setDateOrdered(ts);
        }
        if (ts != null) {
            this.setDateStartSchedule(ts);
        }
        ts = project.getDateFinish();
        if (df != null) {
            this.setDatePromised(df);
        }
        this.setM_Warehouse_ID(project.getM_Warehouse_ID());
        this.setPP_Product_BOM_ID(PP_Product_BOM_ID);
        this.setAD_Workflow_ID(AD_Workflow_ID);
        this.setQtyEntered(Env.ONE);
        this.setQtyOrdered(Env.ONE);
        MPPProductBOM bom = new MPPProductBOM(project.getCtx(), PP_Product_BOM_ID, project.get_TrxName());
        MProduct product = MProduct.get(project.getCtx(), bom.getM_Product_ID());
        this.setC_UOM_ID(product.getC_UOM_ID());
        this.setM_Product_ID(bom.getM_Product_ID());
        String where = "IsManufacturingResource = 'Y' AND ManufacturingResourceType = 'PT' AND M_Warehouse_ID = " + project.getM_Warehouse_ID();
        MResource resoruce = (MResource)MTable.get(project.getCtx(), MResource.Table_ID).getPO(where, project.get_TrxName());
        if (resoruce == null) {
            throw new IllegalStateException("Resource is mandatory.");
        }
        this.setS_Resource_ID(resoruce.getS_Resource_ID());
    }

    public MPPOrder(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public BigDecimal getQtyOpen() {
        return this.getQtyOrdered().subtract(this.getQtyDelivered()).subtract(this.getQtyScrap());
    }

    public MPPOrderBOMLine[] getLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            MPPOrder.set_TrxName(this.m_lines, this.get_TrxName());
            return this.m_lines;
        }
        String whereClause = "PP_Order_ID=?";
        List<MPPOrderBOMLine> list = new Query(this.getCtx(), "PP_Order_BOMLine", whereClause, this.get_TrxName()).setParameters(this.getPP_Order_ID()).setOrderBy("Line").list();
        this.m_lines = list.toArray(new MPPOrderBOMLine[list.size()]);
        return this.m_lines;
    }

    public MPPOrderBOMLine[] getLines() {
        return this.getLines(true);
    }

    public void setC_DocTypeTarget_ID(String docBaseType) {
        if (this.getC_DocTypeTarget_ID() > 0) {
            return;
        }
        MDocType[] doc = MDocType.getOfDocBaseType(this.getCtx(), docBaseType);
        if (doc == null) {
            throw new DocTypeNotFoundException(docBaseType, "");
        }
        this.setC_DocTypeTarget_ID(doc[0].get_ID());
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() <= 0) {
            return;
        }
        String sql = "UPDATE PP_Order SET Processed=? WHERE PP_Order_ID=?";
        DB.executeUpdateEx("UPDATE PP_Order SET Processed=? WHERE PP_Order_ID=?", new Object[]{processed, this.get_ID()}, this.get_TrxName());
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        int ii;
        if (this.getAD_Client_ID() == 0) {
            this.m_processMsg = "AD_Client_ID = 0";
            return false;
        }
        if (this.getAD_Org_ID() == 0) {
            int context_AD_Org_ID = Env.getAD_Org_ID(this.getCtx());
            if (context_AD_Org_ID == 0) {
                this.m_processMsg = "AD_Org_ID = 0";
                return false;
            }
            this.setAD_Org_ID(context_AD_Org_ID);
            this.log.warning("beforeSave - Changed Org to Context=" + context_AD_Org_ID);
        }
        if (this.getM_Warehouse_ID() == 0 && (ii = Env.getContextAsInt(this.getCtx(), "#M_Warehouse_ID")) != 0) {
            this.setM_Warehouse_ID(ii);
        }
        if (this.getC_UOM_ID() <= 0 && this.getM_Product_ID() > 0) {
            this.setC_UOM_ID(this.getM_Product().getC_UOM_ID());
        }
        if (this.getDateFinishSchedule() == null) {
            this.setDateFinishSchedule(this.getDatePromised());
        }
        if (this.is_ValueChanged("QtyDelivered") || this.is_ValueChanged("QtyOrdered")) {
            this.orderStock();
        }
        MPPOrder.updateQtyBatchs(this.getCtx(), this, false);
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return false;
        }
        if ("CL".equals(this.getDocAction()) || "VO".equals(this.getDocAction())) {
            return true;
        }
        if (this.is_ValueChanged("QtyEntered") && !this.isDelivered()) {
            this.deleteWorkflowAndBOM();
            this.explotion();
        }
        if (this.is_ValueChanged("QtyEntered") && this.isDelivered()) {
            throw new AdempiereException("Cannot Change Quantity, Only is allow with Draft or In Process Status");
        }
        if (!newRecord) {
            return success;
        }
        this.explotion();
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        if (this.getDocStatus().equals("DR") || this.getDocStatus().equals("IP")) {
            String whereClause = "PP_Order_ID=? AND AD_Client_ID=?";
            Object[] params = new Object[]{this.get_ID(), this.getAD_Client_ID()};
            this.deletePO("PP_Order_Cost", whereClause, params);
            this.deleteWorkflowAndBOM();
        }
        if ("IP".equals(this.getDocStatus()) || "CO".equals(this.getDocStatus())) {
            this.setQtyOrdered(Env.ZERO);
            this.orderStock();
        }
        return true;
    }

    private void deleteWorkflowAndBOM() {
        if (this.get_ID() <= 0) {
            return;
        }
        String whereClause = "PP_Order_ID=? AND AD_Client_ID=?";
        Object[] params = new Object[]{this.get_ID(), this.getAD_Client_ID()};
        DB.executeUpdateEx("UPDATE PP_Order_Workflow SET PP_Order_Node_ID=NULL WHERE " + whereClause, params, this.get_TrxName());
        this.deletePO("PP_Order_Node_Asset", whereClause, params);
        this.deletePO("PP_Order_Node_Product", whereClause, params);
        this.deletePO("PP_Order_NodeNext", whereClause, params);
        this.deletePO("PP_Order_Node", whereClause, params);
        this.deletePO("PP_Order_Workflow", whereClause, params);
        this.deletePO("PP_Order_BOMLine", whereClause, params);
        this.deletePO("PP_Order_BOM", whereClause, params);
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info(this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info(this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        String docBaseType;
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPPOrderBOMLine[] lines = this.getLines(true);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        if (this.getC_DocType_ID() != 0) {
            for (int i2 = 0; i2 < lines.length; ++i2) {
                if (lines[i2].getM_Warehouse_ID() == this.getM_Warehouse_ID()) continue;
                this.log.warning("different Warehouse " + lines[i2]);
                this.m_processMsg = "@CannotChangeDocType@";
                return "IN";
            }
        }
        if ("DR".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || this.getC_DocType_ID() == 0) {
            this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
        }
        if (!"MQO".equals(docBaseType = MDocType.get(this.getCtx(), this.getC_DocType_ID()).getDocBaseType())) {
            this.reserveStock(lines);
            this.orderStock();
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        return "IP";
    }

    private void orderStock() {
        MProduct product = this.getM_Product();
        if (!product.isStocked()) {
            return;
        }
        BigDecimal target = this.getQtyOrdered();
        BigDecimal difference = target.subtract(this.getQtyReserved()).subtract(this.getQtyDelivered());
        if (difference.signum() == 0) {
            return;
        }
        BigDecimal ordered = difference;
        int M_Locator_ID = this.getM_Locator_ID(ordered);
        if ("CL".equals(this.getDocAction()) ? !MStorage.add(this.getCtx(), this.getM_Warehouse_ID(), M_Locator_ID, this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), this.getM_AttributeSetInstance_ID(), Env.ZERO, Env.ZERO, ordered, this.get_TrxName()) : !MStorage.add(this.getCtx(), this.getM_Warehouse_ID(), M_Locator_ID, this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), this.getM_AttributeSetInstance_ID(), Env.ZERO, Env.ZERO, ordered, this.get_TrxName())) {
            throw new AdempiereException();
        }
        this.setQtyReserved(this.getQtyReserved().add(difference));
    }

    private void reserveStock(MPPOrderBOMLine[] lines) {
        for (MPPOrderBOMLine line : lines) {
            line.reserveStock();
            line.saveEx();
        }
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        MDocType doc = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if ("MQO".equals(doc.getDocBaseType())) {
            String whereClause = "PP_Product_BOM_ID=? AND AD_Workflow_ID=?";
            MQMSpecification qms = (MQMSpecification)new Query(this.getCtx(), "QM_Specification", whereClause, this.get_TrxName()).setParameters(this.getPP_Product_BOM_ID(), this.getAD_Workflow_ID()).firstOnly();
            return qms != null ? qms.isValid(this.getM_AttributeSetInstance_ID()) : true;
        }
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String status;
        if ("PR".equals(this.getDocAction())) {
            this.setProcessed(false);
            return "IP";
        }
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.setIsApproved(this.approveIt());
            MDocType doc = MDocType.get(this.getCtx(), this.getC_DocType_ID());
            if (this.isApproved() && "MQO".equals(doc.getDocBaseType())) {
                this.setProcessed(true);
                this.setDocAction("CO");
                String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
                if (valid != null) {
                    this.m_processMsg = valid;
                    return "IN";
                }
                return "CO";
            }
            if ("MQO".equals(doc.getDocBaseType())) {
                this.setProcessed(true);
                this.setDocAction("CO");
                String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
                if (valid != null) {
                    this.m_processMsg = valid;
                    return "IN";
                }
                return "CO";
            }
        }
        this.createStandardCosts();
        this.autoReportActivities();
        this.setDocAction("CL");
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        return "CO";
    }

    public boolean isAvailable() {
        String whereClause = "QtyOnHand >= QtyRequired AND PP_Order_ID=?";
        boolean available = new Query(this.getCtx(), "RV_PP_Order_Storage", whereClause, this.get_TrxName()).setParameters(this.get_ID()).match();
        return available;
    }

    @Override
    public boolean voidIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if (this.isDelivered()) {
            throw new AdempiereException("Cannot void this document because exist transactions");
        }
        for (MPPOrderBOMLine line : this.getLines()) {
            BigDecimal old = line.getQtyRequired();
            if (old.signum() == 0) continue;
            line.addDescription(Msg.parseTranslation(this.getCtx(), "@Voided@ @QtyRequired@ : (" + old + ")"));
            line.setQtyRequired(Env.ZERO);
            line.saveEx();
        }
        this.getMPPOrderWorkflow().voidActivities();
        BigDecimal old = this.getQtyOrdered();
        if (old.signum() != 0) {
            this.addDescription(Msg.parseTranslation(this.getCtx(), "@Voided@ @QtyOrdered@ : (" + old + ")"));
            this.setQtyOrdered(Env.ZERO);
            this.setQtyEntered(Env.ZERO);
            this.saveEx();
        }
        this.orderStock();
        this.reserveStock(this.getLines());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus())) {
            return true;
        }
        if (!"CO".equals(this.getDocStatus())) {
            String DocStatus = this.completeIt();
            this.setDocStatus(DocStatus);
            this.setDocAction("--");
        }
        if (!this.isDelivered()) {
            throw new AdempiereException("Cannot close this document because do not exist transactions");
        }
        this.createVariances();
        for (MPPOrderBOMLine line : this.getLines()) {
            BigDecimal old = line.getQtyRequired();
            if (old.compareTo(line.getQtyDelivered()) == 0) continue;
            line.setQtyRequired(line.getQtyDelivered());
            line.addDescription(Msg.parseTranslation(this.getCtx(), "@closed@ @QtyRequired@ (" + old + ")"));
            line.saveEx();
        }
        MPPOrderWorkflow m_order_wf = this.getMPPOrderWorkflow();
        m_order_wf.closeActivities(m_order_wf.getLastNode(this.getAD_Client_ID()), this.getUpdated(), false);
        BigDecimal old = this.getQtyOrdered();
        if (old.signum() != 0) {
            this.addDescription(Msg.parseTranslation(this.getCtx(), "@closed@ @QtyOrdered@ : (" + old + ")"));
            this.setQtyOrdered(this.getQtyDelivered());
            this.saveEx();
        }
        this.orderStock();
        this.reserveStock(this.getLines());
        this.setDocStatus("CL");
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        return this.voidIt();
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        if (this.isDelivered()) {
            throw new AdempiereException("Cannot re activate this document because exist transactions");
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getPlanner_ID();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return Env.ZERO;
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public String getSummary() {
        return "" + this.getDocumentNo() + "/" + this.getDatePromised();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        ReportEngine re = ReportEngine.get(this.getCtx(), 8, this.getPP_Order_ID());
        if (re == null) {
            return null;
        }
        return re.getPDF(file);
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePO(String tableName, String whereClause, Object[] params) {
        try (POResultSet rs = new Query(this.getCtx(), tableName, whereClause, this.get_TrxName()).setParameters(params).scroll();){
            while (rs.hasNext()) {
                ((PO)rs.next()).deleteEx(true);
            }
        }
    }

    public void setQty(BigDecimal Qty) {
        super.setQtyEntered(Qty);
        super.setQtyOrdered(this.getQtyEntered());
    }

    @Override
    public void setQtyEntered(BigDecimal QtyEntered) {
        if (QtyEntered != null && this.getC_UOM_ID() != 0) {
            int precision = MUOM.getPrecision(this.getCtx(), this.getC_UOM_ID());
            QtyEntered = QtyEntered.setScale(precision, 4);
        }
        super.setQtyEntered(QtyEntered);
    }

    @Override
    public void setQtyOrdered(BigDecimal QtyOrdered) {
        if (QtyOrdered != null) {
            int precision = this.getM_Product().getUOMPrecision();
            QtyOrdered = QtyOrdered.setScale(precision, 4);
        }
        super.setQtyOrdered(QtyOrdered);
    }

    @Override
    public MProduct getM_Product() {
        return MProduct.get(this.getCtx(), this.getM_Product_ID());
    }

    public MPPOrderBOM getMPPOrderBOM() {
        String whereClause = "PP_Order_ID=?";
        return (MPPOrderBOM)new Query(this.getCtx(), "PP_Order_BOM", "PP_Order_ID=?", this.get_TrxName()).setParameters(this.getPP_Order_ID()).firstOnly();
    }

    public MPPOrderWorkflow getMPPOrderWorkflow() {
        if (this.m_PP_Order_Workflow != null) {
            return this.m_PP_Order_Workflow;
        }
        String whereClause = "PP_Order_ID=?";
        this.m_PP_Order_Workflow = (MPPOrderWorkflow)new Query(this.getCtx(), "PP_Order_Workflow", "PP_Order_ID=?", this.get_TrxName()).setParameters(this.getPP_Order_ID()).firstOnly();
        return this.m_PP_Order_Workflow;
    }

    private void explotion() {
        MPPOrderWorkflow PP_Order_Workflow;
        MPPProductBOM PP_Product_BOM = MPPProductBOM.get(this.getCtx(), this.getPP_Product_BOM_ID());
        if (this.getM_Product_ID() != PP_Product_BOM.getM_Product_ID()) {
            throw new AdempiereException("@NotMatch@ @PP_Product_BOM_ID@ , @M_Product_ID@");
        }
        MProduct product = MProduct.get(this.getCtx(), PP_Product_BOM.getM_Product_ID());
        if (!product.isVerified()) {
            throw new AdempiereException("Product BOM Configuration not verified. Please verify the product first - " + product.getValue());
        }
        if (PP_Product_BOM.isValidFromTo(this.getDateStartSchedule())) {
            MPPOrderBOM PP_Order_BOM = new MPPOrderBOM(PP_Product_BOM, this.getPP_Order_ID(), this.get_TrxName());
            PP_Order_BOM.setAD_Org_ID(this.getAD_Org_ID());
            PP_Order_BOM.saveEx();
            for (MPPProductBOMLine PP_Product_BOMline : PP_Product_BOM.getLines(true)) {
                if (PP_Product_BOMline.isValidFromTo(this.getDateStartSchedule())) {
                    MPPOrderBOMLine mPPOrderBOMLine = new MPPOrderBOMLine(PP_Product_BOMline, this.getPP_Order_ID(), PP_Order_BOM.get_ID(), this.getM_Warehouse_ID(), this.get_TrxName());
                    mPPOrderBOMLine.setAD_Org_ID(this.getAD_Org_ID());
                    mPPOrderBOMLine.setM_Warehouse_ID(this.getM_Warehouse_ID());
                    mPPOrderBOMLine.setM_Locator_ID(this.getM_Locator_ID());
                    mPPOrderBOMLine.setQtyOrdered(this.getQtyOrdered());
                    mPPOrderBOMLine.saveEx();
                    continue;
                }
                this.log.fine("BOM Line skiped - " + PP_Product_BOMline);
            }
        } else {
            throw new BOMExpiredException(PP_Product_BOM, this.getDateStartSchedule());
        }
        MWorkflow AD_Workflow = MWorkflow.get(this.getCtx(), this.getAD_Workflow_ID());
        if (!AD_Workflow.isValid()) {
            throw new AdempiereException("Routing is not valid. Please validate it first - " + AD_Workflow.getValue());
        }
        if (AD_Workflow.isValidFromTo(this.getDateStartSchedule())) {
            PP_Order_Workflow = new MPPOrderWorkflow(AD_Workflow, this.get_ID(), this.get_TrxName());
            PP_Order_Workflow.setAD_Org_ID(this.getAD_Org_ID());
            PP_Order_Workflow.saveEx();
            for (MWFNode mWFNode : AD_Workflow.getNodes(false, this.getAD_Client_ID())) {
                if (!mWFNode.isValidFromTo(this.getDateStartSchedule())) continue;
                MPPOrderNode PP_Order_Node = new MPPOrderNode(mWFNode, PP_Order_Workflow, this.getQtyOrdered(), this.get_TrxName());
                PP_Order_Node.setAD_Org_ID(this.getAD_Org_ID());
                PP_Order_Node.saveEx();
                for (MWFNodeNext AD_WF_NodeNext : mWFNode.getTransitions(this.getAD_Client_ID())) {
                    MPPOrderNodeNext nodenext = new MPPOrderNodeNext(AD_WF_NodeNext, PP_Order_Node);
                    nodenext.setAD_Org_ID(this.getAD_Org_ID());
                    nodenext.saveEx();
                }
                for (MPPWFNodeProduct wfnp : MPPWFNodeProduct.forAD_WF_Node_ID(this.getCtx(), mWFNode.get_ID())) {
                    MPPOrderNodeProduct nodeOrderProduct = new MPPOrderNodeProduct(wfnp, PP_Order_Node);
                    nodeOrderProduct.setAD_Org_ID(this.getAD_Org_ID());
                    nodeOrderProduct.saveEx();
                }
                for (MPPWFNodeAsset wfna : MPPWFNodeAsset.forAD_WF_Node_ID(this.getCtx(), mWFNode.get_ID())) {
                    MPPOrderNodeAsset nodeorderasset = new MPPOrderNodeAsset(wfna, PP_Order_Node);
                    nodeorderasset.setAD_Org_ID(this.getAD_Org_ID());
                    nodeorderasset.saveEx();
                }
            }
            PP_Order_Workflow.getNodes(true);
            for (PO pO : PP_Order_Workflow.getNodes(false, this.getAD_Client_ID())) {
                if (PP_Order_Workflow.getAD_WF_Node_ID() == ((X_PP_Order_Node)pO).getAD_WF_Node_ID()) {
                    PP_Order_Workflow.setPP_Order_Node_ID(((X_PP_Order_Node)pO).getPP_Order_Node_ID());
                }
                for (MPPOrderNodeNext next : ((MPPOrderNode)pO).getTransitions(this.getAD_Client_ID())) {
                    next.setPP_Order_Next_ID();
                    next.saveEx();
                }
            }
        } else {
            throw new RoutingExpiredException(AD_Workflow, this.getDateStartSchedule());
        }
        PP_Order_Workflow.saveEx();
    }

    public static void createReceipt(MPPOrder order, Timestamp movementDate, BigDecimal qtyDelivered, BigDecimal qtyToDeliver, BigDecimal qtyScrap, BigDecimal qtyReject, int M_Locator_ID, int M_AttributeSetInstance_ID) {
        if (qtyToDeliver.signum() != 0 || qtyScrap.signum() != 0 || qtyReject.signum() != 0) {
            MPPCostCollector.createCollector(order, order.getM_Product_ID(), M_Locator_ID, M_AttributeSetInstance_ID, order.getS_Resource_ID(), 0, 0, MDocType.getDocType("MCC"), "100", movementDate, qtyToDeliver, qtyScrap, qtyReject, 0, Env.ZERO);
        }
        order.setDateDelivered(movementDate);
        if (order.getDateStart() == null) {
            order.setDateStart(movementDate);
        }
        BigDecimal DQ = qtyDelivered;
        BigDecimal SQ = qtyScrap;
        BigDecimal OQ = qtyToDeliver;
        if (DQ.add(SQ).compareTo(OQ) >= 0) {
            order.setDateFinish(movementDate);
        }
        order.saveEx();
    }

    public static void createIssue(MPPOrder order, int PP_OrderBOMLine_ID, Timestamp movementdate, BigDecimal qty, BigDecimal qtyScrap, BigDecimal qtyReject, MStorage[] storages, boolean forceIssue) {
        if (qty.signum() == 0) {
            return;
        }
        MPPOrderBOMLine PP_orderbomLine = new MPPOrderBOMLine(order.getCtx(), PP_OrderBOMLine_ID, order.get_TrxName());
        BigDecimal toIssue = qty.add(qtyScrap);
        for (MStorage storage : storages) {
            if (storage.getQtyOnHand().signum() == 0) continue;
            BigDecimal qtyIssue = toIssue.min(storage.getQtyOnHand());
            if (qtyIssue.signum() != 0 || qtyScrap.signum() != 0 || qtyReject.signum() != 0) {
                String CostCollectorType = "110";
                if (PP_orderbomLine.isComponentType("CP")) {
                    CostCollectorType = "150";
                }
                MPPCostCollector.createCollector(order, PP_orderbomLine.getM_Product_ID(), storage.getM_Locator_ID(), storage.getM_AttributeSetInstance_ID(), order.getS_Resource_ID(), PP_OrderBOMLine_ID, 0, MDocType.getDocType("MCC"), CostCollectorType, movementdate, qtyIssue, qtyScrap, qtyReject, 0, Env.ZERO);
                PP_orderbomLine.load(order.get_TrxName());
                if (PP_orderbomLine.getQtyBatch().signum() == 0 && PP_orderbomLine.getQtyBOM().signum() == 0) {
                    order.createMethodChangeVariance(PP_orderbomLine);
                }
            }
            if ((toIssue = toIssue.subtract(qtyIssue)).signum() == 0) break;
        }
        if (forceIssue && toIssue.signum() != 0) {
            MPPCostCollector.createCollector(order, PP_orderbomLine.getM_Product_ID(), PP_orderbomLine.getM_Locator_ID(), PP_orderbomLine.getM_AttributeSetInstance_ID(), order.getS_Resource_ID(), PP_OrderBOMLine_ID, 0, MDocType.getDocType("MCC"), "110", movementdate, toIssue, Env.ZERO, Env.ZERO, 0, Env.ZERO);
            return;
        }
        if (toIssue.signum() != 0) {
            throw new AdempiereException("Should not happen toIssue=" + toIssue);
        }
    }

    public static boolean isQtyAvailable(MPPOrder order, I_PP_Order_BOMLine line) {
        MProduct product = MProduct.get(order.getCtx(), line.getM_Product_ID());
        if (product == null || !product.isStocked()) {
            return true;
        }
        BigDecimal qtyToDeliver = line.getQtyRequired();
        BigDecimal qtyScrap = line.getQtyScrap();
        BigDecimal qtyRequired = qtyToDeliver.add(qtyScrap);
        BigDecimal qtyAvailable = MStorage.getQtyAvailable(order.getM_Warehouse_ID(), 0, line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), order.get_TrxName());
        return qtyAvailable.compareTo(qtyRequired) >= 0;
    }

    public int getM_Locator_ID() {
        MWarehouse wh = MWarehouse.get(this.getCtx(), this.getM_Warehouse_ID());
        return wh.getDefaultLocator().getM_Locator_ID();
    }

    private int getM_Locator_ID(BigDecimal qty) {
        int M_Locator_ID = 0;
        int M_ASI_ID = this.getM_AttributeSetInstance_ID();
        if (M_ASI_ID != 0) {
            M_Locator_ID = MStorage.getM_Locator_ID(this.getM_Warehouse_ID(), this.getM_Product_ID(), M_ASI_ID, qty, this.get_TrxName());
        }
        if (M_Locator_ID == 0) {
            M_Locator_ID = this.getM_Locator_ID();
        }
        return M_Locator_ID;
    }

    public boolean isDelivered() {
        if (this.getQtyDelivered().signum() > 0 || this.getQtyScrap().signum() > 0 || this.getQtyReject().signum() > 0) {
            return true;
        }
        for (MPPOrderBOMLine mPPOrderBOMLine : this.getLines()) {
            if (mPPOrderBOMLine.getQtyDelivered().signum() <= 0) continue;
            return true;
        }
        for (PO pO : this.getMPPOrderWorkflow().getNodes(true, this.getAD_Client_ID())) {
            if (((X_PP_Order_Node)pO).getQtyDelivered().signum() > 0) {
                return true;
            }
            if (((X_PP_Order_Node)pO).getDurationReal() <= 0) continue;
            return true;
        }
        return false;
    }

    public void setDefault() {
        this.setLine(10);
        this.setPriorityRule("5");
        this.setDescription("");
        this.setQtyDelivered(Env.ZERO);
        this.setQtyReject(Env.ZERO);
        this.setQtyScrap(Env.ZERO);
        this.setIsSelected(false);
        this.setIsSOTrx(false);
        this.setIsApproved(false);
        this.setIsPrinted(false);
        this.setProcessed(false);
        this.setProcessing(false);
        this.setPosted(false);
        this.setC_DocTypeTarget_ID("MOP");
        this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
        this.setDocStatus("DR");
        this.setDocAction("PR");
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MPPOrder[").append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",IsSOTrx=").append(this.isSOTrx()).append(",C_DocType_ID=").append(this.getC_DocType_ID()).append("]");
        return sb.toString();
    }

    public void autoReportActivities() {
        for (MPPOrderNode activity : this.getMPPOrderWorkflow().getNodes()) {
            if (!activity.isMilestone() || !activity.isSubcontracting() && activity.get_ID() != this.getMPPOrderWorkflow().getPP_Order_Node_ID()) continue;
            MPPCostCollector mPPCostCollector = MPPCostCollector.createCollector(this, this.getM_Product_ID(), this.getM_Locator_ID(), this.getM_AttributeSetInstance_ID(), this.getS_Resource_ID(), 0, activity.getPP_Order_Node_ID(), MDocType.getDocType("MCC"), "160", this.getUpdated(), activity.getQtyToDeliver(), Env.ZERO, Env.ZERO, 0, Env.ZERO);
        }
    }

    public final void createStandardCosts() {
        MAcctSchema as = MClient.get(this.getCtx(), this.getAD_Client_ID()).getAcctSchema();
        this.log.info("Cost_Group_ID" + as.getM_CostType_ID());
        TreeSet<Integer> productsAdded = new TreeSet<Integer>();
        MProduct product = this.getM_Product();
        productsAdded.add(product.getM_Product_ID());
        CostDimension d = new CostDimension(product, as, as.getM_CostType_ID(), this.getAD_Org_ID(), this.getM_Warehouse_ID(), this.getM_AttributeSetInstance_ID(), -10);
        List costs = d.toQuery(MCost.class, this.get_TrxName()).list();
        for (MCost cost : costs) {
            MPPOrderCost.createOrderCostDimension(this.get_ID(), cost);
        }
        for (MPPOrderBOMLine line : this.getLines()) {
            MProduct product2 = line.getM_Product();
            if (productsAdded.contains(product2.getM_Product_ID())) continue;
            productsAdded.add(product2.getM_Product_ID());
            CostDimension d2 = new CostDimension(line.getM_Product(), as, as.getM_CostType_ID(), line.getAD_Org_ID(), this.getM_Warehouse_ID(), line.getM_AttributeSetInstance_ID(), -10);
            List costs2 = d2.toQuery(MCost.class, this.get_TrxName()).list();
            for (MCost cost : costs2) {
                MPPOrderCost.createOrderCostDimension(this.get_ID(), cost);
            }
        }
        for (MPPOrderNode node : this.getMPPOrderWorkflow().getNodes(true)) {
            MProduct resourceProduct;
            int S_Resource_ID = node.getS_Resource_ID();
            if (S_Resource_ID <= 0 || productsAdded.contains((resourceProduct = MProduct.forS_Resource_ID(this.getCtx(), S_Resource_ID, null)).getM_Product_ID())) continue;
            productsAdded.add(resourceProduct.getM_Product_ID());
            CostDimension d3 = new CostDimension(resourceProduct, as, as.getM_CostType_ID(), node.getAD_Org_ID(), this.getM_Warehouse_ID(), 0, -10);
            List costs3 = d3.toQuery(MCost.class, this.get_TrxName()).list();
            for (MCost cost : costs3) {
                MPPOrderCost.createOrderCostDimension(this.get_ID(), cost);
            }
        }
    }

    public void createVariances() {
        for (MPPOrderBOMLine line : this.getLines(true)) {
            this.createUsageVariance(line);
        }
        this.m_lines = null;
        MPPOrderWorkflow orderWorkflow = this.getMPPOrderWorkflow();
        if (orderWorkflow != null) {
            for (MPPOrderNode node : orderWorkflow.getNodes(true)) {
                this.createUsageVariance(node);
            }
        }
    }

    private void createUsageVariance(I_PP_Order_BOMLine bomLine) {
        MLocator locator;
        MPPOrder order = this;
        Timestamp movementDate = order.getUpdated();
        MPPOrderBOMLine line = (MPPOrderBOMLine)bomLine;
        if (line.getQtyBatch().signum() == 0 && line.getQtyBOM().signum() == 0) {
            return;
        }
        BigDecimal qtyUsageVariancePrev = line.getQtyVariance();
        BigDecimal qtyOpen = line.getQtyOpen();
        BigDecimal qtyUsageVariance = qtyOpen.subtract(qtyUsageVariancePrev);
        if (qtyUsageVariance.signum() == 0) {
            return;
        }
        int M_Locator_ID = line.getM_Locator_ID();
        if (M_Locator_ID <= 0 && (locator = MLocator.getDefault(MWarehouse.get(order.getCtx(), order.getM_Warehouse_ID()))) != null) {
            M_Locator_ID = locator.getM_Locator_ID();
        }
        MPPCostCollector.createCollector(order, line.getM_Product_ID(), M_Locator_ID, line.getM_AttributeSetInstance_ID(), order.getS_Resource_ID(), line.getPP_Order_BOMLine_ID(), 0, MDocType.getDocType("MCC"), "120", movementDate, qtyUsageVariance, Env.ZERO, Env.ZERO, 0, Env.ZERO);
    }

    private void createMethodChangeVariance(MPPOrderBOMLine line) {
        MLocator locator;
        MPPOrder order = this;
        Timestamp movementDate = order.getUpdated();
        if (line.getQtyBatch().signum() != 0 && line.getQtyBOM().signum() != 0) {
            return;
        }
        BigDecimal qtyMethodChangeVariancePrev = line.getQtyMethodChangeVariance();
        BigDecimal qtyOpen = line.getQtyOpen();
        BigDecimal qtyMethodChangeVariance = qtyOpen.subtract(qtyMethodChangeVariancePrev);
        if (qtyMethodChangeVariance.signum() == 0) {
            return;
        }
        int M_Locator_ID = line.getM_Locator_ID();
        if (M_Locator_ID <= 0 && (locator = MLocator.getDefault(MWarehouse.get(order.getCtx(), order.getM_Warehouse_ID()))) != null) {
            M_Locator_ID = locator.getM_Locator_ID();
        }
        MPPCostCollector cc = MPPCostCollector.createCollector(order, line.getM_Product_ID(), M_Locator_ID, line.getM_AttributeSetInstance_ID(), order.getS_Resource_ID(), line.getPP_Order_BOMLine_ID(), 0, MDocType.getDocType("MCC"), "130", movementDate, qtyMethodChangeVariance, Env.ZERO, Env.ZERO, 0, Env.ZERO);
    }

    private void createUsageVariance(I_PP_Order_Node orderNode) {
        MPPOrder order = this;
        Timestamp movementDate = order.getUpdated();
        MPPOrderNode node = (MPPOrderNode)orderNode;
        BigDecimal setupTimeReal = BigDecimal.valueOf(node.getSetupTimeReal());
        BigDecimal durationReal = BigDecimal.valueOf(node.getDurationReal());
        if (setupTimeReal.signum() == 0 && durationReal.signum() == 0) {
            return;
        }
        BigDecimal setupTimeVariancePrev = node.getSetupTimeUsageVariance();
        BigDecimal durationVariancePrev = node.getDurationUsageVariance();
        BigDecimal setupTimeRequired = BigDecimal.valueOf(node.getSetupTimeRequired());
        BigDecimal durationRequired = BigDecimal.valueOf(node.getDurationRequired());
        BigDecimal qtyOpen = node.getQtyToDeliver();
        BigDecimal setupTimeVariance = setupTimeRequired.subtract(setupTimeReal).subtract(setupTimeVariancePrev);
        BigDecimal durationVariance = durationRequired.subtract(durationReal).subtract(durationVariancePrev);
        if (qtyOpen.signum() == 0 && setupTimeVariance.signum() == 0 && durationVariance.signum() == 0) {
            return;
        }
        MPPCostCollector.createCollector(order, order.getM_Product_ID(), order.getM_Locator_ID(), order.getM_AttributeSetInstance_ID(), node.getS_Resource_ID(), 0, node.getPP_Order_Node_ID(), MDocType.getDocType("MCC"), "120", movementDate, qtyOpen, Env.ZERO, Env.ZERO, setupTimeVariance.intValueExact(), durationVariance);
    }

    public BigDecimal getQtyToDeliver() {
        return this.getQtyOrdered().subtract(this.getQtyDelivered());
    }

    public void updateMakeToKit(BigDecimal qtyShipment) {
        MPPOrderBOM obom = this.getMPPOrderBOM();
        this.getLines(true);
        if ("K".equals(obom.getBOMType()) && "M".equals(obom.getBOMUse())) {
            Timestamp today = new Timestamp(System.currentTimeMillis());
            ArrayList[][] issue = new ArrayList[this.m_lines.length][1];
            for (int i2 = 0; i2 < this.getLines().length; ++i2) {
                MPPOrderBOMLine line = this.m_lines[i2];
                KeyNamePair id = null;
                id = "1".equals(line.getIssueMethod()) ? new KeyNamePair(line.get_ID(), "Y") : new KeyNamePair(line.get_ID(), "N");
                ArrayList<Object> data = new ArrayList<Object>();
                BigDecimal qtyToDeliver = qtyShipment.multiply(line.getQtyMultiplier());
                data.add(id);
                data.add(line.isCritical());
                MProduct product = line.getM_Product();
                data.add(product.getValue());
                KeyNamePair productKey = new KeyNamePair(product.get_ID(), product.getName());
                data.add(productKey);
                data.add(qtyToDeliver);
                data.add(Env.ZERO);
                issue[i2][0] = data;
            }
            boolean forceIssue = false;
            MOrderLine oline = (MOrderLine)this.getC_OrderLine();
            if ("L".equals(oline.getParent().getDeliveryRule()) || "O".equals(oline.getParent().getDeliveryRule())) {
                boolean isCompleteQtyDeliver = MPPOrder.isQtyAvailable(this, issue, today);
                if (!isCompleteQtyDeliver) {
                    throw new AdempiereException("@NoQtyAvailable@");
                }
            } else {
                if ("A".equals(oline.getParent().getDeliveryRule()) || "R".equals(oline.getParent().getDeliveryRule()) || "M".equals(oline.getParent().getDeliveryRule())) {
                    throw new AdempiereException("@ActionNotSupported@");
                }
                if ("F".equals(oline.getParent().getDeliveryRule())) {
                    forceIssue = true;
                }
            }
            for (int i3 = 0; i3 < issue.length; ++i3) {
                int M_AttributeSetInstance_ID = 0;
                KeyNamePair key = (KeyNamePair)issue[i3][0].get(0);
                Boolean isCritical = (Boolean)issue[i3][0].get(1);
                String value = (String)issue[i3][0].get(2);
                KeyNamePair productkey = (KeyNamePair)issue[i3][0].get(3);
                int M_Product_ID = productkey.getKey();
                MProduct product = MProduct.get(this.getCtx(), M_Product_ID);
                BigDecimal qtyToDeliver = (BigDecimal)issue[i3][0].get(4);
                BigDecimal qtyScrapComponent = (BigDecimal)issue[i3][0].get(5);
                int PP_Order_BOMLine_ID = key.getKey();
                if (PP_Order_BOMLine_ID > 0) {
                    MPPOrderBOMLine orderBOMLine = new MPPOrderBOMLine(this.getCtx(), PP_Order_BOMLine_ID, this.get_TrxName());
                    M_AttributeSetInstance_ID = orderBOMLine.getM_AttributeSetInstance_ID();
                }
                MStorage[] storages = MPPOrder.getStorages(this.getCtx(), M_Product_ID, this.getM_Warehouse_ID(), M_AttributeSetInstance_ID, today, this.get_TrxName());
                MPPOrder.createIssue(this, key.getKey(), today, qtyToDeliver, qtyScrapComponent, Env.ZERO, storages, forceIssue);
            }
            MPPOrder.createReceipt(this, today, this.getQtyDelivered(), qtyShipment, this.getQtyScrap(), this.getQtyReject(), this.getM_Locator_ID(), this.getM_AttributeSetInstance_ID());
        }
    }
}

