/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.grid;

import java.awt.Component;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.script.ScriptEngine;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.adempiere.model.MBrowseField;
import org.adempiere.model.MViewColumn;
import org.compiere.grid.ed.VCellRenderer;
import org.compiere.grid.ed.VHeaderRenderer;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IDColumnEditor;
import org.compiere.minigrid.IDColumnRenderer;
import org.compiere.minigrid.ROCellEditor;
import org.compiere.model.GridField;
import org.compiere.model.MRule;
import org.compiere.swing.CTable;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.eevolution.form.BrowserCallOut;
import org.eevolution.form.BrowserRows;
import org.eevolution.form.VBrowser;
import org.eevolution.grid.IBrowseTable;
import org.eevolution.grid.VBrowseCellEditor;

public class BrowseTable
extends CTable
implements IBrowseTable {
    private static final long serialVersionUID = 2853772547464132497L;
    private static CLogger log = CLogger.getCLogger(BrowseTable.class);
    protected BrowserRows browserRows = null;
    protected VBrowser browser;
    private ArrayList<Integer> m_readWriteColumn = new ArrayList();
    private ArrayList<Integer> m_minWidth = new ArrayList();
    private int m_colorColumnIndex = -1;
    private Object m_colorDataCompare = Env.ZERO;
    private boolean m_multiSelection = false;
    private boolean showTotals = false;
    private boolean autoResize = true;
    private List<String> activeCallOuts = new ArrayList<String>();
    private List<BrowserCallOut> activeCallOutInstance = new ArrayList<BrowserCallOut>();
    private Properties ctx = Env.getCtx();

    public BrowseTable(VBrowser browser) {
        this.browserRows = new BrowserRows(this);
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(false);
        this.setCellEditor(new ROCellEditor());
        this.browser = browser;
    }

    public boolean isAutoResize() {
        return this.autoResize;
    }

    public void setAutoResize(boolean autoResize) {
        this.autoResize = autoResize;
    }

    public TableColumn getColumn(int col) {
        return this.getColumnModel().getColumn(col);
    }

    @Override
    public int getColumnCount() {
        return this.getColumnModel().getColumnCount();
    }

    @Override
    public void autoSize() {
        if (!this.autoResize) {
            return;
        }
        long start = System.currentTimeMillis();
        int SLACK = 8;
        int MAXSIZE = 300;
        TableModel model = this.getModel();
        int size = model.getColumnCount();
        for (int col = 0; col < size; ++col) {
            TableCellRenderer renderer;
            TableColumn tc = this.getColumnModel().getColumn(col);
            int width = 0;
            if (this.m_minWidth.size() > col) {
                width = this.m_minWidth.get(col);
            }
            if ((renderer = tc.getHeaderRenderer()) == null) {
                renderer = new DefaultTableCellRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(this, tc.getHeaderValue(), false, false, 0, 0);
            width = Math.max(width, comp.getPreferredSize().width + 8);
            int maxRow = Math.min(30, this.getRowCount());
            for (int row = 0; row < maxRow; ++row) {
                renderer = this.getCellRenderer(row, col);
                comp = renderer.getTableCellRendererComponent(this, this.getValueAt(row, col), false, false, row, col);
                if (comp == null) continue;
                int rowWidth = comp.getPreferredSize().width + 8;
                width = Math.max(width, rowWidth);
            }
            width = Math.min(300, width);
            tc.setPreferredWidth(width);
        }
        log.finer("Cols=" + size + " - " + (System.currentTimeMillis() - start) + "ms");
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (column != 0 && this.getValueAt(row, 0) instanceof Boolean && !((Boolean)this.getValueAt(row, 0)).booleanValue()) {
            return false;
        }
        return this.m_readWriteColumn.contains(new Integer(column));
    }

    @Override
    public void setColumnReadOnly(int column, boolean readOnly) {
        if (this.m_readWriteColumn.contains(new Integer(column))) {
            if (readOnly) {
                int size = this.m_readWriteColumn.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    if (this.m_readWriteColumn.get(i2) != column) continue;
                    this.m_readWriteColumn.remove(i2);
                    break;
                }
            }
        } else if (!readOnly) {
            this.m_readWriteColumn.add(new Integer(column));
        }
    }

    public String prepareTable(List<MBrowseField> fields, boolean multiSelection) {
        StringBuffer sql = new StringBuffer("");
        this.m_multiSelection = multiSelection;
        int col = 0;
        for (MBrowseField field : fields) {
            MViewColumn columnView = field.getAD_View_Column();
            if (col > 0 && columnView.getColumnSQL().length() > 0) {
                sql.append(", ");
            }
            if (field.isKey()) {
                this.setKey(col);
                field.setName("#");
            }
            sql.append(columnView.getColumnSQL()).append(" ").append("AS").append(" ").append(columnView.getColumnName());
            this.browserRows.addBrowserField(field, col);
            if (!field.isDisplayed()) continue;
            this.addColumn(field.get_ValueAsString("Name"));
            ++col;
        }
        col = 0;
        for (MBrowseField field : fields) {
            if (!field.isDisplayed()) continue;
            this.setColumnClass(col, MBrowseField.createGridFieldVO(field, this.browser.getWindowNo()), field.getAD_Reference_ID(), field.isReadOnly(), field.get_ValueAsString("Name"));
            ++col;
        }
        return sql.toString();
    }

    @Override
    public void addColumn(String header) {
        if (!(this.getModel() instanceof DefaultTableModel)) {
            throw new IllegalArgumentException("Model must be instance of DefaultTableModel");
        }
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        model.addColumn(Util.cleanAmp(header));
    }

    @Override
    public void setColumnClass(int index, GridField gridField, int displayType, boolean readOnly, String header) {
        TableColumn tc = this.getColumnModel().getColumn(index);
        if (tc == null) {
            return;
        }
        this.setColumnReadOnly(index, readOnly);
        if (header != null && header.length() > 0) {
            tc.setHeaderValue(Util.cleanAmp(header));
        }
        if (index == this.p_keyColumnIndex) {
            tc.setCellRenderer(new IDColumnRenderer(this.m_multiSelection));
            if (this.m_multiSelection) {
                tc.setCellEditor(new IDColumnEditor());
                this.setColumnReadOnly(index, false);
            } else {
                tc.setCellEditor(new ROCellEditor());
            }
            this.m_minWidth.add(new Integer(10));
            tc.setMaxWidth(20);
            tc.setPreferredWidth(20);
            tc.setResizable(false);
            tc.setHeaderRenderer(new VHeaderRenderer(22));
        } else {
            tc.setCellRenderer(new VCellRenderer(gridField));
            tc.setCellEditor(new VBrowseCellEditor(gridField));
            this.m_minWidth.add(new Integer(30));
            tc.setHeaderRenderer(new VHeaderRenderer(displayType));
        }
    }

    @Override
    public void setRowCount(int no) {
        if (!(this.getModel() instanceof DefaultTableModel)) {
            throw new IllegalArgumentException("Model must be instance of DefaultTableModel");
        }
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        model.setRowCount(no);
    }

    @Override
    public Integer getSelectedRowKey() {
        if (this.browserRows.getColumnCount() == 0) {
            throw new UnsupportedOperationException("Layout not defined");
        }
        int row = this.getSelectedRow();
        if (row != -1 && this.p_keyColumnIndex != -1) {
            Object data = this.getModel().getValueAt(row, this.p_keyColumnIndex);
            if (data instanceof IDColumn) {
                data = ((IDColumn)data).getRecord_ID();
            }
            if (data instanceof Integer) {
                return (Integer)data;
            }
        }
        return null;
    }

    public Collection<Integer> getSelectedKeys() {
        if (this.browserRows.getColumnCount() == 0) {
            throw new UnsupportedOperationException("Layout not defined");
        }
        if (this.p_keyColumnIndex < 0) {
            throw new UnsupportedOperationException("Key Column is not defined");
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int row = 0; row < this.getRowCount(); ++row) {
            IDColumn record;
            Object data = this.getModel().getValueAt(row, this.p_keyColumnIndex);
            if (!(data instanceof IDColumn) || !(record = (IDColumn)data).isSelected()) continue;
            list.add(record.getRecord_ID());
        }
        return list;
    }

    @Override
    public boolean isMultiSelection() {
        return this.m_multiSelection;
    }

    @Override
    public void setMultiSelection(boolean multiSelection) {
        this.m_multiSelection = multiSelection;
    }

    public void setColorColumn(int modelIndex) {
        this.m_colorColumnIndex = modelIndex;
    }

    @Override
    public void setColorCompare(Object dataCompare) {
        this.m_colorDataCompare = dataCompare;
    }

    @Override
    public int getColorCode(int row) {
        if (this.m_colorColumnIndex == -1) {
            return 0;
        }
        Object data = this.getModel().getValueAt(row, this.m_colorColumnIndex);
        int cmp = 0;
        if (data == null) {
            return 0;
        }
        try {
            if (data instanceof Timestamp) {
                if (this.m_colorDataCompare == null || !(this.m_colorDataCompare instanceof Timestamp)) {
                    this.m_colorDataCompare = new Timestamp(System.currentTimeMillis());
                }
                cmp = ((Timestamp)this.m_colorDataCompare).compareTo((Timestamp)data);
            } else {
                if (this.m_colorDataCompare == null || !(this.m_colorDataCompare instanceof BigDecimal)) {
                    this.m_colorDataCompare = Env.ZERO;
                }
                if (!(data instanceof BigDecimal)) {
                    data = new BigDecimal(data.toString());
                }
                cmp = ((BigDecimal)this.m_colorDataCompare).compareTo((BigDecimal)data);
            }
        }
        catch (Exception e) {
            return 0;
        }
        if (cmp > 0) {
            return -1;
        }
        if (cmp < 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isShowTotals() {
        return this.showTotals;
    }

    @Override
    public void setShowTotals(boolean show) {
        this.showTotals = show;
    }

    public void addTotals() {
        int row;
        if (this.getRowCount() == 0 || this.browserRows.getNoViewColumns() == 0) {
            return;
        }
        Object[] total = new Object[this.browserRows.getNoViewColumns().intValue()];
        for (row = 0; row < this.getRowCount(); ++row) {
            for (int col = 0; col < this.browserRows.getNoViewColumns(); ++col) {
                Object data = this.getModel().getValueAt(row, col);
                int ReferenceType = this.browserRows.getBrowserField(this.browserRows.getTableIndex(col)).getAD_Reference_ID();
                if (!DisplayType.isNumeric(ReferenceType)) continue;
                BigDecimal subtotal = Env.ZERO;
                if (total[col] != null) {
                    subtotal = (BigDecimal)total[col];
                }
                BigDecimal amt = (BigDecimal)data;
                if (subtotal == null) {
                    subtotal = Env.ZERO;
                }
                if (amt == null) {
                    amt = Env.ZERO;
                }
                total[col] = subtotal.add(amt);
            }
        }
        row = this.getRowCount() + 1;
        boolean markerSet = false;
        this.setRowCount(row);
        for (int col = 0; col < this.browserRows.getNoViewColumns(); ++col) {
            MBrowseField field = this.browserRows.getBrowserField(this.browserRows.getTableIndex(col));
            GridField gridField = MBrowseField.createGridFieldVO(field, this.browser.getWindowNo());
            if (DisplayType.isNumeric(field.getAD_Reference_ID())) {
                gridField.setValue(total[col], true);
                this.setValueAt(row - 1, col, gridField);
                continue;
            }
            if (DisplayType.isText(field.getAD_Reference_ID()) && !markerSet) {
                gridField.setValue(" \u03a3 ", true);
                this.setValueAt(row - 1, col, gridField);
                markerSet = true;
                continue;
            }
            gridField.setValue(null, true);
            this.setValueAt(row - 1, col, gridField);
        }
    }

    public BrowserRows getData() {
        return this.browserRows;
    }

    @Override
    public void setValueAt(int row, int column, GridField gridField) {
        if (gridField == null) {
            throw new UnsupportedOperationException("No GridField");
        }
        this.browserRows.setValue(row, this.browserRows.getTableIndex(column), gridField);
        if (gridField.isDisplayed()) {
            super.setValueAt(gridField.getValue(), row, column);
        }
    }

    private void setKey(int col) {
        this.p_keyColumnIndex = col;
        this.browser.m_keyColumnIndex = col;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processCallOut(GridField field, Object value, Object oldValue, int currentRow, int currentColumn) {
        String callout = field.getCallout();
        if (callout.length() == 0) {
            return "";
        }
        log.fine(field.getColumnName() + "=" + value + " (" + callout + ") - old=" + oldValue);
        StringTokenizer st = new StringTokenizer(callout, ";,", false);
        while (st.hasMoreTokens()) {
            String cmd = st.nextToken().trim();
            if (this.activeCallOuts.contains(cmd)) continue;
            String retValue = "";
            if (cmd.toLowerCase().startsWith("@script:")) {
                MRule rule = MRule.get(this.ctx, cmd.substring("@script:".length()));
                if (rule == null) {
                    retValue = "Callout " + cmd + " not found";
                    log.log(Level.SEVERE, retValue);
                    return retValue;
                }
                if (!rule.getEventType().equals("C") || !rule.getRuleType().equals("S")) {
                    retValue = "Callout " + cmd + " must be of type JSR 223 and event Callout";
                    log.log(Level.SEVERE, retValue);
                    return retValue;
                }
                ScriptEngine engine = rule.getScriptEngine();
                MRule.setContext(engine, this.ctx, this.browser.getWindowNo());
                engine.put("A_WindowNo", this.browser.getWindowNo());
                engine.put("A_Tab", this);
                engine.put("A_Field", field);
                engine.put("A_Value", value);
                engine.put("A_OldValue", oldValue);
                engine.put("A_currentRow", currentRow);
                engine.put("A_currentColumn", currentColumn);
                engine.put("A_Ctx", this.ctx);
                try {
                    this.activeCallOuts.add(cmd);
                    retValue = engine.eval(rule.getScript()).toString();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "", e);
                    String string = retValue = "Callout Invalid: " + e.toString();
                    return string;
                }
                finally {
                    this.activeCallOuts.remove(cmd);
                }
            }
            BrowserCallOut call = null;
            String method = null;
            int methodStart = cmd.lastIndexOf(46);
            try {
                if (methodStart != -1) {
                    Class<?> cClass = Class.forName(cmd.substring(0, methodStart));
                    call = (BrowserCallOut)cClass.newInstance();
                    method = cmd.substring(methodStart + 1);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "class", e);
                return "Callout Invalid: " + cmd + " (" + e.toString() + ")";
            }
            if (call == null || method == null || method.length() == 0) {
                return "Callout Invalid: " + method;
            }
            try {
                this.activeCallOuts.add(cmd);
                this.activeCallOutInstance.add(call);
                retValue = call.start(this.ctx, method, this.browser.getWindowNo(), this.browserRows, field, value, oldValue, currentRow, currentColumn);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "start", e);
                String string = retValue = "Callout Invalid: " + e.toString();
                return string;
            }
            finally {
                this.activeCallOuts.remove(cmd);
                this.activeCallOutInstance.remove(call);
            }
            if (Util.isEmpty(retValue)) continue;
            log.severe(retValue);
            return retValue;
        }
        return "";
    }

    @Override
    protected void sort(int modelColumnIndex) {
        this.sorting = false;
    }
}

