/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form.crp;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.compiere.model.MProduct;
import org.compiere.model.MResource;
import org.compiere.model.MResourceType;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.eevolution.form.crp.CRPModel;
import org.eevolution.form.crp.DiagramTreeCellRenderer;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.MPPOrderNode;
import org.eevolution.model.MPPOrderWorkflow;
import org.eevolution.model.reasoner.CRPReasoner;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public abstract class CRPDatasetFactory
extends CRPReasoner
implements CRPModel {
    protected JTree tree;
    protected DefaultCategoryDataset dataset;

    protected abstract BigDecimal convert(BigDecimal var1);

    public static CRPModel get(Timestamp start, Timestamp end, MResource r) {
        MResourceType t = MResourceType.get(Env.getCtx(), r.getS_ResourceType_ID());
        final MUOM uom1 = MUOM.get(Env.getCtx(), MUOM.getMinute_UOM_ID(Env.getCtx()));
        final MUOM uom2 = MUOM.get(Env.getCtx(), t.getC_UOM_ID());
        CRPDatasetFactory factory = new CRPDatasetFactory(){

            @Override
            protected BigDecimal convert(BigDecimal minutes) {
                return MUOMConversion.convert(Env.getCtx(), uom1.get_ID(), uom2.get_ID(), minutes);
            }
        };
        super.generate(start, end, r);
        return factory;
    }

    private void generate(Timestamp start, Timestamp end, MResource r) {
        if (start == null || end == null || r == null) {
            return;
        }
        String labelActCap = Msg.translate(Env.getCtx(), "DailyCapacity");
        String labelLoadAct = Msg.translate(Env.getCtx(), "ActualLoad");
        SimpleDateFormat formatter = DisplayType.getDateFormat(16, Env.getLanguage(Env.getCtx()));
        BigDecimal dailyCapacity = this.getMaxRange(r);
        this.dataset = new DefaultCategoryDataset();
        HashMap<DefaultMutableTreeNode, String> names = new HashMap<DefaultMutableTreeNode, String>();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(r);
        names.put(root, this.getTreeNodeRepresentation(null, root, r));
        Timestamp dateTime = start;
        while (end.after(dateTime)) {
            String label = formatter.format(dateTime);
            names.putAll(this.addTreeNodes(dateTime, root, r));
            boolean available = this.isAvailable(r, dateTime);
            this.dataset.addValue((Number)(available ? dailyCapacity : BigDecimal.ZERO), (Comparable)((Object)labelActCap), (Comparable)((Object)label));
            this.dataset.addValue((Number)(available ? this.calculateLoad(dateTime, r, null) : BigDecimal.ZERO), (Comparable)((Object)labelLoadAct), (Comparable)((Object)label));
            dateTime = TimeUtil.addDays(dateTime, 1);
        }
        this.tree = new JTree(root);
        this.tree.setCellRenderer(new DiagramTreeCellRenderer(names));
    }

    @Override
    public BigDecimal calculateLoad(Timestamp dateTime, MResource r, String docStatus) {
        MResourceType t = MResourceType.get(Env.getCtx(), r.getS_ResourceType_ID());
        MUOM uom = MUOM.get(Env.getCtx(), t.getC_UOM_ID());
        long millis = 0L;
        for (MPPOrderNode node : this.getPPOrderNodes(dateTime, r)) {
            MPPOrder o;
            if (docStatus != null && !(o = new MPPOrder(node.getCtx(), node.getPP_Order_ID(), node.get_TrxName())).getDocStatus().equals(docStatus)) continue;
            millis += this.calculateMillisForDay(dateTime, node, t);
        }
        BigDecimal scale = new BigDecimal(60000);
        BigDecimal minutes = new BigDecimal(millis).divide(scale, 2, 4);
        return this.convert(minutes);
    }

    private Timestamp[] getDayBorders(Timestamp dateTime, MPPOrderNode node, MResourceType t) {
        Timestamp endDayTime = t.getDayEnd(dateTime);
        endDayTime = endDayTime.before(node.getDateFinishSchedule()) ? endDayTime : node.getDateFinishSchedule();
        Timestamp startDayTime = t.getDayStart(dateTime);
        startDayTime = startDayTime.after(node.getDateStartSchedule()) ? startDayTime : node.getDateStartSchedule();
        return new Timestamp[]{startDayTime, endDayTime};
    }

    private long calculateMillisForDay(Timestamp dateTime, MPPOrderNode node, MResourceType t) {
        Timestamp[] borders = this.getDayBorders(dateTime, node, t);
        return borders[1].getTime() - borders[0].getTime();
    }

    private HashMap<DefaultMutableTreeNode, String> addTreeNodes(Timestamp dateTime, DefaultMutableTreeNode root, MResource r) {
        HashMap<DefaultMutableTreeNode, String> names = new HashMap<DefaultMutableTreeNode, String>();
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(dateTime);
        names.put(parent, this.getTreeNodeRepresentation(null, parent, r));
        root.add(parent);
        for (MPPOrder order : this.getPPOrders(dateTime, r)) {
            DefaultMutableTreeNode childOrder = new DefaultMutableTreeNode(order);
            parent.add(childOrder);
            names.put(childOrder, this.getTreeNodeRepresentation(dateTime, childOrder, r));
            for (MPPOrderNode node : this.getPPOrderNodes(dateTime, r)) {
                DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(node);
                childOrder.add(childNode);
                names.put(childNode, this.getTreeNodeRepresentation(dateTime, childNode, r));
            }
        }
        return names;
    }

    private String getTreeNodeRepresentation(Timestamp dateTime, DefaultMutableTreeNode node, MResource r) {
        String name = null;
        if (node.getUserObject() instanceof MResource) {
            MResource res = (MResource)node.getUserObject();
            name = res.getName();
        } else if (node.getUserObject() instanceof Timestamp) {
            Timestamp d = (Timestamp)node.getUserObject();
            SimpleDateFormat df = Env.getLanguage(Env.getCtx()).getDateFormat();
            name = df.format(d);
            if (!this.isAvailable(r, d)) {
                name = "{" + name + "}";
            }
        } else if (node.getUserObject() instanceof MPPOrder) {
            MPPOrder o = (MPPOrder)node.getUserObject();
            MProduct p2 = MProduct.get(Env.getCtx(), o.getM_Product_ID());
            name = o.getDocumentNo() + " (" + p2.getName() + ")";
        } else if (node.getUserObject() instanceof MPPOrderNode) {
            MPPOrderNode on = (MPPOrderNode)node.getUserObject();
            MPPOrderWorkflow owf = on.getMPPOrderWorkflow();
            MResourceType rt = MResourceType.get(Env.getCtx(), r.getS_ResourceType_ID());
            SimpleDateFormat df = new SimpleDateFormat("HH:mm");
            Timestamp[] interval = this.getDayBorders(dateTime, on, rt);
            name = df.format(interval[0]) + " - " + df.format(interval[1]) + " " + on.getName() + " (" + owf.getName() + ")";
        }
        return name;
    }

    private BigDecimal getMaxRange(MResource r) {
        BigDecimal utilizationDec = r.getPercentUtilization().divide(Env.ONEHUNDRED, 2, RoundingMode.HALF_UP);
        int precision = 2;
        return r.getDailyCapacity().multiply(utilizationDec).setScale(precision, RoundingMode.HALF_UP);
    }

    @Override
    public CategoryDataset getDataset() {
        return this.dataset;
    }

    @Override
    public JTree getTree() {
        return this.tree;
    }
}

