/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ADialog;
import org.compiere.apps.ADialogDialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MColumn;
import org.compiere.model.MDocType;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MQuery;
import org.compiere.model.PrintInfo;
import org.compiere.plaf.CompiereColor;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.print.Viewer;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTabbedPane;
import org.compiere.swing.CTextPane;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.eevolution.model.MDDOrder;
import org.eevolution.model.MDDOrderLine;

public class VOrderDistributionReceipt
extends CPanel
implements FormPanel,
ActionListener,
VetoableChangeListener,
ChangeListener,
TableModelListener {
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private boolean m_selectionActive = true;
    private Object m_DD_Order_ID = null;
    private Object m_MovementDate = null;
    private static CLogger log = CLogger.getCLogger(VOrderDistributionReceipt.class);
    private CTabbedPane tabbedPane = new CTabbedPane();
    private CPanel selPanel = new CPanel();
    private CPanel selNorthPanel = new CPanel();
    private BorderLayout selPanelLayout = new BorderLayout();
    private CLabel lOrder = new CLabel();
    private VLookup fOrder;
    private VDate fMovementDate = new VDate("MovementDate", true, false, true, 15, "MovementDate");
    private CLabel lMovementDate = new CLabel(Msg.translate(Env.getCtx(), "MovementDate"));
    private FlowLayout northPanelLayout = new FlowLayout();
    private ConfirmPanel confirmPanelSel = new ConfirmPanel(true);
    private ConfirmPanel confirmPanelGen = new ConfirmPanel(false, true, false, false, false, false, true);
    private StatusBar statusBar = new StatusBar();
    private CPanel genPanel = new CPanel();
    private BorderLayout genLayout = new BorderLayout();
    private CTextPane info = new CTextPane();
    private JScrollPane scrollPane = new JScrollPane();
    private MiniTable miniTable = new MiniTable();
    private ArrayList<Integer> selection = null;

    @Override
    public void init(int WindowNo, FormFrame frame) {
        log.info("");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        Env.setContext(Env.getCtx(), this.m_WindowNo, "IsSOTrx", "Y");
        try {
            this.fillPicks();
            this.jbInit();
            this.dynInit();
            frame.getContentPane().add((Component)this.tabbedPane, "Center");
            frame.getContentPane().add((Component)this.statusBar, "South");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "init", ex);
        }
    }

    void jbInit() throws Exception {
        CompiereColor.setBackground(this);
        this.selPanel.setLayout(this.selPanelLayout);
        this.lOrder.setLabelFor(this.fOrder);
        this.selNorthPanel.setLayout(this.northPanelLayout);
        this.northPanelLayout.setAlignment(0);
        this.tabbedPane.add((Component)this.selPanel, Msg.getMsg(Env.getCtx(), "Select"));
        this.selPanel.add((Component)this.selNorthPanel, "North");
        this.selNorthPanel.add((Component)this.lOrder, null);
        this.selNorthPanel.add((Component)this.fOrder, null);
        this.selNorthPanel.add((Component)this.lMovementDate, null);
        this.selNorthPanel.add((Component)this.fMovementDate, null);
        this.selPanel.setName("selPanel");
        this.selPanel.add((Component)this.confirmPanelSel, "South");
        this.selPanel.add((Component)this.scrollPane, "Center");
        this.scrollPane.getViewport().add((Component)this.miniTable, null);
        this.confirmPanelSel.addActionListener(this);
        this.tabbedPane.add((Component)this.genPanel, Msg.getMsg(Env.getCtx(), "Generate"));
        this.genPanel.setLayout(this.genLayout);
        this.genPanel.add((Component)this.info, "Center");
        this.genPanel.setEnabled(false);
        this.info.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.info.setEditable(false);
        this.genPanel.add((Component)this.confirmPanelGen, "South");
        this.confirmPanelGen.addActionListener(this);
    }

    private void fillPicks() throws Exception {
        Language language = Language.getLoginLanguage();
        MLookup orderL = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, MColumn.getColumn_ID("DD_Order", "DD_Order_ID"), 30, language, "DD_Order_ID", 0, false, "DocStatus='CO' AND IsInTransit='Y'");
        this.fOrder = new VLookup("DD_Order_ID", true, false, true, orderL);
        this.lOrder.setText(Msg.translate(Env.getCtx(), "DD_Order_ID"));
        this.fOrder.addVetoableChangeListener(this);
        Timestamp today = new Timestamp(System.currentTimeMillis());
        this.m_MovementDate = today;
        this.fMovementDate.setValue(today);
        this.fMovementDate.addVetoableChangeListener(this);
    }

    private void dynInit() {
        this.miniTable.addColumn("DD_Order_ID");
        this.miniTable.addColumn("QtyInTransit");
        this.miniTable.addColumn("C_UOM_ID");
        this.miniTable.addColumn("Value");
        this.miniTable.addColumn("M_Product_ID");
        this.miniTable.addColumn("M_WarehouseSource_ID");
        this.miniTable.setMultiSelection(true);
        this.miniTable.setRowSelectionAllowed(true);
        this.miniTable.setColumnClass(0, IDColumn.class, false, " ");
        this.miniTable.setColumnClass(1, BigDecimal.class, false, Msg.translate(Env.getCtx(), "QtyInTransit"));
        this.miniTable.setColumnClass(2, String.class, true, Msg.translate(Env.getCtx(), "C_UOM_ID"));
        this.miniTable.setColumnClass(3, String.class, true, Msg.translate(Env.getCtx(), "M_Product_ID"));
        this.miniTable.setColumnClass(4, String.class, true, Msg.translate(Env.getCtx(), "Value"));
        this.miniTable.setColumnClass(5, String.class, true, Msg.translate(Env.getCtx(), "WarehouseSource"));
        this.miniTable.autoSize();
        this.miniTable.getModel().addTableModelListener(this);
        this.statusBar.setStatusLine(Msg.getMsg(Env.getCtx(), "InOutGenerateSel"));
        this.statusBar.setStatusDB(" ");
        this.tabbedPane.addChangeListener(this);
    }

    private String getOrderSQL() {
        StringBuffer sql = new StringBuffer("SELECT ol.DD_OrderLine_ID, ol.QtyInTransit , uom.Name , p.Value ,p.Name  , w.Name FROM DD_OrderLine ol INNER JOIN DD_Order o ON (o.DD_Order_ID=ol.DD_Order_ID) INNER JOIN M_Product p ON (p.M_Product_ID=ol.M_Product_ID)  INNER JOIN C_UOM uom  ON (uom.C_UOM_ID=ol.C_UOM_ID) INNER JOIN M_Locator  l ON (l.M_Locator_ID = ol.M_Locator_ID) INNER JOIN M_Warehouse  w ON (w.M_Warehouse_ID = l.M_Warehouse_ID) WHERE o.DocStatus= 'CO' AND  ol.QtyInTransit > 0  AND  o.DD_Order_ID = ? ");
        return sql.toString();
    }

    private void executeQuery() {
        log.info("");
        String sql = "";
        if (this.m_DD_Order_ID == null) {
            return;
        }
        sql = this.getOrderSQL();
        log.fine(sql);
        int row = 0;
        this.miniTable.setRowCount(row);
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, Integer.parseInt(this.m_DD_Order_ID.toString()));
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.miniTable.setRowCount(row + 1);
                this.miniTable.setValueAt(new IDColumn(rs.getInt(1)), row, 0);
                this.miniTable.setValueAt(rs.getBigDecimal(2), row, 1);
                this.miniTable.setValueAt(rs.getString(3), row, 2);
                this.miniTable.setValueAt(rs.getString(4), row, 4);
                this.miniTable.setValueAt(rs.getString(5), row, 3);
                this.miniTable.setValueAt(rs.getString(6), row, 5);
                ++row;
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        this.miniTable.autoSize();
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.info("Cmd=" + e.getActionCommand());
        if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
            return;
        }
        this.saveSelection();
        if (this.selection != null && this.selection.size() > 0 && this.m_selectionActive && this.m_DD_Order_ID != null && this.m_MovementDate != null) {
            this.generateMovements();
        } else {
            this.dispose();
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        log.info(e.getPropertyName() + "=" + e.getNewValue());
        if (e.getPropertyName().equals("DD_Order_ID")) {
            this.m_DD_Order_ID = e.getNewValue();
        }
        if (e.getPropertyName().equals("MovementDate")) {
            this.m_MovementDate = e.getNewValue();
        }
        this.executeQuery();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int index = this.tabbedPane.getSelectedIndex();
        this.m_selectionActive = index == 0;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int rowsSelected = 0;
        int rows = this.miniTable.getRowCount();
        for (int i = 0; i < rows; ++i) {
            IDColumn id = (IDColumn)this.miniTable.getValueAt(i, 0);
            if (id == null || !id.isSelected()) continue;
            ++rowsSelected;
        }
        this.statusBar.setStatusDB(" " + rowsSelected + " ");
    }

    private void saveSelection() {
        log.info("");
        this.miniTable.editingStopped(new ChangeEvent(this));
        ArrayList<Integer> results = new ArrayList<Integer>();
        this.selection = null;
        int rows = this.miniTable.getRowCount();
        for (int i = 0; i < rows; ++i) {
            IDColumn id = (IDColumn)this.miniTable.getValueAt(i, 0);
            if (id == null || !id.isSelected()) continue;
            results.add(id.getRecord_ID());
        }
        if (results.size() == 0) {
            return;
        }
        log.config("Selected #" + results.size());
        this.selection = results;
    }

    private void generateMovements() {
        log.info("DD_Order_ID=" + this.m_DD_Order_ID);
        log.info("MovementDate" + this.m_MovementDate);
        String trxName = Trx.createTrxName("IOG");
        Trx trx = Trx.get(trxName, true);
        this.m_selectionActive = false;
        this.statusBar.setStatusLine(Msg.translate(Env.getCtx(), "M_Movement_ID"));
        this.statusBar.setStatusDB(String.valueOf(this.selection.size()));
        if (this.selection.size() <= 0) {
            return;
        }
        Properties m_ctx = Env.getCtx();
        Timestamp MovementDate = (Timestamp)this.m_MovementDate;
        MDDOrder order = new MDDOrder(m_ctx, Integer.parseInt(this.m_DD_Order_ID.toString()), trxName);
        MMovement movement = new MMovement(m_ctx, 0, trxName);
        movement.setDD_Order_ID(order.getDD_Order_ID());
        movement.setAD_User_ID(order.getAD_User_ID());
        movement.setPOReference(order.getPOReference());
        movement.setReversal_ID(0);
        movement.setM_Shipper_ID(order.getM_Shipper_ID());
        movement.setDescription(order.getDescription());
        movement.setC_BPartner_ID(order.getC_BPartner_ID());
        movement.setC_BPartner_Location_ID(order.getC_BPartner_Location_ID());
        movement.setAD_Org_ID(order.getAD_Org_ID());
        movement.setAD_OrgTrx_ID(order.getAD_OrgTrx_ID());
        movement.setAD_User_ID(order.getAD_User_ID());
        movement.setC_Activity_ID(order.getC_Activity_ID());
        movement.setC_Campaign_ID(order.getC_Campaign_ID());
        movement.setC_Project_ID(order.getC_Project_ID());
        movement.setMovementDate(MovementDate);
        movement.setDeliveryRule(order.getDeliveryRule());
        movement.setDeliveryViaRule(order.getDeliveryViaRule());
        movement.setDocAction("PR");
        movement.setDocStatus("DR");
        int docTypeDO_ID = this.getDocType("MMM", order.getAD_Org_ID());
        if (docTypeDO_ID > 0) {
            movement.setC_DocType_ID(docTypeDO_ID);
        }
        movement.saveEx();
        for (int i = 0; i < this.selection.size(); ++i) {
            int DD_OrderLine_ID = this.selection.get(i);
            MDDOrderLine oline = new MDDOrderLine(m_ctx, DD_OrderLine_ID, trxName);
            MMovementLine line = new MMovementLine(movement);
            line.setM_Product_ID(oline.getM_Product_ID());
            BigDecimal QtyDeliver = (BigDecimal)this.miniTable.getValueAt(i, 1);
            if (QtyDeliver == null | QtyDeliver.compareTo(oline.getQtyInTransit()) > 0) {
                throw new AdempiereException("Error in Qty");
            }
            line.setOrderLine(oline, QtyDeliver, true);
            line.saveEx();
        }
        movement.setDocAction("CL");
        movement.setDocStatus(movement.completeIt());
        movement.saveEx();
        trx.commit();
        this.generateMovements_complete(movement);
    }

    private int getDocType(String docBaseType, int AD_Org_ID) {
        MDocType[] docs = MDocType.getOfDocBaseType(Env.getCtx(), docBaseType);
        if (docs == null || docs.length == 0) {
            String textMsg = "Not found default document type for docbasetype " + docBaseType;
            throw new AdempiereException(textMsg);
        }
        for (MDocType doc : docs) {
            if (doc.getAD_Org_ID() != AD_Org_ID) continue;
            return doc.getC_DocType_ID();
        }
        log.info("Doc Type for " + docBaseType + ": " + docs[0].getC_DocType_ID());
        return docs[0].getC_DocType_ID();
    }

    private void generateMovements_complete(MMovement movement) {
        this.tabbedPane.setSelectedIndex(1);
        StringBuffer iText = new StringBuffer();
        iText.append("<b>").append("").append("</b><br>").append(Msg.translate(Env.getCtx(), "DocumentNo") + " : " + movement.getDocumentNo()).append("<br>").append("");
        this.info.setText(iText.toString());
        this.confirmPanelGen.getOKButton().setEnabled(false);
        if (ADialog.ask(this.m_WindowNo, this, "PrintShipments")) {
            ADialogDialog d;
            this.setCursor(Cursor.getPredefinedCursor(3));
            int retValue = ADialogDialog.A_CANCEL;
            do {
                MPrintFormat format = MPrintFormat.get(Env.getCtx(), MPrintFormat.getPrintFormat_ID("Inventory Move Hdr (Example)", MMovement.Table_ID, 0), false);
                MQuery query = new MQuery("M_Movement");
                query.addRestriction("M_Movement_ID", "=", movement.getM_Movement_ID());
                PrintInfo info = new PrintInfo("M_Movement", MMovement.Table_ID, movement.getM_Movement_ID());
                ReportEngine re = new ReportEngine(Env.getCtx(), format, query, info);
                re.print();
                new Viewer(re);
            } while ((retValue = (d = new ADialogDialog((Frame)this.m_frame, Env.getHeader(Env.getCtx(), this.m_WindowNo), Msg.getMsg(Env.getCtx(), "PrintoutOK?"), 3)).getReturnCode()) == ADialogDialog.A_CANCEL);
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.confirmPanelGen.getOKButton().setEnabled(true);
    }
}

