/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.adempiere.model.MBrowseField;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.ProcessParameterPanel;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VEditorFactory;
import org.compiere.model.GridField;
import org.compiere.model.GridFieldVO;
import org.compiere.model.MLookup;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VBrowserSearch
extends CPanel
implements VetoableChangeListener {
    private static final long serialVersionUID = 165374610556112182L;
    private int p_WindowNo;
    private ArrayList<VEditor> m_vEditors = new ArrayList();
    private ArrayList<VEditor> m_vEditors2 = new ArrayList();
    private ArrayList<GridField> m_mFields = new ArrayList();
    private ArrayList<GridField> m_mFields2 = new ArrayList();
    private static CLogger log = CLogger.getCLogger(ProcessParameterPanel.class);
    protected LinkedHashMap<Object, Object> m_search = new LinkedHashMap();

    public VBrowserSearch(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public VBrowserSearch(LayoutManager layout) {
        super(layout);
    }

    public VBrowserSearch(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public VBrowserSearch(int windowNo) {
        this.p_WindowNo = windowNo;
    }

    public VBrowserSearch() {
    }

    public VBrowserSearch(CompiereColor bc) {
        super(bc);
    }

    public void addField(MBrowseField field, int row, int col, String name, String title2) {
        GridFieldVO voBase = GridFieldVO.createStdField(field.getCtx(), this.p_WindowNo, 0, 0, 0, false, false, false);
        String uniqueName = field.getAD_View_Column().getColumnSQL();
        voBase.isProcess = true;
        voBase.IsDisplayed = true;
        voBase.IsReadOnly = true;
        voBase.IsUpdateable = true;
        voBase.WindowNo = this.p_WindowNo;
        voBase.AD_Column_ID = field.getAD_View_Column().getAD_Column_ID();
        voBase.AD_Table_ID = field.getAD_View_Column().getAD_Column().getAD_Table_ID();
        voBase.ColumnName = field.getAD_View_Column().getAD_Column().getColumnName();
        voBase.displayType = field.getAD_Reference_ID();
        voBase.AD_Reference_Value_ID = field.getAD_Reference_Value_ID();
        voBase.IsMandatory = field.isMandatory();
        voBase.IsAlwaysUpdateable = false;
        voBase.IsKey = field.isKey();
        voBase.DefaultValue = field.getDefaultValue();
        voBase.DefaultValue2 = field.getDefaultValue2();
        voBase.InfoFactoryClass = field.getInfoFactoryClass();
        voBase.FieldLength = field.getFieldLength();
        voBase.ReadOnlyLogic = field.getReadOnlyLogic();
        voBase.DisplayLogic = field.getDisplayLogic();
        voBase.VFormat = field.getVFormat();
        voBase.ValueMin = field.getValueMin();
        voBase.ValueMax = field.getValueMax();
        voBase.ValidationCode = field.getAD_Val_Rule().getCode();
        voBase.isRange = field.isRange();
        voBase.Description = field.getDescription();
        voBase.Help = uniqueName;
        voBase.Header = title2;
        GridField gField = new GridField(GridFieldVO.createParameter(voBase));
        Object defaultObject = gField.getDefault();
        gField.setValue(defaultObject, true);
        if (defaultObject != null) {
            this.processNewValue(defaultObject, gField.getVO().Help);
        }
        gField.lookupLoadComplete();
        this.m_mFields.add(gField);
        VEditor editor = VEditorFactory.getEditor(gField, false);
        editor.setReadWrite(true);
        editor.addVetoableChangeListener(this);
        this.m_vEditors.add(editor);
        if (20 != field.getAD_Reference_ID()) {
            CLabel label2 = VEditorFactory.getLabel(gField);
            label2.setName(uniqueName);
            this.add((Component)label2, new ALayoutConstraint(row, col));
        }
        this.add((Component)((Object)editor), new ALayoutConstraint(row, col + 1));
        this.setParameter(name, editor);
        if (field.isRange()) {
            ++col;
            title2 = Msg.getMsg(Env.getCtx(), "To");
            name = name + "_To";
            voBase.Header = title2;
            voBase.DefaultValue = field.getDefaultValue2();
            GridField gField2 = new GridField(GridFieldVO.createParameter(voBase));
            Object defaultObject2 = gField2.getDefault();
            gField2.setValue(defaultObject2, true);
            gField2.lookupLoadComplete();
            this.m_mFields2.add(gField2);
            VEditor editor2 = VEditorFactory.getEditor(gField2, false);
            editor2.setReadWrite(true);
            editor2.addVetoableChangeListener(this);
            this.m_vEditors2.add(editor2);
            CLabel label3 = VEditorFactory.getLabel(gField2);
            label3.setName(uniqueName);
            this.add((Component)label3, new ALayoutConstraint(row, ++col));
            this.add((Component)((Object)editor2), new ALayoutConstraint(row, ++col));
            this.setParameter(name, editor2);
        } else {
            this.m_mFields2.add(null);
            this.m_vEditors2.add(null);
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        GridField changedField;
        if (evt.getSource() instanceof VEditor && (changedField = ((VEditor)evt.getSource()).getField()) != null) {
            this.processDependencies(changedField);
        }
        String columnName = "";
        if (evt.getSource() instanceof VEditor) {
            VEditor vEditor = (VEditor)evt.getSource();
            columnName = vEditor.getField().getVO().Help;
        }
        this.processNewValue(evt.getNewValue(), columnName);
    }

    public void setParameter(Object name, Object value) {
        if (value != null) {
            this.m_search.put(name, value);
        }
    }

    public LinkedHashMap<Object, Object> getParameters() {
        return this.m_search;
    }

    public Object getParamenterValue(Object key) {
        VEditor editor = (VEditor)this.m_search.get(key);
        if (editor != null) {
            return editor.getValue();
        }
        return null;
    }

    private void processDependencies(GridField changedField) {
        String columnName = changedField.getVO().Help;
        for (GridField field : this.m_mFields) {
            if (field == null || field == changedField) continue;
            this.verifyChangedField(field, columnName);
        }
        for (GridField field : this.m_mFields2) {
            if (field == null || field == changedField) continue;
            this.verifyChangedField(field, columnName);
        }
    }

    private void verifyChangedField(GridField field, String columnName) {
        MLookup mLookup;
        ArrayList<String> list = field.getDependentOn();
        if (list.contains(columnName) && field.getLookup() instanceof MLookup && (mLookup = (MLookup)field.getLookup()).getValidation().indexOf("@" + columnName + "@") != -1) {
            log.fine(columnName + " changed - " + field.getColumnName() + " set to null");
            field.setValue(null, true);
        }
    }

    private void processNewValue(Object value, String name) {
        if (value == null) {
            value = new String("");
        }
        if (value instanceof String) {
            Env.setContext(Env.getCtx(), this.p_WindowNo, name, (String)value);
        } else if (value instanceof Integer) {
            Env.setContext(Env.getCtx(), this.p_WindowNo, name, (Integer)value);
        } else if (value instanceof Boolean) {
            Env.setContext(Env.getCtx(), this.p_WindowNo, name, (Boolean)value);
        } else if (value instanceof Timestamp) {
            Env.setContext(Env.getCtx(), this.p_WindowNo, name, (Timestamp)value);
        } else {
            Env.setContext(Env.getCtx(), this.p_WindowNo, name, value.toString());
        }
        this.dynamicDisplay();
    }

    public void dynamicDisplay() {
        Component[] comps = this.getComponents();
        for (int i2 = 0; i2 < comps.length; ++i2) {
            int index;
            Component comp = comps[i2];
            String columnName = "";
            if (comp instanceof VEditor) {
                VEditor vEditor = (VEditor)((Object)comp);
                columnName = vEditor.getField().getVO().Help;
            } else {
                columnName = comp.getName();
            }
            if (columnName == null || columnName.length() <= 0 || this.m_mFields.get(index = this.getIndex(columnName)) == null) continue;
            if (this.m_mFields.get(index).isDisplayed(true)) {
                if (!comp.isVisible()) {
                    comp.setVisible(true);
                }
                boolean rw = this.m_mFields.get(index).isEditablePara(true);
                this.m_vEditors.get(index).setReadWrite(rw);
                if (!this.m_mFields.get((int)index).getVO().isRange) continue;
                this.m_vEditors2.get(index).setReadWrite(rw);
                continue;
            }
            if (!comp.isVisible()) continue;
            comp.setVisible(false);
        }
    }

    private int getIndex(String columnName) {
        for (int i2 = 0; i2 < this.m_mFields.size(); ++i2) {
            if (!this.m_mFields.get((int)i2).getVO().Help.equals(columnName)) continue;
            return i2;
        }
        return 0;
    }

    public void dispose() {
        this.cleanContext();
        this.m_vEditors.clear();
        this.m_vEditors2.clear();
        this.m_mFields.clear();
        this.m_mFields2.clear();
        this.removeAll();
    }

    protected void cleanContext() {
        for (GridField f : this.m_mFields) {
            if (f == null) continue;
            f.restoreValue();
            Env.setContext(f.getVO().ctx, this.p_WindowNo, f.getVO().Help, "");
        }
        for (GridField f : this.m_mFields2) {
            if (f == null) continue;
            f.restoreValue();
            Env.setContext(f.getVO().ctx, this.p_WindowNo, f.getVO().Help, "");
        }
    }
}

