/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.MBrowse;
import org.adempiere.model.MBrowseField;
import org.compiere.Adempiere;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.AGlassPane;
import org.compiere.apps.ALayout;
import org.compiere.apps.AppsAction;
import org.compiere.apps.ProcessCtl;
import org.compiere.apps.ProcessParameterPanel;
import org.compiere.apps.StatusBar;
import org.compiere.apps.Waiting;
import org.compiere.grid.ed.VEditor;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.GridField;
import org.compiere.model.GridFieldVO;
import org.compiere.model.MPInstance;
import org.compiere.model.MProcess;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.swing.CFrame;
import org.compiere.swing.CollapsiblePanel;
import org.compiere.util.ASyncProcess;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Login;
import org.compiere.util.Msg;
import org.compiere.util.Splash;
import org.eevolution.form.Browser;
import org.eevolution.form.BrowserRows;
import org.eevolution.form.IBrowser;
import org.eevolution.form.VBrowserSearch;
import org.eevolution.grid.BrowseTable;

public class VBrowser
extends Browser
implements IBrowser,
ActionListener,
VetoableChangeListener,
ChangeListener,
ListSelectionListener,
TableModelListener,
ASyncProcess {
    CFrame m_frame = new CFrame();
    private ProcessParameterPanel parameterPanel;
    protected StatusBar statusBar = new StatusBar();
    private Worker m_worker = null;
    private Waiting m_waiting = null;
    private JButton bCancel;
    private JButton bDelete;
    private JButton bExport;
    private JButton bFind;
    private JButton bOk;
    private JButton bPrint;
    private JButton bSearch;
    private JButton bSelectAll;
    private JToggleButton bZoom;
    private JPanel buttonSearchPanel;
    private JScrollPane centerPanel;
    private BrowseTable detail;
    private JPanel footButtonPanel;
    private JPanel footPanel;
    private JPanel graphPanel;
    private JPanel processPanel;
    private JPanel searchTab;
    private JTabbedPane tabsPanel;
    private JToolBar toolsBar;
    private JPanel topPanel;
    private AGlassPane m_glassPane = new AGlassPane();
    private CollapsiblePanel collapsibleSearch;
    private VBrowserSearch searchPanel;

    public static CFrame openBrowse(int browse_ID) {
        MBrowse browse = new MBrowse(Env.getCtx(), browse_ID, null);
        boolean modal = true;
        int WindowNo = 0;
        String value = "";
        String keyColumn = "";
        boolean multiSelection = true;
        String whereClause = null;
        CFrame ff = new CFrame();
        return new VBrowser(ff, modal, WindowNo, value, browse, keyColumn, multiSelection, whereClause).getFrame();
    }

    public VBrowser(CFrame frame, boolean modal, int WindowNo, String value, MBrowse browse, String keyColumn, boolean multiSelection, String whereClause) {
        super(modal, WindowNo, value, browse, keyColumn, multiSelection, whereClause);
        this.m_frame = frame;
        this.m_frame.setTitle(browse.getTitle());
        this.m_frame.getContentPane().add((Component)this.statusBar, "South");
        this.windowNo = Env.createWindowNo(this.m_frame);
        this.setContextWhere(browse, whereClause);
        this.initComponents();
        this.statInit();
        int no = this.detail.getRowCount();
        this.setStatusLine(Integer.toString(no) + " " + Msg.getMsg(Env.getCtx(), "SearchRows_EnterQuery"), false);
        this.setStatusDB(Integer.toString(no));
        if (this.isExecuteQueryByDefault()) {
            this.executeQuery();
        }
    }

    private void statInit() {
        this.searchPanel.setLayout(new ALayout());
        int cols = 0;
        int col = 2;
        int row = 0;
        for (MBrowseField field : this.m_Browse.getCriteriaFields()) {
            String title2 = field.getName();
            String name = field.getAD_View_Column().getColumnName();
            this.searchPanel.addField(field, row, cols, name, title2);
            cols += col;
            if (field.isRange()) {
                cols += col;
            }
            if (cols < 4) continue;
            cols = 0;
            ++row;
        }
        this.searchPanel.dynamicDisplay();
        if (this.m_Browse.getAD_Process_ID() > 0) {
            this.m_process = MProcess.get(Env.getCtx(), this.m_Browse.getAD_Process_ID());
            ProcessInfo pi = new ProcessInfo(this.m_process.getName(), this.m_Browse.getAD_Process_ID());
            pi.setAD_User_ID(Env.getAD_User_ID(Env.getCtx()));
            pi.setAD_Client_ID(Env.getAD_Client_ID(Env.getCtx()));
            pi.setWindowNo(this.getWindowNo());
            this.setBrowseProcessInfo(pi);
            this.parameterPanel = new ProcessParameterPanel(pi.getWindowNo(), pi);
            this.parameterPanel.setMode(ProcessParameterPanel.MODE_HORIZONTAL);
            this.parameterPanel.init();
            this.processPanel.add((Component)this.parameterPanel, "Center");
        }
    }

    private boolean initBrowser() {
        List<MBrowseField> fields = this.initBrowserTable();
        if (fields == null) {
            return false;
        }
        StringBuilder where = new StringBuilder("");
        this.setContextWhere(this.m_Browse, null);
        if (this.p_whereClause.length() > 0) {
            where.append(this.p_whereClause);
        }
        this.prepareTable(fields, this.m_View.getFromClause(), where.toString(), "2");
        return true;
    }

    private List<MBrowseField> initBrowserTable() {
        List<MBrowseField> list = this.initBrowserData();
        if (list.size() == 0) {
            ADialog.error(this.getWindowNo(), this.m_frame, "Error", "No Browse Fields");
            this.log.log(Level.SEVERE, "No Browser for view=" + this.m_View.getName());
            return null;
        }
        this.log.finest("Browse Fields #" + list.size());
        this.detail = new BrowseTable(this);
        this.centerPanel.setViewportView(this.detail);
        return list;
    }

    public void setStatusLine(String text, boolean error) {
        this.statusBar.setStatusLine(text, error);
        Thread.yield();
    }

    public void setStatusDB(String text) {
        this.statusBar.setStatusDB(text);
    }

    protected void executeQuery() {
        if (this.evaluateMandatoryFilter()) {
            if (this.getAD_Window_ID() > 1) {
                this.bZoom.setEnabled(true);
            }
            this.bSelectAll.setEnabled(true);
            this.bExport.setEnabled(true);
            if (this.isDeleteable()) {
                this.bDelete.setEnabled(true);
            }
            this.collapsibleSearch.setCollapsed(this.isCollapsibleByDefault());
            this.p_loadedOK = this.initBrowser();
            Env.setContext(Env.getCtx(), 0, "currWindowNo", this.getWindowNo());
            if (this.parameterPanel != null) {
                this.parameterPanel.refreshContext();
            }
            if (this.m_worker != null && this.m_worker.isAlive()) {
                return;
            }
            if (!this.testCount()) {
                return;
            }
            this.m_frame.setCursor(Cursor.getPredefinedCursor(3));
            this.setStatusLine(Msg.getMsg(Env.getCtx(), "StartSearch"), false);
            this.m_worker = new Worker();
            this.m_worker.start();
        }
    }

    private void cmd_zoom() {
        this.m_frame.setCursor(Cursor.getPredefinedCursor(3));
        MQuery query = this.getMQuery();
        if (query != null) {
            AEnv.zoom(this.m_frame, this.getAD_Window_ID(), query);
        }
        this.m_frame.setCursor(Cursor.getDefaultCursor());
        this.bZoom.setSelected(false);
    }

    private void cmd_deleteSelection() {
        this.m_frame.setCursor(Cursor.getPredefinedCursor(3));
        if (ADialog.ask(this.getWindowNo(), this.m_frame, "DeleteSelection")) {
            int records = this.deleteSelection();
            this.setStatusLine(Msg.getMsg(Env.getCtx(), "Deleted") + records, false);
        }
        this.m_frame.setCursor(Cursor.getDefaultCursor());
        this.bDelete.setSelected(false);
        this.executeQuery();
    }

    protected void prepareTable(List<MBrowseField> fields, String from, String staticWhere, String orderBy) {
        this.browserFields = fields;
        StringBuffer sql = new StringBuffer("SELECT DISTINCT ");
        sql.append(this.detail.prepareTable(this.browserFields, this.p_multiSelection));
        this.detail.setRowSelectionAllowed(true);
        this.detail.setMultiSelection(this.p_multiSelection);
        this.detail.setShowTotals(this.m_Browse.isShowTotal());
        sql.append(" FROM ").append(from);
        sql.append(" WHERE ");
        this.m_sqlMain = sql.toString();
        this.m_sqlCount = "SELECT COUNT(*) FROM " + from + " WHERE ";
        this.m_sqlOrderBy = this.getSQLOrderBy();
        if (this.m_keyColumnIndex == -1) {
            this.log.log(Level.WARNING, "No KeyColumn - " + sql);
        }
    }

    private boolean testCount() {
        int no = -1;
        no = this.getCount();
        MRole role = MRole.getDefault();
        if (role.isQueryMax(no)) {
            return ADialog.ask(this.getWindowNo(), this.m_frame, "InfoHighRecordCount", String.valueOf(no));
        }
        return true;
    }

    protected void saveSelection() {
        if (this.detail == null) {
            return;
        }
        this.log.config("OK=" + this.m_ok);
        if (!this.m_ok) {
            this.m_results.clear();
            this.detail.removeAll();
            this.detail = null;
            return;
        }
        if (this.p_multiSelection) {
            this.m_results.clear();
            this.m_results.addAll(this.getSelectedRowKeys());
        } else {
            Integer data = this.getSelectedRowKey();
            if (data != null) {
                this.m_results.add(data);
            }
        }
        this.detail.removeAll();
        this.detail = null;
    }

    protected void saveResultSelection() {
        if (this.m_keyColumnIndex == -1) {
            return;
        }
        if (this.p_multiSelection) {
            int rows = this.detail.getRowCount();
            BrowserRows browserRows = this.detail.getData();
            this.m_values = new LinkedHashMap();
            for (int row = 0; row < rows; ++row) {
                IDColumn dataColumn;
                Object data = this.detail.getModel().getValueAt(row, this.m_keyColumnIndex);
                if (!(data instanceof IDColumn) || !(dataColumn = (IDColumn)data).isSelected()) continue;
                LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
                for (int col = 0; col < browserRows.getColumnCount(); ++col) {
                    MBrowseField field = browserRows.getBrowserField(col);
                    if (field.isReadOnly() && !field.isIdentifier()) continue;
                    GridField gridField = this.detail.getData().getValue(row, col);
                    Object value = gridField.getValue();
                    values.put(field.getAD_View_Column().getColumnName(), value);
                }
                if (values.size() <= 0) continue;
                this.m_values.put(dataColumn.getRecord_ID(), values);
            }
        }
    }

    @Override
    public ArrayList<Integer> getSelectedRowKeys() {
        int row;
        ArrayList<Integer> selectedDataList = new ArrayList<Integer>();
        if (this.m_keyColumnIndex == -1) {
            return selectedDataList;
        }
        if (this.p_multiSelection) {
            int rows = this.detail.getRowCount();
            for (int row2 = 0; row2 < rows; ++row2) {
                IDColumn dataColumn;
                Object data = this.detail.getModel().getValueAt(row2, this.m_keyColumnIndex);
                if (!(data instanceof IDColumn) || !(dataColumn = (IDColumn)data).isSelected()) continue;
                selectedDataList.add(dataColumn.getRecord_ID());
            }
        }
        if (selectedDataList.size() == 0 && (row = this.detail.getSelectedRow()) != -1 && this.m_keyColumnIndex != -1) {
            Object data = this.detail.getModel().getValueAt(row, this.m_keyColumnIndex);
            if (data instanceof IDColumn) {
                selectedDataList.add(((IDColumn)data).getRecord_ID());
            }
            if (data instanceof Integer) {
                selectedDataList.add((Integer)data);
            }
        }
        return selectedDataList;
    }

    public void dispose(boolean ok) {
        this.log.config("OK=" + ok);
        this.m_ok = ok;
        if (this.m_worker != null) {
            if (this.m_worker.isAlive()) {
                this.m_worker.interrupt();
            }
            this.log.config("Worker alive=" + this.m_worker.isAlive());
        }
        this.m_worker = null;
        this.saveResultSelection();
        this.saveSelection();
        this.m_frame.removeAll();
        this.m_frame.dispose();
        if (this.m_Browse.getAD_Process_ID() <= 0) {
            return;
        }
        MPInstance instance = new MPInstance(Env.getCtx(), this.m_Browse.getAD_Process_ID(), this.getBrowseProcessInfo().getRecord_ID());
        instance.saveEx();
        DB.createT_Selection(instance.getAD_PInstance_ID(), this.getSelectedKeys(), null);
        ProcessInfo pi = this.getBrowseProcessInfo();
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        pi.setWindowNo(this.getWindowNo());
        this.parameterPanel.saveParameters();
        ProcessInfoUtil.setParameterFromDB(pi);
        this.setBrowseProcessInfo(pi);
        this.createT_Selection_Browse(instance.getAD_PInstance_ID());
        ProcessCtl worker = new ProcessCtl(this, pi.getWindowNo(), pi, null);
        worker.start();
        Env.clearWinContext(this.getWindowNo());
    }

    private void setupToolBar() {
        AppsAction a2 = new AppsAction("Ok", null, "Ok");
        this.bOk = new JButton(a2);
        a2 = new AppsAction("Cancel", null, "Cancel");
        this.bCancel = new JButton(a2);
        this.toolsBar = new JToolBar();
        a2 = new AppsAction("Print", null, "Print");
        this.bPrint = new JButton(a2);
        a2 = new AppsAction("Zoom", null, "Zoom");
        this.bZoom = new JToggleButton(a2);
        a2 = new AppsAction("Export", null, "Export");
        this.bExport = new JButton(a2);
        a2 = new AppsAction("Delete", null, "Delete");
        this.bDelete = new JButton(a2);
        a2 = new AppsAction("Find", null, "Find");
        this.bFind = new JButton(a2);
        a2 = new AppsAction("SelectAll", null, Msg.getMsg(Env.getCtx(), "SelectAll"));
        this.bSelectAll = new JButton(a2);
    }

    private void initComponents() {
        this.toolsBar = new JToolBar();
        this.bZoom = new JToggleButton();
        this.bExport = new JButton();
        this.bDelete = new JButton();
        this.tabsPanel = new JTabbedPane();
        this.searchTab = new JPanel();
        this.topPanel = new JPanel();
        this.searchPanel = new VBrowserSearch(this.getWindowNo());
        this.buttonSearchPanel = new JPanel();
        this.bSearch = new JButton();
        this.centerPanel = new JScrollPane();
        this.detail = new BrowseTable(this);
        this.footPanel = new JPanel();
        this.footButtonPanel = new JPanel();
        this.bCancel = new JButton();
        this.bOk = new JButton();
        this.processPanel = new JPanel();
        this.graphPanel = new JPanel();
        this.setupToolBar();
        this.toolsBar.setRollover(true);
        this.bSelectAll.setHorizontalTextPosition(0);
        this.bSelectAll.setVerticalTextPosition(3);
        this.bSelectAll.setEnabled(false);
        this.bSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VBrowser.this.selectedRows();
            }
        });
        this.toolsBar.add(this.bSelectAll);
        this.bZoom.setText(Msg.getMsg(Env.getCtx(), "Zoom").replaceAll("[&]", ""));
        this.bZoom.setFocusable(false);
        this.bZoom.setHorizontalTextPosition(0);
        this.bZoom.setVerticalTextPosition(3);
        this.bZoom.setEnabled(false);
        this.bZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VBrowser.this.bZoomActionPerformed(evt);
            }
        });
        if (this.AD_Window_ID > 0) {
            this.toolsBar.add(this.bZoom);
        }
        this.bExport.setText(Msg.getMsg(Env.getCtx(), "Export"));
        this.bExport.setFocusable(false);
        this.bExport.setHorizontalTextPosition(0);
        this.bExport.setVerticalTextPosition(3);
        this.bExport.setEnabled(false);
        this.bExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VBrowser.this.bExportActionPerformed(evt);
            }
        });
        this.toolsBar.add(this.bExport);
        this.bDelete.setText(Msg.getMsg(Env.getCtx(), "Delete").replaceAll("[&]", ""));
        this.bDelete.setFocusable(false);
        this.bDelete.setHorizontalTextPosition(0);
        this.bDelete.setVerticalTextPosition(3);
        this.bDelete.setEnabled(false);
        this.bDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VBrowser.this.bDeleteActionPerformed(evt);
            }
        });
        if (this.isDeleteable()) {
            this.toolsBar.add(this.bDelete);
        }
        this.m_frame.getContentPane().add((Component)this.toolsBar, "First");
        this.searchTab.setLayout(new BorderLayout());
        this.topPanel.setLayout(new BorderLayout());
        this.searchPanel.setLayout(new GridBagLayout());
        this.collapsibleSearch = new CollapsiblePanel(Msg.getMsg(Env.getCtx(), "SearchCriteria"));
        this.collapsibleSearch.add(this.searchPanel);
        this.topPanel.add((Component)this.collapsibleSearch, "North");
        this.bSearch.setText(Msg.getMsg(Env.getCtx(), "StartSearch"));
        this.bSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VBrowser.this.bSearchActionPerformed(evt);
            }
        });
        this.buttonSearchPanel.add(this.bSearch);
        this.collapsibleSearch.add(this.buttonSearchPanel);
        this.searchTab.add((Component)this.topPanel, "North");
        this.centerPanel.setViewportView(this.detail);
        this.searchTab.add((Component)this.centerPanel, "Center");
        this.footPanel.setLayout(new BorderLayout());
        this.bCancel.setText(Msg.getMsg(Env.getCtx(), "Cancel").replaceAll("[&]", ""));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VBrowser.this.bCancelActionPerformed(evt);
            }
        });
        this.footButtonPanel.add(this.bCancel);
        this.bOk.setText(Msg.getMsg(Env.getCtx(), "Ok").replaceAll("[&]", ""));
        this.bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VBrowser.this.bOkActionPerformed(evt);
            }
        });
        this.footButtonPanel.add(this.bOk);
        this.footPanel.add((Component)this.footButtonPanel, "South");
        this.processPanel.setLayout(new BorderLayout());
        this.footPanel.add((Component)this.processPanel, "Center");
        this.searchTab.add((Component)this.footPanel, "South");
        this.tabsPanel.addTab(Msg.getMsg(Env.getCtx(), "Search"), this.searchTab);
        this.graphPanel.setLayout(new BorderLayout());
        this.m_frame.getContentPane().add((Component)this.tabsPanel, "Center");
    }

    private void selectedRows() {
        int topIndex = this.detail.isShowTotals() ? 2 : 1;
        int rows = this.detail.getRowCount();
        TableModel model = this.detail.getModel();
        if (this.isAllSelected) {
            for (int row = 0; row <= rows - topIndex; ++row) {
                Object data = model.getValueAt(row, this.m_keyColumnIndex);
                if (!(data instanceof IDColumn)) continue;
                IDColumn dataColumn = (IDColumn)data;
                dataColumn.setSelected(true);
                model.setValueAt(dataColumn, row, this.m_keyColumnIndex);
            }
        } else {
            for (int row = 0; row <= rows - topIndex; ++row) {
                Object data = model.getValueAt(row, this.m_keyColumnIndex);
                if (!(data instanceof IDColumn)) continue;
                IDColumn dataColumn = (IDColumn)data;
                dataColumn.setSelected(false);
                model.setValueAt(dataColumn, row, this.m_keyColumnIndex);
            }
            this.detail.clearSelection();
        }
        this.isAllSelected = !this.isAllSelected;
    }

    private void bZoomActionPerformed(ActionEvent evt) {
        this.cmd_zoom();
    }

    private void bOkActionPerformed(ActionEvent evt) {
        this.m_frame.setCursor(Cursor.getPredefinedCursor(3));
        this.m_ok = true;
        if (this.m_worker != null) {
            if (this.m_worker.isAlive()) {
                this.m_worker.interrupt();
            }
            this.log.config("Worker alive=" + this.m_worker.isAlive());
        }
        this.m_worker = null;
        this.saveResultSelection();
        this.saveSelection();
        if (this.m_Browse.getAD_Process_ID() > 0 && this.getSelectedKeys() != null) {
            MPInstance instance = new MPInstance(Env.getCtx(), this.m_Browse.getAD_Process_ID(), this.getBrowseProcessInfo().getRecord_ID());
            instance.saveEx();
            DB.createT_Selection(instance.getAD_PInstance_ID(), this.getSelectedKeys(), null);
            ProcessInfo pi = this.getBrowseProcessInfo();
            pi.setWindowNo(this.getWindowNo());
            pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
            this.parameterPanel.saveParameters();
            ProcessInfoUtil.setParameterFromDB(pi);
            this.setBrowseProcessInfo(pi);
            this.createT_Selection_Browse(instance.getAD_PInstance_ID());
            ProcessCtl worker = new ProcessCtl(this, pi.getWindowNo(), pi, null);
            this.m_waiting = new Waiting((Frame)this.m_frame, Msg.getMsg(Env.getCtx(), "Processing"), false, this.getBrowseProcessInfo().getEstSeconds());
            worker.run();
            this.m_waiting.doNotWait();
            this.setStatusLine(pi.getSummary(), pi.isError());
        }
        this.m_frame.setCursor(Cursor.getDefaultCursor());
        this.p_loadedOK = this.initBrowser();
        this.collapsibleSearch.setCollapsed(false);
    }

    private void bCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public void dispose() {
        this.searchPanel.dispose();
        this.m_frame.removeAll();
        this.m_frame.dispose();
    }

    private void bSearchActionPerformed(ActionEvent evt) {
        this.bZoom.setEnabled(true);
        this.bSelectAll.setEnabled(true);
        this.bExport.setEnabled(true);
        this.bDelete.setEnabled(true);
        this.collapsibleSearch.setCollapsed(!this.isCollapsibleByDefault());
        this.p_loadedOK = this.initBrowser();
        Env.setContext(Env.getCtx(), 0, "currWindowNo", this.getWindowNo());
        if (this.m_Browse.getAD_Process_ID() > 0) {
            this.parameterPanel.refreshContext();
        }
        this.executeQuery();
    }

    private void bFindActionPerformed(ActionEvent evt) {
    }

    private void bExportActionPerformed(ActionEvent evt) {
        this.m_frame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            File file = this.exportXLS();
            Env.startBrowser(file.toURI().toString());
        }
        catch (Exception e) {
            throw new AdempiereException("Failed to render report", e);
        }
        this.m_frame.setCursor(Cursor.getDefaultCursor());
        this.bExport.setSelected(false);
    }

    @Override
    public ArrayList<ArrayList<Object>> getDataRows() {
        ArrayList rows = this.m_rows;
        if (this.isShowTotal()) {
            ArrayList<Object> row = new ArrayList<Object>();
            int lastRow = this.detail.getRowCount() - 1;
            for (int column = 0; column <= this.detail.getColumnCount() - 1; ++column) {
                Object data = this.detail.getValueAt(lastRow, column);
                if (data == null) {
                    row.add(null);
                    continue;
                }
                row.add(data);
            }
            rows.add(row);
        }
        return rows;
    }

    private void bDeleteActionPerformed(ActionEvent evt) {
        this.cmd_deleteSelection();
    }

    private void bPrintActionPerformed(ActionEvent evt) {
    }

    public CFrame getForm() {
        return this.m_frame;
    }

    public static void main(String[] args) {
        Splash.getSplash();
        Adempiere.startup(true);
        Ini.setProperty("ApplicationUserID", "SuperUser");
        Ini.setProperty("ApplicationPassword", "System");
        Ini.setProperty("Role", "GardenWorld Admin");
        Ini.setProperty("Client", "GardenWorld");
        Ini.setProperty("Organization", "HQ");
        Ini.setProperty("Warehouse", "HQ Warehouse");
        Ini.setProperty("Language", "English");
        Login login = new Login(Env.getCtx());
        login.batchLogin();
        Properties m_ctx = Env.getCtx();
        MBrowse browse = new MBrowse(m_ctx, 50025, null);
        CFrame frame = new CFrame();
        boolean modal = true;
        int WindowNo = 0;
        String value = "";
        String keyColumn = "";
        boolean multiSelection = true;
        String whereClause = "";
        VBrowser browser = new VBrowser(frame, modal, WindowNo, value, browse, keyColumn, multiSelection, whereClause);
        browser.getFrame().setVisible(true);
        browser.getFrame().pack();
    }

    public CFrame getFrame() {
        return this.m_frame;
    }

    public Dimension getPreferredSize() {
        Dimension size = this.m_frame.getPreferredSize();
        if (size.width > 1024) {
            size.width = 994;
        }
        return size;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    @Override
    public void tableChanged(TableModelEvent e) {
    }

    @Override
    public void executeASync(ProcessInfo pi) {
    }

    @Override
    public boolean isUILocked() {
        return false;
    }

    @Override
    public void lockUI(ProcessInfo pi) {
    }

    @Override
    public void unlockUI(ProcessInfo pi) {
    }

    @Override
    public Object getParameterValue(Object key) {
        VEditor editor = (VEditor)this.searchPanel.getParameters().get(key);
        if (editor != null) {
            return editor.getValue();
        }
        return null;
    }

    @Override
    public String getSQLWhere(boolean refresh) {
        if (!refresh) {
            return this.m_whereClause;
        }
        this.m_parameters_values = new ArrayList();
        this.m_parameters = new ArrayList();
        boolean onRange = false;
        StringBuilder sql = new StringBuilder(this.p_whereClause);
        for (Map.Entry<Object, Object> entry : this.searchPanel.getParameters().entrySet()) {
            VEditor editor = (VEditor)entry.getValue();
            GridFieldVO field = editor.getField().getVO();
            if (!onRange) {
                if (editor.getValue() != null && !editor.getValue().toString().isEmpty() && !field.isRange) {
                    sql.append(" AND ");
                    if (10 == field.displayType) {
                        if (field.ColumnName.equals("Value") || field.ColumnName.equals("DocumentNo")) {
                            String value = (String)editor.getValue();
                            if (!value.contains(",")) continue;
                            value = value.replace(" ", "");
                            String inStr = new String(value);
                            StringBuffer outStr = new StringBuffer("(");
                            int i2 = inStr.indexOf(44);
                            while (i2 != -1) {
                                outStr.append("'" + inStr.substring(0, i2) + "',");
                                inStr = inStr.substring(i2 + 1, inStr.length());
                                i2 = inStr.indexOf(44);
                            }
                            outStr.append("'" + inStr + "')");
                            sql.append(field.Help).append(" IN ").append(outStr);
                            continue;
                        }
                        sql.append(field.Help).append(" LIKE ? ");
                        this.m_parameters.add(field.Help);
                        this.m_parameters_values.add("%" + editor.getValue() + "%");
                        continue;
                    }
                    sql.append(field.Help).append("=? ");
                    this.m_parameters.add(field.Help);
                    this.m_parameters_values.add(editor.getValue());
                    continue;
                }
                if (editor.getValue() != null && !editor.getValue().toString().isEmpty() && field.isRange) {
                    sql.append(" AND ");
                    sql.append(field.Help).append(" >= ? ");
                    this.m_parameters.add(field.Help);
                    this.m_parameters_values.add(editor.getValue());
                    onRange = true;
                    continue;
                }
                if (editor.getValue() != null || !field.isRange) continue;
                onRange = true;
                continue;
            }
            if (editor.getValue() != null && !editor.getValue().toString().isEmpty()) {
                sql.append(" AND ").append(field.Help).append(" <= ? ");
                this.m_parameters.add(field.Help);
                this.m_parameters_values.add(editor.getValue());
                onRange = false;
                continue;
            }
            onRange = false;
        }
        this.m_whereClause = sql.toString();
        return sql.toString();
    }

    @Override
    public void setParameters() {
        this.m_parameters_values = new ArrayList();
        this.m_parameters = new ArrayList();
        this.m_parameters_field = new ArrayList();
        boolean onRange = false;
        for (Map.Entry<Object, Object> entry : this.searchPanel.getParameters().entrySet()) {
            VEditor editor = (VEditor)entry.getValue();
            GridFieldVO field = editor.getField().getVO();
            if (!onRange) {
                if (editor.getValue() != null && !editor.getValue().toString().isEmpty() && !field.isRange) {
                    this.m_parameters.add(field.Help);
                    this.m_parameters_values.add(editor.getValue());
                    this.m_parameters_field.add(field);
                    continue;
                }
                if (editor.getValue() == null || editor.getValue().toString().isEmpty() || !field.isRange) continue;
                this.m_parameters.add(field.Help);
                this.m_parameters_values.add(editor.getValue());
                this.m_parameters_field.add(field);
                onRange = true;
                continue;
            }
            if (editor.getValue() == null || editor.getValue().toString().isEmpty()) continue;
            this.m_parameters.add(field.Help);
            this.m_parameters_values.add(editor.getValue());
            this.m_parameters_field.add(field);
            onRange = false;
        }
    }

    public boolean evaluateMandatoryFilter() {
        Object value_from = null;
        boolean onRange = false;
        boolean result = true;
        for (Map.Entry<Object, Object> entry : this.searchPanel.getParameters().entrySet()) {
            VEditor editor = (VEditor)entry.getValue();
            GridFieldVO field = editor.getField().getVO();
            if (!onRange) {
                if ((editor.getValue() == null || editor.getValue() != null && editor.getValue().toString().isEmpty()) && !field.isRange && editor.isMandatory()) {
                    ADialog.error(this.windowNo, this.getForm().getContentPane(), "FillMandatory", Msg.translate(Env.getCtx(), field.ColumnName));
                    return false;
                }
                if (editor.getValue() != null && !editor.getValue().toString().isEmpty() && field.isRange && editor.isMandatory()) {
                    onRange = true;
                    value_from = editor.getValue();
                    continue;
                }
                if (editor.getValue() != null || !field.isRange || !editor.isMandatory()) continue;
                onRange = true;
                value_from = null;
                continue;
            }
            if ((editor.getValue() == null || editor.getValue() != null && editor.getValue().toString().isEmpty()) && editor.isMandatory()) {
                if (value_from != null) {
                    value_from = null;
                    onRange = false;
                    continue;
                }
                ADialog.error(this.windowNo, this.getForm().getContentPane(), "FillMandatory", Msg.translate(Env.getCtx(), field.ColumnName));
                return false;
            }
            onRange = false;
            value_from = null;
        }
        return result;
    }

    class Worker
    extends Thread {
        private PreparedStatement m_pstmt = null;
        private ResultSet m_rs = null;
        private String dataSql = null;

        Worker() {
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            int no = 0;
            this.dataSql = VBrowser.this.getSQL();
            VBrowser.this.detail.setRowCount(0);
            try {
                this.m_pstmt = VBrowser.this.getStatement(this.dataSql);
                VBrowser.this.log.fine("Start query - " + (System.currentTimeMillis() - start) + "ms");
                this.m_rs = this.m_pstmt.executeQuery();
                VBrowser.this.log.fine("End query - " + (System.currentTimeMillis() - start) + "ms");
                while (this.m_rs.next()) {
                    if (this.isInterrupted()) {
                        VBrowser.this.log.finer("Interrupted");
                        this.close();
                        return;
                    }
                    ++no;
                    int row = VBrowser.this.detail.getRowCount();
                    VBrowser.this.detail.setRowCount(row + 1);
                    int colOffset = 1;
                    int columnDisplayIndex = 0;
                    int column = 0;
                    for (MBrowseField field : VBrowser.this.browserFields) {
                        Object value = null;
                        if (field.isKey() && !field.getAD_View_Column().getColumnSQL().equals("'Row' AS \"Row\"")) {
                            value = new IDColumn(this.m_rs.getInt(column + colOffset));
                        } else if (field.isKey() && !field.getAD_View_Column().getColumnSQL().equals("'Row' AS \"Row\"")) {
                            value = new IDColumn(no);
                        } else if (19 == field.getAD_Reference_ID() || 18 == field.getAD_Reference_ID() || 11 == field.getAD_Reference_ID() || 35 == field.getAD_Reference_ID() || 25 == field.getAD_Reference_ID()) {
                            Integer id = this.m_rs.getInt(column + colOffset);
                            value = id != 0 ? id : null;
                        } else if (DisplayType.isNumeric(field.getAD_Reference_ID())) {
                            value = this.m_rs.getBigDecimal(column + colOffset);
                        } else if (DisplayType.isDate(field.getAD_Reference_ID())) {
                            value = this.m_rs.getTimestamp(column + colOffset);
                        } else if (20 == field.getAD_Reference_ID()) {
                            value = this.m_rs.getString(column + colOffset);
                            if (value != null) {
                                value = value.equals("Y");
                            }
                        } else {
                            value = this.m_rs.getObject(column + colOffset);
                        }
                        GridField gridField = MBrowseField.createGridFieldVO(field, VBrowser.this.getWindowNo());
                        gridField.setValue(value, true);
                        VBrowser.this.detail.setValueAt(row, columnDisplayIndex, gridField);
                        if (field.isDisplayed()) {
                            ++columnDisplayIndex;
                        }
                        ++column;
                    }
                }
            }
            catch (SQLException e) {
                VBrowser.this.log.log(Level.SEVERE, this.dataSql, e);
            }
            this.close();
            VBrowser.this.log.fine("#" + no + " - " + (System.currentTimeMillis() - start) + "ms");
            if (VBrowser.this.detail.isShowTotals()) {
                VBrowser.this.detail.addTotals();
            }
            VBrowser.this.detail.autoSize();
            VBrowser.this.m_frame.setCursor(Cursor.getDefaultCursor());
            VBrowser.this.setStatusLine(Integer.toString(no) + " " + Msg.getMsg(Env.getCtx(), "SearchRows_EnterQuery"), false);
            VBrowser.this.setStatusDB(Integer.toString(no));
            if (no == 0) {
                VBrowser.this.log.fine(this.dataSql);
            } else {
                VBrowser.this.detail.getSelectionModel().setSelectionInterval(0, 0);
                VBrowser.this.detail.requestFocus();
            }
            VBrowser.this.isAllSelected = VBrowser.this.isSelectedByDefault();
            VBrowser.this.selectedRows();
        }

        private void close() {
            DB.close(this.m_rs, this.m_pstmt);
            this.m_rs = null;
            this.m_pstmt = null;
        }
    }
}

