/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.util.LinkedHashMap;
import org.adempiere.model.MBrowseField;
import org.compiere.model.GridField;
import org.eevolution.grid.BrowseTable;
import org.eevolution.grid.IBrowserRows;

public class BrowserRows
implements IBrowserRows {
    private Integer column = null;
    private Integer row = null;
    private Integer noViewColumns = 0;
    private LinkedHashMap<Integer, LinkedHashMap<Integer, GridField>> rows = new LinkedHashMap();
    private LinkedHashMap<Integer, MBrowseField> browserFields = new LinkedHashMap();
    private LinkedHashMap<Integer, Integer> displayIndexes = new LinkedHashMap();
    private LinkedHashMap<Integer, Integer> indexesDisplay = new LinkedHashMap();
    private LinkedHashMap<String, Integer> columnNamesIndex = new LinkedHashMap();
    private BrowseTable table;

    public BrowserRows() {
    }

    public BrowserRows(BrowseTable table2) {
        this.table = table2;
    }

    @Override
    public void addBrowserField(MBrowseField field, int column) {
        if (field.isDisplayed()) {
            this.indexesDisplay.put(column, this.noViewColumns);
            this.displayIndexes.put(this.noViewColumns, column);
            Integer n = this.noViewColumns;
            Integer n2 = this.noViewColumns = Integer.valueOf(this.noViewColumns + 1);
        }
        this.columnNamesIndex.put(field.getAD_View_Column().getAD_Column().getColumnName(), column);
        this.browserFields.put(column, field);
    }

    @Override
    public MBrowseField getBrowserField(int col) {
        return this.browserFields.get(col);
    }

    @Override
    public void setValue(int row, int col, GridField gridField) {
        this.column = col;
        this.row = row;
        LinkedHashMap<Integer, GridField> values = this.rows.get(row);
        if (values == null) {
            values = new LinkedHashMap();
        }
        values.put(col, gridField);
        this.rows.put(row, values);
    }

    @Override
    public GridField getValue(int row, int col) {
        if (this.rows.size() > row) {
            LinkedHashMap<Integer, GridField> values = this.rows.get(row);
            return values.get(col);
        }
        return null;
    }

    @Override
    public LinkedHashMap<Integer, MBrowseField> getBrowserFields() {
        return this.browserFields;
    }

    @Override
    public LinkedHashMap<Integer, LinkedHashMap<Integer, GridField>> getRows() {
        return this.rows;
    }

    @Override
    public int size() {
        return this.rows.size();
    }

    @Override
    public void clear() {
        this.rows.clear();
    }

    @Override
    public int getColumnCount() {
        return this.browserFields.size();
    }

    @Override
    public Integer getNoViewColumns() {
        return this.noViewColumns;
    }

    @Override
    public int getDisplayIndex(int index) {
        return this.indexesDisplay.get(index);
    }

    @Override
    public int getTableIndex(int display) {
        return this.displayIndexes.get(display);
    }

    public BrowseTable getTable() {
        return this.table;
    }

    public void setTable(BrowseTable table2) {
        this.table = table2;
    }

    @Override
    public int getSelectedRow() {
        if (this.table == null) {
            return -1;
        }
        return this.table.getSelectedRow();
    }

    @Override
    public int getSelectedColumn() {
        if (this.table == null) {
            return -1;
        }
        return this.table.getSelectedColumn();
    }

    @Override
    public Object getValueOfSelectedCell() {
        if (this.table != null) {
            return this.getValue(this.getSelectedRow(), this.getTableIndex(this.getSelectedColumn()));
        }
        return null;
    }

    @Override
    public void setValueOfSelectedCell(GridField gridField) {
        if (this.table != null && gridField != null) {
            this.table.setValueAt(this.getSelectedRow(), this.getSelectedColumn(), gridField);
        }
    }

    @Override
    public Object getValueOfColumn(int col) {
        if (this.table != null) {
            return this.getValue(this.getSelectedRow(), col);
        }
        return null;
    }

    @Override
    public void setValueOfColumn(int row, String ColumnName, GridField gridField) {
        if (this.table != null && this.columnNamesIndex.get(ColumnName) != null && gridField != null) {
            this.table.setValueAt(row, this.getDisplayIndex(this.columnNamesIndex.get(ColumnName)), gridField);
        }
    }

    @Override
    public Object getValueOfColumn(int row, String ColumnName) {
        if (this.table != null) {
            int index;
            int n = index = this.columnNamesIndex.get(ColumnName) == null ? -1 : this.columnNamesIndex.get(ColumnName);
            if (index >= 0) {
                return this.getValue(row, index);
            }
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i2 = 0; i2 < this.rows.size(); ++i2) {
            result.append(this.rows.get(i2) + "\n");
        }
        return result.toString();
    }
}

