/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.adempiere.impexp.ArrayExcelExporter;
import org.adempiere.model.I_AD_View_Column;
import org.adempiere.model.MBrowse;
import org.adempiere.model.MBrowseField;
import org.adempiere.model.MView;
import org.adempiere.model.MViewColumn;
import org.adempiere.model.MViewDefinition;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.GridFieldVO;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MProcess;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;

public abstract class Browser {
    public MBrowse m_Browse = null;
    public MView m_View = null;
    public static final int WINDOW_WIDTH = 1024;
    public ArrayList<String> m_queryColumns = new ArrayList();
    public ArrayList<String> m_queryColumnsSql = new ArrayList();
    protected ArrayList<Object> m_parameters;
    protected ArrayList<Object> m_parameters_values;
    protected ArrayList<GridFieldVO> m_parameters_field;
    protected String m_whereClause = "";
    public MProcess m_process = null;
    public ProcessInfo m_pi = null;
    public ProcessInfo m_browse_pi = null;
    public boolean p_loadedOK = false;
    public int m_keyColumnIndex = -1;
    public boolean m_ok = false;
    public boolean m_cancel = false;
    public ArrayList<Integer> m_results = new ArrayList(3);
    public LinkedHashMap<Integer, LinkedHashMap<String, Object>> m_values = new LinkedHashMap();
    public CLogger log = CLogger.getCLogger(this.getClass());
    public List<MBrowseField> browserFields;
    public String m_sqlMain;
    public String m_sqlCount;
    public String m_sqlOrderBy;
    public int windowNo;
    public String p_FromClause;
    public String p_keyColumn;
    public boolean p_multiSelection;
    public String p_whereClause = "";
    public static final int INFO_WIDTH = 800;
    public boolean isAllSelected = false;
    private Exporter m_exporter = null;
    private Language m_language = null;
    protected ArrayList<ArrayList<Object>> m_rows = new ArrayList();
    protected boolean isCollapsibleByDefault = true;
    protected boolean isSelectedByDefault = false;
    protected boolean isExecuteQueryByDefault = false;
    protected boolean isDeleteable = true;
    protected boolean isShowTotal = false;
    protected int AD_Window_ID = 0;

    public static LinkedHashMap<String, Object> getBrowseValues(int AD_PInstance_ID, String alias, int recordId, String trxName) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<Object> parameters = new ArrayList<Object>();
        try {
            StringBuilder sql = new StringBuilder("SELECT ColumnName , Value_String, Value_Date , Value_Number FROM T_Selection_Browse WHERE  AD_PInstance_ID=? AND T_Selection_ID=? ");
            parameters.add(AD_PInstance_ID);
            parameters.add(recordId);
            if (alias != null) {
                sql.append("AND ColumnName LIKE ?");
                parameters.add(alias.toUpperCase() + "_%");
            }
            pstmt = DB.prepareStatement(sql.toString(), trxName);
            DB.setParameters((PreparedStatement)pstmt, parameters);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String columnName = rs.getString(1);
                String valueString = rs.getString(2);
                Timestamp valueDate = rs.getTimestamp(3);
                BigDecimal valueBigDecimal = rs.getBigDecimal(4);
                if (valueString != null) {
                    values.put(columnName, valueString);
                    continue;
                }
                if (valueDate != null) {
                    values.put(columnName, valueDate);
                    continue;
                }
                if (valueBigDecimal == null) continue;
                values.put(columnName, valueBigDecimal);
            }
        }
        catch (SQLException ex) {
            try {
                throw new DBException(ex);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return values;
    }

    public Browser(boolean modal, int WindowNo, String value, MBrowse browse, String keyColumn, boolean multiSelection, String where) {
        this.m_Browse = browse;
        this.m_View = browse.getAD_View();
        this.p_keyColumn = keyColumn;
        this.p_multiSelection = multiSelection;
        this.m_language = Language.getLanguage(Env.getAD_Language(this.m_Browse.getCtx()));
        this.isCollapsibleByDefault = browse.isCollapsibleByDefault();
        this.isDeleteable = browse.isDeleteable();
        this.isSelectedByDefault = browse.isSelectedByDefault();
        this.isExecuteQueryByDefault = browse.isExecutedQueryByDefault();
        this.isShowTotal = browse.isShowTotal();
        this.AD_Window_ID = browse.getAD_Window_ID();
        this.log.info(this.m_Browse.getName() + " - " + keyColumn + " - " + this.p_whereClause);
    }

    public void setContextWhere(MBrowse browse, String where) {
        this.p_whereClause = null;
        String whereClause = where != null ? where : "";
        whereClause = browse.getWhereClause() != null ? whereClause + browse.getWhereClause() : " 1=1 ";
        if (whereClause == null || whereClause.indexOf(64) == -1) {
            this.p_whereClause = whereClause;
        } else {
            this.p_whereClause = Env.parseContext(Env.getCtx(), this.getWindowNo(), whereClause, true, true);
            if (this.p_whereClause.length() == 0) {
                this.log.log(Level.SEVERE, "Cannot parse context= " + whereClause);
            }
        }
        this.log.info(browse.getName() + " - " + this.p_whereClause);
    }

    public List<MBrowseField> initBrowserData() {
        ArrayList<MBrowseField> list = new ArrayList<MBrowseField>();
        MBrowseField fieldKey = this.m_Browse.getFieldKey();
        if (fieldKey != null) {
            list.add(fieldKey);
        } else {
            MViewColumn column = new MViewColumn(this.m_Browse.getCtx(), 0, this.m_Browse.get_TrxName());
            column.setName("Row");
            column.setColumnSQL("'Row' AS \"Row\"");
            MBrowseField browseField = new MBrowseField(this.m_Browse, column);
            browseField.setAD_Reference_ID(13);
            browseField.setIsKey(true);
            browseField.setIsReadOnly(false);
        }
        for (MBrowseField field : this.m_Browse.getDisplayFields()) {
            if (field.isQueryCriteria()) {
                this.m_queryColumns.add(field.getName());
            }
            this.m_queryColumnsSql.add(field.getAD_View_Column().getColumnSQL());
            if (field.isKey()) continue;
            if (field.getAxis_Column_ID() > 0) {
                for (MBrowseField fieldAxis : this.getInfoColumnForAxisField(field)) {
                    list.add(fieldAxis);
                }
                continue;
            }
            list.add(field);
        }
        return list;
    }

    public ArrayList<Object> getParameters() {
        return this.m_parameters;
    }

    public ArrayList<Object> getParametersValues() {
        return this.m_parameters_values;
    }

    public void addSQLWhere(StringBuffer sql, int index, String value) {
        if (!value.equals("") && !value.equals("%") && index < this.m_queryColumns.size()) {
            sql.append(" UPPER(").append(this.m_queryColumnsSql.get(index).toString()).append(") LIKE '");
            sql.append(value);
            if (value.endsWith("%")) {
                sql.append("'");
            } else {
                sql.append("%'");
            }
        }
    }

    public void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        boolean index = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        long start = System.currentTimeMillis();
        String dynWhere = this.getSQLWhere(true);
        StringBuffer sql = new StringBuffer(this.m_sqlCount);
        if (dynWhere.length() > 0) {
            sql.append(dynWhere);
        }
        String countSql = Msg.parseTranslation(Env.getCtx(), sql.toString());
        countSql = MRole.getDefault().addAccessSQL(countSql, this.m_View.getParentEntityAliasName(), true, false);
        this.log.finer(countSql);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int no = -1;
        try {
            pstmt = DB.prepareStatement(countSql, null);
            if (this.getParametersValues().size() > 0) {
                DB.setParameters((PreparedStatement)pstmt, this.getParametersValues());
            }
            this.setParameters(pstmt, true);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                no = rs.getInt(1);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, countSql, e);
            no = -2;
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.log.fine("#" + no + " - " + (System.currentTimeMillis() - start) + "ms");
        return no;
    }

    public abstract ArrayList<Integer> getSelectedRowKeys();

    public void setProcessInfo(ProcessInfo pi) {
        this.m_pi = pi;
        if (this.m_pi != null && this.m_browse_pi != null) {
            this.m_browse_pi.setRecord_ID(this.m_pi.getRecord_ID());
        }
    }

    public ProcessInfo getProcessInfo() {
        return this.m_pi;
    }

    public void setBrowseProcessInfo(ProcessInfo pi) {
        this.m_browse_pi = pi;
    }

    public ProcessInfo getBrowseProcessInfo() {
        return this.m_browse_pi;
    }

    public String getKeyColumn() {
        if (this.p_keyColumn == null || this.p_keyColumn.isEmpty()) {
            this.p_keyColumn = this.m_Browse.getFieldKey().getAD_View_Column().getAD_Column().getColumnName();
        }
        return this.p_keyColumn;
    }

    public Integer getSelectedRowKey() {
        ArrayList<Integer> selectedDataList = this.getSelectedRowKeys();
        if (selectedDataList.size() == 0) {
            return null;
        }
        return selectedDataList.get(0);
    }

    public List<Integer> getSelectedKeys() {
        if (!this.m_ok || this.m_results.size() == 0) {
            return null;
        }
        return this.m_results;
    }

    public Object getSelectedKey() {
        if (!this.m_ok || this.m_results.size() == 0) {
            return null;
        }
        return this.m_results.get(0);
    }

    protected int deleteSelection() {
        MTable table2 = null;
        MBrowseField fieldKey = this.m_Browse.getFieldKey();
        if (fieldKey != null && fieldKey.getAD_View_Column().getAD_Column_ID() > 0) {
            table2 = (MTable)fieldKey.getAD_View_Column().getAD_Column().getAD_Table();
        }
        int records = 0;
        for (int id : this.getSelectedRowKeys()) {
            if (table2 == null) continue;
            table2.getPO(id, null).deleteEx(true);
            ++records;
        }
        return records;
    }

    protected boolean isSelectedByDefault() {
        return this.isSelectedByDefault;
    }

    protected boolean isExecuteQueryByDefault() {
        return this.isExecuteQueryByDefault;
    }

    protected boolean isCollapsibleByDefault() {
        return this.isCollapsibleByDefault;
    }

    protected boolean isDeleteable() {
        return this.isDeleteable;
    }

    protected boolean isShowTotal() {
        return this.isShowTotal;
    }

    protected int getAD_Window_ID() {
        return this.AD_Window_ID;
    }

    public int getAD_Browse_ID() {
        return this.m_Browse.getAD_Browse_ID();
    }

    public List<MBrowseField> getInfoColumnForAxisField(MBrowseField field) {
        ArrayList<MBrowseField> list = new ArrayList<MBrowseField>();
        try {
            MViewColumn xcol = field.getAD_View_Column();
            I_AD_View_Column pcol = field.getAxis_Parent_Column();
            I_AD_View_Column ycol = field.getAxis_Column();
            String columnName = xcol.getAD_Column().getColumnName();
            MBrowseField fieldKey = ((MBrowse)field.getAD_Browse()).getFieldKey();
            if (fieldKey == null) {
                throw new AdempiereException("@NotFound@ @IsKey@");
            }
            MTable xTable = (MTable)ycol.getAD_View_Definition().getAD_Table();
            String xTableName = xTable.getTableName();
            String keyColumn = MQuery.getZoomColumnName(columnName);
            String tableName = MQuery.getZoomTableName(columnName);
            String whereClause = "";
            if (pcol != null && pcol.getAD_View_Column_ID() > 0) {
                MTable parentTable = MTable.get(field.getCtx(), tableName);
                MColumn parentColumn = this.getParentColumn(parentTable.getAD_Table_ID());
                if (parentColumn == null) {
                    throw new AdempiereException("@NotFound@ @IsParent@");
                }
                if (field.getAD_Val_Rule_ID() > 0) {
                    whereClause = Env.parseContext(Env.getCtx(), this.getWindowNo(), field.getAD_Val_Rule().getCode(), false);
                }
            }
            MLookup lookup = MLookupFactory.get(Env.getCtx(), 0, xcol.getAD_Column_ID(), field.getAD_Reference_ID(), this.m_language, keyColumn, field.getAD_Reference_Value_ID(), false, whereClause);
            int cols = 0;
            StringBuilder axisSql = new StringBuilder("(SELECT ");
            axisSql.append("SUM(").append(ycol.getAD_Column().getColumnName()).append(") FROM  ").append(ycol.getAD_View_Definition().getAD_Table().getTableName()).append(" WHERE ").append(xTableName).append(".").append(fieldKey.getAD_View_Column().getAD_Column().getColumnName()).append("=").append(fieldKey.getAD_View_Column().getColumnSQL()).append(this.getAxisSQLWhere(ycol)).append(" AND ").append(xTableName).append(".").append(xcol.getAD_Column().getColumnName());
            for (int id : this.getAxisRecordIds(tableName, whereClause)) {
                String display = lookup.getDisplay(id).trim();
                display = display.length() > 12 ? display.substring(1, 12) + "_" + ++cols : display;
                String joinColumn = Msg.translate(this.m_language, ycol.getAD_Column().getColumnName());
                joinColumn = joinColumn.length() > 15 ? joinColumn.substring(1, 15) : joinColumn;
                String sqlColName = display + "/" + joinColumn;
                String colName = lookup.getDisplay(id).trim() + "/" + Msg.translate(this.m_language, ycol.getAD_Column().getColumnName());
                StringBuffer select = new StringBuffer(axisSql);
                select.append("=").append(id).append(")");
                MViewColumn viewColumn = new MViewColumn(field.getCtx(), 0, field.get_TrxName());
                MViewColumn.copyValues((MViewColumn)ycol, viewColumn);
                viewColumn.setAD_View_Column_ID(ycol.getAD_View_Column_ID());
                viewColumn.setAD_Column_ID(ycol.getAD_Column_ID());
                viewColumn.setColumnSQL(select.toString());
                viewColumn.setColumnName("\"" + sqlColName + "\"");
                MBrowseField browseField = new MBrowseField((MBrowse)field.getAD_Browse(), viewColumn);
                browseField.setAD_Browse_ID(field.getAD_Browse_ID());
                browseField.setAD_Element_ID(field.getAD_Element_ID());
                browseField.setName(colName);
                browseField.setDescription(viewColumn.getDescription());
                browseField.setHelp(viewColumn.getHelp());
                if (viewColumn.get_ID() > 0) {
                    browseField.setAD_View_Column_ID(viewColumn.getAD_View_Column_ID());
                }
                browseField.setIsActive(true);
                browseField.setIsIdentifier(viewColumn.isIdentifier());
                browseField.setIsRange(false);
                browseField.setIsQueryCriteria(false);
                browseField.setAD_Reference_ID(ycol.getAD_Column().getAD_Reference_ID());
                browseField.setAD_Reference_Value_ID(ycol.getAD_Column().getAD_Reference_Value_ID());
                browseField.setIsKey(false);
                browseField.setIsDisplayed(true);
                browseField.setIsReadOnly(field.isReadOnly());
                browseField.setAD_Element_ID(field.getAD_Element_ID());
                list.add(browseField);
                this.log.finest("Added Column=" + sqlColName + " SQL = " + select);
            }
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
        return list;
    }

    private int[] getAxisRecordIds(String tableName, String tableWhereClause) {
        StringBuilder whereClause = new StringBuilder();
        StringBuilder orderBy = new StringBuilder();
        whereClause.append("EXISTS (SELECT 1 FROM AD_Table t WHERE t.TableName=? AND t.AD_Table_ID=AD_Column.AD_Table_ID) AND ");
        whereClause.append("IsIdentifier").append("=?");
        List columns = new Query(Env.getCtx(), "AD_Column", whereClause.toString(), null).setOnlyActiveRecords(true).setParameters(tableName, true).setOrderBy("SeqNo").list();
        int count = 1;
        for (MColumn column : columns) {
            orderBy.append(column.getColumnName());
            if (count != columns.size()) {
                orderBy.append(",");
            }
            ++count;
        }
        return new Query(Env.getCtx(), tableName, tableWhereClause, null).setOnlyActiveRecords(true).setOrderBy(orderBy.toString()).getIDs();
    }

    private MColumn getParentColumn(int AD_Table_ID) {
        String whereClause = "AD_Table_ID=? AND IsParent=? ";
        return (MColumn)new Query(Env.getCtx(), "AD_Column", whereClause, null).setParameters(AD_Table_ID, true).first();
    }

    public MBrowseField getFieldKey() {
        MBrowseField fieldKey = this.m_Browse.getFieldKey();
        return fieldKey;
    }

    public boolean IsIdentifierSelection(String columnName) {
        for (MBrowseField field : this.m_Browse.getIdentifierFields()) {
            if (!field.getAD_View_Column().getColumnName().equals(columnName)) continue;
            return true;
        }
        return false;
    }

    public MQuery getMQuery() {
        Integer record_ID = this.getSelectedRowKey();
        if (record_ID == null) {
            return null;
        }
        MBrowseField fieldKey = this.getFieldKey();
        if (fieldKey == null) {
            return null;
        }
        MColumn column = fieldKey.getAD_View_Column().getAD_Column();
        String keyColumn = MQuery.getZoomColumnName(column.getColumnName());
        String tableName = column.getAD_Table().getTableName();
        MQuery query = new MQuery(tableName);
        query.addRestriction(keyColumn, "=", record_ID);
        return query;
    }

    public abstract Object getParameterValue(Object var1);

    public abstract void setParameters();

    public abstract String getSQLWhere(boolean var1);

    public String getAxisSQLWhere(I_AD_View_Column viewColumn) {
        MViewDefinition viewDefinition = (MViewDefinition)viewColumn.getAD_View_Definition();
        MTable tableBaseName = viewDefinition.getAD_Table();
        StringBuilder whereAxis = new StringBuilder();
        boolean onRange = false;
        this.setParameters();
        for (int i2 = 0; i2 < this.m_parameters_field.size(); ++i2) {
            String fieldName = "";
            MColumn column = tableBaseName.getColumn(this.m_parameters_field.get((int)i2).ColumnName);
            if (column == null) continue;
            fieldName = tableBaseName.getTableName() + "." + column.getColumnName();
            if (!onRange) {
                if (this.m_parameters_values.get(i2) != null && !this.m_parameters_values.get(i2).toString().isEmpty() && !this.m_parameters_field.get((int)i2).isRange) {
                    whereAxis.append(" AND ");
                    whereAxis.append(fieldName).append("=").append(this.m_parameters_values.get(i2).toString());
                    continue;
                }
                if (this.m_parameters_values.get(i2) == null || this.m_parameters_values.get(i2).toString().isEmpty() || !this.m_parameters_field.get((int)i2).isRange) continue;
                whereAxis.append(" AND ");
                whereAxis.append(fieldName).append(" BETWEEN ").append(this.m_parameters_values.get(i2).toString());
                onRange = true;
                continue;
            }
            if (this.m_parameters_values.get(i2) == null || this.m_parameters_values.get(i2).toString().isEmpty()) continue;
            whereAxis.append(" AND ").append(this.m_parameters_values.get(i2).toString());
            onRange = false;
        }
        return whereAxis.toString();
    }

    protected String getSQL() {
        String dynWhere = this.getSQLWhere(false);
        StringBuilder sql = new StringBuilder(this.m_sqlMain);
        if (dynWhere.length() > 0) {
            sql.append(dynWhere);
        }
        String dataSql = Msg.parseTranslation(Env.getCtx(), sql.toString());
        dataSql = MRole.getDefault().addAccessSQL(dataSql, this.m_View.getParentEntityAliasName(), true, false);
        dataSql = dataSql + this.m_sqlOrderBy;
        this.log.finer(dataSql);
        return dataSql;
    }

    public String getSQLOrderBy() {
        StringBuilder sqlOrderBy = new StringBuilder();
        for (MBrowseField field : this.m_Browse.getOrderByFields()) {
            int orderByPosition;
            if (!field.isOrderBy() || (orderByPosition = this.getOrderByPosition(field)) <= 0) continue;
            if (sqlOrderBy.length() > 0) {
                sqlOrderBy.append(",");
            }
            sqlOrderBy.append(orderByPosition);
        }
        return sqlOrderBy.length() > 0 ? " ORDER BY " + sqlOrderBy.toString() : "";
    }

    private int getOrderByPosition(MBrowseField BrowserField) {
        int colOffset = 1;
        int col = 0;
        for (MBrowseField field : this.browserFields) {
            int sortBySqlNo = col + colOffset;
            if (BrowserField.getAD_Browse_Field_ID() == field.getAD_Browse_Field_ID()) {
                return sortBySqlNo;
            }
            ++col;
        }
        return -1;
    }

    protected PreparedStatement getStatement(String sql) {
        CPreparedStatement stmt = null;
        try {
            stmt = DB.prepareStatement(sql, null);
            if (this.getParametersValues().size() > 0) {
                DB.setParameters((PreparedStatement)stmt, this.getParametersValues());
            }
            this.setParameters(stmt, false);
            return stmt;
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
            return stmt;
        }
    }

    public abstract ArrayList<ArrayList<Object>> getDataRows();

    protected File exportXLS() {
        File file = null;
        try {
            if (this.m_exporter != null && this.m_exporter.isAlive()) {
                return file;
            }
            this.m_exporter = new Exporter();
            this.m_exporter.start();
            while (this.m_exporter.isAlive()) {
            }
            ArrayList<ArrayList<Object>> rows = this.getDataRows();
            if (rows.size() > 1) {
                String path = System.getProperty("java.io.tmpdir");
                String prefix = this.makePrefix(this.m_Browse.getName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.log(Level.FINE, "Path=" + path + " Prefix=" + prefix);
                }
                file = File.createTempFile(prefix, ".xls", new File(path));
                ArrayExcelExporter exporter = new ArrayExcelExporter(Env.getCtx(), rows);
                exporter.export(file, this.m_language, false);
            }
        }
        catch (IOException e) {
            this.log.log(Level.SEVERE, "", e);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
        }
        return file;
    }

    private String makePrefix(String name) {
        char[] nameArray;
        StringBuffer prefix = new StringBuffer();
        for (char ch : nameArray = name.toCharArray()) {
            if (Character.isLetterOrDigit(ch)) {
                prefix.append(ch);
                continue;
            }
            prefix.append("_");
        }
        return prefix.toString();
    }

    public void createT_Selection_Browse(int AD_PInstance_ID) {
        StringBuilder insert = new StringBuilder();
        insert.append("INSERT INTO T_SELECTION_BROWSE (AD_PINSTANCE_ID, T_SELECTION_ID, COLUMNNAME , VALUE_STRING, VALUE_NUMBER , VALUE_DATE ) VALUES(?,?,?,?,?,?) ");
        for (Map.Entry<Integer, LinkedHashMap<String, Object>> records : this.m_values.entrySet()) {
            LinkedHashMap<String, Object> fields = records.getValue();
            for (Map.Entry<String, Object> field : fields.entrySet()) {
                Comparable<BigDecimal> value;
                ArrayList<Object> parameters = new ArrayList<Object>();
                parameters.add(AD_PInstance_ID);
                parameters.add(records.getKey());
                parameters.add(field.getKey());
                Object data = field.getValue();
                if (data instanceof IDColumn) {
                    IDColumn id = (IDColumn)data;
                    parameters.add(null);
                    parameters.add(id.getRecord_ID());
                    parameters.add(null);
                } else if (data instanceof String) {
                    parameters.add(data);
                    parameters.add(null);
                    parameters.add(null);
                } else if (data instanceof BigDecimal || data instanceof Integer || data instanceof Double) {
                    parameters.add(null);
                    if (data instanceof Double) {
                        value = BigDecimal.valueOf((Double)data);
                        parameters.add(value);
                    } else {
                        parameters.add(data);
                    }
                    parameters.add(null);
                } else if (data instanceof Integer) {
                    parameters.add(null);
                    parameters.add((Integer)data);
                    parameters.add(null);
                } else if (data instanceof Timestamp || data instanceof Date) {
                    parameters.add(null);
                    parameters.add(null);
                    if (data instanceof Date) {
                        value = new Timestamp(((Date)data).getTime());
                        parameters.add(value);
                    } else {
                        parameters.add(data);
                    }
                } else {
                    parameters.add(data);
                    parameters.add(null);
                    parameters.add(null);
                }
                DB.executeUpdateEx(insert.toString(), parameters.toArray(), null);
            }
        }
    }

    public int getWindowNo() {
        return this.windowNo;
    }

    class Exporter
    extends Thread {
        private PreparedStatement m_pstmt = null;
        private ResultSet m_rs = null;
        private String dataSql = null;

        Exporter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long start = System.currentTimeMillis();
            int no = 0;
            this.dataSql = Browser.this.getSQL();
            this.m_pstmt = Browser.this.getStatement(this.dataSql);
            Browser.this.m_rows = new ArrayList();
            try {
                Browser.this.log.fine("Start query - " + (System.currentTimeMillis() - start) + "ms");
                this.m_rs = this.m_pstmt.executeQuery();
                Browser.this.log.fine("End query - " + (System.currentTimeMillis() - start) + "ms");
                boolean isFirstRow = true;
                while (this.m_rs.next()) {
                    if (this.isInterrupted()) {
                        Browser.this.log.finer("Interrupted");
                        this.close();
                        return;
                    }
                    ++no;
                    ArrayList<String> header = isFirstRow ? new ArrayList<String>() : null;
                    ArrayList<Object> row = new ArrayList<Object>();
                    int colOffset = 1;
                    int col = 0;
                    for (MBrowseField field : Browser.this.browserFields) {
                        if (isFirstRow) {
                            String columnName = field.getName();
                            header.add(columnName);
                        }
                        Object data = null;
                        int colIndex = col + colOffset;
                        data = field.isKey() && !field.getName().equals(field.getAD_View_Column().getColumnSQL().equals("'Row' AS \"Row\"")) ? new IDColumn(this.m_rs.getInt(colIndex)) : (field.isKey() && field.getName().equals(field.getAD_View_Column().getColumnSQL().equals("'Row' AS \"Row\"")) ? new IDColumn(no) : (20 == field.getAD_Reference_ID() ? new Boolean("Y".equals(this.m_rs.getString(colIndex))) : (DisplayType.isDate(field.getAD_Reference_ID()) ? this.m_rs.getTimestamp(colIndex) : (DisplayType.isNumeric(field.getAD_Reference_ID()) ? this.m_rs.getBigDecimal(colIndex) : (11 == field.getAD_Reference_ID() ? new Integer(this.m_rs.getInt(colIndex)) : this.m_rs.getString(colIndex))))));
                        row.add(data);
                        ++col;
                    }
                    if (isFirstRow) {
                        Browser.this.m_rows.add(header);
                    }
                    Browser.this.m_rows.add(row);
                    isFirstRow = false;
                }
            }
            catch (Throwable e) {
                Browser.this.log.log(Level.SEVERE, this.dataSql, e);
            }
            finally {
                this.close();
            }
            Browser.this.log.fine("#" + no + " - " + (System.currentTimeMillis() - start) + "ms");
            if (no == 0) {
                Browser.this.log.fine(this.dataSql);
            }
        }

        private void close() {
            DB.close(this.m_rs, this.m_pstmt);
            this.m_rs = null;
            this.m_pstmt = null;
        }
    }
}

